/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Objects;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.IMachineImage;
import software.amazon.awscdk.services.ec2.MachineImageConfig;
import software.amazon.awscdk.services.ec2.UserData;
import software.amazon.awscdk.services.ec2.WindowsImageProps;
import software.amazon.awscdk.services.ec2.WindowsVersion;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.WindowsImage")
public class WindowsImage
extends JsiiObject
implements IMachineImage {
    protected WindowsImage(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WindowsImage(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public WindowsImage(WindowsVersion version, WindowsImageProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(version, "version is required"), props});
    }

    public WindowsImage(WindowsVersion version) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(version, "version is required")});
    }

    @Override
    public MachineImageConfig getImage(Construct scope) {
        return (MachineImageConfig)this.jsiiCall("getImage", MachineImageConfig.class, new Object[]{Objects.requireNonNull(scope, "scope is required")});
    }

    public static final class Builder {
        private final WindowsVersion version;
        private WindowsImageProps.Builder props;

        public static Builder create(WindowsVersion version) {
            return new Builder(version);
        }

        private Builder(WindowsVersion version) {
            this.version = version;
        }

        public Builder userData(UserData userData) {
            this.props().userData(userData);
            return this;
        }

        public WindowsImage build() {
            return new WindowsImage(this.version, this.props != null ? this.props.build() : null);
        }

        private WindowsImageProps.Builder props() {
            if (this.props == null) {
                this.props = new WindowsImageProps.Builder();
            }
            return this.props;
        }
    }
}

