package software.amazon.awscdk.services.ec2;

/**
 * This creates a linux bastion host you can use to connect to other instances or services in your VPC. The recommended way to connect to the bastion host is by using AWS Systems Manager Session Manager.
 * 
 * The operating system is Amazon Linux 2 with the latest SSM agent installed
 * 
 * You can also configure this bastion host to allow connections via SSH
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.7 (build e0b2c0d)", date = "2019-11-19T21:07:19.820Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.BastionHostLinux")
public class BastionHostLinux extends software.amazon.awscdk.core.Construct implements software.amazon.awscdk.services.ec2.IInstance {

    protected BastionHostLinux(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BastionHostLinux(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * 
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public BastionHostLinux(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.BastionHostLinuxProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Allow SSH access from the given peer or peers.
     * 
     * Necessary if you want to connect to the instance using ssh. If not
     * called, you should use SSM Session Manager to connect to the instance.
     * 
     * EXPERIMENTAL
     * 
     * @param peer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void allowSshAccessFrom(final software.amazon.awscdk.services.ec2.IPeer... peer) {
        this.jsiiCall("allowSshAccessFrom", Void.class, java.util.Arrays.<Object>stream(peer).toArray(Object[]::new));
    }

    /**
     * Allows specify security group connections for the instance.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }

    /**
     * The principal to grant permissions to.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
    }

    /**
     * The underlying instance resource.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.ec2.Instance getInstance() {
        return this.jsiiGet("instance", software.amazon.awscdk.services.ec2.Instance.class);
    }

    /**
     * The availability zone the instance was launched in.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getInstanceAvailabilityZone() {
        return this.jsiiGet("instanceAvailabilityZone", java.lang.String.class);
    }

    /**
     * The instance's ID.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getInstanceId() {
        return this.jsiiGet("instanceId", java.lang.String.class);
    }

    /**
     * Private DNS name for this instance.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getInstancePrivateDnsName() {
        return this.jsiiGet("instancePrivateDnsName", java.lang.String.class);
    }

    /**
     * Private IP for this instance.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getInstancePrivateIp() {
        return this.jsiiGet("instancePrivateIp", java.lang.String.class);
    }

    /**
     * Publicly-routable DNS name for this instance.
     * 
     * (May be an empty string if the instance does not have a public name).
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getInstancePublicDnsName() {
        return this.jsiiGet("instancePublicDnsName", java.lang.String.class);
    }

    /**
     * Publicly-routable IP  address for this instance.
     * 
     * (May be an empty string if the instance does not have a public IP).
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getInstancePublicIp() {
        return this.jsiiGet("instancePublicIp", java.lang.String.class);
    }

    /**
     * The IAM role assumed by the instance.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.iam.IRole getRole() {
        return this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
    }

    /**
     * The stack in which this resource is defined.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.core.Stack getStack() {
        return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.BastionHostLinux}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        /**
         * EXPERIMENTAL
         * 
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.BastionHostLinuxProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.BastionHostLinuxProps.Builder();
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param vpc VPC to launch the instance in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param availabilityZone In which AZ to place the instance within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param instanceName The name of the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceName(final java.lang.String instanceName) {
            this.props.instanceName(instanceName);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param instanceType Type of instance to launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(final software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param securityGroup Security Group to assign to this instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param subnetSelection Select the subnets to run the bastion host in. Set this to PUBLIC if you need to connect to this instance via the internet and cannot use SSM. You have to allow port 22 manually by using the connections field. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.BastionHostLinux}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.ec2.BastionHostLinux build() {
            return new software.amazon.awscdk.services.ec2.BastionHostLinux(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
