/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IDependable;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.AddRouteOptions;
import software.amazon.awscdk.services.ec2.INetworkAcl;
import software.amazon.awscdk.services.ec2.IRouteTable;
import software.amazon.awscdk.services.ec2.ISubnet;
import software.amazon.awscdk.services.ec2.SubnetAttributes;
import software.amazon.awscdk.services.ec2.SubnetProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.Subnet")
public class Subnet
extends Resource
implements ISubnet {
    protected Subnet(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Subnet(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Subnet(Construct scope, String id, SubnetProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public static ISubnet fromSubnetAttributes(Construct scope, String id, SubnetAttributes attrs) {
        return (ISubnet)JsiiObject.jsiiStaticCall(Subnet.class, (String)"fromSubnetAttributes", ISubnet.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    public static Boolean isVpcSubnet(Object x) {
        return (Boolean)JsiiObject.jsiiStaticCall(Subnet.class, (String)"isVpcSubnet", Boolean.class, (Object[])new Object[]{x});
    }

    public void addDefaultInternetRoute(String gatewayId, IDependable gatewayAttachment) {
        this.jsiiCall("addDefaultInternetRoute", Void.class, new Object[]{Objects.requireNonNull(gatewayId, "gatewayId is required"), Objects.requireNonNull(gatewayAttachment, "gatewayAttachment is required")});
    }

    public void addDefaultNatRoute(String natGatewayId) {
        this.jsiiCall("addDefaultNatRoute", Void.class, new Object[]{Objects.requireNonNull(natGatewayId, "natGatewayId is required")});
    }

    public void addRoute(String id, AddRouteOptions options) {
        this.jsiiCall("addRoute", Void.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    public void associateNetworkAcl(String id, INetworkAcl networkAcl) {
        this.jsiiCall("associateNetworkAcl", Void.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(networkAcl, "networkAcl is required")});
    }

    @Override
    public String getAvailabilityZone() {
        return (String)this.jsiiGet("availabilityZone", String.class);
    }

    public List<IDependable> getDependencyElements() {
        return Collections.unmodifiableList((List)this.jsiiGet("dependencyElements", List.class));
    }

    @Override
    public IDependable getInternetConnectivityEstablished() {
        return (IDependable)this.jsiiGet("internetConnectivityEstablished", IDependable.class);
    }

    public INetworkAcl getNetworkAcl() {
        return (INetworkAcl)this.jsiiGet("networkAcl", INetworkAcl.class);
    }

    @Override
    public IRouteTable getRouteTable() {
        return (IRouteTable)this.jsiiGet("routeTable", IRouteTable.class);
    }

    public String getSubnetAvailabilityZone() {
        return (String)this.jsiiGet("subnetAvailabilityZone", String.class);
    }

    @Override
    public String getSubnetId() {
        return (String)this.jsiiGet("subnetId", String.class);
    }

    public List<String> getSubnetIpv6CidrBlocks() {
        return Collections.unmodifiableList((List)this.jsiiGet("subnetIpv6CidrBlocks", List.class));
    }

    public String getSubnetNetworkAclAssociationId() {
        return (String)this.jsiiGet("subnetNetworkAclAssociationId", String.class);
    }

    public String getSubnetVpcId() {
        return (String)this.jsiiGet("subnetVpcId", String.class);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final SubnetProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new SubnetProps.Builder();
        }

        public Builder availabilityZone(String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        public Builder cidrBlock(String cidrBlock) {
            this.props.cidrBlock(cidrBlock);
            return this;
        }

        public Builder vpcId(String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        public Builder mapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.props.mapPublicIpOnLaunch(mapPublicIpOnLaunch);
            return this;
        }

        public Subnet build() {
            return new Subnet(this.scope, this.id, this.props.build());
        }
    }
}

