package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnClientVpnRoute`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnClientVpnRouteProps cfnClientVpnRouteProps = CfnClientVpnRouteProps.builder()
 *         .clientVpnEndpointId("clientVpnEndpointId")
 *         .destinationCidrBlock("destinationCidrBlock")
 *         .targetVpcSubnetId("targetVpcSubnetId")
 *         // the properties below are optional
 *         .description("description")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.65.0 (build 7a02b7f)", date = "2022-08-25T20:40:34.848Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnRouteProps")
@software.amazon.jsii.Jsii.Proxy(CfnClientVpnRouteProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnClientVpnRouteProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the Client VPN endpoint to which to add the route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClientVpnEndpointId();

    /**
     * The IPv4 address range, in CIDR notation, of the route destination. For example:.
     * <p>
     * <ul>
     * <li>To add a route for Internet access, enter <code>0.0.0.0/0</code></li>
     * <li>To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range</li>
     * <li>To add a route for an on-premises network, enter the AWS Site-to-Site VPN connection's IPv4 CIDR range</li>
     * <li>To add a route for the local network, enter the client CIDR range</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDestinationCidrBlock();

    /**
     * The ID of the subnet through which you want to route traffic.
     * <p>
     * The specified subnet must be an existing target network of the Client VPN endpoint.
     * <p>
     * Alternatively, if you're adding a route for the local network, specify <code>local</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetVpcSubnetId();

    /**
     * A brief description of the route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnClientVpnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClientVpnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnClientVpnRouteProps> {
        java.lang.String clientVpnEndpointId;
        java.lang.String destinationCidrBlock;
        java.lang.String targetVpcSubnetId;
        java.lang.String description;

        /**
         * Sets the value of {@link CfnClientVpnRouteProps#getClientVpnEndpointId}
         * @param clientVpnEndpointId The ID of the Client VPN endpoint to which to add the route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientVpnEndpointId(java.lang.String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnRouteProps#getDestinationCidrBlock}
         * @param destinationCidrBlock The IPv4 address range, in CIDR notation, of the route destination. For example:. This parameter is required.
         *                             <ul>
         *                             <li>To add a route for Internet access, enter <code>0.0.0.0/0</code></li>
         *                             <li>To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range</li>
         *                             <li>To add a route for an on-premises network, enter the AWS Site-to-Site VPN connection's IPv4 CIDR range</li>
         *                             <li>To add a route for the local network, enter the client CIDR range</li>
         *                             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationCidrBlock(java.lang.String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnRouteProps#getTargetVpcSubnetId}
         * @param targetVpcSubnetId The ID of the subnet through which you want to route traffic. This parameter is required.
         *                          The specified subnet must be an existing target network of the Client VPN endpoint.
         *                          <p>
         *                          Alternatively, if you're adding a route for the local network, specify <code>local</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetVpcSubnetId(java.lang.String targetVpcSubnetId) {
            this.targetVpcSubnetId = targetVpcSubnetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnRouteProps#getDescription}
         * @param description A brief description of the route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClientVpnRouteProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnClientVpnRouteProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnClientVpnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClientVpnRouteProps {
        private final java.lang.String clientVpnEndpointId;
        private final java.lang.String destinationCidrBlock;
        private final java.lang.String targetVpcSubnetId;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clientVpnEndpointId = software.amazon.jsii.Kernel.get(this, "clientVpnEndpointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationCidrBlock = software.amazon.jsii.Kernel.get(this, "destinationCidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetVpcSubnetId = software.amazon.jsii.Kernel.get(this, "targetVpcSubnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientVpnEndpointId = java.util.Objects.requireNonNull(builder.clientVpnEndpointId, "clientVpnEndpointId is required");
            this.destinationCidrBlock = java.util.Objects.requireNonNull(builder.destinationCidrBlock, "destinationCidrBlock is required");
            this.targetVpcSubnetId = java.util.Objects.requireNonNull(builder.targetVpcSubnetId, "targetVpcSubnetId is required");
            this.description = builder.description;
        }

        @Override
        public final java.lang.String getClientVpnEndpointId() {
            return this.clientVpnEndpointId;
        }

        @Override
        public final java.lang.String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public final java.lang.String getTargetVpcSubnetId() {
            return this.targetVpcSubnetId;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clientVpnEndpointId", om.valueToTree(this.getClientVpnEndpointId()));
            data.set("destinationCidrBlock", om.valueToTree(this.getDestinationCidrBlock()));
            data.set("targetVpcSubnetId", om.valueToTree(this.getTargetVpcSubnetId()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnClientVpnRouteProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClientVpnRouteProps.Jsii$Proxy that = (CfnClientVpnRouteProps.Jsii$Proxy) o;

            if (!clientVpnEndpointId.equals(that.clientVpnEndpointId)) return false;
            if (!destinationCidrBlock.equals(that.destinationCidrBlock)) return false;
            if (!targetVpcSubnetId.equals(that.targetVpcSubnetId)) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clientVpnEndpointId.hashCode();
            result = 31 * result + (this.destinationCidrBlock.hashCode());
            result = 31 * result + (this.targetVpcSubnetId.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
