package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnIPAM`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnIPAMProps cfnIPAMProps = CfnIPAMProps.builder()
 *         .description("description")
 *         .operatingRegions(List.of(IpamOperatingRegionProperty.builder()
 *                 .regionName("regionName")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.65.0 (build 7a02b7f)", date = "2022-08-25T20:40:34.935Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnIPAMProps")
@software.amazon.jsii.Jsii.Proxy(CfnIPAMProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIPAMProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The description for the IPAM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The operating Regions for an IPAM.
     * <p>
     * Operating Regions are AWS Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the AWS Regions you select as operating Regions.
     * <p>
     * For more information about operating Regions, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <em>Amazon VPC IPAM User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOperatingRegions() {
        return null;
    }

    /**
     * The key/value combination of a tag assigned to the resource.
     * <p>
     * Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code> , specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIPAMProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIPAMProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIPAMProps> {
        java.lang.String description;
        java.lang.Object operatingRegions;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnIPAMProps#getDescription}
         * @param description The description for the IPAM.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMProps#getOperatingRegions}
         * @param operatingRegions The operating Regions for an IPAM.
         *                         Operating Regions are AWS Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the AWS Regions you select as operating Regions.
         *                         <p>
         *                         For more information about operating Regions, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <em>Amazon VPC IPAM User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operatingRegions(software.amazon.awscdk.core.IResolvable operatingRegions) {
            this.operatingRegions = operatingRegions;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMProps#getOperatingRegions}
         * @param operatingRegions The operating Regions for an IPAM.
         *                         Operating Regions are AWS Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the AWS Regions you select as operating Regions.
         *                         <p>
         *                         For more information about operating Regions, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <em>Amazon VPC IPAM User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operatingRegions(java.util.List<? extends java.lang.Object> operatingRegions) {
            this.operatingRegions = operatingRegions;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMProps#getTags}
         * @param tags The key/value combination of a tag assigned to the resource.
         *             Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code> , specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIPAMProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIPAMProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIPAMProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIPAMProps {
        private final java.lang.String description;
        private final java.lang.Object operatingRegions;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.operatingRegions = software.amazon.jsii.Kernel.get(this, "operatingRegions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.operatingRegions = builder.operatingRegions;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getOperatingRegions() {
            return this.operatingRegions;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getOperatingRegions() != null) {
                data.set("operatingRegions", om.valueToTree(this.getOperatingRegions()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnIPAMProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIPAMProps.Jsii$Proxy that = (CfnIPAMProps.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.operatingRegions != null ? !this.operatingRegions.equals(that.operatingRegions) : that.operatingRegions != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.operatingRegions != null ? this.operatingRegions.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
