package software.amazon.awscdk.services.ec2;

/**
 * Factory functions for standard Amazon Machine Image objects.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * LaunchTemplate template = LaunchTemplate.Builder.create(this, "LaunchTemplate")
 *         .machineImage(MachineImage.latestAmazonLinux())
 *         .securityGroup(SecurityGroup.Builder.create(this, "LaunchTemplateSG")
 *                 .vpc(vpc)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.65.1 (build b0947e4)", date = "2022-08-30T21:28:32.438Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.MachineImage")
public abstract class MachineImage extends software.amazon.jsii.JsiiObject {

    protected MachineImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MachineImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected MachineImage() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * An image specified in SSM parameter store.
     * <p>
     * By default, the SSM parameter is refreshed at every deployment,
     * causing your instances to be replaced whenever a new version of the AMI
     * is released.
     * <p>
     * Pass <code>{ cachedInContext: true }</code> to keep the AMI ID stable. If you do, you
     * will have to remember to periodically invalidate the context to refresh
     * to the newest AMI ID.
     * <p>
     * @param parameterName This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage fromSsmParameter(final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SsmParameterImageOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "fromSsmParameter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required"), options });
    }

    /**
     * An image specified in SSM parameter store.
     * <p>
     * By default, the SSM parameter is refreshed at every deployment,
     * causing your instances to be replaced whenever a new version of the AMI
     * is released.
     * <p>
     * Pass <code>{ cachedInContext: true }</code> to keep the AMI ID stable. If you do, you
     * will have to remember to periodically invalidate the context to refresh
     * to the newest AMI ID.
     * <p>
     * @param parameterName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage fromSsmParameter(final @org.jetbrains.annotations.NotNull java.lang.String parameterName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "fromSsmParameter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required") });
    }

    /**
     * (deprecated) An image specified in SSM parameter store that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     * <p>
     * @deprecated Use `MachineImage.fromSsmParameter()` instead
     * @param parameterName The name of SSM parameter containing the AMi id. This parameter is required.
     * @param os The operating system type of the AMI. This parameter is required.
     * @param userData optional user data for the given image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage fromSSMParameter(final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.OperatingSystemType os, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.UserData userData) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "fromSSMParameter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required"), java.util.Objects.requireNonNull(os, "os is required"), userData });
    }

    /**
     * (deprecated) An image specified in SSM parameter store that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     * <p>
     * @deprecated Use `MachineImage.fromSsmParameter()` instead
     * @param parameterName The name of SSM parameter containing the AMi id. This parameter is required.
     * @param os The operating system type of the AMI. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage fromSSMParameter(final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.OperatingSystemType os) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "fromSSMParameter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required"), java.util.Objects.requireNonNull(os, "os is required") });
    }

    /**
     * A Linux image where you specify the AMI ID for every region.
     * <p>
     * @param amiMap For every region where you are deploying the stack, specify the AMI ID for that region. This parameter is required.
     * @param props Customize the image by supplying additional props.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage genericLinux(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> amiMap, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.GenericLinuxImageProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "genericLinux", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(amiMap, "amiMap is required"), props });
    }

    /**
     * A Linux image where you specify the AMI ID for every region.
     * <p>
     * @param amiMap For every region where you are deploying the stack, specify the AMI ID for that region. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage genericLinux(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> amiMap) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "genericLinux", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(amiMap, "amiMap is required") });
    }

    /**
     * A Windows image where you specify the AMI ID for every region.
     * <p>
     * @param amiMap For every region where you are deploying the stack, specify the AMI ID for that region. This parameter is required.
     * @param props Customize the image by supplying additional props.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage genericWindows(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> amiMap, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.GenericWindowsImageProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "genericWindows", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(amiMap, "amiMap is required"), props });
    }

    /**
     * A Windows image where you specify the AMI ID for every region.
     * <p>
     * @param amiMap For every region where you are deploying the stack, specify the AMI ID for that region. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage genericWindows(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> amiMap) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "genericWindows", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(amiMap, "amiMap is required") });
    }

    /**
     * An Amazon Linux image that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage latestAmazonLinux(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinuxImageProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "latestAmazonLinux", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { props });
    }

    /**
     * An Amazon Linux image that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage latestAmazonLinux() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "latestAmazonLinux", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class));
    }

    /**
     * A Windows image that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     * <p>
     * @param version This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage latestWindows(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.WindowsVersion version, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.WindowsImageProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "latestWindows", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required"), props });
    }

    /**
     * A Windows image that is automatically kept up-to-date.
     * <p>
     * This Machine Image automatically updates to the latest version on every
     * deployment. Be aware this will cause your instances to be replaced when a
     * new version of the image becomes available. Do not store stateful information
     * on the instance if you are using this image.
     * <p>
     * @param version This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage latestWindows(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.WindowsVersion version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "latestWindows", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * Look up a shared Machine Image using DescribeImages.
     * <p>
     * The most recent, available, launchable image matching the given filter
     * criteria will be used. Looking up AMIs may take a long time; specify
     * as many filter criteria as possible to narrow down the search.
     * <p>
     * The AMI selected will be cached in <code>cdk.context.json</code> and the same value
     * will be used on future runs. To refresh the AMI lookup, you will have to
     * evict the value from the cache using the <code>cdk context</code> command. See
     * https://docs.aws.amazon.com/cdk/latest/guide/context.html for more information.
     * <p>
     * This function can not be used in environment-agnostic stacks.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage lookup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.LookupMachineImageProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.MachineImage.class, "lookup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ec2.MachineImage {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
