package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::Instance`.
 * <p>
 * Specifies an EC2 instance.
 * <p>
 * If an Elastic IP address is attached to your instance, AWS CloudFormation reattaches the Elastic IP address after it updates the instance. For more information about updating stacks, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">AWS CloudFormation Stacks Updates</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnInstance cfnInstance = CfnInstance.Builder.create(this, "MyCfnInstance")
 *         .additionalInfo("additionalInfo")
 *         .affinity("affinity")
 *         .availabilityZone("availabilityZone")
 *         .blockDeviceMappings(List.of(BlockDeviceMappingProperty.builder()
 *                 .deviceName("deviceName")
 *                 // the properties below are optional
 *                 .ebs(EbsProperty.builder()
 *                         .deleteOnTermination(false)
 *                         .encrypted(false)
 *                         .iops(123)
 *                         .kmsKeyId("kmsKeyId")
 *                         .snapshotId("snapshotId")
 *                         .volumeSize(123)
 *                         .volumeType("volumeType")
 *                         .build())
 *                 .noDevice(NoDeviceProperty.builder().build())
 *                 .virtualName("virtualName")
 *                 .build()))
 *         .cpuOptions(CpuOptionsProperty.builder()
 *                 .coreCount(123)
 *                 .threadsPerCore(123)
 *                 .build())
 *         .creditSpecification(CreditSpecificationProperty.builder()
 *                 .cpuCredits("cpuCredits")
 *                 .build())
 *         .disableApiTermination(false)
 *         .ebsOptimized(false)
 *         .elasticGpuSpecifications(List.of(ElasticGpuSpecificationProperty.builder()
 *                 .type("type")
 *                 .build()))
 *         .elasticInferenceAccelerators(List.of(ElasticInferenceAcceleratorProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .count(123)
 *                 .build()))
 *         .enclaveOptions(EnclaveOptionsProperty.builder()
 *                 .enabled(false)
 *                 .build())
 *         .hibernationOptions(HibernationOptionsProperty.builder()
 *                 .configured(false)
 *                 .build())
 *         .hostId("hostId")
 *         .hostResourceGroupArn("hostResourceGroupArn")
 *         .iamInstanceProfile("iamInstanceProfile")
 *         .imageId("imageId")
 *         .instanceInitiatedShutdownBehavior("instanceInitiatedShutdownBehavior")
 *         .instanceType("instanceType")
 *         .ipv6AddressCount(123)
 *         .ipv6Addresses(List.of(InstanceIpv6AddressProperty.builder()
 *                 .ipv6Address("ipv6Address")
 *                 .build()))
 *         .kernelId("kernelId")
 *         .keyName("keyName")
 *         .launchTemplate(LaunchTemplateSpecificationProperty.builder()
 *                 .version("version")
 *                 // the properties below are optional
 *                 .launchTemplateId("launchTemplateId")
 *                 .launchTemplateName("launchTemplateName")
 *                 .build())
 *         .licenseSpecifications(List.of(LicenseSpecificationProperty.builder()
 *                 .licenseConfigurationArn("licenseConfigurationArn")
 *                 .build()))
 *         .monitoring(false)
 *         .networkInterfaces(List.of(NetworkInterfaceProperty.builder()
 *                 .deviceIndex("deviceIndex")
 *                 // the properties below are optional
 *                 .associateCarrierIpAddress(false)
 *                 .associatePublicIpAddress(false)
 *                 .deleteOnTermination(false)
 *                 .description("description")
 *                 .groupSet(List.of("groupSet"))
 *                 .ipv6AddressCount(123)
 *                 .ipv6Addresses(List.of(InstanceIpv6AddressProperty.builder()
 *                         .ipv6Address("ipv6Address")
 *                         .build()))
 *                 .networkInterfaceId("networkInterfaceId")
 *                 .privateIpAddress("privateIpAddress")
 *                 .privateIpAddresses(List.of(PrivateIpAddressSpecificationProperty.builder()
 *                         .primary(false)
 *                         .privateIpAddress("privateIpAddress")
 *                         .build()))
 *                 .secondaryPrivateIpAddressCount(123)
 *                 .subnetId("subnetId")
 *                 .build()))
 *         .placementGroupName("placementGroupName")
 *         .privateDnsNameOptions(PrivateDnsNameOptionsProperty.builder()
 *                 .enableResourceNameDnsAaaaRecord(false)
 *                 .enableResourceNameDnsARecord(false)
 *                 .hostnameType("hostnameType")
 *                 .build())
 *         .privateIpAddress("privateIpAddress")
 *         .propagateTagsToVolumeOnCreation(false)
 *         .ramdiskId("ramdiskId")
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .securityGroups(List.of("securityGroups"))
 *         .sourceDestCheck(false)
 *         .ssmAssociations(List.of(SsmAssociationProperty.builder()
 *                 .documentName("documentName")
 *                 // the properties below are optional
 *                 .associationParameters(List.of(AssociationParameterProperty.builder()
 *                         .key("key")
 *                         .value(List.of("value"))
 *                         .build()))
 *                 .build()))
 *         .subnetId("subnetId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tenancy("tenancy")
 *         .userData("userData")
 *         .volumes(List.of(VolumeProperty.builder()
 *                 .device("device")
 *                 .volumeId("volumeId")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.66.0 (build 3c9512b)", date = "2022-08-31T20:25:12.997Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance")
public class CfnInstance extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnInstance(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInstance(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnInstance.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::Instance`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnInstance(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnInstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::EC2::Instance`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnInstance(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Availability Zone where the specified instance is launched. For example: `us-east-1b` .
     * <p>
     * You can retrieve a list of all Availability Zones for a Region by using the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-getavailabilityzones.html">Fn::GetAZs</a> intrinsic function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "attrAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The private DNS name of the specified instance.
     * <p>
     * For example: <code>ip-10-24-34-0.ec2.internal</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPrivateDnsName() {
        return software.amazon.jsii.Kernel.get(this, "attrPrivateDnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The private IP address of the specified instance.
     * <p>
     * For example: <code>10.24.34.0</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPrivateIp() {
        return software.amazon.jsii.Kernel.get(this, "attrPrivateIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The public DNS name of the specified instance.
     * <p>
     * For example: <code>ec2-107-20-50-45.compute-1.amazonaws.com</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPublicDnsName() {
        return software.amazon.jsii.Kernel.get(this, "attrPublicDnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The public IP address of the specified instance.
     * <p>
     * For example: <code>192.0.2.0</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPublicIp() {
        return software.amazon.jsii.Kernel.get(this, "attrPublicIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags to add to the instance.
     * <p>
     * These tags are not applied to the EBS volumes, such as the root volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * This property is reserved for internal use.
     * <p>
     * If you use it, the stack fails with this error: <code>Bad property set: [Testing this property] (Service: AmazonEC2; Status Code: 400; Error Code: InvalidParameterCombination; Request ID: 0XXXXXX-49c7-4b40-8bcc-76885dcXXXXX)</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAdditionalInfo() {
        return software.amazon.jsii.Kernel.get(this, "additionalInfo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * This property is reserved for internal use.
     * <p>
     * If you use it, the stack fails with this error: <code>Bad property set: [Testing this property] (Service: AmazonEC2; Status Code: 400; Error Code: InvalidParameterCombination; Request ID: 0XXXXXX-49c7-4b40-8bcc-76885dcXXXXX)</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalInfo(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "additionalInfo", value);
    }

    /**
     * Indicates whether the instance is associated with a dedicated host.
     * <p>
     * If you want the instance to always restart on the same host on which it was launched, specify <code>host</code> . If you want the instance to restart on any available host, but try to launch onto the last host it ran on (on a best-effort basis), specify <code>default</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAffinity() {
        return software.amazon.jsii.Kernel.get(this, "affinity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether the instance is associated with a dedicated host.
     * <p>
     * If you want the instance to always restart on the same host on which it was launched, specify <code>host</code> . If you want the instance to restart on any available host, but try to launch onto the last host it ran on (on a best-effort basis), specify <code>default</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAffinity(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "affinity", value);
    }

    /**
     * The Availability Zone of the instance.
     * <p>
     * If not specified, an Availability Zone will be automatically chosen for you based on the load balancing criteria for the Region.
     * <p>
     * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute.html">DescribeImageAttribute</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Availability Zone of the instance.
     * <p>
     * If not specified, an Availability Zone will be automatically chosen for you based on the load balancing criteria for the Region.
     * <p>
     * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute.html">DescribeImageAttribute</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZone", value);
    }

    /**
     * The block device mapping entries that defines the block devices to attach to the instance at launch.
     * <p>
     * By default, the block devices specified in the block device mapping for the AMI are used. You can override the AMI block device mapping using the instance block device mapping. For the root volume, you can override only the volume size, volume type, volume encryption settings, and the <code>DeleteOnTermination</code> setting.
     * <p>
     * <blockquote>
     * <p>
     * After the instance is running, you can modify only the <code>DeleteOnTermination</code> parameter for the attached volumes without interrupting the instance. Modifying any other parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBlockDeviceMappings() {
        return software.amazon.jsii.Kernel.get(this, "blockDeviceMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The block device mapping entries that defines the block devices to attach to the instance at launch.
     * <p>
     * By default, the block devices specified in the block device mapping for the AMI are used. You can override the AMI block device mapping using the instance block device mapping. For the root volume, you can override only the volume size, volume type, volume encryption settings, and the <code>DeleteOnTermination</code> setting.
     * <p>
     * <blockquote>
     * <p>
     * After the instance is running, you can modify only the <code>DeleteOnTermination</code> parameter for the attached volumes without interrupting the instance. Modifying any other parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBlockDeviceMappings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "blockDeviceMappings", value);
    }

    /**
     * The block device mapping entries that defines the block devices to attach to the instance at launch.
     * <p>
     * By default, the block devices specified in the block device mapping for the AMI are used. You can override the AMI block device mapping using the instance block device mapping. For the root volume, you can override only the volume size, volume type, volume encryption settings, and the <code>DeleteOnTermination</code> setting.
     * <p>
     * <blockquote>
     * <p>
     * After the instance is running, you can modify only the <code>DeleteOnTermination</code> parameter for the attached volumes without interrupting the instance. Modifying any other parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBlockDeviceMappings(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "blockDeviceMappings", value);
    }

    /**
     * The CPU options for the instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU options</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCpuOptions() {
        return software.amazon.jsii.Kernel.get(this, "cpuOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The CPU options for the instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU options</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCpuOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cpuOptions", value);
    }

    /**
     * The CPU options for the instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU options</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCpuOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnInstance.CpuOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "cpuOptions", value);
    }

    /**
     * The credit option for CPU usage of the burstable performance instance.
     * <p>
     * Valid values are <code>standard</code> and <code>unlimited</code> . To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html">ModifyInstanceCreditSpecification</a> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Default: <code>standard</code> (T2 instances) or <code>unlimited</code> (T3/T3a instances)
     * <p>
     * For T3 instances with <code>host</code> tenancy, only <code>standard</code> is supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCreditSpecification() {
        return software.amazon.jsii.Kernel.get(this, "creditSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The credit option for CPU usage of the burstable performance instance.
     * <p>
     * Valid values are <code>standard</code> and <code>unlimited</code> . To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html">ModifyInstanceCreditSpecification</a> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Default: <code>standard</code> (T2 instances) or <code>unlimited</code> (T3/T3a instances)
     * <p>
     * For T3 instances with <code>host</code> tenancy, only <code>standard</code> is supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCreditSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "creditSpecification", value);
    }

    /**
     * The credit option for CPU usage of the burstable performance instance.
     * <p>
     * Valid values are <code>standard</code> and <code>unlimited</code> . To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html">ModifyInstanceCreditSpecification</a> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Default: <code>standard</code> (T2 instances) or <code>unlimited</code> (T3/T3a instances)
     * <p>
     * For T3 instances with <code>host</code> tenancy, only <code>standard</code> is supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCreditSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnInstance.CreditSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "creditSpecification", value);
    }

    /**
     * If you set this parameter to `true` , you can't terminate the instance using the Amazon EC2 console, CLI, or API;
     * <p>
     * otherwise, you can. To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute</a> . Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code> , you can terminate the instance by running the shutdown command from the instance.
     * <p>
     * Default: <code>false</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDisableApiTermination() {
        return software.amazon.jsii.Kernel.get(this, "disableApiTermination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If you set this parameter to `true` , you can't terminate the instance using the Amazon EC2 console, CLI, or API;
     * <p>
     * otherwise, you can. To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute</a> . Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code> , you can terminate the instance by running the shutdown command from the instance.
     * <p>
     * Default: <code>false</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisableApiTermination(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "disableApiTermination", value);
    }

    /**
     * If you set this parameter to `true` , you can't terminate the instance using the Amazon EC2 console, CLI, or API;
     * <p>
     * otherwise, you can. To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute</a> . Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code> , you can terminate the instance by running the shutdown command from the instance.
     * <p>
     * Default: <code>false</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisableApiTermination(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "disableApiTermination", value);
    }

    /**
     * Indicates whether the instance is optimized for Amazon EBS I/O.
     * <p>
     * This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
     * <p>
     * Default: <code>false</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptimized() {
        return software.amazon.jsii.Kernel.get(this, "ebsOptimized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether the instance is optimized for Amazon EBS I/O.
     * <p>
     * This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
     * <p>
     * Default: <code>false</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEbsOptimized(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "ebsOptimized", value);
    }

    /**
     * Indicates whether the instance is optimized for Amazon EBS I/O.
     * <p>
     * This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
     * <p>
     * Default: <code>false</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEbsOptimized(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ebsOptimized", value);
    }

    /**
     * An elastic GPU to associate with the instance.
     * <p>
     * An Elastic GPU is a GPU resource that you can attach to your Windows instance to accelerate the graphics performance of your applications. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon EC2 Elastic GPUs</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getElasticGpuSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "elasticGpuSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An elastic GPU to associate with the instance.
     * <p>
     * An Elastic GPU is a GPU resource that you can attach to your Windows instance to accelerate the graphics performance of your applications. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon EC2 Elastic GPUs</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticGpuSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "elasticGpuSpecifications", value);
    }

    /**
     * An elastic GPU to associate with the instance.
     * <p>
     * An Elastic GPU is a GPU resource that you can attach to your Windows instance to accelerate the graphics performance of your applications. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon EC2 Elastic GPUs</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticGpuSpecifications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "elasticGpuSpecifications", value);
    }

    /**
     * An elastic inference accelerator to associate with the instance.
     * <p>
     * Elastic inference accelerators are a resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference workloads.
     * <p>
     * You cannot specify accelerators from different generations in the same request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getElasticInferenceAccelerators() {
        return software.amazon.jsii.Kernel.get(this, "elasticInferenceAccelerators", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An elastic inference accelerator to associate with the instance.
     * <p>
     * Elastic inference accelerators are a resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference workloads.
     * <p>
     * You cannot specify accelerators from different generations in the same request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticInferenceAccelerators(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "elasticInferenceAccelerators", value);
    }

    /**
     * An elastic inference accelerator to associate with the instance.
     * <p>
     * Elastic inference accelerators are a resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference workloads.
     * <p>
     * You cannot specify accelerators from different generations in the same request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticInferenceAccelerators(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "elasticInferenceAccelerators", value);
    }

    /**
     * Indicates whether the instance is enabled for AWS Nitro Enclaves.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnclaveOptions() {
        return software.amazon.jsii.Kernel.get(this, "enclaveOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether the instance is enabled for AWS Nitro Enclaves.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnclaveOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enclaveOptions", value);
    }

    /**
     * Indicates whether the instance is enabled for AWS Nitro Enclaves.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnclaveOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnInstance.EnclaveOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "enclaveOptions", value);
    }

    /**
     * Indicates whether an instance is enabled for hibernation.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * You can't enable hibernation and AWS Nitro Enclaves on the same instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHibernationOptions() {
        return software.amazon.jsii.Kernel.get(this, "hibernationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether an instance is enabled for hibernation.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * You can't enable hibernation and AWS Nitro Enclaves on the same instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHibernationOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "hibernationOptions", value);
    }

    /**
     * Indicates whether an instance is enabled for hibernation.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * You can't enable hibernation and AWS Nitro Enclaves on the same instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHibernationOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnInstance.HibernationOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "hibernationOptions", value);
    }

    /**
     * If you specify host for the `Affinity` property, the ID of a dedicated host that the instance is associated with.
     * <p>
     * If you don't specify an ID, Amazon EC2 launches the instance onto any available, compatible dedicated host in your account. This type of launch is called an untargeted launch. Note that for untargeted launches, you must have a compatible, dedicated host available to successfully launch instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHostId() {
        return software.amazon.jsii.Kernel.get(this, "hostId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If you specify host for the `Affinity` property, the ID of a dedicated host that the instance is associated with.
     * <p>
     * If you don't specify an ID, Amazon EC2 launches the instance onto any available, compatible dedicated host in your account. This type of launch is called an untargeted launch. Note that for untargeted launches, you must have a compatible, dedicated host available to successfully launch instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "hostId", value);
    }

    /**
     * The ARN of the host resource group in which to launch the instances.
     * <p>
     * If you specify a host resource group ARN, omit the <em>Tenancy</em> parameter or set it to <code>host</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHostResourceGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "hostResourceGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the host resource group in which to launch the instances.
     * <p>
     * If you specify a host resource group ARN, omit the <em>Tenancy</em> parameter or set it to <code>host</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostResourceGroupArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "hostResourceGroupArn", value);
    }

    /**
     * The name of an IAM instance profile.
     * <p>
     * To create a new IAM instance profile, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a> resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIamInstanceProfile() {
        return software.amazon.jsii.Kernel.get(this, "iamInstanceProfile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of an IAM instance profile.
     * <p>
     * To create a new IAM instance profile, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a> resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIamInstanceProfile(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "iamInstanceProfile", value);
    }

    /**
     * The ID of the AMI.
     * <p>
     * An AMI ID is required to launch an instance and must be specified here or in a launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getImageId() {
        return software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the AMI.
     * <p>
     * An AMI ID is required to launch an instance and must be specified here or in a launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "imageId", value);
    }

    /**
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
     * <p>
     * Default: <code>stop</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceInitiatedShutdownBehavior() {
        return software.amazon.jsii.Kernel.get(this, "instanceInitiatedShutdownBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
     * <p>
     * Default: <code>stop</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceInitiatedShutdownBehavior(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceInitiatedShutdownBehavior", value);
    }

    /**
     * The instance type. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide* .
     * <p>
     * Default: <code>m1.small</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
        return software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The instance type. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide* .
     * <p>
     * Default: <code>m1.small</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceType", value);
    }

    /**
     * [EC2-VPC] The number of IPv6 addresses to associate with the primary network interface.
     * <p>
     * Amazon EC2 chooses the IPv6 addresses from the range of your subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number of instances to launch.
     * <p>
     * You cannot specify this option and the network interfaces option in the same request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getIpv6AddressCount() {
        return software.amazon.jsii.Kernel.get(this, "ipv6AddressCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * [EC2-VPC] The number of IPv6 addresses to associate with the primary network interface.
     * <p>
     * Amazon EC2 chooses the IPv6 addresses from the range of your subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number of instances to launch.
     * <p>
     * You cannot specify this option and the network interfaces option in the same request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpv6AddressCount(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "ipv6AddressCount", value);
    }

    /**
     * [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface.
     * <p>
     * You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.
     * <p>
     * You cannot specify this option and the network interfaces option in the same request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIpv6Addresses() {
        return software.amazon.jsii.Kernel.get(this, "ipv6Addresses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface.
     * <p>
     * You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.
     * <p>
     * You cannot specify this option and the network interfaces option in the same request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpv6Addresses(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ipv6Addresses", value);
    }

    /**
     * [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface.
     * <p>
     * You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.
     * <p>
     * You cannot specify this option and the network interfaces option in the same request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpv6Addresses(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "ipv6Addresses", value);
    }

    /**
     * The ID of the kernel.
     * <p>
     * <blockquote>
     * <p>
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">PV-GRUB</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKernelId() {
        return software.amazon.jsii.Kernel.get(this, "kernelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the kernel.
     * <p>
     * <blockquote>
     * <p>
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">PV-GRUB</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKernelId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kernelId", value);
    }

    /**
     * The name of the key pair. You can create a key pair using [CreateKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html) or [ImportKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html) .
     * <p>
     * <blockquote>
     * <p>
     * If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is configured to allow users another way to log in.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKeyName() {
        return software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the key pair. You can create a key pair using [CreateKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html) or [ImportKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html) .
     * <p>
     * <blockquote>
     * <p>
     * If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is configured to allow users another way to log in.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeyName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "keyName", value);
    }

    /**
     * The launch template to use to launch the instances.
     * <p>
     * Any parameters that you specify in the AWS CloudFormation template override the same parameters in the launch template. You can specify either the name or ID of a launch template, but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLaunchTemplate() {
        return software.amazon.jsii.Kernel.get(this, "launchTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The launch template to use to launch the instances.
     * <p>
     * Any parameters that you specify in the AWS CloudFormation template override the same parameters in the launch template. You can specify either the name or ID of a launch template, but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchTemplate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "launchTemplate", value);
    }

    /**
     * The launch template to use to launch the instances.
     * <p>
     * Any parameters that you specify in the AWS CloudFormation template override the same parameters in the launch template. You can specify either the name or ID of a launch template, but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchTemplate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnInstance.LaunchTemplateSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "launchTemplate", value);
    }

    /**
     * The license configurations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLicenseSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "licenseSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The license configurations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLicenseSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "licenseSpecifications", value);
    }

    /**
     * The license configurations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLicenseSpecifications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "licenseSpecifications", value);
    }

    /**
     * Specifies whether detailed monitoring is enabled for the instance.
     * <p>
     * Specify <code>true</code> to enable detailed monitoring. Otherwise, basic monitoring is enabled. For more information about detailed monitoring, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off detailed monitoring for your instances</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMonitoring() {
        return software.amazon.jsii.Kernel.get(this, "monitoring", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether detailed monitoring is enabled for the instance.
     * <p>
     * Specify <code>true</code> to enable detailed monitoring. Otherwise, basic monitoring is enabled. For more information about detailed monitoring, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off detailed monitoring for your instances</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoring(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "monitoring", value);
    }

    /**
     * Specifies whether detailed monitoring is enabled for the instance.
     * <p>
     * Specify <code>true</code> to enable detailed monitoring. Otherwise, basic monitoring is enabled. For more information about detailed monitoring, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off detailed monitoring for your instances</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoring(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "monitoring", value);
    }

    /**
     * The network interfaces to associate with the instance.
     * <p>
     * <blockquote>
     * <p>
     * If you use this property to point to a network interface, you must terminate the original interface before attaching a new one to allow the update of the instance to succeed.
     * <p>
     * If this resource has a public IP address and is also in a VPC that is defined in the same template, you must use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> to declare a dependency on the VPC-gateway attachment.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterfaces() {
        return software.amazon.jsii.Kernel.get(this, "networkInterfaces", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The network interfaces to associate with the instance.
     * <p>
     * <blockquote>
     * <p>
     * If you use this property to point to a network interface, you must terminate the original interface before attaching a new one to allow the update of the instance to succeed.
     * <p>
     * If this resource has a public IP address and is also in a VPC that is defined in the same template, you must use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> to declare a dependency on the VPC-gateway attachment.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkInterfaces(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "networkInterfaces", value);
    }

    /**
     * The network interfaces to associate with the instance.
     * <p>
     * <blockquote>
     * <p>
     * If you use this property to point to a network interface, you must terminate the original interface before attaching a new one to allow the update of the instance to succeed.
     * <p>
     * If this resource has a public IP address and is also in a VPC that is defined in the same template, you must use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> to declare a dependency on the VPC-gateway attachment.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkInterfaces(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "networkInterfaces", value);
    }

    /**
     * The name of an existing placement group that you want to launch the instance into (cluster | partition | spread).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPlacementGroupName() {
        return software.amazon.jsii.Kernel.get(this, "placementGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of an existing placement group that you want to launch the instance into (cluster | partition | spread).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlacementGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "placementGroupName", value);
    }

    /**
     * The options for the instance hostname.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPrivateDnsNameOptions() {
        return software.amazon.jsii.Kernel.get(this, "privateDnsNameOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The options for the instance hostname.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPrivateDnsNameOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "privateDnsNameOptions", value);
    }

    /**
     * The options for the instance hostname.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPrivateDnsNameOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnInstance.PrivateDnsNameOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "privateDnsNameOptions", value);
    }

    /**
     * [EC2-VPC] The primary IPv4 address. You must specify a value from the IPv4 address range of the subnet.
     * <p>
     * Only one private IP address can be designated as primary. You can't specify this option if you've specified the option to designate a private IP address as the primary IP address in a network interface specification. You cannot specify this option if you're launching more than one instance in the request.
     * <p>
     * You cannot specify this option and the network interfaces option in the same request.
     * <p>
     * If you make an update to an instance that requires replacement, you must assign a new private IP address. During a replacement, AWS CloudFormation creates a new instance but doesn't delete the old instance until the stack has successfully updated. If the stack update fails, AWS CloudFormation uses the old instance to roll back the stack to the previous working state. The old and new instances cannot have the same private IP address.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPrivateIpAddress() {
        return software.amazon.jsii.Kernel.get(this, "privateIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * [EC2-VPC] The primary IPv4 address. You must specify a value from the IPv4 address range of the subnet.
     * <p>
     * Only one private IP address can be designated as primary. You can't specify this option if you've specified the option to designate a private IP address as the primary IP address in a network interface specification. You cannot specify this option if you're launching more than one instance in the request.
     * <p>
     * You cannot specify this option and the network interfaces option in the same request.
     * <p>
     * If you make an update to an instance that requires replacement, you must assign a new private IP address. During a replacement, AWS CloudFormation creates a new instance but doesn't delete the old instance until the stack has successfully updated. If the stack update fails, AWS CloudFormation uses the old instance to roll back the stack to the previous working state. The old and new instances cannot have the same private IP address.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPrivateIpAddress(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "privateIpAddress", value);
    }

    /**
     * Indicates whether to assign the tags from the instance to all of the volumes attached to the instance at launch.
     * <p>
     * If you specify <code>true</code> and you assign tags to the instance, those tags are automatically assigned to all of the volumes that you attach to the instance at launch. If you specify <code>false</code> , those tags are not assigned to the attached volumes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPropagateTagsToVolumeOnCreation() {
        return software.amazon.jsii.Kernel.get(this, "propagateTagsToVolumeOnCreation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether to assign the tags from the instance to all of the volumes attached to the instance at launch.
     * <p>
     * If you specify <code>true</code> and you assign tags to the instance, those tags are automatically assigned to all of the volumes that you attach to the instance at launch. If you specify <code>false</code> , those tags are not assigned to the attached volumes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPropagateTagsToVolumeOnCreation(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "propagateTagsToVolumeOnCreation", value);
    }

    /**
     * Indicates whether to assign the tags from the instance to all of the volumes attached to the instance at launch.
     * <p>
     * If you specify <code>true</code> and you assign tags to the instance, those tags are automatically assigned to all of the volumes that you attach to the instance at launch. If you specify <code>false</code> , those tags are not assigned to the attached volumes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPropagateTagsToVolumeOnCreation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "propagateTagsToVolumeOnCreation", value);
    }

    /**
     * The ID of the RAM disk to select.
     * <p>
     * Some kernels require additional drivers at launch. Check the kernel requirements for information about whether you need to specify a RAM disk. To find kernel requirements, go to the AWS Resource Center and search for the kernel ID.
     * <p>
     * <blockquote>
     * <p>
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">PV-GRUB</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRamdiskId() {
        return software.amazon.jsii.Kernel.get(this, "ramdiskId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the RAM disk to select.
     * <p>
     * Some kernels require additional drivers at launch. Check the kernel requirements for information about whether you need to specify a RAM disk. To find kernel requirements, go to the AWS Resource Center and search for the kernel ID.
     * <p>
     * <blockquote>
     * <p>
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">PV-GRUB</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRamdiskId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ramdiskId", value);
    }

    /**
     * The IDs of the security groups. You can create a security group using [CreateSecurityGroup](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html) .
     * <p>
     * If you specify a network interface, you must specify any security groups as part of the network interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The IDs of the security groups. You can create a security group using [CreateSecurityGroup](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html) .
     * <p>
     * If you specify a network interface, you must specify any security groups as part of the network interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "securityGroupIds", value);
    }

    /**
     * [EC2-Classic, default VPC] The names of the security groups.
     * <p>
     * For a nondefault VPC, you must use security group IDs instead.
     * <p>
     * You cannot specify this option and the network interfaces option in the same request. The list can contain both the name of existing Amazon EC2 security groups or references to AWS::EC2::SecurityGroup resources created in the template.
     * <p>
     * Default: Amazon EC2 uses the default security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * [EC2-Classic, default VPC] The names of the security groups.
     * <p>
     * For a nondefault VPC, you must use security group IDs instead.
     * <p>
     * You cannot specify this option and the network interfaces option in the same request. The list can contain both the name of existing Amazon EC2 security groups or references to AWS::EC2::SecurityGroup resources created in the template.
     * <p>
     * Default: Amazon EC2 uses the default security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "securityGroups", value);
    }

    /**
     * Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives.
     * <p>
     * If the value is <code>true</code> , source/destination checks are enabled; otherwise, they are disabled. The default value is <code>true</code> . You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSourceDestCheck() {
        return software.amazon.jsii.Kernel.get(this, "sourceDestCheck", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives.
     * <p>
     * If the value is <code>true</code> , source/destination checks are enabled; otherwise, they are disabled. The default value is <code>true</code> . You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceDestCheck(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "sourceDestCheck", value);
    }

    /**
     * Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives.
     * <p>
     * If the value is <code>true</code> , source/destination checks are enabled; otherwise, they are disabled. The default value is <code>true</code> . You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceDestCheck(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceDestCheck", value);
    }

    /**
     * The SSM [document](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html) and parameter values in AWS Systems Manager to associate with this instance. To use this property, you must specify an IAM instance profile role for the instance. For more information, see [Create an Instance Profile for Systems Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-configuring-access-role.html) in the *AWS Systems Manager User Guide* .
     * <p>
     * <blockquote>
     * <p>
     * You can currently associate only one document with an instance.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSsmAssociations() {
        return software.amazon.jsii.Kernel.get(this, "ssmAssociations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The SSM [document](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html) and parameter values in AWS Systems Manager to associate with this instance. To use this property, you must specify an IAM instance profile role for the instance. For more information, see [Create an Instance Profile for Systems Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-configuring-access-role.html) in the *AWS Systems Manager User Guide* .
     * <p>
     * <blockquote>
     * <p>
     * You can currently associate only one document with an instance.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSsmAssociations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ssmAssociations", value);
    }

    /**
     * The SSM [document](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html) and parameter values in AWS Systems Manager to associate with this instance. To use this property, you must specify an IAM instance profile role for the instance. For more information, see [Create an Instance Profile for Systems Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-configuring-access-role.html) in the *AWS Systems Manager User Guide* .
     * <p>
     * <blockquote>
     * <p>
     * You can currently associate only one document with an instance.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSsmAssociations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "ssmAssociations", value);
    }

    /**
     * [EC2-VPC] The ID of the subnet to launch the instance into.
     * <p>
     * If you specify a network interface, you must specify any subnets as part of the network interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
        return software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * [EC2-VPC] The ID of the subnet to launch the instance into.
     * <p>
     * If you specify a network interface, you must specify any subnets as part of the network interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubnetId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "subnetId", value);
    }

    /**
     * The tenancy of the instance (if the instance is running in a VPC).
     * <p>
     * An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTenancy() {
        return software.amazon.jsii.Kernel.get(this, "tenancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The tenancy of the instance (if the instance is running in a VPC).
     * <p>
     * An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTenancy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tenancy", value);
    }

    /**
     * The user data script to make available to the instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Run commands on your Linux instance at launch</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-windows-user-data.html">Run commands on your Windows instance at launch</a> . If you are using a command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16 KB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUserData() {
        return software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user data script to make available to the instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Run commands on your Linux instance at launch</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-windows-user-data.html">Run commands on your Windows instance at launch</a> . If you are using a command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16 KB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserData(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "userData", value);
    }

    /**
     * The volumes to attach to the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVolumes() {
        return software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The volumes to attach to the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVolumes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "volumes", value);
    }

    /**
     * The volumes to attach to the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVolumes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "volumes", value);
    }
    /**
     * Specifies input parameter values for an SSM document in AWS Systems Manager .
     * <p>
     * <code>AssociationParameter</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html">Amazon EC2 Instance SsmAssociation</a> property.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AssociationParameterProperty associationParameterProperty = AssociationParameterProperty.builder()
     *         .key("key")
     *         .value(List.of("value"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.AssociationParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(AssociationParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssociationParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of an input parameter that is in the associated SSM document.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value of an input parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValue();

        /**
         * @return a {@link Builder} of {@link AssociationParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssociationParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssociationParameterProperty> {
            java.lang.String key;
            java.util.List<java.lang.String> value;

            /**
             * Sets the value of {@link AssociationParameterProperty#getKey}
             * @param key The name of an input parameter that is in the associated SSM document. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link AssociationParameterProperty#getValue}
             * @param value The value of an input parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.util.List<java.lang.String> value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssociationParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssociationParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssociationParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssociationParameterProperty {
            private final java.lang.String key;
            private final java.util.List<java.lang.String> value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.util.List<java.lang.String> getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.AssociationParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssociationParameterProperty.Jsii$Proxy that = (AssociationParameterProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies a block device mapping for an instance.
     * <p>
     * You must specify exactly one of the following properties: <code>VirtualName</code> , <code>Ebs</code> , or <code>NoDevice</code> .
     * <p>
     * <code>BlockDeviceMapping</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html">AWS::EC2::Instance</a> resource.
     * <p>
     * <blockquote>
     * <p>
     * After the instance is running, you can modify only the <code>DeleteOnTermination</code> parameter for the attached volumes without interrupting the instance. Modifying any other parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * BlockDeviceMappingProperty blockDeviceMappingProperty = BlockDeviceMappingProperty.builder()
     *         .deviceName("deviceName")
     *         // the properties below are optional
     *         .ebs(EbsProperty.builder()
     *                 .deleteOnTermination(false)
     *                 .encrypted(false)
     *                 .iops(123)
     *                 .kmsKeyId("kmsKeyId")
     *                 .snapshotId("snapshotId")
     *                 .volumeSize(123)
     *                 .volumeType("volumeType")
     *                 .build())
     *         .noDevice(NoDeviceProperty.builder().build())
     *         .virtualName("virtualName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.BlockDeviceMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(BlockDeviceMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The device name (for example, `/dev/sdh` or `xvdh` ).
         * <p>
         * <blockquote>
         * <p>
         * After the instance is running, this parameter is used to specify the device name of the block device mapping to update.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeviceName();

        /**
         * Parameters used to automatically set up EBS volumes when the instance is launched.
         * <p>
         * <blockquote>
         * <p>
         * After the instance is running, you can modify only the <code>DeleteOnTermination</code> parameter for the attached volumes without interrupting the instance. Modifying any other parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-no-interrupt">replacement</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbs() {
            return null;
        }

        /**
         * To omit the device from the block device mapping, specify an empty string.
         * <p>
         * <blockquote>
         * <p>
         * After the instance is running, modifying this parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoDevice() {
            return null;
        }

        /**
         * The virtual device name ( `ephemeral` N).
         * <p>
         * The name must be in the form <code>ephemeral</code> <em>X</em> where <em>X</em> is a number starting from zero (0). For example, an instance type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and <code>ephemeral1</code> . The number of available instance store volumes depends on the instance type. After you connect to the instance, you must mount the volume.
         * <p>
         * NVMe instance store volumes are automatically enumerated and assigned a device name. Including them in your block device mapping has no effect.
         * <p>
         * <em>Constraints</em> : For M3 instances, you must specify instance store volumes in the block device mapping for the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device mapping for the AMI.
         * <p>
         * <blockquote>
         * <p>
         * After the instance is running, modifying this parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVirtualName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BlockDeviceMappingProperty> {
            java.lang.String deviceName;
            java.lang.Object ebs;
            java.lang.Object noDevice;
            java.lang.String virtualName;

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getDeviceName}
             * @param deviceName The device name (for example, `/dev/sdh` or `xvdh` ). This parameter is required.
             *                   <blockquote>
             *                   <p>
             *                   After the instance is running, this parameter is used to specify the device name of the block device mapping to update.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceName(java.lang.String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getEbs}
             * @param ebs Parameters used to automatically set up EBS volumes when the instance is launched.
             *            <blockquote>
             *            <p>
             *            After the instance is running, you can modify only the <code>DeleteOnTermination</code> parameter for the attached volumes without interrupting the instance. Modifying any other parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-no-interrupt">replacement</a> .
             *            <p>
             *            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebs(software.amazon.awscdk.core.IResolvable ebs) {
                this.ebs = ebs;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getEbs}
             * @param ebs Parameters used to automatically set up EBS volumes when the instance is launched.
             *            <blockquote>
             *            <p>
             *            After the instance is running, you can modify only the <code>DeleteOnTermination</code> parameter for the attached volumes without interrupting the instance. Modifying any other parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-no-interrupt">replacement</a> .
             *            <p>
             *            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebs(software.amazon.awscdk.services.ec2.CfnInstance.EbsProperty ebs) {
                this.ebs = ebs;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getNoDevice}
             * @param noDevice To omit the device from the block device mapping, specify an empty string.
             *                 <blockquote>
             *                 <p>
             *                 After the instance is running, modifying this parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noDevice(software.amazon.awscdk.core.IResolvable noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getNoDevice}
             * @param noDevice To omit the device from the block device mapping, specify an empty string.
             *                 <blockquote>
             *                 <p>
             *                 After the instance is running, modifying this parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noDevice(software.amazon.awscdk.services.ec2.CfnInstance.NoDeviceProperty noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getVirtualName}
             * @param virtualName The virtual device name ( `ephemeral` N).
             *                    The name must be in the form <code>ephemeral</code> <em>X</em> where <em>X</em> is a number starting from zero (0). For example, an instance type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and <code>ephemeral1</code> . The number of available instance store volumes depends on the instance type. After you connect to the instance, you must mount the volume.
             *                    <p>
             *                    NVMe instance store volumes are automatically enumerated and assigned a device name. Including them in your block device mapping has no effect.
             *                    <p>
             *                    <em>Constraints</em> : For M3 instances, you must specify instance store volumes in the block device mapping for the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device mapping for the AMI.
             *                    <p>
             *                    <blockquote>
             *                    <p>
             *                    After the instance is running, modifying this parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder virtualName(java.lang.String virtualName) {
                this.virtualName = virtualName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockDeviceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BlockDeviceMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlockDeviceMappingProperty {
            private final java.lang.String deviceName;
            private final java.lang.Object ebs;
            private final java.lang.Object noDevice;
            private final java.lang.String virtualName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deviceName = software.amazon.jsii.Kernel.get(this, "deviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ebs = software.amazon.jsii.Kernel.get(this, "ebs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noDevice = software.amazon.jsii.Kernel.get(this, "noDevice", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.virtualName = software.amazon.jsii.Kernel.get(this, "virtualName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deviceName = java.util.Objects.requireNonNull(builder.deviceName, "deviceName is required");
                this.ebs = builder.ebs;
                this.noDevice = builder.noDevice;
                this.virtualName = builder.virtualName;
            }

            @Override
            public final java.lang.String getDeviceName() {
                return this.deviceName;
            }

            @Override
            public final java.lang.Object getEbs() {
                return this.ebs;
            }

            @Override
            public final java.lang.Object getNoDevice() {
                return this.noDevice;
            }

            @Override
            public final java.lang.String getVirtualName() {
                return this.virtualName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deviceName", om.valueToTree(this.getDeviceName()));
                if (this.getEbs() != null) {
                    data.set("ebs", om.valueToTree(this.getEbs()));
                }
                if (this.getNoDevice() != null) {
                    data.set("noDevice", om.valueToTree(this.getNoDevice()));
                }
                if (this.getVirtualName() != null) {
                    data.set("virtualName", om.valueToTree(this.getVirtualName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.BlockDeviceMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BlockDeviceMappingProperty.Jsii$Proxy that = (BlockDeviceMappingProperty.Jsii$Proxy) o;

                if (!deviceName.equals(that.deviceName)) return false;
                if (this.ebs != null ? !this.ebs.equals(that.ebs) : that.ebs != null) return false;
                if (this.noDevice != null ? !this.noDevice.equals(that.noDevice) : that.noDevice != null) return false;
                return this.virtualName != null ? this.virtualName.equals(that.virtualName) : that.virtualName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deviceName.hashCode();
                result = 31 * result + (this.ebs != null ? this.ebs.hashCode() : 0);
                result = 31 * result + (this.noDevice != null ? this.noDevice.hashCode() : 0);
                result = 31 * result + (this.virtualName != null ? this.virtualName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the CPU options for the instance.
     * <p>
     * When you specify CPU options, you must specify both the number of CPU cores and threads per core.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU options</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * CpuOptionsProperty cpuOptionsProperty = CpuOptionsProperty.builder()
     *         .coreCount(123)
     *         .threadsPerCore(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.CpuOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(CpuOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CpuOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of CPU cores for the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCoreCount() {
            return null;
        }

        /**
         * The number of threads per CPU core.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThreadsPerCore() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CpuOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CpuOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CpuOptionsProperty> {
            java.lang.Number coreCount;
            java.lang.Number threadsPerCore;

            /**
             * Sets the value of {@link CpuOptionsProperty#getCoreCount}
             * @param coreCount The number of CPU cores for the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coreCount(java.lang.Number coreCount) {
                this.coreCount = coreCount;
                return this;
            }

            /**
             * Sets the value of {@link CpuOptionsProperty#getThreadsPerCore}
             * @param threadsPerCore The number of threads per CPU core.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threadsPerCore(java.lang.Number threadsPerCore) {
                this.threadsPerCore = threadsPerCore;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CpuOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CpuOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CpuOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CpuOptionsProperty {
            private final java.lang.Number coreCount;
            private final java.lang.Number threadsPerCore;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.coreCount = software.amazon.jsii.Kernel.get(this, "coreCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.threadsPerCore = software.amazon.jsii.Kernel.get(this, "threadsPerCore", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.coreCount = builder.coreCount;
                this.threadsPerCore = builder.threadsPerCore;
            }

            @Override
            public final java.lang.Number getCoreCount() {
                return this.coreCount;
            }

            @Override
            public final java.lang.Number getThreadsPerCore() {
                return this.threadsPerCore;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCoreCount() != null) {
                    data.set("coreCount", om.valueToTree(this.getCoreCount()));
                }
                if (this.getThreadsPerCore() != null) {
                    data.set("threadsPerCore", om.valueToTree(this.getThreadsPerCore()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.CpuOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CpuOptionsProperty.Jsii$Proxy that = (CpuOptionsProperty.Jsii$Proxy) o;

                if (this.coreCount != null ? !this.coreCount.equals(that.coreCount) : that.coreCount != null) return false;
                return this.threadsPerCore != null ? this.threadsPerCore.equals(that.threadsPerCore) : that.threadsPerCore == null;
            }

            @Override
            public final int hashCode() {
                int result = this.coreCount != null ? this.coreCount.hashCode() : 0;
                result = 31 * result + (this.threadsPerCore != null ? this.threadsPerCore.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the credit option for CPU usage of a T2, T3, or T3a instance.
     * <p>
     * <code>CreditSpecification</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html">AWS::EC2::Instance</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * CreditSpecificationProperty creditSpecificationProperty = CreditSpecificationProperty.builder()
     *         .cpuCredits("cpuCredits")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.CreditSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CreditSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CreditSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The credit option for CPU usage of the instance.
         * <p>
         * Valid values are <code>standard</code> and <code>unlimited</code> . <code>T3</code> instances launch as <code>unlimited</code> by default. <code>T2</code> instances launch as <code>standard</code> by default.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCpuCredits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CreditSpecificationProperty> {
            java.lang.String cpuCredits;

            /**
             * Sets the value of {@link CreditSpecificationProperty#getCpuCredits}
             * @param cpuCredits The credit option for CPU usage of the instance.
             *                   Valid values are <code>standard</code> and <code>unlimited</code> . <code>T3</code> instances launch as <code>unlimited</code> by default. <code>T2</code> instances launch as <code>standard</code> by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuCredits(java.lang.String cpuCredits) {
                this.cpuCredits = cpuCredits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreditSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CreditSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreditSpecificationProperty {
            private final java.lang.String cpuCredits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpuCredits = software.amazon.jsii.Kernel.get(this, "cpuCredits", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpuCredits = builder.cpuCredits;
            }

            @Override
            public final java.lang.String getCpuCredits() {
                return this.cpuCredits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCpuCredits() != null) {
                    data.set("cpuCredits", om.valueToTree(this.getCpuCredits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.CreditSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreditSpecificationProperty.Jsii$Proxy that = (CreditSpecificationProperty.Jsii$Proxy) o;

                return this.cpuCredits != null ? this.cpuCredits.equals(that.cpuCredits) : that.cpuCredits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cpuCredits != null ? this.cpuCredits.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies a block device for an EBS volume.
     * <p>
     * <code>Ebs</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html">Amazon EC2 BlockDeviceMapping</a> property.
     * <p>
     * <blockquote>
     * <p>
     * After the instance is running, you can modify only the <code>DeleteOnTermination</code> parameters for the attached volumes without interrupting the instance. Modifying any other parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * EbsProperty ebsProperty = EbsProperty.builder()
     *         .deleteOnTermination(false)
     *         .encrypted(false)
     *         .iops(123)
     *         .kmsKeyId("kmsKeyId")
     *         .snapshotId("snapshotId")
     *         .volumeSize(123)
     *         .volumeType("volumeType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.EbsProperty")
    @software.amazon.jsii.Jsii.Proxy(EbsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EbsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the EBS volume is deleted on instance termination.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#preserving-volumes-on-termination">Preserving Amazon EBS volumes on instance termination</a> in the <em>Amazon EC2 User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteOnTermination() {
            return null;
        }

        /**
         * Indicates whether the volume should be encrypted.
         * <p>
         * The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default">Encryption by default</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         * <p>
         * Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported instance types</a> .
         * <p>
         * <blockquote>
         * <p>
         * After the instance is running, modifying this parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncrypted() {
            return null;
        }

        /**
         * The number of I/O operations per second (IOPS).
         * <p>
         * For <code>gp3</code> , <code>io1</code> , and <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
         * <p>
         * The following are the supported values for each volume type:
         * <p>
         * <ul>
         * <li><code>gp3</code> : 3,000-16,000 IOPS</li>
         * <li><code>io1</code> : 100-64,000 IOPS</li>
         * <li><code>io2</code> : 100-64,000 IOPS</li>
         * </ul>
         * <p>
         * For <code>io1</code> and <code>io2</code> volumes, we guarantee 64,000 IOPS only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> . Other instance families guarantee performance up to 32,000 IOPS.
         * <p>
         * This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for <code>gp3</code> volumes is 3,000 IOPS. This parameter is not supported for <code>gp2</code> , <code>st1</code> , <code>sc1</code> , or <code>standard</code> volumes.
         * <p>
         * <blockquote>
         * <p>
         * After the instance is running, modifying this parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * The identifier of the AWS KMS key to use for Amazon EBS encryption.
         * <p>
         * If <code>KmsKeyId</code> is specified, the encrypted state must be <code>true</code> . If the encrypted state is <code>true</code> but you do not specify <code>KmsKeyId</code> , your KMS key for EBS is used.
         * <p>
         * You can specify the KMS key using any of the following:
         * <p>
         * <ul>
         * <li>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</li>
         * <li>Key alias. For example, alias/ExampleAlias.</li>
         * <li>Key ARN. For example, arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab.</li>
         * <li>Alias ARN. For example, arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * After the instance is running, modifying this parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * The ID of the snapshot.
         * <p>
         * If you specify both <code>SnapshotId</code> and <code>VolumeSize</code> , <code>VolumeSize</code> must be equal or greater than the size of the snapshot.
         * <p>
         * <blockquote>
         * <p>
         * After the instance is running, modifying this parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotId() {
            return null;
        }

        /**
         * The size of the volume, in GiBs.
         * <p>
         * You must specify either a snapshot ID or a volume size. If you specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the snapshot size.
         * <p>
         * The following are the supported volumes sizes for each volume type:
         * <p>
         * <ul>
         * <li><code>gp2</code> and <code>gp3</code> :1-16,384</li>
         * <li><code>io1</code> and <code>io2</code> : 4-16,384</li>
         * <li><code>st1</code> and <code>sc1</code> : 125-16,384</li>
         * <li><code>standard</code> : 1-1,024</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * After the instance is running, modifying this parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeSize() {
            return null;
        }

        /**
         * The volume type.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <em>Amazon EC2 User Guide</em> . If the volume type is <code>io1</code> or <code>io2</code> , you must specify the IOPS that the volume supports.
         * <p>
         * <blockquote>
         * <p>
         * After the instance is running, modifying this parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EbsProperty> {
            java.lang.Object deleteOnTermination;
            java.lang.Object encrypted;
            java.lang.Number iops;
            java.lang.String kmsKeyId;
            java.lang.String snapshotId;
            java.lang.Number volumeSize;
            java.lang.String volumeType;

            /**
             * Sets the value of {@link EbsProperty#getDeleteOnTermination}
             * @param deleteOnTermination Indicates whether the EBS volume is deleted on instance termination.
             *                            For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#preserving-volumes-on-termination">Preserving Amazon EBS volumes on instance termination</a> in the <em>Amazon EC2 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(java.lang.Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getDeleteOnTermination}
             * @param deleteOnTermination Indicates whether the EBS volume is deleted on instance termination.
             *                            For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#preserving-volumes-on-termination">Preserving Amazon EBS volumes on instance termination</a> in the <em>Amazon EC2 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(software.amazon.awscdk.core.IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getEncrypted}
             * @param encrypted Indicates whether the volume should be encrypted.
             *                  The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default">Encryption by default</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             *                  <p>
             *                  Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported instance types</a> .
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  After the instance is running, modifying this parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(java.lang.Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getEncrypted}
             * @param encrypted Indicates whether the volume should be encrypted.
             *                  The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default">Encryption by default</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             *                  <p>
             *                  Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported instance types</a> .
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  After the instance is running, modifying this parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(software.amazon.awscdk.core.IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getIops}
             * @param iops The number of I/O operations per second (IOPS).
             *             For <code>gp3</code> , <code>io1</code> , and <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
             *             <p>
             *             The following are the supported values for each volume type:
             *             <p>
             *             <ul>
             *             <li><code>gp3</code> : 3,000-16,000 IOPS</li>
             *             <li><code>io1</code> : 100-64,000 IOPS</li>
             *             <li><code>io2</code> : 100-64,000 IOPS</li>
             *             </ul>
             *             <p>
             *             For <code>io1</code> and <code>io2</code> volumes, we guarantee 64,000 IOPS only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> . Other instance families guarantee performance up to 32,000 IOPS.
             *             <p>
             *             This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for <code>gp3</code> volumes is 3,000 IOPS. This parameter is not supported for <code>gp2</code> , <code>st1</code> , <code>sc1</code> , or <code>standard</code> volumes.
             *             <p>
             *             <blockquote>
             *             <p>
             *             After the instance is running, modifying this parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
             *             <p>
             *             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getKmsKeyId}
             * @param kmsKeyId The identifier of the AWS KMS key to use for Amazon EBS encryption.
             *                 If <code>KmsKeyId</code> is specified, the encrypted state must be <code>true</code> . If the encrypted state is <code>true</code> but you do not specify <code>KmsKeyId</code> , your KMS key for EBS is used.
             *                 <p>
             *                 You can specify the KMS key using any of the following:
             *                 <p>
             *                 <ul>
             *                 <li>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</li>
             *                 <li>Key alias. For example, alias/ExampleAlias.</li>
             *                 <li>Key ARN. For example, arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab.</li>
             *                 <li>Alias ARN. For example, arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias.</li>
             *                 </ul>
             *                 <p>
             *                 <blockquote>
             *                 <p>
             *                 After the instance is running, modifying this parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getSnapshotId}
             * @param snapshotId The ID of the snapshot.
             *                   If you specify both <code>SnapshotId</code> and <code>VolumeSize</code> , <code>VolumeSize</code> must be equal or greater than the size of the snapshot.
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   After the instance is running, modifying this parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotId(java.lang.String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getVolumeSize}
             * @param volumeSize The size of the volume, in GiBs.
             *                   You must specify either a snapshot ID or a volume size. If you specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the snapshot size.
             *                   <p>
             *                   The following are the supported volumes sizes for each volume type:
             *                   <p>
             *                   <ul>
             *                   <li><code>gp2</code> and <code>gp3</code> :1-16,384</li>
             *                   <li><code>io1</code> and <code>io2</code> : 4-16,384</li>
             *                   <li><code>st1</code> and <code>sc1</code> : 125-16,384</li>
             *                   <li><code>standard</code> : 1-1,024</li>
             *                   </ul>
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   After the instance is running, modifying this parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSize(java.lang.Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getVolumeType}
             * @param volumeType The volume type.
             *                   For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <em>Amazon EC2 User Guide</em> . If the volume type is <code>io1</code> or <code>io2</code> , you must specify the IOPS that the volume supports.
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   After the instance is running, modifying this parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeType(java.lang.String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EbsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsProperty {
            private final java.lang.Object deleteOnTermination;
            private final java.lang.Object encrypted;
            private final java.lang.Number iops;
            private final java.lang.String kmsKeyId;
            private final java.lang.String snapshotId;
            private final java.lang.Number volumeSize;
            private final java.lang.String volumeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deleteOnTermination = software.amazon.jsii.Kernel.get(this, "deleteOnTermination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.snapshotId = software.amazon.jsii.Kernel.get(this, "snapshotId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.volumeSize = software.amazon.jsii.Kernel.get(this, "volumeSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deleteOnTermination = builder.deleteOnTermination;
                this.encrypted = builder.encrypted;
                this.iops = builder.iops;
                this.kmsKeyId = builder.kmsKeyId;
                this.snapshotId = builder.snapshotId;
                this.volumeSize = builder.volumeSize;
                this.volumeType = builder.volumeType;
            }

            @Override
            public final java.lang.Object getDeleteOnTermination() {
                return this.deleteOnTermination;
            }

            @Override
            public final java.lang.Object getEncrypted() {
                return this.encrypted;
            }

            @Override
            public final java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.String getSnapshotId() {
                return this.snapshotId;
            }

            @Override
            public final java.lang.Number getVolumeSize() {
                return this.volumeSize;
            }

            @Override
            public final java.lang.String getVolumeType() {
                return this.volumeType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeleteOnTermination() != null) {
                    data.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                }
                if (this.getEncrypted() != null) {
                    data.set("encrypted", om.valueToTree(this.getEncrypted()));
                }
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getSnapshotId() != null) {
                    data.set("snapshotId", om.valueToTree(this.getSnapshotId()));
                }
                if (this.getVolumeSize() != null) {
                    data.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                }
                if (this.getVolumeType() != null) {
                    data.set("volumeType", om.valueToTree(this.getVolumeType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.EbsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsProperty.Jsii$Proxy that = (EbsProperty.Jsii$Proxy) o;

                if (this.deleteOnTermination != null ? !this.deleteOnTermination.equals(that.deleteOnTermination) : that.deleteOnTermination != null) return false;
                if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                if (this.snapshotId != null ? !this.snapshotId.equals(that.snapshotId) : that.snapshotId != null) return false;
                if (this.volumeSize != null ? !this.volumeSize.equals(that.volumeSize) : that.volumeSize != null) return false;
                return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deleteOnTermination != null ? this.deleteOnTermination.hashCode() : 0;
                result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                result = 31 * result + (this.snapshotId != null ? this.snapshotId.hashCode() : 0);
                result = 31 * result + (this.volumeSize != null ? this.volumeSize.hashCode() : 0);
                result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the type of Elastic GPU.
     * <p>
     * An Elastic GPU is a GPU resource that you can attach to your Amazon EC2 instance to accelerate the graphics performance of your applications. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon EC2 Elastic GPUs</a> in the <em>Amazon EC2 User Guide for Windows Instances</em> .
     * <p>
     * <code>ElasticGpuSpecification</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html">AWS::EC2::Instance</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * ElasticGpuSpecificationProperty elasticGpuSpecificationProperty = ElasticGpuSpecificationProperty.builder()
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.ElasticGpuSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticGpuSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticGpuSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of Elastic Graphics accelerator.
         * <p>
         * For more information about the values to specify for <code>Type</code> , see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html#elastic-graphics-basics">Elastic Graphics Basics</a> , specifically the Elastic Graphics accelerator column, in the <em>Amazon Elastic Compute Cloud User Guide for Windows Instances</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticGpuSpecificationProperty> {
            java.lang.String type;

            /**
             * Sets the value of {@link ElasticGpuSpecificationProperty#getType}
             * @param type The type of Elastic Graphics accelerator. This parameter is required.
             *             For more information about the values to specify for <code>Type</code> , see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html#elastic-graphics-basics">Elastic Graphics Basics</a> , specifically the Elastic Graphics accelerator column, in the <em>Amazon Elastic Compute Cloud User Guide for Windows Instances</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticGpuSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticGpuSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticGpuSpecificationProperty {
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.ElasticGpuSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticGpuSpecificationProperty.Jsii$Proxy that = (ElasticGpuSpecificationProperty.Jsii$Proxy) o;

                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the Elastic Inference Accelerator for the instance.
     * <p>
     * <code>ElasticInferenceAccelerator</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html">AWS::EC2::Instance</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * ElasticInferenceAcceleratorProperty elasticInferenceAcceleratorProperty = ElasticInferenceAcceleratorProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .count(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.ElasticInferenceAcceleratorProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticInferenceAcceleratorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticInferenceAcceleratorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of elastic inference accelerator.
         * <p>
         * The possible values are <code>eia1.medium</code> , <code>eia1.large</code> , <code>eia1.xlarge</code> , <code>eia2.medium</code> , <code>eia2.large</code> , and <code>eia2.xlarge</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The number of elastic inference accelerators to attach to the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticInferenceAcceleratorProperty> {
            java.lang.String type;
            java.lang.Number count;

            /**
             * Sets the value of {@link ElasticInferenceAcceleratorProperty#getType}
             * @param type The type of elastic inference accelerator. This parameter is required.
             *             The possible values are <code>eia1.medium</code> , <code>eia1.large</code> , <code>eia1.xlarge</code> , <code>eia2.medium</code> , <code>eia2.large</code> , and <code>eia2.xlarge</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ElasticInferenceAcceleratorProperty#getCount}
             * @param count The number of elastic inference accelerators to attach to the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(java.lang.Number count) {
                this.count = count;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticInferenceAcceleratorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticInferenceAcceleratorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticInferenceAcceleratorProperty {
            private final java.lang.String type;
            private final java.lang.Number count;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.count = builder.count;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Number getCount() {
                return this.count;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getCount() != null) {
                    data.set("count", om.valueToTree(this.getCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.ElasticInferenceAcceleratorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticInferenceAcceleratorProperty.Jsii$Proxy that = (ElasticInferenceAcceleratorProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.count != null ? this.count.equals(that.count) : that.count == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Indicates whether the instance is enabled for AWS Nitro Enclaves.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * EnclaveOptionsProperty enclaveOptionsProperty = EnclaveOptionsProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.EnclaveOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(EnclaveOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnclaveOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If this parameter is set to `true` , the instance is enabled for AWS Nitro Enclaves;
         * <p>
         * otherwise, it is not enabled for AWS Nitro Enclaves.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnclaveOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnclaveOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnclaveOptionsProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link EnclaveOptionsProperty#getEnabled}
             * @param enabled If this parameter is set to `true` , the instance is enabled for AWS Nitro Enclaves;.
             *                otherwise, it is not enabled for AWS Nitro Enclaves.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link EnclaveOptionsProperty#getEnabled}
             * @param enabled If this parameter is set to `true` , the instance is enabled for AWS Nitro Enclaves;.
             *                otherwise, it is not enabled for AWS Nitro Enclaves.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnclaveOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnclaveOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnclaveOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnclaveOptionsProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.EnclaveOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnclaveOptionsProperty.Jsii$Proxy that = (EnclaveOptionsProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the hibernation options for the instance.
     * <p>
     * <code>HibernationOptions</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html">AWS::EC2::Instance</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * HibernationOptionsProperty hibernationOptionsProperty = HibernationOptionsProperty.builder()
     *         .configured(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.HibernationOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(HibernationOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HibernationOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If you set this parameter to `true` , your instance is enabled for hibernation.
         * <p>
         * Default: <code>false</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigured() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HibernationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HibernationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HibernationOptionsProperty> {
            java.lang.Object configured;

            /**
             * Sets the value of {@link HibernationOptionsProperty#getConfigured}
             * @param configured If you set this parameter to `true` , your instance is enabled for hibernation.
             *                   Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configured(java.lang.Boolean configured) {
                this.configured = configured;
                return this;
            }

            /**
             * Sets the value of {@link HibernationOptionsProperty#getConfigured}
             * @param configured If you set this parameter to `true` , your instance is enabled for hibernation.
             *                   Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configured(software.amazon.awscdk.core.IResolvable configured) {
                this.configured = configured;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HibernationOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HibernationOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HibernationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HibernationOptionsProperty {
            private final java.lang.Object configured;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configured = software.amazon.jsii.Kernel.get(this, "configured", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configured = builder.configured;
            }

            @Override
            public final java.lang.Object getConfigured() {
                return this.configured;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfigured() != null) {
                    data.set("configured", om.valueToTree(this.getConfigured()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.HibernationOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HibernationOptionsProperty.Jsii$Proxy that = (HibernationOptionsProperty.Jsii$Proxy) o;

                return this.configured != null ? this.configured.equals(that.configured) : that.configured == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configured != null ? this.configured.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the IPv6 address for the instance.
     * <p>
     * <code>InstanceIpv6Address</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html">AWS::EC2::Instance</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * InstanceIpv6AddressProperty instanceIpv6AddressProperty = InstanceIpv6AddressProperty.builder()
     *         .ipv6Address("ipv6Address")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.InstanceIpv6AddressProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceIpv6AddressProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceIpv6AddressProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IPv6 address.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIpv6Address();

        /**
         * @return a {@link Builder} of {@link InstanceIpv6AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceIpv6AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceIpv6AddressProperty> {
            java.lang.String ipv6Address;

            /**
             * Sets the value of {@link InstanceIpv6AddressProperty#getIpv6Address}
             * @param ipv6Address The IPv6 address. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Address(java.lang.String ipv6Address) {
                this.ipv6Address = ipv6Address;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceIpv6AddressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceIpv6AddressProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceIpv6AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceIpv6AddressProperty {
            private final java.lang.String ipv6Address;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ipv6Address = software.amazon.jsii.Kernel.get(this, "ipv6Address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipv6Address = java.util.Objects.requireNonNull(builder.ipv6Address, "ipv6Address is required");
            }

            @Override
            public final java.lang.String getIpv6Address() {
                return this.ipv6Address;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ipv6Address", om.valueToTree(this.getIpv6Address()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.InstanceIpv6AddressProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceIpv6AddressProperty.Jsii$Proxy that = (InstanceIpv6AddressProperty.Jsii$Proxy) o;

                return this.ipv6Address.equals(that.ipv6Address);
            }

            @Override
            public final int hashCode() {
                int result = this.ipv6Address.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies a launch template. You must specify either the launch template ID or launch template name.
     * <p>
     * <code>LaunchTemplateSpecification</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html">AWS::EC2::Instance</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * LaunchTemplateSpecificationProperty launchTemplateSpecificationProperty = LaunchTemplateSpecificationProperty.builder()
     *         .version("version")
     *         // the properties below are optional
     *         .launchTemplateId("launchTemplateId")
     *         .launchTemplateName("launchTemplateName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.LaunchTemplateSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(LaunchTemplateSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LaunchTemplateSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The version number of the launch template.
         * <p>
         * AWS CloudFormation does not support specifying <code>$Latest</code> , or <code>$Default</code> for the template version number.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVersion();

        /**
         * The ID of the launch template.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateId() {
            return null;
        }

        /**
         * The name of the launch template.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LaunchTemplateSpecificationProperty> {
            java.lang.String version;
            java.lang.String launchTemplateId;
            java.lang.String launchTemplateName;

            /**
             * Sets the value of {@link LaunchTemplateSpecificationProperty#getVersion}
             * @param version The version number of the launch template. This parameter is required.
             *                AWS CloudFormation does not support specifying <code>$Latest</code> , or <code>$Default</code> for the template version number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateSpecificationProperty#getLaunchTemplateId}
             * @param launchTemplateId The ID of the launch template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateId(java.lang.String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateSpecificationProperty#getLaunchTemplateName}
             * @param launchTemplateName The name of the launch template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateName(java.lang.String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LaunchTemplateSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateSpecificationProperty {
            private final java.lang.String version;
            private final java.lang.String launchTemplateId;
            private final java.lang.String launchTemplateName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.launchTemplateId = software.amazon.jsii.Kernel.get(this, "launchTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.launchTemplateName = software.amazon.jsii.Kernel.get(this, "launchTemplateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
                this.launchTemplateId = builder.launchTemplateId;
                this.launchTemplateName = builder.launchTemplateName;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            public final java.lang.String getLaunchTemplateId() {
                return this.launchTemplateId;
            }

            @Override
            public final java.lang.String getLaunchTemplateName() {
                return this.launchTemplateName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("version", om.valueToTree(this.getVersion()));
                if (this.getLaunchTemplateId() != null) {
                    data.set("launchTemplateId", om.valueToTree(this.getLaunchTemplateId()));
                }
                if (this.getLaunchTemplateName() != null) {
                    data.set("launchTemplateName", om.valueToTree(this.getLaunchTemplateName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.LaunchTemplateSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LaunchTemplateSpecificationProperty.Jsii$Proxy that = (LaunchTemplateSpecificationProperty.Jsii$Proxy) o;

                if (!version.equals(that.version)) return false;
                if (this.launchTemplateId != null ? !this.launchTemplateId.equals(that.launchTemplateId) : that.launchTemplateId != null) return false;
                return this.launchTemplateName != null ? this.launchTemplateName.equals(that.launchTemplateName) : that.launchTemplateName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.version.hashCode();
                result = 31 * result + (this.launchTemplateId != null ? this.launchTemplateId.hashCode() : 0);
                result = 31 * result + (this.launchTemplateName != null ? this.launchTemplateName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the license configuration to use.
     * <p>
     * <code>LicenseSpecification</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html">AWS::EC2::Instance</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * LicenseSpecificationProperty licenseSpecificationProperty = LicenseSpecificationProperty.builder()
     *         .licenseConfigurationArn("licenseConfigurationArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.LicenseSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(LicenseSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LicenseSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the license configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLicenseConfigurationArn();

        /**
         * @return a {@link Builder} of {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LicenseSpecificationProperty> {
            java.lang.String licenseConfigurationArn;

            /**
             * Sets the value of {@link LicenseSpecificationProperty#getLicenseConfigurationArn}
             * @param licenseConfigurationArn The Amazon Resource Name (ARN) of the license configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder licenseConfigurationArn(java.lang.String licenseConfigurationArn) {
                this.licenseConfigurationArn = licenseConfigurationArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LicenseSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LicenseSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LicenseSpecificationProperty {
            private final java.lang.String licenseConfigurationArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.licenseConfigurationArn = software.amazon.jsii.Kernel.get(this, "licenseConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.licenseConfigurationArn = java.util.Objects.requireNonNull(builder.licenseConfigurationArn, "licenseConfigurationArn is required");
            }

            @Override
            public final java.lang.String getLicenseConfigurationArn() {
                return this.licenseConfigurationArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("licenseConfigurationArn", om.valueToTree(this.getLicenseConfigurationArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.LicenseSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LicenseSpecificationProperty.Jsii$Proxy that = (LicenseSpecificationProperty.Jsii$Proxy) o;

                return this.licenseConfigurationArn.equals(that.licenseConfigurationArn);
            }

            @Override
            public final int hashCode() {
                int result = this.licenseConfigurationArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies a network interface that is to be attached to an instance.
     * <p>
     * You can create a network interface when launching an instance. For an example, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#aws-properties-ec2-instance--examples--Automatically_assign_a_public_IP_address">AWS::EC2::Instance examples</a> .
     * <p>
     * Alternatively, you can attach an existing network interface when launching an instance. For an example, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#aws-resource-ec2-network-interface--examples--Basic_network_interface">AWS::EC2:NetworkInterface examples</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * NetworkInterfaceProperty networkInterfaceProperty = NetworkInterfaceProperty.builder()
     *         .deviceIndex("deviceIndex")
     *         // the properties below are optional
     *         .associateCarrierIpAddress(false)
     *         .associatePublicIpAddress(false)
     *         .deleteOnTermination(false)
     *         .description("description")
     *         .groupSet(List.of("groupSet"))
     *         .ipv6AddressCount(123)
     *         .ipv6Addresses(List.of(InstanceIpv6AddressProperty.builder()
     *                 .ipv6Address("ipv6Address")
     *                 .build()))
     *         .networkInterfaceId("networkInterfaceId")
     *         .privateIpAddress("privateIpAddress")
     *         .privateIpAddresses(List.of(PrivateIpAddressSpecificationProperty.builder()
     *                 .primary(false)
     *                 .privateIpAddress("privateIpAddress")
     *                 .build()))
     *         .secondaryPrivateIpAddressCount(123)
     *         .subnetId("subnetId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.NetworkInterfaceProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkInterfaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkInterfaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The position of the network interface in the attachment order.
         * <p>
         * A primary network interface has a device index of 0.
         * <p>
         * If you create a network interface when launching an instance, you must specify the device index.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeviceIndex();

        /**
         * `CfnInstance.NetworkInterfaceProperty.AssociateCarrierIpAddress`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAssociateCarrierIpAddress() {
            return null;
        }

        /**
         * Indicates whether to assign a public IPv4 address to an instance.
         * <p>
         * Applies only if creating a network interface when launching an instance. The network interface must be the primary network interface. If launching into a default subnet, the default value is <code>true</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAssociatePublicIpAddress() {
            return null;
        }

        /**
         * Indicates whether the network interface is deleted when the instance is terminated.
         * <p>
         * Applies only if creating a network interface when launching an instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteOnTermination() {
            return null;
        }

        /**
         * The description of the network interface.
         * <p>
         * Applies only if creating a network interface when launching an instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The IDs of the security groups for the network interface.
         * <p>
         * Applies only if creating a network interface when launching an instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGroupSet() {
            return null;
        }

        /**
         * A number of IPv6 addresses to assign to the network interface.
         * <p>
         * Amazon EC2 chooses the IPv6 addresses from the range of the subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number of instances to launch.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIpv6AddressCount() {
            return null;
        }

        /**
         * One or more IPv6 addresses to assign to the network interface.
         * <p>
         * You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpv6Addresses() {
            return null;
        }

        /**
         * The ID of the network interface, when attaching an existing network interface.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNetworkInterfaceId() {
            return null;
        }

        /**
         * The private IPv4 address of the network interface.
         * <p>
         * Applies only if creating a network interface when launching an instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrivateIpAddress() {
            return null;
        }

        /**
         * One or more private IPv4 addresses to assign to the network interface.
         * <p>
         * Only one private IPv4 address can be designated as primary.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrivateIpAddresses() {
            return null;
        }

        /**
         * The number of secondary private IPv4 addresses.
         * <p>
         * You can't specify this option and specify more than one private IP address using the private IP addresses option.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSecondaryPrivateIpAddressCount() {
            return null;
        }

        /**
         * The ID of the subnet associated with the network interface.
         * <p>
         * Applies only if creating a network interface when launching an instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkInterfaceProperty> {
            java.lang.String deviceIndex;
            java.lang.Object associateCarrierIpAddress;
            java.lang.Object associatePublicIpAddress;
            java.lang.Object deleteOnTermination;
            java.lang.String description;
            java.util.List<java.lang.String> groupSet;
            java.lang.Number ipv6AddressCount;
            java.lang.Object ipv6Addresses;
            java.lang.String networkInterfaceId;
            java.lang.String privateIpAddress;
            java.lang.Object privateIpAddresses;
            java.lang.Number secondaryPrivateIpAddressCount;
            java.lang.String subnetId;

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getDeviceIndex}
             * @param deviceIndex The position of the network interface in the attachment order. This parameter is required.
             *                    A primary network interface has a device index of 0.
             *                    <p>
             *                    If you create a network interface when launching an instance, you must specify the device index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceIndex(java.lang.String deviceIndex) {
                this.deviceIndex = deviceIndex;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getAssociateCarrierIpAddress}
             * @param associateCarrierIpAddress `CfnInstance.NetworkInterfaceProperty.AssociateCarrierIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associateCarrierIpAddress(java.lang.Boolean associateCarrierIpAddress) {
                this.associateCarrierIpAddress = associateCarrierIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getAssociateCarrierIpAddress}
             * @param associateCarrierIpAddress `CfnInstance.NetworkInterfaceProperty.AssociateCarrierIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associateCarrierIpAddress(software.amazon.awscdk.core.IResolvable associateCarrierIpAddress) {
                this.associateCarrierIpAddress = associateCarrierIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getAssociatePublicIpAddress}
             * @param associatePublicIpAddress Indicates whether to assign a public IPv4 address to an instance.
             *                                 Applies only if creating a network interface when launching an instance. The network interface must be the primary network interface. If launching into a default subnet, the default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associatePublicIpAddress(java.lang.Boolean associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getAssociatePublicIpAddress}
             * @param associatePublicIpAddress Indicates whether to assign a public IPv4 address to an instance.
             *                                 Applies only if creating a network interface when launching an instance. The network interface must be the primary network interface. If launching into a default subnet, the default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associatePublicIpAddress(software.amazon.awscdk.core.IResolvable associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getDeleteOnTermination}
             * @param deleteOnTermination Indicates whether the network interface is deleted when the instance is terminated.
             *                            Applies only if creating a network interface when launching an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(java.lang.Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getDeleteOnTermination}
             * @param deleteOnTermination Indicates whether the network interface is deleted when the instance is terminated.
             *                            Applies only if creating a network interface when launching an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(software.amazon.awscdk.core.IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getDescription}
             * @param description The description of the network interface.
             *                    Applies only if creating a network interface when launching an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getGroupSet}
             * @param groupSet The IDs of the security groups for the network interface.
             *                 Applies only if creating a network interface when launching an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupSet(java.util.List<java.lang.String> groupSet) {
                this.groupSet = groupSet;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getIpv6AddressCount}
             * @param ipv6AddressCount A number of IPv6 addresses to assign to the network interface.
             *                         Amazon EC2 chooses the IPv6 addresses from the range of the subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number of instances to launch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6AddressCount(java.lang.Number ipv6AddressCount) {
                this.ipv6AddressCount = ipv6AddressCount;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getIpv6Addresses}
             * @param ipv6Addresses One or more IPv6 addresses to assign to the network interface.
             *                      You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Addresses(software.amazon.awscdk.core.IResolvable ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getIpv6Addresses}
             * @param ipv6Addresses One or more IPv6 addresses to assign to the network interface.
             *                      You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Addresses(java.util.List<? extends java.lang.Object> ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getNetworkInterfaceId}
             * @param networkInterfaceId The ID of the network interface, when attaching an existing network interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
                this.networkInterfaceId = networkInterfaceId;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getPrivateIpAddress}
             * @param privateIpAddress The private IPv4 address of the network interface.
             *                         Applies only if creating a network interface when launching an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddress(java.lang.String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getPrivateIpAddresses}
             * @param privateIpAddresses One or more private IPv4 addresses to assign to the network interface.
             *                           Only one private IPv4 address can be designated as primary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddresses(software.amazon.awscdk.core.IResolvable privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getPrivateIpAddresses}
             * @param privateIpAddresses One or more private IPv4 addresses to assign to the network interface.
             *                           Only one private IPv4 address can be designated as primary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddresses(java.util.List<? extends java.lang.Object> privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getSecondaryPrivateIpAddressCount}
             * @param secondaryPrivateIpAddressCount The number of secondary private IPv4 addresses.
             *                                       You can't specify this option and specify more than one private IP address using the private IP addresses option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryPrivateIpAddressCount(java.lang.Number secondaryPrivateIpAddressCount) {
                this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getSubnetId}
             * @param subnetId The ID of the subnet associated with the network interface.
             *                 Applies only if creating a network interface when launching an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkInterfaceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkInterfaceProperty {
            private final java.lang.String deviceIndex;
            private final java.lang.Object associateCarrierIpAddress;
            private final java.lang.Object associatePublicIpAddress;
            private final java.lang.Object deleteOnTermination;
            private final java.lang.String description;
            private final java.util.List<java.lang.String> groupSet;
            private final java.lang.Number ipv6AddressCount;
            private final java.lang.Object ipv6Addresses;
            private final java.lang.String networkInterfaceId;
            private final java.lang.String privateIpAddress;
            private final java.lang.Object privateIpAddresses;
            private final java.lang.Number secondaryPrivateIpAddressCount;
            private final java.lang.String subnetId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deviceIndex = software.amazon.jsii.Kernel.get(this, "deviceIndex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.associateCarrierIpAddress = software.amazon.jsii.Kernel.get(this, "associateCarrierIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.associatePublicIpAddress = software.amazon.jsii.Kernel.get(this, "associatePublicIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deleteOnTermination = software.amazon.jsii.Kernel.get(this, "deleteOnTermination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupSet = software.amazon.jsii.Kernel.get(this, "groupSet", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.ipv6AddressCount = software.amazon.jsii.Kernel.get(this, "ipv6AddressCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ipv6Addresses = software.amazon.jsii.Kernel.get(this, "ipv6Addresses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkInterfaceId = software.amazon.jsii.Kernel.get(this, "networkInterfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.privateIpAddress = software.amazon.jsii.Kernel.get(this, "privateIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.privateIpAddresses = software.amazon.jsii.Kernel.get(this, "privateIpAddresses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secondaryPrivateIpAddressCount = software.amazon.jsii.Kernel.get(this, "secondaryPrivateIpAddressCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deviceIndex = java.util.Objects.requireNonNull(builder.deviceIndex, "deviceIndex is required");
                this.associateCarrierIpAddress = builder.associateCarrierIpAddress;
                this.associatePublicIpAddress = builder.associatePublicIpAddress;
                this.deleteOnTermination = builder.deleteOnTermination;
                this.description = builder.description;
                this.groupSet = builder.groupSet;
                this.ipv6AddressCount = builder.ipv6AddressCount;
                this.ipv6Addresses = builder.ipv6Addresses;
                this.networkInterfaceId = builder.networkInterfaceId;
                this.privateIpAddress = builder.privateIpAddress;
                this.privateIpAddresses = builder.privateIpAddresses;
                this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
                this.subnetId = builder.subnetId;
            }

            @Override
            public final java.lang.String getDeviceIndex() {
                return this.deviceIndex;
            }

            @Override
            public final java.lang.Object getAssociateCarrierIpAddress() {
                return this.associateCarrierIpAddress;
            }

            @Override
            public final java.lang.Object getAssociatePublicIpAddress() {
                return this.associatePublicIpAddress;
            }

            @Override
            public final java.lang.Object getDeleteOnTermination() {
                return this.deleteOnTermination;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.util.List<java.lang.String> getGroupSet() {
                return this.groupSet;
            }

            @Override
            public final java.lang.Number getIpv6AddressCount() {
                return this.ipv6AddressCount;
            }

            @Override
            public final java.lang.Object getIpv6Addresses() {
                return this.ipv6Addresses;
            }

            @Override
            public final java.lang.String getNetworkInterfaceId() {
                return this.networkInterfaceId;
            }

            @Override
            public final java.lang.String getPrivateIpAddress() {
                return this.privateIpAddress;
            }

            @Override
            public final java.lang.Object getPrivateIpAddresses() {
                return this.privateIpAddresses;
            }

            @Override
            public final java.lang.Number getSecondaryPrivateIpAddressCount() {
                return this.secondaryPrivateIpAddressCount;
            }

            @Override
            public final java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deviceIndex", om.valueToTree(this.getDeviceIndex()));
                if (this.getAssociateCarrierIpAddress() != null) {
                    data.set("associateCarrierIpAddress", om.valueToTree(this.getAssociateCarrierIpAddress()));
                }
                if (this.getAssociatePublicIpAddress() != null) {
                    data.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
                }
                if (this.getDeleteOnTermination() != null) {
                    data.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getGroupSet() != null) {
                    data.set("groupSet", om.valueToTree(this.getGroupSet()));
                }
                if (this.getIpv6AddressCount() != null) {
                    data.set("ipv6AddressCount", om.valueToTree(this.getIpv6AddressCount()));
                }
                if (this.getIpv6Addresses() != null) {
                    data.set("ipv6Addresses", om.valueToTree(this.getIpv6Addresses()));
                }
                if (this.getNetworkInterfaceId() != null) {
                    data.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
                }
                if (this.getPrivateIpAddress() != null) {
                    data.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                }
                if (this.getPrivateIpAddresses() != null) {
                    data.set("privateIpAddresses", om.valueToTree(this.getPrivateIpAddresses()));
                }
                if (this.getSecondaryPrivateIpAddressCount() != null) {
                    data.set("secondaryPrivateIpAddressCount", om.valueToTree(this.getSecondaryPrivateIpAddressCount()));
                }
                if (this.getSubnetId() != null) {
                    data.set("subnetId", om.valueToTree(this.getSubnetId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.NetworkInterfaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkInterfaceProperty.Jsii$Proxy that = (NetworkInterfaceProperty.Jsii$Proxy) o;

                if (!deviceIndex.equals(that.deviceIndex)) return false;
                if (this.associateCarrierIpAddress != null ? !this.associateCarrierIpAddress.equals(that.associateCarrierIpAddress) : that.associateCarrierIpAddress != null) return false;
                if (this.associatePublicIpAddress != null ? !this.associatePublicIpAddress.equals(that.associatePublicIpAddress) : that.associatePublicIpAddress != null) return false;
                if (this.deleteOnTermination != null ? !this.deleteOnTermination.equals(that.deleteOnTermination) : that.deleteOnTermination != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.groupSet != null ? !this.groupSet.equals(that.groupSet) : that.groupSet != null) return false;
                if (this.ipv6AddressCount != null ? !this.ipv6AddressCount.equals(that.ipv6AddressCount) : that.ipv6AddressCount != null) return false;
                if (this.ipv6Addresses != null ? !this.ipv6Addresses.equals(that.ipv6Addresses) : that.ipv6Addresses != null) return false;
                if (this.networkInterfaceId != null ? !this.networkInterfaceId.equals(that.networkInterfaceId) : that.networkInterfaceId != null) return false;
                if (this.privateIpAddress != null ? !this.privateIpAddress.equals(that.privateIpAddress) : that.privateIpAddress != null) return false;
                if (this.privateIpAddresses != null ? !this.privateIpAddresses.equals(that.privateIpAddresses) : that.privateIpAddresses != null) return false;
                if (this.secondaryPrivateIpAddressCount != null ? !this.secondaryPrivateIpAddressCount.equals(that.secondaryPrivateIpAddressCount) : that.secondaryPrivateIpAddressCount != null) return false;
                return this.subnetId != null ? this.subnetId.equals(that.subnetId) : that.subnetId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deviceIndex.hashCode();
                result = 31 * result + (this.associateCarrierIpAddress != null ? this.associateCarrierIpAddress.hashCode() : 0);
                result = 31 * result + (this.associatePublicIpAddress != null ? this.associatePublicIpAddress.hashCode() : 0);
                result = 31 * result + (this.deleteOnTermination != null ? this.deleteOnTermination.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.groupSet != null ? this.groupSet.hashCode() : 0);
                result = 31 * result + (this.ipv6AddressCount != null ? this.ipv6AddressCount.hashCode() : 0);
                result = 31 * result + (this.ipv6Addresses != null ? this.ipv6Addresses.hashCode() : 0);
                result = 31 * result + (this.networkInterfaceId != null ? this.networkInterfaceId.hashCode() : 0);
                result = 31 * result + (this.privateIpAddress != null ? this.privateIpAddress.hashCode() : 0);
                result = 31 * result + (this.privateIpAddresses != null ? this.privateIpAddresses.hashCode() : 0);
                result = 31 * result + (this.secondaryPrivateIpAddressCount != null ? this.secondaryPrivateIpAddressCount.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Suppresses the specified device included in the block device mapping of the AMI.
     * <p>
     * To suppress a device, specify an empty string.
     * <p>
     * <code>NoDevice</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html">Amazon EC2 BlockDeviceMapping</a> property.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * NoDeviceProperty noDeviceProperty = NoDeviceProperty.builder().build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.NoDeviceProperty")
    @software.amazon.jsii.Jsii.Proxy(NoDeviceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NoDeviceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link NoDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NoDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NoDeviceProperty> {

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NoDeviceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NoDeviceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NoDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NoDeviceProperty {

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();


                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.NoDeviceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }
        }
    }
    /**
     * The type of hostnames to assign to instances in the subnet at launch.
     * <p>
     * For IPv4 only subnets, an instance DNS name must be based on the instance IPv4 address. For IPv6 only subnets, an instance DNS name must be based on the instance ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">Amazon EC2 instance hostname types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * PrivateDnsNameOptionsProperty privateDnsNameOptionsProperty = PrivateDnsNameOptionsProperty.builder()
     *         .enableResourceNameDnsAaaaRecord(false)
     *         .enableResourceNameDnsARecord(false)
     *         .hostnameType("hostnameType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.PrivateDnsNameOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(PrivateDnsNameOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrivateDnsNameOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">Amazon EC2 instance hostname types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableResourceNameDnsAaaaRecord() {
            return null;
        }

        /**
         * Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">Amazon EC2 instance hostname types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableResourceNameDnsARecord() {
            return null;
        }

        /**
         * The type of hostnames to assign to instances in the subnet at launch.
         * <p>
         * For IPv4 only subnets, an instance DNS name must be based on the instance IPv4 address. For IPv6 only subnets, an instance DNS name must be based on the instance ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">Amazon EC2 instance hostname types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostnameType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PrivateDnsNameOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrivateDnsNameOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrivateDnsNameOptionsProperty> {
            java.lang.Object enableResourceNameDnsAaaaRecord;
            java.lang.Object enableResourceNameDnsARecord;
            java.lang.String hostnameType;

            /**
             * Sets the value of {@link PrivateDnsNameOptionsProperty#getEnableResourceNameDnsAaaaRecord}
             * @param enableResourceNameDnsAaaaRecord Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
             *                                        For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">Amazon EC2 instance hostname types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableResourceNameDnsAaaaRecord(java.lang.Boolean enableResourceNameDnsAaaaRecord) {
                this.enableResourceNameDnsAaaaRecord = enableResourceNameDnsAaaaRecord;
                return this;
            }

            /**
             * Sets the value of {@link PrivateDnsNameOptionsProperty#getEnableResourceNameDnsAaaaRecord}
             * @param enableResourceNameDnsAaaaRecord Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
             *                                        For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">Amazon EC2 instance hostname types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableResourceNameDnsAaaaRecord(software.amazon.awscdk.core.IResolvable enableResourceNameDnsAaaaRecord) {
                this.enableResourceNameDnsAaaaRecord = enableResourceNameDnsAaaaRecord;
                return this;
            }

            /**
             * Sets the value of {@link PrivateDnsNameOptionsProperty#getEnableResourceNameDnsARecord}
             * @param enableResourceNameDnsARecord Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
             *                                     For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">Amazon EC2 instance hostname types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableResourceNameDnsARecord(java.lang.Boolean enableResourceNameDnsARecord) {
                this.enableResourceNameDnsARecord = enableResourceNameDnsARecord;
                return this;
            }

            /**
             * Sets the value of {@link PrivateDnsNameOptionsProperty#getEnableResourceNameDnsARecord}
             * @param enableResourceNameDnsARecord Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
             *                                     For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">Amazon EC2 instance hostname types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableResourceNameDnsARecord(software.amazon.awscdk.core.IResolvable enableResourceNameDnsARecord) {
                this.enableResourceNameDnsARecord = enableResourceNameDnsARecord;
                return this;
            }

            /**
             * Sets the value of {@link PrivateDnsNameOptionsProperty#getHostnameType}
             * @param hostnameType The type of hostnames to assign to instances in the subnet at launch.
             *                     For IPv4 only subnets, an instance DNS name must be based on the instance IPv4 address. For IPv6 only subnets, an instance DNS name must be based on the instance ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">Amazon EC2 instance hostname types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostnameType(java.lang.String hostnameType) {
                this.hostnameType = hostnameType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateDnsNameOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrivateDnsNameOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrivateDnsNameOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivateDnsNameOptionsProperty {
            private final java.lang.Object enableResourceNameDnsAaaaRecord;
            private final java.lang.Object enableResourceNameDnsARecord;
            private final java.lang.String hostnameType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableResourceNameDnsAaaaRecord = software.amazon.jsii.Kernel.get(this, "enableResourceNameDnsAaaaRecord", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableResourceNameDnsARecord = software.amazon.jsii.Kernel.get(this, "enableResourceNameDnsARecord", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hostnameType = software.amazon.jsii.Kernel.get(this, "hostnameType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableResourceNameDnsAaaaRecord = builder.enableResourceNameDnsAaaaRecord;
                this.enableResourceNameDnsARecord = builder.enableResourceNameDnsARecord;
                this.hostnameType = builder.hostnameType;
            }

            @Override
            public final java.lang.Object getEnableResourceNameDnsAaaaRecord() {
                return this.enableResourceNameDnsAaaaRecord;
            }

            @Override
            public final java.lang.Object getEnableResourceNameDnsARecord() {
                return this.enableResourceNameDnsARecord;
            }

            @Override
            public final java.lang.String getHostnameType() {
                return this.hostnameType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnableResourceNameDnsAaaaRecord() != null) {
                    data.set("enableResourceNameDnsAaaaRecord", om.valueToTree(this.getEnableResourceNameDnsAaaaRecord()));
                }
                if (this.getEnableResourceNameDnsARecord() != null) {
                    data.set("enableResourceNameDnsARecord", om.valueToTree(this.getEnableResourceNameDnsARecord()));
                }
                if (this.getHostnameType() != null) {
                    data.set("hostnameType", om.valueToTree(this.getHostnameType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.PrivateDnsNameOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrivateDnsNameOptionsProperty.Jsii$Proxy that = (PrivateDnsNameOptionsProperty.Jsii$Proxy) o;

                if (this.enableResourceNameDnsAaaaRecord != null ? !this.enableResourceNameDnsAaaaRecord.equals(that.enableResourceNameDnsAaaaRecord) : that.enableResourceNameDnsAaaaRecord != null) return false;
                if (this.enableResourceNameDnsARecord != null ? !this.enableResourceNameDnsARecord.equals(that.enableResourceNameDnsARecord) : that.enableResourceNameDnsARecord != null) return false;
                return this.hostnameType != null ? this.hostnameType.equals(that.hostnameType) : that.hostnameType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableResourceNameDnsAaaaRecord != null ? this.enableResourceNameDnsAaaaRecord.hashCode() : 0;
                result = 31 * result + (this.enableResourceNameDnsARecord != null ? this.enableResourceNameDnsARecord.hashCode() : 0);
                result = 31 * result + (this.hostnameType != null ? this.hostnameType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a secondary private IPv4 address for a network interface.
     * <p>
     * <code>PrivateIpAddressSpecification</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html">AWS::EC2::NetworkInterface</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * PrivateIpAddressSpecificationProperty privateIpAddressSpecificationProperty = PrivateIpAddressSpecificationProperty.builder()
     *         .primary(false)
     *         .privateIpAddress("privateIpAddress")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.PrivateIpAddressSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PrivateIpAddressSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrivateIpAddressSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the private IPv4 address is the primary private IPv4 address.
         * <p>
         * Only one IPv4 address can be designated as primary.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPrimary();

        /**
         * The private IPv4 addresses.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrivateIpAddress();

        /**
         * @return a {@link Builder} of {@link PrivateIpAddressSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrivateIpAddressSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrivateIpAddressSpecificationProperty> {
            java.lang.Object primary;
            java.lang.String privateIpAddress;

            /**
             * Sets the value of {@link PrivateIpAddressSpecificationProperty#getPrimary}
             * @param primary Indicates whether the private IPv4 address is the primary private IPv4 address. This parameter is required.
             *                Only one IPv4 address can be designated as primary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primary(java.lang.Boolean primary) {
                this.primary = primary;
                return this;
            }

            /**
             * Sets the value of {@link PrivateIpAddressSpecificationProperty#getPrimary}
             * @param primary Indicates whether the private IPv4 address is the primary private IPv4 address. This parameter is required.
             *                Only one IPv4 address can be designated as primary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primary(software.amazon.awscdk.core.IResolvable primary) {
                this.primary = primary;
                return this;
            }

            /**
             * Sets the value of {@link PrivateIpAddressSpecificationProperty#getPrivateIpAddress}
             * @param privateIpAddress The private IPv4 addresses. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddress(java.lang.String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateIpAddressSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrivateIpAddressSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrivateIpAddressSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivateIpAddressSpecificationProperty {
            private final java.lang.Object primary;
            private final java.lang.String privateIpAddress;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.primary = software.amazon.jsii.Kernel.get(this, "primary", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.privateIpAddress = software.amazon.jsii.Kernel.get(this, "privateIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.primary = java.util.Objects.requireNonNull(builder.primary, "primary is required");
                this.privateIpAddress = java.util.Objects.requireNonNull(builder.privateIpAddress, "privateIpAddress is required");
            }

            @Override
            public final java.lang.Object getPrimary() {
                return this.primary;
            }

            @Override
            public final java.lang.String getPrivateIpAddress() {
                return this.privateIpAddress;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("primary", om.valueToTree(this.getPrimary()));
                data.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.PrivateIpAddressSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrivateIpAddressSpecificationProperty.Jsii$Proxy that = (PrivateIpAddressSpecificationProperty.Jsii$Proxy) o;

                if (!primary.equals(that.primary)) return false;
                return this.privateIpAddress.equals(that.privateIpAddress);
            }

            @Override
            public final int hashCode() {
                int result = this.primary.hashCode();
                result = 31 * result + (this.privateIpAddress.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the SSM document and parameter values in AWS Systems Manager to associate with an instance.
     * <p>
     * <code>SsmAssociations</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html">AWS::EC2::Instance</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * SsmAssociationProperty ssmAssociationProperty = SsmAssociationProperty.builder()
     *         .documentName("documentName")
     *         // the properties below are optional
     *         .associationParameters(List.of(AssociationParameterProperty.builder()
     *                 .key("key")
     *                 .value(List.of("value"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.SsmAssociationProperty")
    @software.amazon.jsii.Jsii.Proxy(SsmAssociationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SsmAssociationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of an SSM document to associate with the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDocumentName();

        /**
         * The input parameter values to use with the associated SSM document.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAssociationParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SsmAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SsmAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SsmAssociationProperty> {
            java.lang.String documentName;
            java.lang.Object associationParameters;

            /**
             * Sets the value of {@link SsmAssociationProperty#getDocumentName}
             * @param documentName The name of an SSM document to associate with the instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentName(java.lang.String documentName) {
                this.documentName = documentName;
                return this;
            }

            /**
             * Sets the value of {@link SsmAssociationProperty#getAssociationParameters}
             * @param associationParameters The input parameter values to use with the associated SSM document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associationParameters(software.amazon.awscdk.core.IResolvable associationParameters) {
                this.associationParameters = associationParameters;
                return this;
            }

            /**
             * Sets the value of {@link SsmAssociationProperty#getAssociationParameters}
             * @param associationParameters The input parameter values to use with the associated SSM document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associationParameters(java.util.List<? extends java.lang.Object> associationParameters) {
                this.associationParameters = associationParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SsmAssociationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SsmAssociationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SsmAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SsmAssociationProperty {
            private final java.lang.String documentName;
            private final java.lang.Object associationParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.documentName = software.amazon.jsii.Kernel.get(this, "documentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.associationParameters = software.amazon.jsii.Kernel.get(this, "associationParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.documentName = java.util.Objects.requireNonNull(builder.documentName, "documentName is required");
                this.associationParameters = builder.associationParameters;
            }

            @Override
            public final java.lang.String getDocumentName() {
                return this.documentName;
            }

            @Override
            public final java.lang.Object getAssociationParameters() {
                return this.associationParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("documentName", om.valueToTree(this.getDocumentName()));
                if (this.getAssociationParameters() != null) {
                    data.set("associationParameters", om.valueToTree(this.getAssociationParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.SsmAssociationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SsmAssociationProperty.Jsii$Proxy that = (SsmAssociationProperty.Jsii$Proxy) o;

                if (!documentName.equals(that.documentName)) return false;
                return this.associationParameters != null ? this.associationParameters.equals(that.associationParameters) : that.associationParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.documentName.hashCode();
                result = 31 * result + (this.associationParameters != null ? this.associationParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a volume to attach to an instance.
     * <p>
     * <code>Volume</code> is an embedded property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html">AWS::EC2::Instance</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * VolumeProperty volumeProperty = VolumeProperty.builder()
     *         .device("device")
     *         .volumeId("volumeId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.VolumeProperty")
    @software.amazon.jsii.Jsii.Proxy(VolumeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VolumeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The device name (for example, `/dev/sdh` or `xvdh` ).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDevice();

        /**
         * The ID of the EBS volume.
         * <p>
         * The volume and instance must be within the same Availability Zone.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVolumeId();

        /**
         * @return a {@link Builder} of {@link VolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VolumeProperty> {
            java.lang.String device;
            java.lang.String volumeId;

            /**
             * Sets the value of {@link VolumeProperty#getDevice}
             * @param device The device name (for example, `/dev/sdh` or `xvdh` ). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder device(java.lang.String device) {
                this.device = device;
                return this;
            }

            /**
             * Sets the value of {@link VolumeProperty#getVolumeId}
             * @param volumeId The ID of the EBS volume. This parameter is required.
             *                 The volume and instance must be within the same Availability Zone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeId(java.lang.String volumeId) {
                this.volumeId = volumeId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VolumeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumeProperty {
            private final java.lang.String device;
            private final java.lang.String volumeId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.device = software.amazon.jsii.Kernel.get(this, "device", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.volumeId = software.amazon.jsii.Kernel.get(this, "volumeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.device = java.util.Objects.requireNonNull(builder.device, "device is required");
                this.volumeId = java.util.Objects.requireNonNull(builder.volumeId, "volumeId is required");
            }

            @Override
            public final java.lang.String getDevice() {
                return this.device;
            }

            @Override
            public final java.lang.String getVolumeId() {
                return this.volumeId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("device", om.valueToTree(this.getDevice()));
                data.set("volumeId", om.valueToTree(this.getVolumeId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.VolumeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VolumeProperty.Jsii$Proxy that = (VolumeProperty.Jsii$Proxy) o;

                if (!device.equals(that.device)) return false;
                return this.volumeId.equals(that.volumeId);
            }

            @Override
            public final int hashCode() {
                int result = this.device.hashCode();
                result = 31 * result + (this.volumeId.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnInstance}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnInstance> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ec2.CfnInstanceProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * This property is reserved for internal use.
         * <p>
         * If you use it, the stack fails with this error: <code>Bad property set: [Testing this property] (Service: AmazonEC2; Status Code: 400; Error Code: InvalidParameterCombination; Request ID: 0XXXXXX-49c7-4b40-8bcc-76885dcXXXXX)</code> .
         * <p>
         * @return {@code this}
         * @param additionalInfo This property is reserved for internal use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInfo(final java.lang.String additionalInfo) {
            this.props().additionalInfo(additionalInfo);
            return this;
        }

        /**
         * Indicates whether the instance is associated with a dedicated host.
         * <p>
         * If you want the instance to always restart on the same host on which it was launched, specify <code>host</code> . If you want the instance to restart on any available host, but try to launch onto the last host it ran on (on a best-effort basis), specify <code>default</code> .
         * <p>
         * @return {@code this}
         * @param affinity Indicates whether the instance is associated with a dedicated host. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder affinity(final java.lang.String affinity) {
            this.props().affinity(affinity);
            return this;
        }

        /**
         * The Availability Zone of the instance.
         * <p>
         * If not specified, an Availability Zone will be automatically chosen for you based on the load balancing criteria for the Region.
         * <p>
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute.html">DescribeImageAttribute</a> .
         * <p>
         * @return {@code this}
         * @param availabilityZone The Availability Zone of the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props().availabilityZone(availabilityZone);
            return this;
        }

        /**
         * The block device mapping entries that defines the block devices to attach to the instance at launch.
         * <p>
         * By default, the block devices specified in the block device mapping for the AMI are used. You can override the AMI block device mapping using the instance block device mapping. For the root volume, you can override only the volume size, volume type, volume encryption settings, and the <code>DeleteOnTermination</code> setting.
         * <p>
         * <blockquote>
         * <p>
         * After the instance is running, you can modify only the <code>DeleteOnTermination</code> parameter for the attached volumes without interrupting the instance. Modifying any other parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param blockDeviceMappings The block device mapping entries that defines the block devices to attach to the instance at launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDeviceMappings(final software.amazon.awscdk.core.IResolvable blockDeviceMappings) {
            this.props().blockDeviceMappings(blockDeviceMappings);
            return this;
        }
        /**
         * The block device mapping entries that defines the block devices to attach to the instance at launch.
         * <p>
         * By default, the block devices specified in the block device mapping for the AMI are used. You can override the AMI block device mapping using the instance block device mapping. For the root volume, you can override only the volume size, volume type, volume encryption settings, and the <code>DeleteOnTermination</code> setting.
         * <p>
         * <blockquote>
         * <p>
         * After the instance is running, you can modify only the <code>DeleteOnTermination</code> parameter for the attached volumes without interrupting the instance. Modifying any other parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param blockDeviceMappings The block device mapping entries that defines the block devices to attach to the instance at launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDeviceMappings(final java.util.List<? extends java.lang.Object> blockDeviceMappings) {
            this.props().blockDeviceMappings(blockDeviceMappings);
            return this;
        }

        /**
         * The CPU options for the instance.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU options</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         * <p>
         * @return {@code this}
         * @param cpuOptions The CPU options for the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuOptions(final software.amazon.awscdk.core.IResolvable cpuOptions) {
            this.props().cpuOptions(cpuOptions);
            return this;
        }
        /**
         * The CPU options for the instance.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU options</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         * <p>
         * @return {@code this}
         * @param cpuOptions The CPU options for the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuOptions(final software.amazon.awscdk.services.ec2.CfnInstance.CpuOptionsProperty cpuOptions) {
            this.props().cpuOptions(cpuOptions);
            return this;
        }

        /**
         * The credit option for CPU usage of the burstable performance instance.
         * <p>
         * Valid values are <code>standard</code> and <code>unlimited</code> . To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html">ModifyInstanceCreditSpecification</a> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * Default: <code>standard</code> (T2 instances) or <code>unlimited</code> (T3/T3a instances)
         * <p>
         * For T3 instances with <code>host</code> tenancy, only <code>standard</code> is supported.
         * <p>
         * @return {@code this}
         * @param creditSpecification The credit option for CPU usage of the burstable performance instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creditSpecification(final software.amazon.awscdk.core.IResolvable creditSpecification) {
            this.props().creditSpecification(creditSpecification);
            return this;
        }
        /**
         * The credit option for CPU usage of the burstable performance instance.
         * <p>
         * Valid values are <code>standard</code> and <code>unlimited</code> . To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html">ModifyInstanceCreditSpecification</a> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * Default: <code>standard</code> (T2 instances) or <code>unlimited</code> (T3/T3a instances)
         * <p>
         * For T3 instances with <code>host</code> tenancy, only <code>standard</code> is supported.
         * <p>
         * @return {@code this}
         * @param creditSpecification The credit option for CPU usage of the burstable performance instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creditSpecification(final software.amazon.awscdk.services.ec2.CfnInstance.CreditSpecificationProperty creditSpecification) {
            this.props().creditSpecification(creditSpecification);
            return this;
        }

        /**
         * If you set this parameter to `true` , you can't terminate the instance using the Amazon EC2 console, CLI, or API;
         * <p>
         * otherwise, you can. To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute</a> . Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code> , you can terminate the instance by running the shutdown command from the instance.
         * <p>
         * Default: <code>false</code>
         * <p>
         * @return {@code this}
         * @param disableApiTermination If you set this parameter to `true` , you can't terminate the instance using the Amazon EC2 console, CLI, or API;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableApiTermination(final java.lang.Boolean disableApiTermination) {
            this.props().disableApiTermination(disableApiTermination);
            return this;
        }
        /**
         * If you set this parameter to `true` , you can't terminate the instance using the Amazon EC2 console, CLI, or API;
         * <p>
         * otherwise, you can. To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute</a> . Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code> , you can terminate the instance by running the shutdown command from the instance.
         * <p>
         * Default: <code>false</code>
         * <p>
         * @return {@code this}
         * @param disableApiTermination If you set this parameter to `true` , you can't terminate the instance using the Amazon EC2 console, CLI, or API;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableApiTermination(final software.amazon.awscdk.core.IResolvable disableApiTermination) {
            this.props().disableApiTermination(disableApiTermination);
            return this;
        }

        /**
         * Indicates whether the instance is optimized for Amazon EBS I/O.
         * <p>
         * This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
         * <p>
         * Default: <code>false</code>
         * <p>
         * @return {@code this}
         * @param ebsOptimized Indicates whether the instance is optimized for Amazon EBS I/O. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(final java.lang.Boolean ebsOptimized) {
            this.props().ebsOptimized(ebsOptimized);
            return this;
        }
        /**
         * Indicates whether the instance is optimized for Amazon EBS I/O.
         * <p>
         * This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
         * <p>
         * Default: <code>false</code>
         * <p>
         * @return {@code this}
         * @param ebsOptimized Indicates whether the instance is optimized for Amazon EBS I/O. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(final software.amazon.awscdk.core.IResolvable ebsOptimized) {
            this.props().ebsOptimized(ebsOptimized);
            return this;
        }

        /**
         * An elastic GPU to associate with the instance.
         * <p>
         * An Elastic GPU is a GPU resource that you can attach to your Windows instance to accelerate the graphics performance of your applications. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon EC2 Elastic GPUs</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param elasticGpuSpecifications An elastic GPU to associate with the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticGpuSpecifications(final software.amazon.awscdk.core.IResolvable elasticGpuSpecifications) {
            this.props().elasticGpuSpecifications(elasticGpuSpecifications);
            return this;
        }
        /**
         * An elastic GPU to associate with the instance.
         * <p>
         * An Elastic GPU is a GPU resource that you can attach to your Windows instance to accelerate the graphics performance of your applications. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon EC2 Elastic GPUs</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param elasticGpuSpecifications An elastic GPU to associate with the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticGpuSpecifications(final java.util.List<? extends java.lang.Object> elasticGpuSpecifications) {
            this.props().elasticGpuSpecifications(elasticGpuSpecifications);
            return this;
        }

        /**
         * An elastic inference accelerator to associate with the instance.
         * <p>
         * Elastic inference accelerators are a resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference workloads.
         * <p>
         * You cannot specify accelerators from different generations in the same request.
         * <p>
         * @return {@code this}
         * @param elasticInferenceAccelerators An elastic inference accelerator to associate with the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticInferenceAccelerators(final software.amazon.awscdk.core.IResolvable elasticInferenceAccelerators) {
            this.props().elasticInferenceAccelerators(elasticInferenceAccelerators);
            return this;
        }
        /**
         * An elastic inference accelerator to associate with the instance.
         * <p>
         * Elastic inference accelerators are a resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference workloads.
         * <p>
         * You cannot specify accelerators from different generations in the same request.
         * <p>
         * @return {@code this}
         * @param elasticInferenceAccelerators An elastic inference accelerator to associate with the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticInferenceAccelerators(final java.util.List<? extends java.lang.Object> elasticInferenceAccelerators) {
            this.props().elasticInferenceAccelerators(elasticInferenceAccelerators);
            return this;
        }

        /**
         * Indicates whether the instance is enabled for AWS Nitro Enclaves.
         * <p>
         * @return {@code this}
         * @param enclaveOptions Indicates whether the instance is enabled for AWS Nitro Enclaves. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enclaveOptions(final software.amazon.awscdk.core.IResolvable enclaveOptions) {
            this.props().enclaveOptions(enclaveOptions);
            return this;
        }
        /**
         * Indicates whether the instance is enabled for AWS Nitro Enclaves.
         * <p>
         * @return {@code this}
         * @param enclaveOptions Indicates whether the instance is enabled for AWS Nitro Enclaves. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enclaveOptions(final software.amazon.awscdk.services.ec2.CfnInstance.EnclaveOptionsProperty enclaveOptions) {
            this.props().enclaveOptions(enclaveOptions);
            return this;
        }

        /**
         * Indicates whether an instance is enabled for hibernation.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * You can't enable hibernation and AWS Nitro Enclaves on the same instance.
         * <p>
         * @return {@code this}
         * @param hibernationOptions Indicates whether an instance is enabled for hibernation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hibernationOptions(final software.amazon.awscdk.core.IResolvable hibernationOptions) {
            this.props().hibernationOptions(hibernationOptions);
            return this;
        }
        /**
         * Indicates whether an instance is enabled for hibernation.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * You can't enable hibernation and AWS Nitro Enclaves on the same instance.
         * <p>
         * @return {@code this}
         * @param hibernationOptions Indicates whether an instance is enabled for hibernation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hibernationOptions(final software.amazon.awscdk.services.ec2.CfnInstance.HibernationOptionsProperty hibernationOptions) {
            this.props().hibernationOptions(hibernationOptions);
            return this;
        }

        /**
         * If you specify host for the `Affinity` property, the ID of a dedicated host that the instance is associated with.
         * <p>
         * If you don't specify an ID, Amazon EC2 launches the instance onto any available, compatible dedicated host in your account. This type of launch is called an untargeted launch. Note that for untargeted launches, you must have a compatible, dedicated host available to successfully launch instances.
         * <p>
         * @return {@code this}
         * @param hostId If you specify host for the `Affinity` property, the ID of a dedicated host that the instance is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostId(final java.lang.String hostId) {
            this.props().hostId(hostId);
            return this;
        }

        /**
         * The ARN of the host resource group in which to launch the instances.
         * <p>
         * If you specify a host resource group ARN, omit the <em>Tenancy</em> parameter or set it to <code>host</code> .
         * <p>
         * @return {@code this}
         * @param hostResourceGroupArn The ARN of the host resource group in which to launch the instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostResourceGroupArn(final java.lang.String hostResourceGroupArn) {
            this.props().hostResourceGroupArn(hostResourceGroupArn);
            return this;
        }

        /**
         * The name of an IAM instance profile.
         * <p>
         * To create a new IAM instance profile, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a> resource.
         * <p>
         * @return {@code this}
         * @param iamInstanceProfile The name of an IAM instance profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamInstanceProfile(final java.lang.String iamInstanceProfile) {
            this.props().iamInstanceProfile(iamInstanceProfile);
            return this;
        }

        /**
         * The ID of the AMI.
         * <p>
         * An AMI ID is required to launch an instance and must be specified here or in a launch template.
         * <p>
         * @return {@code this}
         * @param imageId The ID of the AMI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageId(final java.lang.String imageId) {
            this.props().imageId(imageId);
            return this;
        }

        /**
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
         * <p>
         * Default: <code>stop</code>
         * <p>
         * @return {@code this}
         * @param instanceInitiatedShutdownBehavior Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceInitiatedShutdownBehavior(final java.lang.String instanceInitiatedShutdownBehavior) {
            this.props().instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior);
            return this;
        }

        /**
         * The instance type. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide* .
         * <p>
         * Default: <code>m1.small</code>
         * <p>
         * @return {@code this}
         * @param instanceType The instance type. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide* . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final java.lang.String instanceType) {
            this.props().instanceType(instanceType);
            return this;
        }

        /**
         * [EC2-VPC] The number of IPv6 addresses to associate with the primary network interface.
         * <p>
         * Amazon EC2 chooses the IPv6 addresses from the range of your subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number of instances to launch.
         * <p>
         * You cannot specify this option and the network interfaces option in the same request.
         * <p>
         * @return {@code this}
         * @param ipv6AddressCount [EC2-VPC] The number of IPv6 addresses to associate with the primary network interface. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6AddressCount(final java.lang.Number ipv6AddressCount) {
            this.props().ipv6AddressCount(ipv6AddressCount);
            return this;
        }

        /**
         * [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface.
         * <p>
         * You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.
         * <p>
         * You cannot specify this option and the network interfaces option in the same request.
         * <p>
         * @return {@code this}
         * @param ipv6Addresses [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Addresses(final software.amazon.awscdk.core.IResolvable ipv6Addresses) {
            this.props().ipv6Addresses(ipv6Addresses);
            return this;
        }
        /**
         * [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface.
         * <p>
         * You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.
         * <p>
         * You cannot specify this option and the network interfaces option in the same request.
         * <p>
         * @return {@code this}
         * @param ipv6Addresses [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Addresses(final java.util.List<? extends java.lang.Object> ipv6Addresses) {
            this.props().ipv6Addresses(ipv6Addresses);
            return this;
        }

        /**
         * The ID of the kernel.
         * <p>
         * <blockquote>
         * <p>
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">PV-GRUB</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param kernelId The ID of the kernel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kernelId(final java.lang.String kernelId) {
            this.props().kernelId(kernelId);
            return this;
        }

        /**
         * The name of the key pair. You can create a key pair using [CreateKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html) or [ImportKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html) .
         * <p>
         * <blockquote>
         * <p>
         * If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is configured to allow users another way to log in.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param keyName The name of the key pair. You can create a key pair using [CreateKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html) or [ImportKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html) . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyName(final java.lang.String keyName) {
            this.props().keyName(keyName);
            return this;
        }

        /**
         * The launch template to use to launch the instances.
         * <p>
         * Any parameters that you specify in the AWS CloudFormation template override the same parameters in the launch template. You can specify either the name or ID of a launch template, but not both.
         * <p>
         * @return {@code this}
         * @param launchTemplate The launch template to use to launch the instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplate(final software.amazon.awscdk.core.IResolvable launchTemplate) {
            this.props().launchTemplate(launchTemplate);
            return this;
        }
        /**
         * The launch template to use to launch the instances.
         * <p>
         * Any parameters that you specify in the AWS CloudFormation template override the same parameters in the launch template. You can specify either the name or ID of a launch template, but not both.
         * <p>
         * @return {@code this}
         * @param launchTemplate The launch template to use to launch the instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplate(final software.amazon.awscdk.services.ec2.CfnInstance.LaunchTemplateSpecificationProperty launchTemplate) {
            this.props().launchTemplate(launchTemplate);
            return this;
        }

        /**
         * The license configurations.
         * <p>
         * @return {@code this}
         * @param licenseSpecifications The license configurations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseSpecifications(final software.amazon.awscdk.core.IResolvable licenseSpecifications) {
            this.props().licenseSpecifications(licenseSpecifications);
            return this;
        }
        /**
         * The license configurations.
         * <p>
         * @return {@code this}
         * @param licenseSpecifications The license configurations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseSpecifications(final java.util.List<? extends java.lang.Object> licenseSpecifications) {
            this.props().licenseSpecifications(licenseSpecifications);
            return this;
        }

        /**
         * Specifies whether detailed monitoring is enabled for the instance.
         * <p>
         * Specify <code>true</code> to enable detailed monitoring. Otherwise, basic monitoring is enabled. For more information about detailed monitoring, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off detailed monitoring for your instances</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param monitoring Specifies whether detailed monitoring is enabled for the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoring(final java.lang.Boolean monitoring) {
            this.props().monitoring(monitoring);
            return this;
        }
        /**
         * Specifies whether detailed monitoring is enabled for the instance.
         * <p>
         * Specify <code>true</code> to enable detailed monitoring. Otherwise, basic monitoring is enabled. For more information about detailed monitoring, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off detailed monitoring for your instances</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param monitoring Specifies whether detailed monitoring is enabled for the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoring(final software.amazon.awscdk.core.IResolvable monitoring) {
            this.props().monitoring(monitoring);
            return this;
        }

        /**
         * The network interfaces to associate with the instance.
         * <p>
         * <blockquote>
         * <p>
         * If you use this property to point to a network interface, you must terminate the original interface before attaching a new one to allow the update of the instance to succeed.
         * <p>
         * If this resource has a public IP address and is also in a VPC that is defined in the same template, you must use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> to declare a dependency on the VPC-gateway attachment.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param networkInterfaces The network interfaces to associate with the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaces(final software.amazon.awscdk.core.IResolvable networkInterfaces) {
            this.props().networkInterfaces(networkInterfaces);
            return this;
        }
        /**
         * The network interfaces to associate with the instance.
         * <p>
         * <blockquote>
         * <p>
         * If you use this property to point to a network interface, you must terminate the original interface before attaching a new one to allow the update of the instance to succeed.
         * <p>
         * If this resource has a public IP address and is also in a VPC that is defined in the same template, you must use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> to declare a dependency on the VPC-gateway attachment.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param networkInterfaces The network interfaces to associate with the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaces(final java.util.List<? extends java.lang.Object> networkInterfaces) {
            this.props().networkInterfaces(networkInterfaces);
            return this;
        }

        /**
         * The name of an existing placement group that you want to launch the instance into (cluster | partition | spread).
         * <p>
         * @return {@code this}
         * @param placementGroupName The name of an existing placement group that you want to launch the instance into (cluster | partition | spread). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementGroupName(final java.lang.String placementGroupName) {
            this.props().placementGroupName(placementGroupName);
            return this;
        }

        /**
         * The options for the instance hostname.
         * <p>
         * @return {@code this}
         * @param privateDnsNameOptions The options for the instance hostname. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsNameOptions(final software.amazon.awscdk.core.IResolvable privateDnsNameOptions) {
            this.props().privateDnsNameOptions(privateDnsNameOptions);
            return this;
        }
        /**
         * The options for the instance hostname.
         * <p>
         * @return {@code this}
         * @param privateDnsNameOptions The options for the instance hostname. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsNameOptions(final software.amazon.awscdk.services.ec2.CfnInstance.PrivateDnsNameOptionsProperty privateDnsNameOptions) {
            this.props().privateDnsNameOptions(privateDnsNameOptions);
            return this;
        }

        /**
         * [EC2-VPC] The primary IPv4 address. You must specify a value from the IPv4 address range of the subnet.
         * <p>
         * Only one private IP address can be designated as primary. You can't specify this option if you've specified the option to designate a private IP address as the primary IP address in a network interface specification. You cannot specify this option if you're launching more than one instance in the request.
         * <p>
         * You cannot specify this option and the network interfaces option in the same request.
         * <p>
         * If you make an update to an instance that requires replacement, you must assign a new private IP address. During a replacement, AWS CloudFormation creates a new instance but doesn't delete the old instance until the stack has successfully updated. If the stack update fails, AWS CloudFormation uses the old instance to roll back the stack to the previous working state. The old and new instances cannot have the same private IP address.
         * <p>
         * @return {@code this}
         * @param privateIpAddress [EC2-VPC] The primary IPv4 address. You must specify a value from the IPv4 address range of the subnet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateIpAddress(final java.lang.String privateIpAddress) {
            this.props().privateIpAddress(privateIpAddress);
            return this;
        }

        /**
         * Indicates whether to assign the tags from the instance to all of the volumes attached to the instance at launch.
         * <p>
         * If you specify <code>true</code> and you assign tags to the instance, those tags are automatically assigned to all of the volumes that you attach to the instance at launch. If you specify <code>false</code> , those tags are not assigned to the attached volumes.
         * <p>
         * @return {@code this}
         * @param propagateTagsToVolumeOnCreation Indicates whether to assign the tags from the instance to all of the volumes attached to the instance at launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTagsToVolumeOnCreation(final java.lang.Boolean propagateTagsToVolumeOnCreation) {
            this.props().propagateTagsToVolumeOnCreation(propagateTagsToVolumeOnCreation);
            return this;
        }
        /**
         * Indicates whether to assign the tags from the instance to all of the volumes attached to the instance at launch.
         * <p>
         * If you specify <code>true</code> and you assign tags to the instance, those tags are automatically assigned to all of the volumes that you attach to the instance at launch. If you specify <code>false</code> , those tags are not assigned to the attached volumes.
         * <p>
         * @return {@code this}
         * @param propagateTagsToVolumeOnCreation Indicates whether to assign the tags from the instance to all of the volumes attached to the instance at launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTagsToVolumeOnCreation(final software.amazon.awscdk.core.IResolvable propagateTagsToVolumeOnCreation) {
            this.props().propagateTagsToVolumeOnCreation(propagateTagsToVolumeOnCreation);
            return this;
        }

        /**
         * The ID of the RAM disk to select.
         * <p>
         * Some kernels require additional drivers at launch. Check the kernel requirements for information about whether you need to specify a RAM disk. To find kernel requirements, go to the AWS Resource Center and search for the kernel ID.
         * <p>
         * <blockquote>
         * <p>
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">PV-GRUB</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param ramdiskId The ID of the RAM disk to select. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ramdiskId(final java.lang.String ramdiskId) {
            this.props().ramdiskId(ramdiskId);
            return this;
        }

        /**
         * The IDs of the security groups. You can create a security group using [CreateSecurityGroup](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html) .
         * <p>
         * If you specify a network interface, you must specify any security groups as part of the network interface.
         * <p>
         * @return {@code this}
         * @param securityGroupIds The IDs of the security groups. You can create a security group using [CreateSecurityGroup](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html) . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(final java.util.List<java.lang.String> securityGroupIds) {
            this.props().securityGroupIds(securityGroupIds);
            return this;
        }

        /**
         * [EC2-Classic, default VPC] The names of the security groups.
         * <p>
         * For a nondefault VPC, you must use security group IDs instead.
         * <p>
         * You cannot specify this option and the network interfaces option in the same request. The list can contain both the name of existing Amazon EC2 security groups or references to AWS::EC2::SecurityGroup resources created in the template.
         * <p>
         * Default: Amazon EC2 uses the default security group.
         * <p>
         * @return {@code this}
         * @param securityGroups [EC2-Classic, default VPC] The names of the security groups. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<java.lang.String> securityGroups) {
            this.props().securityGroups(securityGroups);
            return this;
        }

        /**
         * Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives.
         * <p>
         * If the value is <code>true</code> , source/destination checks are enabled; otherwise, they are disabled. The default value is <code>true</code> . You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls.
         * <p>
         * @return {@code this}
         * @param sourceDestCheck Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDestCheck(final java.lang.Boolean sourceDestCheck) {
            this.props().sourceDestCheck(sourceDestCheck);
            return this;
        }
        /**
         * Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives.
         * <p>
         * If the value is <code>true</code> , source/destination checks are enabled; otherwise, they are disabled. The default value is <code>true</code> . You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls.
         * <p>
         * @return {@code this}
         * @param sourceDestCheck Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDestCheck(final software.amazon.awscdk.core.IResolvable sourceDestCheck) {
            this.props().sourceDestCheck(sourceDestCheck);
            return this;
        }

        /**
         * The SSM [document](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html) and parameter values in AWS Systems Manager to associate with this instance. To use this property, you must specify an IAM instance profile role for the instance. For more information, see [Create an Instance Profile for Systems Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-configuring-access-role.html) in the *AWS Systems Manager User Guide* .
         * <p>
         * <blockquote>
         * <p>
         * You can currently associate only one document with an instance.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param ssmAssociations The SSM [document](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html) and parameter values in AWS Systems Manager to associate with this instance. To use this property, you must specify an IAM instance profile role for the instance. For more information, see [Create an Instance Profile for Systems Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-configuring-access-role.html) in the *AWS Systems Manager User Guide* . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ssmAssociations(final software.amazon.awscdk.core.IResolvable ssmAssociations) {
            this.props().ssmAssociations(ssmAssociations);
            return this;
        }
        /**
         * The SSM [document](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html) and parameter values in AWS Systems Manager to associate with this instance. To use this property, you must specify an IAM instance profile role for the instance. For more information, see [Create an Instance Profile for Systems Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-configuring-access-role.html) in the *AWS Systems Manager User Guide* .
         * <p>
         * <blockquote>
         * <p>
         * You can currently associate only one document with an instance.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param ssmAssociations The SSM [document](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html) and parameter values in AWS Systems Manager to associate with this instance. To use this property, you must specify an IAM instance profile role for the instance. For more information, see [Create an Instance Profile for Systems Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-configuring-access-role.html) in the *AWS Systems Manager User Guide* . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ssmAssociations(final java.util.List<? extends java.lang.Object> ssmAssociations) {
            this.props().ssmAssociations(ssmAssociations);
            return this;
        }

        /**
         * [EC2-VPC] The ID of the subnet to launch the instance into.
         * <p>
         * If you specify a network interface, you must specify any subnets as part of the network interface.
         * <p>
         * @return {@code this}
         * @param subnetId [EC2-VPC] The ID of the subnet to launch the instance into. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetId(final java.lang.String subnetId) {
            this.props().subnetId(subnetId);
            return this;
        }

        /**
         * The tags to add to the instance.
         * <p>
         * These tags are not applied to the EBS volumes, such as the root volume.
         * <p>
         * @return {@code this}
         * @param tags The tags to add to the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The tenancy of the instance (if the instance is running in a VPC).
         * <p>
         * An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware.
         * <p>
         * @return {@code this}
         * @param tenancy The tenancy of the instance (if the instance is running in a VPC). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tenancy(final java.lang.String tenancy) {
            this.props().tenancy(tenancy);
            return this;
        }

        /**
         * The user data script to make available to the instance.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Run commands on your Linux instance at launch</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-windows-user-data.html">Run commands on your Windows instance at launch</a> . If you are using a command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16 KB.
         * <p>
         * @return {@code this}
         * @param userData The user data script to make available to the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final java.lang.String userData) {
            this.props().userData(userData);
            return this;
        }

        /**
         * The volumes to attach to the instance.
         * <p>
         * @return {@code this}
         * @param volumes The volumes to attach to the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final software.amazon.awscdk.core.IResolvable volumes) {
            this.props().volumes(volumes);
            return this;
        }
        /**
         * The volumes to attach to the instance.
         * <p>
         * @return {@code this}
         * @param volumes The volumes to attach to the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final java.util.List<? extends java.lang.Object> volumes) {
            this.props().volumes(volumes);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnInstance}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnInstance build() {
            return new software.amazon.awscdk.services.ec2.CfnInstance(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.CfnInstanceProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.CfnInstanceProps.Builder();
            }
            return this.props;
        }
    }
}
