package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnLocalGatewayRoute`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnLocalGatewayRouteProps cfnLocalGatewayRouteProps = CfnLocalGatewayRouteProps.builder()
 *         .destinationCidrBlock("destinationCidrBlock")
 *         .localGatewayRouteTableId("localGatewayRouteTableId")
 *         .localGatewayVirtualInterfaceGroupId("localGatewayVirtualInterfaceGroupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.66.0 (build 3c9512b)", date = "2022-08-31T20:25:13.110Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLocalGatewayRouteProps")
@software.amazon.jsii.Jsii.Proxy(CfnLocalGatewayRouteProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLocalGatewayRouteProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The CIDR block used for destination matches.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDestinationCidrBlock();

    /**
     * The ID of the local gateway route table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLocalGatewayRouteTableId();

    /**
     * The ID of the virtual interface group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLocalGatewayVirtualInterfaceGroupId();

    /**
     * @return a {@link Builder} of {@link CfnLocalGatewayRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLocalGatewayRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLocalGatewayRouteProps> {
        java.lang.String destinationCidrBlock;
        java.lang.String localGatewayRouteTableId;
        java.lang.String localGatewayVirtualInterfaceGroupId;

        /**
         * Sets the value of {@link CfnLocalGatewayRouteProps#getDestinationCidrBlock}
         * @param destinationCidrBlock The CIDR block used for destination matches. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationCidrBlock(java.lang.String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocalGatewayRouteProps#getLocalGatewayRouteTableId}
         * @param localGatewayRouteTableId The ID of the local gateway route table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localGatewayRouteTableId(java.lang.String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocalGatewayRouteProps#getLocalGatewayVirtualInterfaceGroupId}
         * @param localGatewayVirtualInterfaceGroupId The ID of the virtual interface group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localGatewayVirtualInterfaceGroupId(java.lang.String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLocalGatewayRouteProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLocalGatewayRouteProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLocalGatewayRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLocalGatewayRouteProps {
        private final java.lang.String destinationCidrBlock;
        private final java.lang.String localGatewayRouteTableId;
        private final java.lang.String localGatewayVirtualInterfaceGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationCidrBlock = software.amazon.jsii.Kernel.get(this, "destinationCidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.localGatewayRouteTableId = software.amazon.jsii.Kernel.get(this, "localGatewayRouteTableId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.localGatewayVirtualInterfaceGroupId = software.amazon.jsii.Kernel.get(this, "localGatewayVirtualInterfaceGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationCidrBlock = java.util.Objects.requireNonNull(builder.destinationCidrBlock, "destinationCidrBlock is required");
            this.localGatewayRouteTableId = java.util.Objects.requireNonNull(builder.localGatewayRouteTableId, "localGatewayRouteTableId is required");
            this.localGatewayVirtualInterfaceGroupId = java.util.Objects.requireNonNull(builder.localGatewayVirtualInterfaceGroupId, "localGatewayVirtualInterfaceGroupId is required");
        }

        @Override
        public final java.lang.String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public final java.lang.String getLocalGatewayRouteTableId() {
            return this.localGatewayRouteTableId;
        }

        @Override
        public final java.lang.String getLocalGatewayVirtualInterfaceGroupId() {
            return this.localGatewayVirtualInterfaceGroupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationCidrBlock", om.valueToTree(this.getDestinationCidrBlock()));
            data.set("localGatewayRouteTableId", om.valueToTree(this.getLocalGatewayRouteTableId()));
            data.set("localGatewayVirtualInterfaceGroupId", om.valueToTree(this.getLocalGatewayVirtualInterfaceGroupId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLocalGatewayRouteProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLocalGatewayRouteProps.Jsii$Proxy that = (CfnLocalGatewayRouteProps.Jsii$Proxy) o;

            if (!destinationCidrBlock.equals(that.destinationCidrBlock)) return false;
            if (!localGatewayRouteTableId.equals(that.localGatewayRouteTableId)) return false;
            return this.localGatewayVirtualInterfaceGroupId.equals(that.localGatewayVirtualInterfaceGroupId);
        }

        @Override
        public final int hashCode() {
            int result = this.destinationCidrBlock.hashCode();
            result = 31 * result + (this.localGatewayRouteTableId.hashCode());
            result = 31 * result + (this.localGatewayVirtualInterfaceGroupId.hashCode());
            return result;
        }
    }
}
