package software.amazon.awscdk.services.ec2;

/**
 * A VPC flow log.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * LogGroup logGroup = new LogGroup(this, "MyCustomLogGroup");
 * Role role = Role.Builder.create(this, "MyCustomRole")
 *         .assumedBy(new ServicePrincipal("vpc-flow-logs.amazonaws.com"))
 *         .build();
 * FlowLog.Builder.create(this, "FlowLog")
 *         .resourceType(FlowLogResourceType.fromVpc(vpc))
 *         .destination(FlowLogDestination.toCloudWatchLogs(logGroup, role))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.66.0 (build 3c9512b)", date = "2022-08-31T20:25:13.481Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.FlowLog")
public class FlowLog extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.ec2.IFlowLog {

    protected FlowLog(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FlowLog(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FlowLog(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLogProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import a Flow Log by it's Id.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param flowLogId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IFlowLog fromFlowLogId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String flowLogId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.FlowLog.class, "fromFlowLogId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IFlowLog.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(flowLogId, "flowLogId is required") });
    }

    /**
     * The Id of the VPC Flow Log.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFlowLogId() {
        return software.amazon.jsii.Kernel.get(this, "flowLogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The S3 bucket to publish flow logs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getBucket() {
        return software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     * The iam role used to publish logs to CloudWatch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getIamRole() {
        return software.amazon.jsii.Kernel.get(this, "iamRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * S3 bucket key prefix to publish the flow logs under.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKeyPrefix() {
        return software.amazon.jsii.Kernel.get(this, "keyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CloudWatch Logs LogGroup to publish flow logs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.FlowLog}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.FlowLog> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.FlowLogProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.FlowLogProps.Builder();
        }

        /**
         * Specifies the type of destination to which the flow log data is to be published.
         * <p>
         * Flow log data can be published to CloudWatch Logs or Amazon S3
         * <p>
         * Default: FlowLogDestinationType.toCloudWatchLogs()
         * <p>
         * @return {@code this}
         * @param destination Specifies the type of destination to which the flow log data is to be published. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(final software.amazon.awscdk.services.ec2.FlowLogDestination destination) {
            this.props.destination(destination);
            return this;
        }

        /**
         * The type of traffic to log.
         * <p>
         * You can log traffic that the resource accepts or rejects, or all traffic.
         * <p>
         * Default: ALL
         * <p>
         * @return {@code this}
         * @param trafficType The type of traffic to log. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficType(final software.amazon.awscdk.services.ec2.FlowLogTrafficType trafficType) {
            this.props.trafficType(trafficType);
            return this;
        }

        /**
         * The type of resource for which to create the flow log.
         * <p>
         * @return {@code this}
         * @param resourceType The type of resource for which to create the flow log. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(final software.amazon.awscdk.services.ec2.FlowLogResourceType resourceType) {
            this.props.resourceType(resourceType);
            return this;
        }

        /**
         * The name of the FlowLog.
         * <p>
         * It is not recommended to use an explicit name.
         * <p>
         * Default: If you don't specify a flowLogName, AWS CloudFormation generates a
         * unique physical ID and uses that ID for the group name.
         * <p>
         * @return {@code this}
         * @param flowLogName The name of the FlowLog. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowLogName(final java.lang.String flowLogName) {
            this.props.flowLogName(flowLogName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.FlowLog}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.FlowLog build() {
            return new software.amazon.awscdk.services.ec2.FlowLog(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
