package software.amazon.awscdk.services.ec2;

/**
 * A machine image whose AMI ID will be searched using DescribeImages.
 * <p>
 * The most recent, available, launchable image matching the given filter
 * criteria will be used. Looking up AMIs may take a long time; specify
 * as many filter criteria as possible to narrow down the search.
 * <p>
 * The AMI selected will be cached in <code>cdk.context.json</code> and the same value
 * will be used on future runs. To refresh the AMI lookup, you will have to
 * evict the value from the cache using the <code>cdk context</code> command. See
 * https://docs.aws.amazon.com/cdk/latest/guide/context.html for more information.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * UserData userData;
 * LookupMachineImage lookupMachineImage = LookupMachineImage.Builder.create()
 *         .name("name")
 *         // the properties below are optional
 *         .filters(Map.of(
 *                 "filtersKey", List.of("filters")))
 *         .owners(List.of("owners"))
 *         .userData(userData)
 *         .windows(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-07T23:46:50.333Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.LookupMachineImage")
public class LookupMachineImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IMachineImage {

    protected LookupMachineImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LookupMachineImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LookupMachineImage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.LookupMachineImageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Return the image to use in the given context.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.MachineImageConfig getImage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
        return software.amazon.jsii.Kernel.call(this, "getImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.MachineImageConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.LookupMachineImage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.LookupMachineImage> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.ec2.LookupMachineImageProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.ec2.LookupMachineImageProps.Builder();
        }

        /**
         * Name of the image (may contain wildcards).
         * <p>
         * @return {@code this}
         * @param name Name of the image (may contain wildcards). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Additional filters on the AMI.
         * <p>
         * Default: - No additional filters
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImages.html">https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImages.html</a>
         * @param filters Additional filters on the AMI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filters(final java.util.Map<java.lang.String, ? extends java.util.List<java.lang.String>> filters) {
            this.props.filters(filters);
            return this;
        }

        /**
         * Owner account IDs or aliases.
         * <p>
         * Default: - All owners
         * <p>
         * @return {@code this}
         * @param owners Owner account IDs or aliases. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder owners(final java.util.List<java.lang.String> owners) {
            this.props.owners(owners);
            return this;
        }

        /**
         * Custom userdata for this image.
         * <p>
         * Default: - Empty user data appropriate for the platform type
         * <p>
         * @return {@code this}
         * @param userData Custom userdata for this image. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final software.amazon.awscdk.services.ec2.UserData userData) {
            this.props.userData(userData);
            return this;
        }

        /**
         * Look for Windows images.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param windows Look for Windows images. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder windows(final java.lang.Boolean windows) {
            this.props.windows(windows);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.LookupMachineImage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.LookupMachineImage build() {
            return new software.amazon.awscdk.services.ec2.LookupMachineImage(
                this.props.build()
            );
        }
    }
}
