package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::Route`.
 * <p>
 * Specifies a route in a route table within a VPC.
 * <p>
 * You must specify either <code>DestinationCidrBlock</code> or <code>DestinationIpv6CidrBlock</code> , plus the ID of one of the target resources.
 * <p>
 * If you create a route that references a transit gateway in the same template where you create the transit gateway, you must declare a dependency on the transit gateway attachment. The route table cannot use the transit gateway until it has successfully attached to the VPC. Add a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> in the <code>AWS::EC2::Route</code> resource to explicitly declare a dependency on the <code>AWS::EC2::TransitGatewayAttachment</code> resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnRoute cfnRoute = CfnRoute.Builder.create(this, "MyCfnRoute")
 *         .routeTableId("routeTableId")
 *         // the properties below are optional
 *         .carrierGatewayId("carrierGatewayId")
 *         .destinationCidrBlock("destinationCidrBlock")
 *         .destinationIpv6CidrBlock("destinationIpv6CidrBlock")
 *         .egressOnlyInternetGatewayId("egressOnlyInternetGatewayId")
 *         .gatewayId("gatewayId")
 *         .instanceId("instanceId")
 *         .localGatewayId("localGatewayId")
 *         .natGatewayId("natGatewayId")
 *         .networkInterfaceId("networkInterfaceId")
 *         .transitGatewayId("transitGatewayId")
 *         .vpcEndpointId("vpcEndpointId")
 *         .vpcPeeringConnectionId("vpcPeeringConnectionId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-10-06T13:25:01.974Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnRoute")
public class CfnRoute extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnRoute(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRoute(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnRoute.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::Route`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRoute(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnRouteProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ID of the route table.
     * <p>
     * The routing table must be associated with the same VPC that the virtual private gateway is attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRouteTableId() {
        return software.amazon.jsii.Kernel.get(this, "routeTableId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the route table.
     * <p>
     * The routing table must be associated with the same VPC that the virtual private gateway is attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRouteTableId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "routeTableId", java.util.Objects.requireNonNull(value, "routeTableId is required"));
    }

    /**
     * The ID of the carrier gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCarrierGatewayId() {
        return software.amazon.jsii.Kernel.get(this, "carrierGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the carrier gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCarrierGatewayId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "carrierGatewayId", value);
    }

    /**
     * The IPv4 CIDR block used for the destination match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDestinationCidrBlock() {
        return software.amazon.jsii.Kernel.get(this, "destinationCidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IPv4 CIDR block used for the destination match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinationCidrBlock(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "destinationCidrBlock", value);
    }

    /**
     * The IPv6 CIDR block used for the destination match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDestinationIpv6CidrBlock() {
        return software.amazon.jsii.Kernel.get(this, "destinationIpv6CidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IPv6 CIDR block used for the destination match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinationIpv6CidrBlock(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "destinationIpv6CidrBlock", value);
    }

    /**
     * The ID of the egress-only internet gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEgressOnlyInternetGatewayId() {
        return software.amazon.jsii.Kernel.get(this, "egressOnlyInternetGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the egress-only internet gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEgressOnlyInternetGatewayId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "egressOnlyInternetGatewayId", value);
    }

    /**
     * The ID of an internet gateway or virtual private gateway attached to your VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGatewayId() {
        return software.amazon.jsii.Kernel.get(this, "gatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of an internet gateway or virtual private gateway attached to your VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGatewayId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "gatewayId", value);
    }

    /**
     * The ID of a NAT instance in your VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceId() {
        return software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of a NAT instance in your VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceId", value);
    }

    /**
     * The ID of the local gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLocalGatewayId() {
        return software.amazon.jsii.Kernel.get(this, "localGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the local gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLocalGatewayId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "localGatewayId", value);
    }

    /**
     * The ID of a NAT gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNatGatewayId() {
        return software.amazon.jsii.Kernel.get(this, "natGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of a NAT gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNatGatewayId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "natGatewayId", value);
    }

    /**
     * The ID of the network interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNetworkInterfaceId() {
        return software.amazon.jsii.Kernel.get(this, "networkInterfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the network interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkInterfaceId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "networkInterfaceId", value);
    }

    /**
     * The ID of a transit gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTransitGatewayId() {
        return software.amazon.jsii.Kernel.get(this, "transitGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of a transit gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransitGatewayId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "transitGatewayId", value);
    }

    /**
     * The ID of a VPC endpoint.
     * <p>
     * Supported for Gateway Load Balancer endpoints only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpcEndpointId() {
        return software.amazon.jsii.Kernel.get(this, "vpcEndpointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of a VPC endpoint.
     * <p>
     * Supported for Gateway Load Balancer endpoints only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcEndpointId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpcEndpointId", value);
    }

    /**
     * The ID of a VPC peering connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpcPeeringConnectionId() {
        return software.amazon.jsii.Kernel.get(this, "vpcPeeringConnectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of a VPC peering connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcPeeringConnectionId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpcPeeringConnectionId", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnRoute}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnRoute> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnRouteProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnRouteProps.Builder();
        }

        /**
         * The ID of the route table.
         * <p>
         * The routing table must be associated with the same VPC that the virtual private gateway is attached to.
         * <p>
         * @return {@code this}
         * @param routeTableId The ID of the route table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeTableId(final java.lang.String routeTableId) {
            this.props.routeTableId(routeTableId);
            return this;
        }

        /**
         * The ID of the carrier gateway.
         * <p>
         * @return {@code this}
         * @param carrierGatewayId The ID of the carrier gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder carrierGatewayId(final java.lang.String carrierGatewayId) {
            this.props.carrierGatewayId(carrierGatewayId);
            return this;
        }

        /**
         * The IPv4 CIDR block used for the destination match.
         * <p>
         * @return {@code this}
         * @param destinationCidrBlock The IPv4 CIDR block used for the destination match. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationCidrBlock(final java.lang.String destinationCidrBlock) {
            this.props.destinationCidrBlock(destinationCidrBlock);
            return this;
        }

        /**
         * The IPv6 CIDR block used for the destination match.
         * <p>
         * @return {@code this}
         * @param destinationIpv6CidrBlock The IPv6 CIDR block used for the destination match. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationIpv6CidrBlock(final java.lang.String destinationIpv6CidrBlock) {
            this.props.destinationIpv6CidrBlock(destinationIpv6CidrBlock);
            return this;
        }

        /**
         * The ID of the egress-only internet gateway.
         * <p>
         * @return {@code this}
         * @param egressOnlyInternetGatewayId The ID of the egress-only internet gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressOnlyInternetGatewayId(final java.lang.String egressOnlyInternetGatewayId) {
            this.props.egressOnlyInternetGatewayId(egressOnlyInternetGatewayId);
            return this;
        }

        /**
         * The ID of an internet gateway or virtual private gateway attached to your VPC.
         * <p>
         * @return {@code this}
         * @param gatewayId The ID of an internet gateway or virtual private gateway attached to your VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayId(final java.lang.String gatewayId) {
            this.props.gatewayId(gatewayId);
            return this;
        }

        /**
         * The ID of a NAT instance in your VPC.
         * <p>
         * @return {@code this}
         * @param instanceId The ID of a NAT instance in your VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(final java.lang.String instanceId) {
            this.props.instanceId(instanceId);
            return this;
        }

        /**
         * The ID of the local gateway.
         * <p>
         * @return {@code this}
         * @param localGatewayId The ID of the local gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localGatewayId(final java.lang.String localGatewayId) {
            this.props.localGatewayId(localGatewayId);
            return this;
        }

        /**
         * The ID of a NAT gateway.
         * <p>
         * @return {@code this}
         * @param natGatewayId The ID of a NAT gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder natGatewayId(final java.lang.String natGatewayId) {
            this.props.natGatewayId(natGatewayId);
            return this;
        }

        /**
         * The ID of the network interface.
         * <p>
         * @return {@code this}
         * @param networkInterfaceId The ID of the network interface. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaceId(final java.lang.String networkInterfaceId) {
            this.props.networkInterfaceId(networkInterfaceId);
            return this;
        }

        /**
         * The ID of a transit gateway.
         * <p>
         * @return {@code this}
         * @param transitGatewayId The ID of a transit gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayId(final java.lang.String transitGatewayId) {
            this.props.transitGatewayId(transitGatewayId);
            return this;
        }

        /**
         * The ID of a VPC endpoint.
         * <p>
         * Supported for Gateway Load Balancer endpoints only.
         * <p>
         * @return {@code this}
         * @param vpcEndpointId The ID of a VPC endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcEndpointId(final java.lang.String vpcEndpointId) {
            this.props.vpcEndpointId(vpcEndpointId);
            return this;
        }

        /**
         * The ID of a VPC peering connection.
         * <p>
         * @return {@code this}
         * @param vpcPeeringConnectionId The ID of a VPC peering connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcPeeringConnectionId(final java.lang.String vpcPeeringConnectionId) {
            this.props.vpcPeeringConnectionId(vpcPeeringConnectionId);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnRoute}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnRoute build() {
            return new software.amazon.awscdk.services.ec2.CfnRoute(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
