package software.amazon.awscdk.services.ec2;

/**
 * Specify configuration parameters for a single subnet group in a VPC.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * SubnetConfiguration subnetConfiguration = SubnetConfiguration.builder()
 *         .name("name")
 *         .subnetType(SubnetType.ISOLATED)
 *         // the properties below are optional
 *         .cidrMask(123)
 *         .mapPublicIpOnLaunch(false)
 *         .reserved(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-10-06T13:25:02.434Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.SubnetConfiguration")
@software.amazon.jsii.Jsii.Proxy(SubnetConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubnetConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * Logical name for the subnet group.
     * <p>
     * This name can be used when selecting VPC subnets to distinguish
     * between different subnet groups of the same type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The type of Subnet to configure.
     * <p>
     * The Subnet type will control the ability to route and connect to the
     * Internet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SubnetType getSubnetType();

    /**
     * The number of leading 1 bits in the routing mask.
     * <p>
     * The number of available IP addresses in each subnet of this group
     * will be equal to <code>2^(32 - cidrMask) - 2</code>.
     * <p>
     * Valid values are <code>16--28</code>.
     * <p>
     * Default: - Available IP space is evenly divided across subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCidrMask() {
        return null;
    }

    /**
     * Controls if a public IP is associated to an instance at launch.
     * <p>
     * Default: true in Subnet.Public, false in Subnet.Private or Subnet.Isolated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMapPublicIpOnLaunch() {
        return null;
    }

    /**
     * Controls if subnet IP space needs to be reserved.
     * <p>
     * When true, the IP space for the subnet is reserved but no actual
     * resources are provisioned. This space is only dependent on the
     * number of availability zones and on <code>cidrMask</code> - all other subnet
     * properties are ignored.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReserved() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SubnetConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubnetConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SubnetConfiguration> {
        java.lang.String name;
        software.amazon.awscdk.services.ec2.SubnetType subnetType;
        java.lang.Number cidrMask;
        java.lang.Boolean mapPublicIpOnLaunch;
        java.lang.Boolean reserved;

        /**
         * Sets the value of {@link SubnetConfiguration#getName}
         * @param name Logical name for the subnet group. This parameter is required.
         *             This name can be used when selecting VPC subnets to distinguish
         *             between different subnet groups of the same type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link SubnetConfiguration#getSubnetType}
         * @param subnetType The type of Subnet to configure. This parameter is required.
         *                   The Subnet type will control the ability to route and connect to the
         *                   Internet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetType(software.amazon.awscdk.services.ec2.SubnetType subnetType) {
            this.subnetType = subnetType;
            return this;
        }

        /**
         * Sets the value of {@link SubnetConfiguration#getCidrMask}
         * @param cidrMask The number of leading 1 bits in the routing mask.
         *                 The number of available IP addresses in each subnet of this group
         *                 will be equal to <code>2^(32 - cidrMask) - 2</code>.
         *                 <p>
         *                 Valid values are <code>16--28</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrMask(java.lang.Number cidrMask) {
            this.cidrMask = cidrMask;
            return this;
        }

        /**
         * Sets the value of {@link SubnetConfiguration#getMapPublicIpOnLaunch}
         * @param mapPublicIpOnLaunch Controls if a public IP is associated to an instance at launch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapPublicIpOnLaunch(java.lang.Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        /**
         * Sets the value of {@link SubnetConfiguration#getReserved}
         * @param reserved Controls if subnet IP space needs to be reserved.
         *                 When true, the IP space for the subnet is reserved but no actual
         *                 resources are provisioned. This space is only dependent on the
         *                 number of availability zones and on <code>cidrMask</code> - all other subnet
         *                 properties are ignored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reserved(java.lang.Boolean reserved) {
            this.reserved = reserved;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubnetConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SubnetConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SubnetConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubnetConfiguration {
        private final java.lang.String name;
        private final software.amazon.awscdk.services.ec2.SubnetType subnetType;
        private final java.lang.Number cidrMask;
        private final java.lang.Boolean mapPublicIpOnLaunch;
        private final java.lang.Boolean reserved;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetType = software.amazon.jsii.Kernel.get(this, "subnetType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetType.class));
            this.cidrMask = software.amazon.jsii.Kernel.get(this, "cidrMask", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.mapPublicIpOnLaunch = software.amazon.jsii.Kernel.get(this, "mapPublicIpOnLaunch", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.reserved = software.amazon.jsii.Kernel.get(this, "reserved", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.subnetType = java.util.Objects.requireNonNull(builder.subnetType, "subnetType is required");
            this.cidrMask = builder.cidrMask;
            this.mapPublicIpOnLaunch = builder.mapPublicIpOnLaunch;
            this.reserved = builder.reserved;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetType getSubnetType() {
            return this.subnetType;
        }

        @Override
        public final java.lang.Number getCidrMask() {
            return this.cidrMask;
        }

        @Override
        public final java.lang.Boolean getMapPublicIpOnLaunch() {
            return this.mapPublicIpOnLaunch;
        }

        @Override
        public final java.lang.Boolean getReserved() {
            return this.reserved;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("subnetType", om.valueToTree(this.getSubnetType()));
            if (this.getCidrMask() != null) {
                data.set("cidrMask", om.valueToTree(this.getCidrMask()));
            }
            if (this.getMapPublicIpOnLaunch() != null) {
                data.set("mapPublicIpOnLaunch", om.valueToTree(this.getMapPublicIpOnLaunch()));
            }
            if (this.getReserved() != null) {
                data.set("reserved", om.valueToTree(this.getReserved()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.SubnetConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubnetConfiguration.Jsii$Proxy that = (SubnetConfiguration.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!subnetType.equals(that.subnetType)) return false;
            if (this.cidrMask != null ? !this.cidrMask.equals(that.cidrMask) : that.cidrMask != null) return false;
            if (this.mapPublicIpOnLaunch != null ? !this.mapPublicIpOnLaunch.equals(that.mapPublicIpOnLaunch) : that.mapPublicIpOnLaunch != null) return false;
            return this.reserved != null ? this.reserved.equals(that.reserved) : that.reserved == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.subnetType.hashCode());
            result = 31 * result + (this.cidrMask != null ? this.cidrMask.hashCode() : 0);
            result = 31 * result + (this.mapPublicIpOnLaunch != null ? this.mapPublicIpOnLaunch.hashCode() : 0);
            result = 31 * result + (this.reserved != null ? this.reserved.hashCode() : 0);
            return result;
        }
    }
}
