package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnEC2Fleet`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnEC2FleetProps cfnEC2FleetProps = CfnEC2FleetProps.builder()
 *         .launchTemplateConfigs(List.of(FleetLaunchTemplateConfigRequestProperty.builder()
 *                 .launchTemplateSpecification(FleetLaunchTemplateSpecificationRequestProperty.builder()
 *                         .launchTemplateId("launchTemplateId")
 *                         .launchTemplateName("launchTemplateName")
 *                         .version("version")
 *                         .build())
 *                 .overrides(List.of(FleetLaunchTemplateOverridesRequestProperty.builder()
 *                         .availabilityZone("availabilityZone")
 *                         .instanceRequirements(InstanceRequirementsRequestProperty.builder()
 *                                 .acceleratorCount(AcceleratorCountRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .acceleratorManufacturers(List.of("acceleratorManufacturers"))
 *                                 .acceleratorNames(List.of("acceleratorNames"))
 *                                 .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .acceleratorTypes(List.of("acceleratorTypes"))
 *                                 .bareMetal("bareMetal")
 *                                 .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .burstablePerformance("burstablePerformance")
 *                                 .cpuManufacturers(List.of("cpuManufacturers"))
 *                                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
 *                                 .instanceGenerations(List.of("instanceGenerations"))
 *                                 .localStorage("localStorage")
 *                                 .localStorageTypes(List.of("localStorageTypes"))
 *                                 .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .memoryMiB(MemoryMiBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .onDemandMaxPricePercentageOverLowestPrice(123)
 *                                 .requireHibernateSupport(false)
 *                                 .spotMaxPricePercentageOverLowestPrice(123)
 *                                 .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .vCpuCount(VCpuCountRangeRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .build())
 *                         .instanceType("instanceType")
 *                         .maxPrice("maxPrice")
 *                         .placement(PlacementProperty.builder()
 *                                 .affinity("affinity")
 *                                 .availabilityZone("availabilityZone")
 *                                 .groupName("groupName")
 *                                 .hostId("hostId")
 *                                 .hostResourceGroupArn("hostResourceGroupArn")
 *                                 .partitionNumber(123)
 *                                 .spreadDomain("spreadDomain")
 *                                 .tenancy("tenancy")
 *                                 .build())
 *                         .priority(123)
 *                         .subnetId("subnetId")
 *                         .weightedCapacity(123)
 *                         .build()))
 *                 .build()))
 *         .targetCapacitySpecification(TargetCapacitySpecificationRequestProperty.builder()
 *                 .totalTargetCapacity(123)
 *                 // the properties below are optional
 *                 .defaultTargetCapacityType("defaultTargetCapacityType")
 *                 .onDemandTargetCapacity(123)
 *                 .spotTargetCapacity(123)
 *                 .targetCapacityUnitType("targetCapacityUnitType")
 *                 .build())
 *         // the properties below are optional
 *         .context("context")
 *         .excessCapacityTerminationPolicy("excessCapacityTerminationPolicy")
 *         .onDemandOptions(OnDemandOptionsRequestProperty.builder()
 *                 .allocationStrategy("allocationStrategy")
 *                 .capacityReservationOptions(CapacityReservationOptionsRequestProperty.builder()
 *                         .usageStrategy("usageStrategy")
 *                         .build())
 *                 .maxTotalPrice("maxTotalPrice")
 *                 .minTargetCapacity(123)
 *                 .singleAvailabilityZone(false)
 *                 .singleInstanceType(false)
 *                 .build())
 *         .replaceUnhealthyInstances(false)
 *         .spotOptions(SpotOptionsRequestProperty.builder()
 *                 .allocationStrategy("allocationStrategy")
 *                 .instanceInterruptionBehavior("instanceInterruptionBehavior")
 *                 .instancePoolsToUseCount(123)
 *                 .maintenanceStrategies(MaintenanceStrategiesProperty.builder()
 *                         .capacityRebalance(CapacityRebalanceProperty.builder()
 *                                 .replacementStrategy("replacementStrategy")
 *                                 .terminationDelay(123)
 *                                 .build())
 *                         .build())
 *                 .maxTotalPrice("maxTotalPrice")
 *                 .minTargetCapacity(123)
 *                 .singleAvailabilityZone(false)
 *                 .singleInstanceType(false)
 *                 .build())
 *         .tagSpecifications(List.of(TagSpecificationProperty.builder()
 *                 .resourceType("resourceType")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .terminateInstancesWithExpiration(false)
 *         .type("type")
 *         .validFrom("validFrom")
 *         .validUntil("validUntil")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-10-13T20:01:02.673Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2FleetProps")
@software.amazon.jsii.Jsii.Proxy(CfnEC2FleetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEC2FleetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The configuration for the EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getLaunchTemplateConfigs();

    /**
     * The number of units to request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTargetCapacitySpecification();

    /**
     * Reserved.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContext() {
        return null;
    }

    /**
     * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExcessCapacityTerminationPolicy() {
        return null;
    }

    /**
     * Describes the configuration of On-Demand Instances in an EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOnDemandOptions() {
        return null;
    }

    /**
     * Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
     * <p>
     * Supported only for fleets of type <code>maintain</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet health checks</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getReplaceUnhealthyInstances() {
        return null;
    }

    /**
     * Describes the configuration of Spot Instances in an EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSpotOptions() {
        return null;
    }

    /**
     * The key-value pair for tagging the EC2 Fleet request on creation. For more information, see [Tagging your resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources) .
     * <p>
     * If the fleet type is <code>instant</code> , specify a resource type of <code>fleet</code> to tag the fleet or <code>instance</code> to tag the instances at launch.
     * <p>
     * If the fleet type is <code>maintain</code> or <code>request</code> , specify a resource type of <code>fleet</code> to tag the fleet. You cannot specify a resource type of <code>instance</code> . To tag instances at launch, specify the tags in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
        return null;
    }

    /**
     * Indicates whether running instances should be terminated when the EC2 Fleet expires.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTerminateInstancesWithExpiration() {
        return null;
    }

    /**
     * The fleet type. The default value is `maintain` .
     * <p>
     * <ul>
     * <li><code>maintain</code> - The EC2 Fleet places an asynchronous request for your desired capacity, and continues to maintain your desired Spot capacity by replenishing interrupted Spot Instances.</li>
     * <li><code>request</code> - The EC2 Fleet places an asynchronous one-time request for your desired capacity, but does submit Spot requests in alternative capacity pools if Spot capacity is unavailable, and does not maintain Spot capacity if Spot Instances are interrupted.</li>
     * <li><code>instant</code> - The EC2 Fleet places a synchronous one-time request for your desired capacity, and returns errors for any instances that could not be launched.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-request-type.html">EC2 Fleet request types</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return null;
    }

    /**
     * The start date and time of the request, in UTC format (for example, *YYYY* - *MM* - *DD* T *HH* : *MM* : *SS* Z).
     * <p>
     * The default is to start fulfilling the request immediately.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getValidFrom() {
        return null;
    }

    /**
     * The end date and time of the request, in UTC format (for example, *YYYY* - *MM* - *DD* T *HH* : *MM* : *SS* Z).
     * <p>
     * At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getValidUntil() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEC2FleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEC2FleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEC2FleetProps> {
        java.lang.Object launchTemplateConfigs;
        java.lang.Object targetCapacitySpecification;
        java.lang.String context;
        java.lang.String excessCapacityTerminationPolicy;
        java.lang.Object onDemandOptions;
        java.lang.Object replaceUnhealthyInstances;
        java.lang.Object spotOptions;
        java.lang.Object tagSpecifications;
        java.lang.Object terminateInstancesWithExpiration;
        java.lang.String type;
        java.lang.String validFrom;
        java.lang.String validUntil;

        /**
         * Sets the value of {@link CfnEC2FleetProps#getLaunchTemplateConfigs}
         * @param launchTemplateConfigs The configuration for the EC2 Fleet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateConfigs(software.amazon.awscdk.core.IResolvable launchTemplateConfigs) {
            this.launchTemplateConfigs = launchTemplateConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnEC2FleetProps#getLaunchTemplateConfigs}
         * @param launchTemplateConfigs The configuration for the EC2 Fleet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateConfigs(java.util.List<? extends java.lang.Object> launchTemplateConfigs) {
            this.launchTemplateConfigs = launchTemplateConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnEC2FleetProps#getTargetCapacitySpecification}
         * @param targetCapacitySpecification The number of units to request. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetCapacitySpecification(software.amazon.awscdk.core.IResolvable targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnEC2FleetProps#getTargetCapacitySpecification}
         * @param targetCapacitySpecification The number of units to request. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetCapacitySpecification(software.amazon.awscdk.services.ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnEC2FleetProps#getContext}
         * @param context Reserved.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder context(java.lang.String context) {
            this.context = context;
            return this;
        }

        /**
         * Sets the value of {@link CfnEC2FleetProps#getExcessCapacityTerminationPolicy}
         * @param excessCapacityTerminationPolicy Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excessCapacityTerminationPolicy(java.lang.String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnEC2FleetProps#getOnDemandOptions}
         * @param onDemandOptions Describes the configuration of On-Demand Instances in an EC2 Fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onDemandOptions(software.amazon.awscdk.core.IResolvable onDemandOptions) {
            this.onDemandOptions = onDemandOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnEC2FleetProps#getOnDemandOptions}
         * @param onDemandOptions Describes the configuration of On-Demand Instances in an EC2 Fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onDemandOptions(software.amazon.awscdk.services.ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty onDemandOptions) {
            this.onDemandOptions = onDemandOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnEC2FleetProps#getReplaceUnhealthyInstances}
         * @param replaceUnhealthyInstances Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
         *                                  Supported only for fleets of type <code>maintain</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet health checks</a> in the <em>Amazon EC2 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceUnhealthyInstances(java.lang.Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
            return this;
        }

        /**
         * Sets the value of {@link CfnEC2FleetProps#getReplaceUnhealthyInstances}
         * @param replaceUnhealthyInstances Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
         *                                  Supported only for fleets of type <code>maintain</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet health checks</a> in the <em>Amazon EC2 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceUnhealthyInstances(software.amazon.awscdk.core.IResolvable replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
            return this;
        }

        /**
         * Sets the value of {@link CfnEC2FleetProps#getSpotOptions}
         * @param spotOptions Describes the configuration of Spot Instances in an EC2 Fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotOptions(software.amazon.awscdk.core.IResolvable spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnEC2FleetProps#getSpotOptions}
         * @param spotOptions Describes the configuration of Spot Instances in an EC2 Fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotOptions(software.amazon.awscdk.services.ec2.CfnEC2Fleet.SpotOptionsRequestProperty spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnEC2FleetProps#getTagSpecifications}
         * @param tagSpecifications The key-value pair for tagging the EC2 Fleet request on creation. For more information, see [Tagging your resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources) .
         *                          If the fleet type is <code>instant</code> , specify a resource type of <code>fleet</code> to tag the fleet or <code>instance</code> to tag the instances at launch.
         *                          <p>
         *                          If the fleet type is <code>maintain</code> or <code>request</code> , specify a resource type of <code>fleet</code> to tag the fleet. You cannot specify a resource type of <code>instance</code> . To tag instances at launch, specify the tags in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(software.amazon.awscdk.core.IResolvable tagSpecifications) {
            this.tagSpecifications = tagSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnEC2FleetProps#getTagSpecifications}
         * @param tagSpecifications The key-value pair for tagging the EC2 Fleet request on creation. For more information, see [Tagging your resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources) .
         *                          If the fleet type is <code>instant</code> , specify a resource type of <code>fleet</code> to tag the fleet or <code>instance</code> to tag the instances at launch.
         *                          <p>
         *                          If the fleet type is <code>maintain</code> or <code>request</code> , specify a resource type of <code>fleet</code> to tag the fleet. You cannot specify a resource type of <code>instance</code> . To tag instances at launch, specify the tags in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(java.util.List<? extends java.lang.Object> tagSpecifications) {
            this.tagSpecifications = tagSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnEC2FleetProps#getTerminateInstancesWithExpiration}
         * @param terminateInstancesWithExpiration Indicates whether running instances should be terminated when the EC2 Fleet expires.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminateInstancesWithExpiration(java.lang.Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
            return this;
        }

        /**
         * Sets the value of {@link CfnEC2FleetProps#getTerminateInstancesWithExpiration}
         * @param terminateInstancesWithExpiration Indicates whether running instances should be terminated when the EC2 Fleet expires.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminateInstancesWithExpiration(software.amazon.awscdk.core.IResolvable terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
            return this;
        }

        /**
         * Sets the value of {@link CfnEC2FleetProps#getType}
         * @param type The fleet type. The default value is `maintain` .
         *             <ul>
         *             <li><code>maintain</code> - The EC2 Fleet places an asynchronous request for your desired capacity, and continues to maintain your desired Spot capacity by replenishing interrupted Spot Instances.</li>
         *             <li><code>request</code> - The EC2 Fleet places an asynchronous one-time request for your desired capacity, but does submit Spot requests in alternative capacity pools if Spot capacity is unavailable, and does not maintain Spot capacity if Spot Instances are interrupted.</li>
         *             <li><code>instant</code> - The EC2 Fleet places a synchronous one-time request for your desired capacity, and returns errors for any instances that could not be launched.</li>
         *             </ul>
         *             <p>
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-request-type.html">EC2 Fleet request types</a> in the <em>Amazon EC2 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnEC2FleetProps#getValidFrom}
         * @param validFrom The start date and time of the request, in UTC format (for example, *YYYY* - *MM* - *DD* T *HH* : *MM* : *SS* Z).
         *                  The default is to start fulfilling the request immediately.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validFrom(java.lang.String validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        /**
         * Sets the value of {@link CfnEC2FleetProps#getValidUntil}
         * @param validUntil The end date and time of the request, in UTC format (for example, *YYYY* - *MM* - *DD* T *HH* : *MM* : *SS* Z).
         *                   At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validUntil(java.lang.String validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEC2FleetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEC2FleetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEC2FleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEC2FleetProps {
        private final java.lang.Object launchTemplateConfigs;
        private final java.lang.Object targetCapacitySpecification;
        private final java.lang.String context;
        private final java.lang.String excessCapacityTerminationPolicy;
        private final java.lang.Object onDemandOptions;
        private final java.lang.Object replaceUnhealthyInstances;
        private final java.lang.Object spotOptions;
        private final java.lang.Object tagSpecifications;
        private final java.lang.Object terminateInstancesWithExpiration;
        private final java.lang.String type;
        private final java.lang.String validFrom;
        private final java.lang.String validUntil;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.launchTemplateConfigs = software.amazon.jsii.Kernel.get(this, "launchTemplateConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.targetCapacitySpecification = software.amazon.jsii.Kernel.get(this, "targetCapacitySpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.context = software.amazon.jsii.Kernel.get(this, "context", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.excessCapacityTerminationPolicy = software.amazon.jsii.Kernel.get(this, "excessCapacityTerminationPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.onDemandOptions = software.amazon.jsii.Kernel.get(this, "onDemandOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.replaceUnhealthyInstances = software.amazon.jsii.Kernel.get(this, "replaceUnhealthyInstances", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.spotOptions = software.amazon.jsii.Kernel.get(this, "spotOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tagSpecifications = software.amazon.jsii.Kernel.get(this, "tagSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.terminateInstancesWithExpiration = software.amazon.jsii.Kernel.get(this, "terminateInstancesWithExpiration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.validFrom = software.amazon.jsii.Kernel.get(this, "validFrom", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.validUntil = software.amazon.jsii.Kernel.get(this, "validUntil", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.launchTemplateConfigs = java.util.Objects.requireNonNull(builder.launchTemplateConfigs, "launchTemplateConfigs is required");
            this.targetCapacitySpecification = java.util.Objects.requireNonNull(builder.targetCapacitySpecification, "targetCapacitySpecification is required");
            this.context = builder.context;
            this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
            this.onDemandOptions = builder.onDemandOptions;
            this.replaceUnhealthyInstances = builder.replaceUnhealthyInstances;
            this.spotOptions = builder.spotOptions;
            this.tagSpecifications = builder.tagSpecifications;
            this.terminateInstancesWithExpiration = builder.terminateInstancesWithExpiration;
            this.type = builder.type;
            this.validFrom = builder.validFrom;
            this.validUntil = builder.validUntil;
        }

        @Override
        public final java.lang.Object getLaunchTemplateConfigs() {
            return this.launchTemplateConfigs;
        }

        @Override
        public final java.lang.Object getTargetCapacitySpecification() {
            return this.targetCapacitySpecification;
        }

        @Override
        public final java.lang.String getContext() {
            return this.context;
        }

        @Override
        public final java.lang.String getExcessCapacityTerminationPolicy() {
            return this.excessCapacityTerminationPolicy;
        }

        @Override
        public final java.lang.Object getOnDemandOptions() {
            return this.onDemandOptions;
        }

        @Override
        public final java.lang.Object getReplaceUnhealthyInstances() {
            return this.replaceUnhealthyInstances;
        }

        @Override
        public final java.lang.Object getSpotOptions() {
            return this.spotOptions;
        }

        @Override
        public final java.lang.Object getTagSpecifications() {
            return this.tagSpecifications;
        }

        @Override
        public final java.lang.Object getTerminateInstancesWithExpiration() {
            return this.terminateInstancesWithExpiration;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getValidFrom() {
            return this.validFrom;
        }

        @Override
        public final java.lang.String getValidUntil() {
            return this.validUntil;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("launchTemplateConfigs", om.valueToTree(this.getLaunchTemplateConfigs()));
            data.set("targetCapacitySpecification", om.valueToTree(this.getTargetCapacitySpecification()));
            if (this.getContext() != null) {
                data.set("context", om.valueToTree(this.getContext()));
            }
            if (this.getExcessCapacityTerminationPolicy() != null) {
                data.set("excessCapacityTerminationPolicy", om.valueToTree(this.getExcessCapacityTerminationPolicy()));
            }
            if (this.getOnDemandOptions() != null) {
                data.set("onDemandOptions", om.valueToTree(this.getOnDemandOptions()));
            }
            if (this.getReplaceUnhealthyInstances() != null) {
                data.set("replaceUnhealthyInstances", om.valueToTree(this.getReplaceUnhealthyInstances()));
            }
            if (this.getSpotOptions() != null) {
                data.set("spotOptions", om.valueToTree(this.getSpotOptions()));
            }
            if (this.getTagSpecifications() != null) {
                data.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
            }
            if (this.getTerminateInstancesWithExpiration() != null) {
                data.set("terminateInstancesWithExpiration", om.valueToTree(this.getTerminateInstancesWithExpiration()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }
            if (this.getValidFrom() != null) {
                data.set("validFrom", om.valueToTree(this.getValidFrom()));
            }
            if (this.getValidUntil() != null) {
                data.set("validUntil", om.valueToTree(this.getValidUntil()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2FleetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEC2FleetProps.Jsii$Proxy that = (CfnEC2FleetProps.Jsii$Proxy) o;

            if (!launchTemplateConfigs.equals(that.launchTemplateConfigs)) return false;
            if (!targetCapacitySpecification.equals(that.targetCapacitySpecification)) return false;
            if (this.context != null ? !this.context.equals(that.context) : that.context != null) return false;
            if (this.excessCapacityTerminationPolicy != null ? !this.excessCapacityTerminationPolicy.equals(that.excessCapacityTerminationPolicy) : that.excessCapacityTerminationPolicy != null) return false;
            if (this.onDemandOptions != null ? !this.onDemandOptions.equals(that.onDemandOptions) : that.onDemandOptions != null) return false;
            if (this.replaceUnhealthyInstances != null ? !this.replaceUnhealthyInstances.equals(that.replaceUnhealthyInstances) : that.replaceUnhealthyInstances != null) return false;
            if (this.spotOptions != null ? !this.spotOptions.equals(that.spotOptions) : that.spotOptions != null) return false;
            if (this.tagSpecifications != null ? !this.tagSpecifications.equals(that.tagSpecifications) : that.tagSpecifications != null) return false;
            if (this.terminateInstancesWithExpiration != null ? !this.terminateInstancesWithExpiration.equals(that.terminateInstancesWithExpiration) : that.terminateInstancesWithExpiration != null) return false;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
            if (this.validFrom != null ? !this.validFrom.equals(that.validFrom) : that.validFrom != null) return false;
            return this.validUntil != null ? this.validUntil.equals(that.validUntil) : that.validUntil == null;
        }

        @Override
        public final int hashCode() {
            int result = this.launchTemplateConfigs.hashCode();
            result = 31 * result + (this.targetCapacitySpecification.hashCode());
            result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
            result = 31 * result + (this.excessCapacityTerminationPolicy != null ? this.excessCapacityTerminationPolicy.hashCode() : 0);
            result = 31 * result + (this.onDemandOptions != null ? this.onDemandOptions.hashCode() : 0);
            result = 31 * result + (this.replaceUnhealthyInstances != null ? this.replaceUnhealthyInstances.hashCode() : 0);
            result = 31 * result + (this.spotOptions != null ? this.spotOptions.hashCode() : 0);
            result = 31 * result + (this.tagSpecifications != null ? this.tagSpecifications.hashCode() : 0);
            result = 31 * result + (this.terminateInstancesWithExpiration != null ? this.terminateInstancesWithExpiration.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.validFrom != null ? this.validFrom.hashCode() : 0);
            result = 31 * result + (this.validUntil != null ? this.validUntil.hashCode() : 0);
            return result;
        }
    }
}
