package software.amazon.awscdk.services.ec2;

/**
 * Construction properties for a VpcEndpointService.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * NetworkLoadBalancer networkLoadBalancer1;
 * NetworkLoadBalancer networkLoadBalancer2;
 * VpcEndpointService.Builder.create(this, "EndpointService")
 *         .vpcEndpointServiceLoadBalancers(List.of(networkLoadBalancer1, networkLoadBalancer2))
 *         .acceptanceRequired(true)
 *         .allowedPrincipals(List.of(new ArnPrincipal("arn:aws:iam::123456789012:root")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-10-13T20:01:03.432Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.VpcEndpointServiceProps")
@software.amazon.jsii.Jsii.Proxy(VpcEndpointServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcEndpointServiceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * One or more load balancers to host the VPC Endpoint Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer> getVpcEndpointServiceLoadBalancers();

    /**
     * Whether requests from service consumers to connect to the service through an endpoint must be accepted.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAcceptanceRequired() {
        return null;
    }

    /**
     * IAM users, IAM roles, or AWS accounts to allow inbound connections from.
     * <p>
     * These principals can connect to your service using VPC endpoints. Takes a
     * list of one or more ArnPrincipal.
     * <p>
     * Default: - no principals
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal> getAllowedPrincipals() {
        return null;
    }

    /**
     * (deprecated) Name of the Vpc Endpoint Service.
     * <p>
     * Default: - CDK generated name
     * <p>
     * @deprecated This property is not used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcEndpointServiceName() {
        return null;
    }

    /**
     * (deprecated) IAM users, IAM roles, or AWS accounts to allow inbound connections from.
     * <p>
     * These principals can connect to your service using VPC endpoints. Takes a
     * list of one or more ArnPrincipal.
     * <p>
     * Default: - no principals
     * <p>
     * @deprecated use `allowedPrincipals`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal> getWhitelistedPrincipals() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VpcEndpointServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcEndpointServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VpcEndpointServiceProps> {
        java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer> vpcEndpointServiceLoadBalancers;
        java.lang.Boolean acceptanceRequired;
        java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal> allowedPrincipals;
        java.lang.String vpcEndpointServiceName;
        java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal> whitelistedPrincipals;

        /**
         * Sets the value of {@link VpcEndpointServiceProps#getVpcEndpointServiceLoadBalancers}
         * @param vpcEndpointServiceLoadBalancers One or more load balancers to host the VPC Endpoint Service. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder vpcEndpointServiceLoadBalancers(java.util.List<? extends software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer> vpcEndpointServiceLoadBalancers) {
            this.vpcEndpointServiceLoadBalancers = (java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer>)vpcEndpointServiceLoadBalancers;
            return this;
        }

        /**
         * Sets the value of {@link VpcEndpointServiceProps#getAcceptanceRequired}
         * @param acceptanceRequired Whether requests from service consumers to connect to the service through an endpoint must be accepted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptanceRequired(java.lang.Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        /**
         * Sets the value of {@link VpcEndpointServiceProps#getAllowedPrincipals}
         * @param allowedPrincipals IAM users, IAM roles, or AWS accounts to allow inbound connections from.
         *                          These principals can connect to your service using VPC endpoints. Takes a
         *                          list of one or more ArnPrincipal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder allowedPrincipals(java.util.List<? extends software.amazon.awscdk.services.iam.ArnPrincipal> allowedPrincipals) {
            this.allowedPrincipals = (java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal>)allowedPrincipals;
            return this;
        }

        /**
         * Sets the value of {@link VpcEndpointServiceProps#getVpcEndpointServiceName}
         * @param vpcEndpointServiceName Name of the Vpc Endpoint Service.
         * @return {@code this}
         * @deprecated This property is not used
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder vpcEndpointServiceName(java.lang.String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
            return this;
        }

        /**
         * Sets the value of {@link VpcEndpointServiceProps#getWhitelistedPrincipals}
         * @param whitelistedPrincipals IAM users, IAM roles, or AWS accounts to allow inbound connections from.
         *                              These principals can connect to your service using VPC endpoints. Takes a
         *                              list of one or more ArnPrincipal.
         * @return {@code this}
         * @deprecated use `allowedPrincipals`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        @SuppressWarnings("unchecked")
        public Builder whitelistedPrincipals(java.util.List<? extends software.amazon.awscdk.services.iam.ArnPrincipal> whitelistedPrincipals) {
            this.whitelistedPrincipals = (java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal>)whitelistedPrincipals;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcEndpointServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VpcEndpointServiceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VpcEndpointServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcEndpointServiceProps {
        private final java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer> vpcEndpointServiceLoadBalancers;
        private final java.lang.Boolean acceptanceRequired;
        private final java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal> allowedPrincipals;
        private final java.lang.String vpcEndpointServiceName;
        private final java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal> whitelistedPrincipals;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpcEndpointServiceLoadBalancers = software.amazon.jsii.Kernel.get(this, "vpcEndpointServiceLoadBalancers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer.class)));
            this.acceptanceRequired = software.amazon.jsii.Kernel.get(this, "acceptanceRequired", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.allowedPrincipals = software.amazon.jsii.Kernel.get(this, "allowedPrincipals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.ArnPrincipal.class)));
            this.vpcEndpointServiceName = software.amazon.jsii.Kernel.get(this, "vpcEndpointServiceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.whitelistedPrincipals = software.amazon.jsii.Kernel.get(this, "whitelistedPrincipals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.ArnPrincipal.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpcEndpointServiceLoadBalancers = (java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer>)java.util.Objects.requireNonNull(builder.vpcEndpointServiceLoadBalancers, "vpcEndpointServiceLoadBalancers is required");
            this.acceptanceRequired = builder.acceptanceRequired;
            this.allowedPrincipals = (java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal>)builder.allowedPrincipals;
            this.vpcEndpointServiceName = builder.vpcEndpointServiceName;
            this.whitelistedPrincipals = (java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal>)builder.whitelistedPrincipals;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer> getVpcEndpointServiceLoadBalancers() {
            return this.vpcEndpointServiceLoadBalancers;
        }

        @Override
        public final java.lang.Boolean getAcceptanceRequired() {
            return this.acceptanceRequired;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal> getAllowedPrincipals() {
            return this.allowedPrincipals;
        }

        @Override
        public final java.lang.String getVpcEndpointServiceName() {
            return this.vpcEndpointServiceName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal> getWhitelistedPrincipals() {
            return this.whitelistedPrincipals;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpcEndpointServiceLoadBalancers", om.valueToTree(this.getVpcEndpointServiceLoadBalancers()));
            if (this.getAcceptanceRequired() != null) {
                data.set("acceptanceRequired", om.valueToTree(this.getAcceptanceRequired()));
            }
            if (this.getAllowedPrincipals() != null) {
                data.set("allowedPrincipals", om.valueToTree(this.getAllowedPrincipals()));
            }
            if (this.getVpcEndpointServiceName() != null) {
                data.set("vpcEndpointServiceName", om.valueToTree(this.getVpcEndpointServiceName()));
            }
            if (this.getWhitelistedPrincipals() != null) {
                data.set("whitelistedPrincipals", om.valueToTree(this.getWhitelistedPrincipals()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.VpcEndpointServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcEndpointServiceProps.Jsii$Proxy that = (VpcEndpointServiceProps.Jsii$Proxy) o;

            if (!vpcEndpointServiceLoadBalancers.equals(that.vpcEndpointServiceLoadBalancers)) return false;
            if (this.acceptanceRequired != null ? !this.acceptanceRequired.equals(that.acceptanceRequired) : that.acceptanceRequired != null) return false;
            if (this.allowedPrincipals != null ? !this.allowedPrincipals.equals(that.allowedPrincipals) : that.allowedPrincipals != null) return false;
            if (this.vpcEndpointServiceName != null ? !this.vpcEndpointServiceName.equals(that.vpcEndpointServiceName) : that.vpcEndpointServiceName != null) return false;
            return this.whitelistedPrincipals != null ? this.whitelistedPrincipals.equals(that.whitelistedPrincipals) : that.whitelistedPrincipals == null;
        }

        @Override
        public final int hashCode() {
            int result = this.vpcEndpointServiceLoadBalancers.hashCode();
            result = 31 * result + (this.acceptanceRequired != null ? this.acceptanceRequired.hashCode() : 0);
            result = 31 * result + (this.allowedPrincipals != null ? this.allowedPrincipals.hashCode() : 0);
            result = 31 * result + (this.vpcEndpointServiceName != null ? this.vpcEndpointServiceName.hashCode() : 0);
            result = 31 * result + (this.whitelistedPrincipals != null ? this.whitelistedPrincipals.hashCode() : 0);
            return result;
        }
    }
}
