package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 * <p>
 * Specifies a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to enable and manage client VPN sessions. It is the destination endpoint at which all client VPN sessions are terminated.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnClientVpnEndpoint cfnClientVpnEndpoint = CfnClientVpnEndpoint.Builder.create(this, "MyCfnClientVpnEndpoint")
 *         .authenticationOptions(List.of(ClientAuthenticationRequestProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .activeDirectory(DirectoryServiceAuthenticationRequestProperty.builder()
 *                         .directoryId("directoryId")
 *                         .build())
 *                 .federatedAuthentication(FederatedAuthenticationRequestProperty.builder()
 *                         .samlProviderArn("samlProviderArn")
 *                         // the properties below are optional
 *                         .selfServiceSamlProviderArn("selfServiceSamlProviderArn")
 *                         .build())
 *                 .mutualAuthentication(CertificateAuthenticationRequestProperty.builder()
 *                         .clientRootCertificateChainArn("clientRootCertificateChainArn")
 *                         .build())
 *                 .build()))
 *         .clientCidrBlock("clientCidrBlock")
 *         .connectionLogOptions(ConnectionLogOptionsProperty.builder()
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .cloudwatchLogGroup("cloudwatchLogGroup")
 *                 .cloudwatchLogStream("cloudwatchLogStream")
 *                 .build())
 *         .serverCertificateArn("serverCertificateArn")
 *         // the properties below are optional
 *         .clientConnectOptions(ClientConnectOptionsProperty.builder()
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .lambdaFunctionArn("lambdaFunctionArn")
 *                 .build())
 *         .clientLoginBannerOptions(ClientLoginBannerOptionsProperty.builder()
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .bannerText("bannerText")
 *                 .build())
 *         .description("description")
 *         .dnsServers(List.of("dnsServers"))
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .selfServicePortal("selfServicePortal")
 *         .sessionTimeoutHours(123)
 *         .splitTunnel(false)
 *         .tagSpecifications(List.of(TagSpecificationProperty.builder()
 *                 .resourceType("resourceType")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .transportProtocol("transportProtocol")
 *         .vpcId("vpcId")
 *         .vpnPort(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-10-20T14:12:15.445Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnEndpoint")
public class CfnClientVpnEndpoint extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnClientVpnEndpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnClientVpnEndpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::ClientVpnEndpoint`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnClientVpnEndpoint(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnClientVpnEndpointProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Information about the authentication method to be used to authenticate clients.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAuthenticationOptions() {
        return software.amazon.jsii.Kernel.get(this, "authenticationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the authentication method to be used to authenticate clients.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthenticationOptions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "authenticationOptions", java.util.Objects.requireNonNull(value, "authenticationOptions is required"));
    }

    /**
     * Information about the authentication method to be used to authenticate clients.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthenticationOptions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ClientAuthenticationRequestProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ClientAuthenticationRequestProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "authenticationOptions", java.util.Objects.requireNonNull(value, "authenticationOptions is required"));
    }

    /**
     * The IPv4 address range, in CIDR notation, from which to assign client IP addresses.
     * <p>
     * The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClientCidrBlock() {
        return software.amazon.jsii.Kernel.get(this, "clientCidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IPv4 address range, in CIDR notation, from which to assign client IP addresses.
     * <p>
     * The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientCidrBlock(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clientCidrBlock", java.util.Objects.requireNonNull(value, "clientCidrBlock is required"));
    }

    /**
     * Information about the client connection logging options.
     * <p>
     * If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:
     * <p>
     * <ul>
     * <li>Client connection requests</li>
     * <li>Client connection results (successful and unsuccessful)</li>
     * <li>Reasons for unsuccessful client connection requests</li>
     * <li>Client connection termination time</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConnectionLogOptions() {
        return software.amazon.jsii.Kernel.get(this, "connectionLogOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the client connection logging options.
     * <p>
     * If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:
     * <p>
     * <ul>
     * <li>Client connection requests</li>
     * <li>Client connection results (successful and unsuccessful)</li>
     * <li>Reasons for unsuccessful client connection requests</li>
     * <li>Client connection termination time</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionLogOptions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "connectionLogOptions", java.util.Objects.requireNonNull(value, "connectionLogOptions is required"));
    }

    /**
     * Information about the client connection logging options.
     * <p>
     * If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:
     * <p>
     * <ul>
     * <li>Client connection requests</li>
     * <li>Client connection results (successful and unsuccessful)</li>
     * <li>Reasons for unsuccessful client connection requests</li>
     * <li>Client connection termination time</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionLogOptions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ConnectionLogOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "connectionLogOptions", java.util.Objects.requireNonNull(value, "connectionLogOptions is required"));
    }

    /**
     * The ARN of the server certificate.
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">AWS Certificate Manager User Guide</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServerCertificateArn() {
        return software.amazon.jsii.Kernel.get(this, "serverCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the server certificate.
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">AWS Certificate Manager User Guide</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerCertificateArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serverCertificateArn", java.util.Objects.requireNonNull(value, "serverCertificateArn is required"));
    }

    /**
     * The options for managing connection authorization for new client connections.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getClientConnectOptions() {
        return software.amazon.jsii.Kernel.get(this, "clientConnectOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The options for managing connection authorization for new client connections.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientConnectOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "clientConnectOptions", value);
    }

    /**
     * The options for managing connection authorization for new client connections.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientConnectOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ClientConnectOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "clientConnectOptions", value);
    }

    /**
     * Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getClientLoginBannerOptions() {
        return software.amazon.jsii.Kernel.get(this, "clientLoginBannerOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientLoginBannerOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "clientLoginBannerOptions", value);
    }

    /**
     * Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientLoginBannerOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ClientLoginBannerOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "clientLoginBannerOptions", value);
    }

    /**
     * A brief description of the Client VPN endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A brief description of the Client VPN endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Information about the DNS servers to be used for DNS resolution.
     * <p>
     * A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDnsServers() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "dnsServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Information about the DNS servers to be used for DNS resolution.
     * <p>
     * A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDnsServers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "dnsServers", value);
    }

    /**
     * The IDs of one or more security groups to apply to the target network.
     * <p>
     * You must also specify the ID of the VPC that contains the security groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The IDs of one or more security groups to apply to the target network.
     * <p>
     * You must also specify the ID of the VPC that contains the security groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "securityGroupIds", value);
    }

    /**
     * Specify whether to enable the self-service portal for the Client VPN endpoint.
     * <p>
     * Default Value: <code>enabled</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSelfServicePortal() {
        return software.amazon.jsii.Kernel.get(this, "selfServicePortal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specify whether to enable the self-service portal for the Client VPN endpoint.
     * <p>
     * Default Value: <code>enabled</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSelfServicePortal(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "selfServicePortal", value);
    }

    /**
     * The maximum VPN session duration time in hours.
     * <p>
     * Valid values: <code>8 | 10 | 12 | 24</code>
     * <p>
     * Default value: <code>24</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSessionTimeoutHours() {
        return software.amazon.jsii.Kernel.get(this, "sessionTimeoutHours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum VPN session duration time in hours.
     * <p>
     * Valid values: <code>8 | 10 | 12 | 24</code>
     * <p>
     * Default value: <code>24</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSessionTimeoutHours(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "sessionTimeoutHours", value);
    }

    /**
     * Indicates whether split-tunnel is enabled on the AWS Client VPN endpoint.
     * <p>
     * By default, split-tunnel on a VPN endpoint is disabled.
     * <p>
     * For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel AWS Client VPN endpoint</a> in the <em>AWS Client VPN Administrator Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSplitTunnel() {
        return software.amazon.jsii.Kernel.get(this, "splitTunnel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether split-tunnel is enabled on the AWS Client VPN endpoint.
     * <p>
     * By default, split-tunnel on a VPN endpoint is disabled.
     * <p>
     * For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel AWS Client VPN endpoint</a> in the <em>AWS Client VPN Administrator Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSplitTunnel(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "splitTunnel", value);
    }

    /**
     * Indicates whether split-tunnel is enabled on the AWS Client VPN endpoint.
     * <p>
     * By default, split-tunnel on a VPN endpoint is disabled.
     * <p>
     * For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel AWS Client VPN endpoint</a> in the <em>AWS Client VPN Administrator Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSplitTunnel(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "splitTunnel", value);
    }

    /**
     * The tags to apply to the Client VPN endpoint during creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "tagSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The tags to apply to the Client VPN endpoint during creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tagSpecifications", value);
    }

    /**
     * The tags to apply to the Client VPN endpoint during creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagSpecifications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.TagSpecificationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.TagSpecificationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "tagSpecifications", value);
    }

    /**
     * The transport protocol to be used by the VPN session.
     * <p>
     * Default value: <code>udp</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTransportProtocol() {
        return software.amazon.jsii.Kernel.get(this, "transportProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The transport protocol to be used by the VPN session.
     * <p>
     * Default value: <code>udp</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransportProtocol(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "transportProtocol", value);
    }

    /**
     * The ID of the VPC to associate with the Client VPN endpoint.
     * <p>
     * If no security group IDs are specified in the request, the default security group for the VPC is applied.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
        return software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the VPC to associate with the Client VPN endpoint.
     * <p>
     * If no security group IDs are specified in the request, the default security group for the VPC is applied.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpcId", value);
    }

    /**
     * The port number to assign to the Client VPN endpoint for TCP and UDP traffic.
     * <p>
     * Valid Values: <code>443</code> | <code>1194</code>
     * <p>
     * Default Value: <code>443</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getVpnPort() {
        return software.amazon.jsii.Kernel.get(this, "vpnPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The port number to assign to the Client VPN endpoint for TCP and UDP traffic.
     * <p>
     * Valid Values: <code>443</code> | <code>1194</code>
     * <p>
     * Default Value: <code>443</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpnPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "vpnPort", value);
    }
    /**
     * Information about the client certificate to be used for authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * CertificateAuthenticationRequestProperty certificateAuthenticationRequestProperty = CertificateAuthenticationRequestProperty.builder()
     *         .clientRootCertificateChainArn("clientRootCertificateChainArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(CertificateAuthenticationRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CertificateAuthenticationRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the client certificate.
         * <p>
         * The certificate must be signed by a certificate authority (CA) and it must be provisioned in AWS Certificate Manager (ACM).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientRootCertificateChainArn();

        /**
         * @return a {@link Builder} of {@link CertificateAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CertificateAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CertificateAuthenticationRequestProperty> {
            java.lang.String clientRootCertificateChainArn;

            /**
             * Sets the value of {@link CertificateAuthenticationRequestProperty#getClientRootCertificateChainArn}
             * @param clientRootCertificateChainArn The ARN of the client certificate. This parameter is required.
             *                                      The certificate must be signed by a certificate authority (CA) and it must be provisioned in AWS Certificate Manager (ACM).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientRootCertificateChainArn(java.lang.String clientRootCertificateChainArn) {
                this.clientRootCertificateChainArn = clientRootCertificateChainArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CertificateAuthenticationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CertificateAuthenticationRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CertificateAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CertificateAuthenticationRequestProperty {
            private final java.lang.String clientRootCertificateChainArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientRootCertificateChainArn = software.amazon.jsii.Kernel.get(this, "clientRootCertificateChainArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientRootCertificateChainArn = java.util.Objects.requireNonNull(builder.clientRootCertificateChainArn, "clientRootCertificateChainArn is required");
            }

            @Override
            public final java.lang.String getClientRootCertificateChainArn() {
                return this.clientRootCertificateChainArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientRootCertificateChainArn", om.valueToTree(this.getClientRootCertificateChainArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CertificateAuthenticationRequestProperty.Jsii$Proxy that = (CertificateAuthenticationRequestProperty.Jsii$Proxy) o;

                return this.clientRootCertificateChainArn.equals(that.clientRootCertificateChainArn);
            }

            @Override
            public final int hashCode() {
                int result = this.clientRootCertificateChainArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Describes the authentication method to be used by a Client VPN endpoint.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/authentication-authrization.html#client-authentication">Authentication</a> in the <em>AWS Client VPN Administrator Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * ClientAuthenticationRequestProperty clientAuthenticationRequestProperty = ClientAuthenticationRequestProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .activeDirectory(DirectoryServiceAuthenticationRequestProperty.builder()
     *                 .directoryId("directoryId")
     *                 .build())
     *         .federatedAuthentication(FederatedAuthenticationRequestProperty.builder()
     *                 .samlProviderArn("samlProviderArn")
     *                 // the properties below are optional
     *                 .selfServiceSamlProviderArn("selfServiceSamlProviderArn")
     *                 .build())
     *         .mutualAuthentication(CertificateAuthenticationRequestProperty.builder()
     *                 .clientRootCertificateChainArn("clientRootCertificateChainArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnEndpoint.ClientAuthenticationRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(ClientAuthenticationRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClientAuthenticationRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of client authentication to be used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Information about the Active Directory to be used, if applicable.
         * <p>
         * You must provide this information if <em>Type</em> is <code>directory-service-authentication</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getActiveDirectory() {
            return null;
        }

        /**
         * Information about the IAM SAML identity provider, if applicable.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFederatedAuthentication() {
            return null;
        }

        /**
         * Information about the authentication certificates to be used, if applicable.
         * <p>
         * You must provide this information if <em>Type</em> is <code>certificate-authentication</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMutualAuthentication() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClientAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClientAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClientAuthenticationRequestProperty> {
            java.lang.String type;
            java.lang.Object activeDirectory;
            java.lang.Object federatedAuthentication;
            java.lang.Object mutualAuthentication;

            /**
             * Sets the value of {@link ClientAuthenticationRequestProperty#getType}
             * @param type The type of client authentication to be used. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ClientAuthenticationRequestProperty#getActiveDirectory}
             * @param activeDirectory Information about the Active Directory to be used, if applicable.
             *                        You must provide this information if <em>Type</em> is <code>directory-service-authentication</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activeDirectory(software.amazon.awscdk.core.IResolvable activeDirectory) {
                this.activeDirectory = activeDirectory;
                return this;
            }

            /**
             * Sets the value of {@link ClientAuthenticationRequestProperty#getActiveDirectory}
             * @param activeDirectory Information about the Active Directory to be used, if applicable.
             *                        You must provide this information if <em>Type</em> is <code>directory-service-authentication</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activeDirectory(software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty activeDirectory) {
                this.activeDirectory = activeDirectory;
                return this;
            }

            /**
             * Sets the value of {@link ClientAuthenticationRequestProperty#getFederatedAuthentication}
             * @param federatedAuthentication Information about the IAM SAML identity provider, if applicable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder federatedAuthentication(software.amazon.awscdk.core.IResolvable federatedAuthentication) {
                this.federatedAuthentication = federatedAuthentication;
                return this;
            }

            /**
             * Sets the value of {@link ClientAuthenticationRequestProperty#getFederatedAuthentication}
             * @param federatedAuthentication Information about the IAM SAML identity provider, if applicable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder federatedAuthentication(software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.FederatedAuthenticationRequestProperty federatedAuthentication) {
                this.federatedAuthentication = federatedAuthentication;
                return this;
            }

            /**
             * Sets the value of {@link ClientAuthenticationRequestProperty#getMutualAuthentication}
             * @param mutualAuthentication Information about the authentication certificates to be used, if applicable.
             *                             You must provide this information if <em>Type</em> is <code>certificate-authentication</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mutualAuthentication(software.amazon.awscdk.core.IResolvable mutualAuthentication) {
                this.mutualAuthentication = mutualAuthentication;
                return this;
            }

            /**
             * Sets the value of {@link ClientAuthenticationRequestProperty#getMutualAuthentication}
             * @param mutualAuthentication Information about the authentication certificates to be used, if applicable.
             *                             You must provide this information if <em>Type</em> is <code>certificate-authentication</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mutualAuthentication(software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty mutualAuthentication) {
                this.mutualAuthentication = mutualAuthentication;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClientAuthenticationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClientAuthenticationRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClientAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientAuthenticationRequestProperty {
            private final java.lang.String type;
            private final java.lang.Object activeDirectory;
            private final java.lang.Object federatedAuthentication;
            private final java.lang.Object mutualAuthentication;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.activeDirectory = software.amazon.jsii.Kernel.get(this, "activeDirectory", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.federatedAuthentication = software.amazon.jsii.Kernel.get(this, "federatedAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mutualAuthentication = software.amazon.jsii.Kernel.get(this, "mutualAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.activeDirectory = builder.activeDirectory;
                this.federatedAuthentication = builder.federatedAuthentication;
                this.mutualAuthentication = builder.mutualAuthentication;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getActiveDirectory() {
                return this.activeDirectory;
            }

            @Override
            public final java.lang.Object getFederatedAuthentication() {
                return this.federatedAuthentication;
            }

            @Override
            public final java.lang.Object getMutualAuthentication() {
                return this.mutualAuthentication;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getActiveDirectory() != null) {
                    data.set("activeDirectory", om.valueToTree(this.getActiveDirectory()));
                }
                if (this.getFederatedAuthentication() != null) {
                    data.set("federatedAuthentication", om.valueToTree(this.getFederatedAuthentication()));
                }
                if (this.getMutualAuthentication() != null) {
                    data.set("mutualAuthentication", om.valueToTree(this.getMutualAuthentication()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnClientVpnEndpoint.ClientAuthenticationRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClientAuthenticationRequestProperty.Jsii$Proxy that = (ClientAuthenticationRequestProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.activeDirectory != null ? !this.activeDirectory.equals(that.activeDirectory) : that.activeDirectory != null) return false;
                if (this.federatedAuthentication != null ? !this.federatedAuthentication.equals(that.federatedAuthentication) : that.federatedAuthentication != null) return false;
                return this.mutualAuthentication != null ? this.mutualAuthentication.equals(that.mutualAuthentication) : that.mutualAuthentication == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.activeDirectory != null ? this.activeDirectory.hashCode() : 0);
                result = 31 * result + (this.federatedAuthentication != null ? this.federatedAuthentication.hashCode() : 0);
                result = 31 * result + (this.mutualAuthentication != null ? this.mutualAuthentication.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Indicates whether client connect options are enabled.
     * <p>
     * The default is <code>false</code> (not enabled).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * ClientConnectOptionsProperty clientConnectOptionsProperty = ClientConnectOptionsProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .lambdaFunctionArn("lambdaFunctionArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnEndpoint.ClientConnectOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ClientConnectOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClientConnectOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether client connect options are enabled.
         * <p>
         * The default is <code>false</code> (not enabled).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * The Amazon Resource Name (ARN) of the AWS Lambda function used for connection authorization.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLambdaFunctionArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClientConnectOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClientConnectOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClientConnectOptionsProperty> {
            java.lang.Object enabled;
            java.lang.String lambdaFunctionArn;

            /**
             * Sets the value of {@link ClientConnectOptionsProperty#getEnabled}
             * @param enabled Indicates whether client connect options are enabled. This parameter is required.
             *                The default is <code>false</code> (not enabled).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ClientConnectOptionsProperty#getEnabled}
             * @param enabled Indicates whether client connect options are enabled. This parameter is required.
             *                The default is <code>false</code> (not enabled).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ClientConnectOptionsProperty#getLambdaFunctionArn}
             * @param lambdaFunctionArn The Amazon Resource Name (ARN) of the AWS Lambda function used for connection authorization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionArn(java.lang.String lambdaFunctionArn) {
                this.lambdaFunctionArn = lambdaFunctionArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClientConnectOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClientConnectOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClientConnectOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientConnectOptionsProperty {
            private final java.lang.Object enabled;
            private final java.lang.String lambdaFunctionArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambdaFunctionArn = software.amazon.jsii.Kernel.get(this, "lambdaFunctionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.lambdaFunctionArn = builder.lambdaFunctionArn;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getLambdaFunctionArn() {
                return this.lambdaFunctionArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getLambdaFunctionArn() != null) {
                    data.set("lambdaFunctionArn", om.valueToTree(this.getLambdaFunctionArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnClientVpnEndpoint.ClientConnectOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClientConnectOptionsProperty.Jsii$Proxy that = (ClientConnectOptionsProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                return this.lambdaFunctionArn != null ? this.lambdaFunctionArn.equals(that.lambdaFunctionArn) : that.lambdaFunctionArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.lambdaFunctionArn != null ? this.lambdaFunctionArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * ClientLoginBannerOptionsProperty clientLoginBannerOptionsProperty = ClientLoginBannerOptionsProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .bannerText("bannerText")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnEndpoint.ClientLoginBannerOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ClientLoginBannerOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClientLoginBannerOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enable or disable a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
         * <p>
         * Valid values: <code>true | false</code>
         * <p>
         * Default value: <code>false</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * Customizable text that will be displayed in a banner on AWS provided clients when a VPN session is established.
         * <p>
         * UTF-8 encoded characters only. Maximum of 1400 characters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBannerText() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClientLoginBannerOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClientLoginBannerOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClientLoginBannerOptionsProperty> {
            java.lang.Object enabled;
            java.lang.String bannerText;

            /**
             * Sets the value of {@link ClientLoginBannerOptionsProperty#getEnabled}
             * @param enabled Enable or disable a customizable text banner that will be displayed on AWS provided clients when a VPN session is established. This parameter is required.
             *                Valid values: <code>true | false</code>
             *                <p>
             *                Default value: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ClientLoginBannerOptionsProperty#getEnabled}
             * @param enabled Enable or disable a customizable text banner that will be displayed on AWS provided clients when a VPN session is established. This parameter is required.
             *                Valid values: <code>true | false</code>
             *                <p>
             *                Default value: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ClientLoginBannerOptionsProperty#getBannerText}
             * @param bannerText Customizable text that will be displayed in a banner on AWS provided clients when a VPN session is established.
             *                   UTF-8 encoded characters only. Maximum of 1400 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bannerText(java.lang.String bannerText) {
                this.bannerText = bannerText;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClientLoginBannerOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClientLoginBannerOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClientLoginBannerOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientLoginBannerOptionsProperty {
            private final java.lang.Object enabled;
            private final java.lang.String bannerText;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bannerText = software.amazon.jsii.Kernel.get(this, "bannerText", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.bannerText = builder.bannerText;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getBannerText() {
                return this.bannerText;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getBannerText() != null) {
                    data.set("bannerText", om.valueToTree(this.getBannerText()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnClientVpnEndpoint.ClientLoginBannerOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClientLoginBannerOptionsProperty.Jsii$Proxy that = (ClientLoginBannerOptionsProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                return this.bannerText != null ? this.bannerText.equals(that.bannerText) : that.bannerText == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.bannerText != null ? this.bannerText.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the client connection logging options for the Client VPN endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * ConnectionLogOptionsProperty connectionLogOptionsProperty = ConnectionLogOptionsProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .cloudwatchLogGroup("cloudwatchLogGroup")
     *         .cloudwatchLogStream("cloudwatchLogStream")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnEndpoint.ConnectionLogOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectionLogOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectionLogOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether connection logging is enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * The name of the CloudWatch Logs log group.
         * <p>
         * Required if connection logging is enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCloudwatchLogGroup() {
            return null;
        }

        /**
         * The name of the CloudWatch Logs log stream to which the connection data is published.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCloudwatchLogStream() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectionLogOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectionLogOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectionLogOptionsProperty> {
            java.lang.Object enabled;
            java.lang.String cloudwatchLogGroup;
            java.lang.String cloudwatchLogStream;

            /**
             * Sets the value of {@link ConnectionLogOptionsProperty#getEnabled}
             * @param enabled Indicates whether connection logging is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionLogOptionsProperty#getEnabled}
             * @param enabled Indicates whether connection logging is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionLogOptionsProperty#getCloudwatchLogGroup}
             * @param cloudwatchLogGroup The name of the CloudWatch Logs log group.
             *                           Required if connection logging is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudwatchLogGroup(java.lang.String cloudwatchLogGroup) {
                this.cloudwatchLogGroup = cloudwatchLogGroup;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionLogOptionsProperty#getCloudwatchLogStream}
             * @param cloudwatchLogStream The name of the CloudWatch Logs log stream to which the connection data is published.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudwatchLogStream(java.lang.String cloudwatchLogStream) {
                this.cloudwatchLogStream = cloudwatchLogStream;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectionLogOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectionLogOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectionLogOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionLogOptionsProperty {
            private final java.lang.Object enabled;
            private final java.lang.String cloudwatchLogGroup;
            private final java.lang.String cloudwatchLogStream;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudwatchLogGroup = software.amazon.jsii.Kernel.get(this, "cloudwatchLogGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cloudwatchLogStream = software.amazon.jsii.Kernel.get(this, "cloudwatchLogStream", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.cloudwatchLogGroup = builder.cloudwatchLogGroup;
                this.cloudwatchLogStream = builder.cloudwatchLogStream;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getCloudwatchLogGroup() {
                return this.cloudwatchLogGroup;
            }

            @Override
            public final java.lang.String getCloudwatchLogStream() {
                return this.cloudwatchLogStream;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getCloudwatchLogGroup() != null) {
                    data.set("cloudwatchLogGroup", om.valueToTree(this.getCloudwatchLogGroup()));
                }
                if (this.getCloudwatchLogStream() != null) {
                    data.set("cloudwatchLogStream", om.valueToTree(this.getCloudwatchLogStream()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnClientVpnEndpoint.ConnectionLogOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectionLogOptionsProperty.Jsii$Proxy that = (ConnectionLogOptionsProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (this.cloudwatchLogGroup != null ? !this.cloudwatchLogGroup.equals(that.cloudwatchLogGroup) : that.cloudwatchLogGroup != null) return false;
                return this.cloudwatchLogStream != null ? this.cloudwatchLogStream.equals(that.cloudwatchLogStream) : that.cloudwatchLogStream == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.cloudwatchLogGroup != null ? this.cloudwatchLogGroup.hashCode() : 0);
                result = 31 * result + (this.cloudwatchLogStream != null ? this.cloudwatchLogStream.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the Active Directory to be used for client authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * DirectoryServiceAuthenticationRequestProperty directoryServiceAuthenticationRequestProperty = DirectoryServiceAuthenticationRequestProperty.builder()
     *         .directoryId("directoryId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(DirectoryServiceAuthenticationRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DirectoryServiceAuthenticationRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the Active Directory to be used for authentication.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDirectoryId();

        /**
         * @return a {@link Builder} of {@link DirectoryServiceAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DirectoryServiceAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DirectoryServiceAuthenticationRequestProperty> {
            java.lang.String directoryId;

            /**
             * Sets the value of {@link DirectoryServiceAuthenticationRequestProperty#getDirectoryId}
             * @param directoryId The ID of the Active Directory to be used for authentication. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder directoryId(java.lang.String directoryId) {
                this.directoryId = directoryId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DirectoryServiceAuthenticationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DirectoryServiceAuthenticationRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DirectoryServiceAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DirectoryServiceAuthenticationRequestProperty {
            private final java.lang.String directoryId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.directoryId = software.amazon.jsii.Kernel.get(this, "directoryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.directoryId = java.util.Objects.requireNonNull(builder.directoryId, "directoryId is required");
            }

            @Override
            public final java.lang.String getDirectoryId() {
                return this.directoryId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("directoryId", om.valueToTree(this.getDirectoryId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DirectoryServiceAuthenticationRequestProperty.Jsii$Proxy that = (DirectoryServiceAuthenticationRequestProperty.Jsii$Proxy) o;

                return this.directoryId.equals(that.directoryId);
            }

            @Override
            public final int hashCode() {
                int result = this.directoryId.hashCode();
                return result;
            }
        }
    }
    /**
     * The IAM SAML identity provider used for federated authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * FederatedAuthenticationRequestProperty federatedAuthenticationRequestProperty = FederatedAuthenticationRequestProperty.builder()
     *         .samlProviderArn("samlProviderArn")
     *         // the properties below are optional
     *         .selfServiceSamlProviderArn("selfServiceSamlProviderArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnEndpoint.FederatedAuthenticationRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(FederatedAuthenticationRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FederatedAuthenticationRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the IAM SAML identity provider.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSamlProviderArn();

        /**
         * The Amazon Resource Name (ARN) of the IAM SAML identity provider for the self-service portal.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSelfServiceSamlProviderArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FederatedAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FederatedAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FederatedAuthenticationRequestProperty> {
            java.lang.String samlProviderArn;
            java.lang.String selfServiceSamlProviderArn;

            /**
             * Sets the value of {@link FederatedAuthenticationRequestProperty#getSamlProviderArn}
             * @param samlProviderArn The Amazon Resource Name (ARN) of the IAM SAML identity provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder samlProviderArn(java.lang.String samlProviderArn) {
                this.samlProviderArn = samlProviderArn;
                return this;
            }

            /**
             * Sets the value of {@link FederatedAuthenticationRequestProperty#getSelfServiceSamlProviderArn}
             * @param selfServiceSamlProviderArn The Amazon Resource Name (ARN) of the IAM SAML identity provider for the self-service portal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selfServiceSamlProviderArn(java.lang.String selfServiceSamlProviderArn) {
                this.selfServiceSamlProviderArn = selfServiceSamlProviderArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FederatedAuthenticationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FederatedAuthenticationRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FederatedAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FederatedAuthenticationRequestProperty {
            private final java.lang.String samlProviderArn;
            private final java.lang.String selfServiceSamlProviderArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.samlProviderArn = software.amazon.jsii.Kernel.get(this, "samlProviderArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.selfServiceSamlProviderArn = software.amazon.jsii.Kernel.get(this, "selfServiceSamlProviderArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.samlProviderArn = java.util.Objects.requireNonNull(builder.samlProviderArn, "samlProviderArn is required");
                this.selfServiceSamlProviderArn = builder.selfServiceSamlProviderArn;
            }

            @Override
            public final java.lang.String getSamlProviderArn() {
                return this.samlProviderArn;
            }

            @Override
            public final java.lang.String getSelfServiceSamlProviderArn() {
                return this.selfServiceSamlProviderArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("samlProviderArn", om.valueToTree(this.getSamlProviderArn()));
                if (this.getSelfServiceSamlProviderArn() != null) {
                    data.set("selfServiceSamlProviderArn", om.valueToTree(this.getSelfServiceSamlProviderArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnClientVpnEndpoint.FederatedAuthenticationRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FederatedAuthenticationRequestProperty.Jsii$Proxy that = (FederatedAuthenticationRequestProperty.Jsii$Proxy) o;

                if (!samlProviderArn.equals(that.samlProviderArn)) return false;
                return this.selfServiceSamlProviderArn != null ? this.selfServiceSamlProviderArn.equals(that.selfServiceSamlProviderArn) : that.selfServiceSamlProviderArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.samlProviderArn.hashCode();
                result = 31 * result + (this.selfServiceSamlProviderArn != null ? this.selfServiceSamlProviderArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The tags to apply to a resource when the resource is being created.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TagSpecificationProperty tagSpecificationProperty = TagSpecificationProperty.builder()
     *         .resourceType("resourceType")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnEndpoint.TagSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(TagSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of resource to tag.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceType();

        /**
         * The tags to apply to the resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

        /**
         * @return a {@link Builder} of {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagSpecificationProperty> {
            java.lang.String resourceType;
            java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Sets the value of {@link TagSpecificationProperty#getResourceType}
             * @param resourceType The type of resource to tag. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link TagSpecificationProperty#getTags}
             * @param tags The tags to apply to the resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagSpecificationProperty {
            private final java.lang.String resourceType;
            private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = java.util.Objects.requireNonNull(builder.resourceType, "resourceType is required");
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)java.util.Objects.requireNonNull(builder.tags, "tags is required");
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceType", om.valueToTree(this.getResourceType()));
                data.set("tags", om.valueToTree(this.getTags()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnClientVpnEndpoint.TagSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagSpecificationProperty.Jsii$Proxy that = (TagSpecificationProperty.Jsii$Proxy) o;

                if (!resourceType.equals(that.resourceType)) return false;
                return this.tags.equals(that.tags);
            }

            @Override
            public final int hashCode() {
                int result = this.resourceType.hashCode();
                result = 31 * result + (this.tags.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnClientVpnEndpointProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnClientVpnEndpointProps.Builder();
        }

        /**
         * Information about the authentication method to be used to authenticate clients.
         * <p>
         * @return {@code this}
         * @param authenticationOptions Information about the authentication method to be used to authenticate clients. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationOptions(final software.amazon.awscdk.core.IResolvable authenticationOptions) {
            this.props.authenticationOptions(authenticationOptions);
            return this;
        }
        /**
         * Information about the authentication method to be used to authenticate clients.
         * <p>
         * @return {@code this}
         * @param authenticationOptions Information about the authentication method to be used to authenticate clients. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationOptions(final java.util.List<? extends java.lang.Object> authenticationOptions) {
            this.props.authenticationOptions(authenticationOptions);
            return this;
        }

        /**
         * The IPv4 address range, in CIDR notation, from which to assign client IP addresses.
         * <p>
         * The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
         * <p>
         * @return {@code this}
         * @param clientCidrBlock The IPv4 address range, in CIDR notation, from which to assign client IP addresses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientCidrBlock(final java.lang.String clientCidrBlock) {
            this.props.clientCidrBlock(clientCidrBlock);
            return this;
        }

        /**
         * Information about the client connection logging options.
         * <p>
         * If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:
         * <p>
         * <ul>
         * <li>Client connection requests</li>
         * <li>Client connection results (successful and unsuccessful)</li>
         * <li>Reasons for unsuccessful client connection requests</li>
         * <li>Client connection termination time</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param connectionLogOptions Information about the client connection logging options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionLogOptions(final software.amazon.awscdk.core.IResolvable connectionLogOptions) {
            this.props.connectionLogOptions(connectionLogOptions);
            return this;
        }
        /**
         * Information about the client connection logging options.
         * <p>
         * If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:
         * <p>
         * <ul>
         * <li>Client connection requests</li>
         * <li>Client connection results (successful and unsuccessful)</li>
         * <li>Reasons for unsuccessful client connection requests</li>
         * <li>Client connection termination time</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param connectionLogOptions Information about the client connection logging options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionLogOptions(final software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ConnectionLogOptionsProperty connectionLogOptions) {
            this.props.connectionLogOptions(connectionLogOptions);
            return this;
        }

        /**
         * The ARN of the server certificate.
         * <p>
         * For more information, see the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">AWS Certificate Manager User Guide</a> .
         * <p>
         * @return {@code this}
         * @param serverCertificateArn The ARN of the server certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverCertificateArn(final java.lang.String serverCertificateArn) {
            this.props.serverCertificateArn(serverCertificateArn);
            return this;
        }

        /**
         * The options for managing connection authorization for new client connections.
         * <p>
         * @return {@code this}
         * @param clientConnectOptions The options for managing connection authorization for new client connections. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientConnectOptions(final software.amazon.awscdk.core.IResolvable clientConnectOptions) {
            this.props.clientConnectOptions(clientConnectOptions);
            return this;
        }
        /**
         * The options for managing connection authorization for new client connections.
         * <p>
         * @return {@code this}
         * @param clientConnectOptions The options for managing connection authorization for new client connections. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientConnectOptions(final software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ClientConnectOptionsProperty clientConnectOptions) {
            this.props.clientConnectOptions(clientConnectOptions);
            return this;
        }

        /**
         * Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
         * <p>
         * @return {@code this}
         * @param clientLoginBannerOptions Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientLoginBannerOptions(final software.amazon.awscdk.core.IResolvable clientLoginBannerOptions) {
            this.props.clientLoginBannerOptions(clientLoginBannerOptions);
            return this;
        }
        /**
         * Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
         * <p>
         * @return {@code this}
         * @param clientLoginBannerOptions Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientLoginBannerOptions(final software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ClientLoginBannerOptionsProperty clientLoginBannerOptions) {
            this.props.clientLoginBannerOptions(clientLoginBannerOptions);
            return this;
        }

        /**
         * A brief description of the Client VPN endpoint.
         * <p>
         * @return {@code this}
         * @param description A brief description of the Client VPN endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Information about the DNS servers to be used for DNS resolution.
         * <p>
         * A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server.
         * <p>
         * @return {@code this}
         * @param dnsServers Information about the DNS servers to be used for DNS resolution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsServers(final java.util.List<java.lang.String> dnsServers) {
            this.props.dnsServers(dnsServers);
            return this;
        }

        /**
         * The IDs of one or more security groups to apply to the target network.
         * <p>
         * You must also specify the ID of the VPC that contains the security groups.
         * <p>
         * @return {@code this}
         * @param securityGroupIds The IDs of one or more security groups to apply to the target network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(final java.util.List<java.lang.String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        /**
         * Specify whether to enable the self-service portal for the Client VPN endpoint.
         * <p>
         * Default Value: <code>enabled</code>
         * <p>
         * @return {@code this}
         * @param selfServicePortal Specify whether to enable the self-service portal for the Client VPN endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfServicePortal(final java.lang.String selfServicePortal) {
            this.props.selfServicePortal(selfServicePortal);
            return this;
        }

        /**
         * The maximum VPN session duration time in hours.
         * <p>
         * Valid values: <code>8 | 10 | 12 | 24</code>
         * <p>
         * Default value: <code>24</code>
         * <p>
         * @return {@code this}
         * @param sessionTimeoutHours The maximum VPN session duration time in hours. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionTimeoutHours(final java.lang.Number sessionTimeoutHours) {
            this.props.sessionTimeoutHours(sessionTimeoutHours);
            return this;
        }

        /**
         * Indicates whether split-tunnel is enabled on the AWS Client VPN endpoint.
         * <p>
         * By default, split-tunnel on a VPN endpoint is disabled.
         * <p>
         * For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel AWS Client VPN endpoint</a> in the <em>AWS Client VPN Administrator Guide</em> .
         * <p>
         * @return {@code this}
         * @param splitTunnel Indicates whether split-tunnel is enabled on the AWS Client VPN endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder splitTunnel(final java.lang.Boolean splitTunnel) {
            this.props.splitTunnel(splitTunnel);
            return this;
        }
        /**
         * Indicates whether split-tunnel is enabled on the AWS Client VPN endpoint.
         * <p>
         * By default, split-tunnel on a VPN endpoint is disabled.
         * <p>
         * For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel AWS Client VPN endpoint</a> in the <em>AWS Client VPN Administrator Guide</em> .
         * <p>
         * @return {@code this}
         * @param splitTunnel Indicates whether split-tunnel is enabled on the AWS Client VPN endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder splitTunnel(final software.amazon.awscdk.core.IResolvable splitTunnel) {
            this.props.splitTunnel(splitTunnel);
            return this;
        }

        /**
         * The tags to apply to the Client VPN endpoint during creation.
         * <p>
         * @return {@code this}
         * @param tagSpecifications The tags to apply to the Client VPN endpoint during creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(final software.amazon.awscdk.core.IResolvable tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }
        /**
         * The tags to apply to the Client VPN endpoint during creation.
         * <p>
         * @return {@code this}
         * @param tagSpecifications The tags to apply to the Client VPN endpoint during creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(final java.util.List<? extends java.lang.Object> tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }

        /**
         * The transport protocol to be used by the VPN session.
         * <p>
         * Default value: <code>udp</code>
         * <p>
         * @return {@code this}
         * @param transportProtocol The transport protocol to be used by the VPN session. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transportProtocol(final java.lang.String transportProtocol) {
            this.props.transportProtocol(transportProtocol);
            return this;
        }

        /**
         * The ID of the VPC to associate with the Client VPN endpoint.
         * <p>
         * If no security group IDs are specified in the request, the default security group for the VPC is applied.
         * <p>
         * @return {@code this}
         * @param vpcId The ID of the VPC to associate with the Client VPN endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(final java.lang.String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        /**
         * The port number to assign to the Client VPN endpoint for TCP and UDP traffic.
         * <p>
         * Valid Values: <code>443</code> | <code>1194</code>
         * <p>
         * Default Value: <code>443</code>
         * <p>
         * @return {@code this}
         * @param vpnPort The port number to assign to the Client VPN endpoint for TCP and UDP traffic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnPort(final java.lang.Number vpnPort) {
            this.props.vpnPort(vpnPort);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint build() {
            return new software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
