package software.amazon.awscdk.services.ec2;

/**
 * Options to add a gateway endpoint to a VPC.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Add gateway endpoints when creating the VPC
 * Vpc vpc = Vpc.Builder.create(this, "MyVpc")
 *         .gatewayEndpoints(Map.of(
 *                 "S3", GatewayVpcEndpointOptions.builder()
 *                         .service(GatewayVpcEndpointAwsService.S3)
 *                         .build()))
 *         .build();
 * // Alternatively gateway endpoints can be added on the VPC
 * GatewayVpcEndpoint dynamoDbEndpoint = vpc.addGatewayEndpoint("DynamoDbEndpoint", GatewayVpcEndpointOptions.builder()
 *         .service(GatewayVpcEndpointAwsService.DYNAMODB)
 *         .build());
 * // This allows to customize the endpoint policy
 * dynamoDbEndpoint.addToPolicy(
 * PolicyStatement.Builder.create() // Restrict to listing and describing tables
 *         .principals(List.of(new AnyPrincipal()))
 *         .actions(List.of("dynamodb:DescribeTable", "dynamodb:ListTables"))
 *         .resources(List.of("*")).build());
 * // Add an interface endpoint
 * vpc.addInterfaceEndpoint("EcrDockerEndpoint", InterfaceVpcEndpointOptions.builder()
 *         .service(InterfaceVpcEndpointAwsService.ECR_DOCKER)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-10-20T14:12:16.059Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.GatewayVpcEndpointOptions")
@software.amazon.jsii.Jsii.Proxy(GatewayVpcEndpointOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GatewayVpcEndpointOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The service to use for this gateway VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService getService();

    /**
     * Where to add endpoint routing.
     * <p>
     * By default, this endpoint will be routable from all subnets in the VPC.
     * Specify a list of subnet selection objects here to be more specific.
     * <p>
     * Default: - All subnets in the VPC
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * Vpc vpc;
     * vpc.addGatewayEndpoint("DynamoDbEndpoint", GatewayVpcEndpointOptions.builder()
     *         .service(GatewayVpcEndpointAwsService.DYNAMODB)
     *         // Add only to ISOLATED subnets
     *         .subnets(List.of(SubnetSelection.builder().subnetType(SubnetType.PRIVATE_ISOLATED).build()))
     *         .build());
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GatewayVpcEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GatewayVpcEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GatewayVpcEndpointOptions> {
        software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService service;
        java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> subnets;

        /**
         * Sets the value of {@link GatewayVpcEndpointOptions#getService}
         * @param service The service to use for this gateway VPC endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link GatewayVpcEndpointOptions#getSubnets}
         * @param subnets Where to add endpoint routing.
         *                By default, this endpoint will be routable from all subnets in the VPC.
         *                Specify a list of subnet selection objects here to be more specific.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder subnets(java.util.List<? extends software.amazon.awscdk.services.ec2.SubnetSelection> subnets) {
            this.subnets = (java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection>)subnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GatewayVpcEndpointOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GatewayVpcEndpointOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GatewayVpcEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayVpcEndpointOptions {
        private final software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService service;
        private final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> subnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.service = software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService.class));
            this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.service = java.util.Objects.requireNonNull(builder.service, "service is required");
            this.subnets = (java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection>)builder.subnets;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService getService() {
            return this.service;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getSubnets() {
            return this.subnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("service", om.valueToTree(this.getService()));
            if (this.getSubnets() != null) {
                data.set("subnets", om.valueToTree(this.getSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.GatewayVpcEndpointOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GatewayVpcEndpointOptions.Jsii$Proxy that = (GatewayVpcEndpointOptions.Jsii$Proxy) o;

            if (!service.equals(that.service)) return false;
            return this.subnets != null ? this.subnets.equals(that.subnets) : that.subnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.service.hashCode();
            result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
            return result;
        }
    }
}
