/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.ec2.$Module;
import software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis;
import software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysisProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnNetworkInsightsAnalysis")
public class CfnNetworkInsightsAnalysis
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnNetworkInsightsAnalysis.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnNetworkInsightsAnalysis(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnNetworkInsightsAnalysis(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnNetworkInsightsAnalysis(@NotNull Construct scope, @NotNull String id, @NotNull CfnNetworkInsightsAnalysisProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public IResolvable getAttrAlternatePathHints() {
        return (IResolvable)Kernel.get((Object)((Object)this), (String)"attrAlternatePathHints", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public IResolvable getAttrExplanations() {
        return (IResolvable)Kernel.get((Object)((Object)this), (String)"attrExplanations", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public IResolvable getAttrForwardPathComponents() {
        return (IResolvable)Kernel.get((Object)((Object)this), (String)"attrForwardPathComponents", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public String getAttrNetworkInsightsAnalysisArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrNetworkInsightsAnalysisArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrNetworkInsightsAnalysisId() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrNetworkInsightsAnalysisId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResolvable getAttrNetworkPathFound() {
        return (IResolvable)Kernel.get((Object)((Object)this), (String)"attrNetworkPathFound", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public IResolvable getAttrReturnPathComponents() {
        return (IResolvable)Kernel.get((Object)((Object)this), (String)"attrReturnPathComponents", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public String getAttrStartDate() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrStartDate", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStatus() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStatusMessage() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrStatusMessage", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @NotNull
    public String getNetworkInsightsPathId() {
        return (String)Kernel.get((Object)((Object)this), (String)"networkInsightsPathId", (NativeType)NativeType.forClass(String.class));
    }

    public void setNetworkInsightsPathId(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"networkInsightsPathId", (Object)Objects.requireNonNull(value, "networkInsightsPathId is required"));
    }

    @Nullable
    public List<String> getFilterInArns() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"filterInArns", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setFilterInArns(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"filterInArns", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnNetworkInsightsAnalysis> {
        private final Construct scope;
        private final String id;
        private final CfnNetworkInsightsAnalysisProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnNetworkInsightsAnalysisProps.Builder();
        }

        public Builder networkInsightsPathId(String networkInsightsPathId) {
            this.props.networkInsightsPathId(networkInsightsPathId);
            return this;
        }

        public Builder filterInArns(List<String> filterInArns) {
            this.props.filterInArns(filterInArns);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnNetworkInsightsAnalysis build() {
            return new CfnNetworkInsightsAnalysis(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnNetworkInsightsAnalysis.TransitGatewayRouteTableRouteProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TransitGatewayRouteTableRouteProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAttachmentId() {
            return null;
        }

        @Nullable
        default public String getDestinationCidr() {
            return null;
        }

        @Nullable
        default public String getPrefixListId() {
            return null;
        }

        @Nullable
        default public String getResourceId() {
            return null;
        }

        @Nullable
        default public String getResourceType() {
            return null;
        }

        @Nullable
        default public String getRouteOrigin() {
            return null;
        }

        @Nullable
        default public String getState() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TransitGatewayRouteTableRouteProperty> {
            String attachmentId;
            String destinationCidr;
            String prefixListId;
            String resourceId;
            String resourceType;
            String routeOrigin;
            String state;

            public Builder attachmentId(String attachmentId) {
                this.attachmentId = attachmentId;
                return this;
            }

            public Builder destinationCidr(String destinationCidr) {
                this.destinationCidr = destinationCidr;
                return this;
            }

            public Builder prefixListId(String prefixListId) {
                this.prefixListId = prefixListId;
                return this;
            }

            public Builder resourceId(String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            public Builder resourceType(String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            public Builder routeOrigin(String routeOrigin) {
                this.routeOrigin = routeOrigin;
                return this;
            }

            public Builder state(String state) {
                this.state = state;
                return this;
            }

            public TransitGatewayRouteTableRouteProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnNetworkInsightsAnalysis.PortRangeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PortRangeProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getFrom() {
            return null;
        }

        @Nullable
        default public Number getTo() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PortRangeProperty> {
            Number from;
            Number to;

            public Builder from(Number from) {
                this.from = from;
                return this;
            }

            public Builder to(Number to) {
                this.to = to;
                return this;
            }

            public PortRangeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnNetworkInsightsAnalysis.PathComponentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PathComponentProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAclRule() {
            return null;
        }

        @Nullable
        default public Object getAdditionalDetails() {
            return null;
        }

        @Nullable
        default public Object getComponent() {
            return null;
        }

        @Nullable
        default public Object getDestinationVpc() {
            return null;
        }

        @Nullable
        default public Object getElasticLoadBalancerListener() {
            return null;
        }

        @Nullable
        default public Object getExplanations() {
            return null;
        }

        @Nullable
        default public Object getInboundHeader() {
            return null;
        }

        @Nullable
        default public Object getOutboundHeader() {
            return null;
        }

        @Nullable
        default public Object getRouteTableRoute() {
            return null;
        }

        @Nullable
        default public Object getSecurityGroupRule() {
            return null;
        }

        @Nullable
        default public Number getSequenceNumber() {
            return null;
        }

        @Nullable
        default public Object getSourceVpc() {
            return null;
        }

        @Nullable
        default public Object getSubnet() {
            return null;
        }

        @Nullable
        default public Object getTransitGateway() {
            return null;
        }

        @Nullable
        default public Object getTransitGatewayRouteTableRoute() {
            return null;
        }

        @Nullable
        default public Object getVpc() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PathComponentProperty> {
            Object aclRule;
            Object additionalDetails;
            Object component;
            Object destinationVpc;
            Object elasticLoadBalancerListener;
            Object explanations;
            Object inboundHeader;
            Object outboundHeader;
            Object routeTableRoute;
            Object securityGroupRule;
            Number sequenceNumber;
            Object sourceVpc;
            Object subnet;
            Object transitGateway;
            Object transitGatewayRouteTableRoute;
            Object vpc;

            public Builder aclRule(IResolvable aclRule) {
                this.aclRule = aclRule;
                return this;
            }

            public Builder aclRule(AnalysisAclRuleProperty aclRule) {
                this.aclRule = aclRule;
                return this;
            }

            public Builder additionalDetails(IResolvable additionalDetails) {
                this.additionalDetails = additionalDetails;
                return this;
            }

            public Builder additionalDetails(List<? extends Object> additionalDetails) {
                this.additionalDetails = additionalDetails;
                return this;
            }

            public Builder component(IResolvable component) {
                this.component = component;
                return this;
            }

            public Builder component(AnalysisComponentProperty component) {
                this.component = component;
                return this;
            }

            public Builder destinationVpc(IResolvable destinationVpc) {
                this.destinationVpc = destinationVpc;
                return this;
            }

            public Builder destinationVpc(AnalysisComponentProperty destinationVpc) {
                this.destinationVpc = destinationVpc;
                return this;
            }

            public Builder elasticLoadBalancerListener(IResolvable elasticLoadBalancerListener) {
                this.elasticLoadBalancerListener = elasticLoadBalancerListener;
                return this;
            }

            public Builder elasticLoadBalancerListener(AnalysisComponentProperty elasticLoadBalancerListener) {
                this.elasticLoadBalancerListener = elasticLoadBalancerListener;
                return this;
            }

            public Builder explanations(IResolvable explanations) {
                this.explanations = explanations;
                return this;
            }

            public Builder explanations(List<? extends Object> explanations) {
                this.explanations = explanations;
                return this;
            }

            public Builder inboundHeader(IResolvable inboundHeader) {
                this.inboundHeader = inboundHeader;
                return this;
            }

            public Builder inboundHeader(AnalysisPacketHeaderProperty inboundHeader) {
                this.inboundHeader = inboundHeader;
                return this;
            }

            public Builder outboundHeader(IResolvable outboundHeader) {
                this.outboundHeader = outboundHeader;
                return this;
            }

            public Builder outboundHeader(AnalysisPacketHeaderProperty outboundHeader) {
                this.outboundHeader = outboundHeader;
                return this;
            }

            public Builder routeTableRoute(IResolvable routeTableRoute) {
                this.routeTableRoute = routeTableRoute;
                return this;
            }

            public Builder routeTableRoute(AnalysisRouteTableRouteProperty routeTableRoute) {
                this.routeTableRoute = routeTableRoute;
                return this;
            }

            public Builder securityGroupRule(IResolvable securityGroupRule) {
                this.securityGroupRule = securityGroupRule;
                return this;
            }

            public Builder securityGroupRule(AnalysisSecurityGroupRuleProperty securityGroupRule) {
                this.securityGroupRule = securityGroupRule;
                return this;
            }

            public Builder sequenceNumber(Number sequenceNumber) {
                this.sequenceNumber = sequenceNumber;
                return this;
            }

            public Builder sourceVpc(IResolvable sourceVpc) {
                this.sourceVpc = sourceVpc;
                return this;
            }

            public Builder sourceVpc(AnalysisComponentProperty sourceVpc) {
                this.sourceVpc = sourceVpc;
                return this;
            }

            public Builder subnet(IResolvable subnet) {
                this.subnet = subnet;
                return this;
            }

            public Builder subnet(AnalysisComponentProperty subnet) {
                this.subnet = subnet;
                return this;
            }

            public Builder transitGateway(IResolvable transitGateway) {
                this.transitGateway = transitGateway;
                return this;
            }

            public Builder transitGateway(AnalysisComponentProperty transitGateway) {
                this.transitGateway = transitGateway;
                return this;
            }

            public Builder transitGatewayRouteTableRoute(IResolvable transitGatewayRouteTableRoute) {
                this.transitGatewayRouteTableRoute = transitGatewayRouteTableRoute;
                return this;
            }

            public Builder transitGatewayRouteTableRoute(TransitGatewayRouteTableRouteProperty transitGatewayRouteTableRoute) {
                this.transitGatewayRouteTableRoute = transitGatewayRouteTableRoute;
                return this;
            }

            public Builder vpc(IResolvable vpc) {
                this.vpc = vpc;
                return this;
            }

            public Builder vpc(AnalysisComponentProperty vpc) {
                this.vpc = vpc;
                return this;
            }

            public PathComponentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnNetworkInsightsAnalysis.ExplanationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ExplanationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAcl() {
            return null;
        }

        @Nullable
        default public Object getAclRule() {
            return null;
        }

        @Nullable
        default public String getAddress() {
            return null;
        }

        @Nullable
        default public List<String> getAddresses() {
            return null;
        }

        @Nullable
        default public Object getAttachedTo() {
            return null;
        }

        @Nullable
        default public List<String> getAvailabilityZones() {
            return null;
        }

        @Nullable
        default public List<String> getCidrs() {
            return null;
        }

        @Nullable
        default public Object getClassicLoadBalancerListener() {
            return null;
        }

        @Nullable
        default public Object getComponent() {
            return null;
        }

        @Nullable
        default public String getComponentAccount() {
            return null;
        }

        @Nullable
        default public String getComponentRegion() {
            return null;
        }

        @Nullable
        default public Object getCustomerGateway() {
            return null;
        }

        @Nullable
        default public Object getDestination() {
            return null;
        }

        @Nullable
        default public Object getDestinationVpc() {
            return null;
        }

        @Nullable
        default public String getDirection() {
            return null;
        }

        @Nullable
        default public Object getElasticLoadBalancerListener() {
            return null;
        }

        @Nullable
        default public String getExplanationCode() {
            return null;
        }

        @Nullable
        default public Object getIngressRouteTable() {
            return null;
        }

        @Nullable
        default public Object getInternetGateway() {
            return null;
        }

        @Nullable
        default public String getLoadBalancerArn() {
            return null;
        }

        @Nullable
        default public Number getLoadBalancerListenerPort() {
            return null;
        }

        @Nullable
        default public Object getLoadBalancerTarget() {
            return null;
        }

        @Nullable
        default public Object getLoadBalancerTargetGroup() {
            return null;
        }

        @Nullable
        default public Object getLoadBalancerTargetGroups() {
            return null;
        }

        @Nullable
        default public Number getLoadBalancerTargetPort() {
            return null;
        }

        @Nullable
        default public String getMissingComponent() {
            return null;
        }

        @Nullable
        default public Object getNatGateway() {
            return null;
        }

        @Nullable
        default public Object getNetworkInterface() {
            return null;
        }

        @Nullable
        default public String getPacketField() {
            return null;
        }

        @Nullable
        default public Number getPort() {
            return null;
        }

        @Nullable
        default public Object getPortRanges() {
            return null;
        }

        @Nullable
        default public Object getPrefixList() {
            return null;
        }

        @Nullable
        default public List<String> getProtocols() {
            return null;
        }

        @Nullable
        default public Object getRouteTable() {
            return null;
        }

        @Nullable
        default public Object getRouteTableRoute() {
            return null;
        }

        @Nullable
        default public Object getSecurityGroup() {
            return null;
        }

        @Nullable
        default public Object getSecurityGroupRule() {
            return null;
        }

        @Nullable
        default public Object getSecurityGroups() {
            return null;
        }

        @Nullable
        default public Object getSourceVpc() {
            return null;
        }

        @Nullable
        default public String getState() {
            return null;
        }

        @Nullable
        default public Object getSubnet() {
            return null;
        }

        @Nullable
        default public Object getSubnetRouteTable() {
            return null;
        }

        @Nullable
        default public Object getTransitGateway() {
            return null;
        }

        @Nullable
        default public Object getTransitGatewayAttachment() {
            return null;
        }

        @Nullable
        default public Object getTransitGatewayRouteTable() {
            return null;
        }

        @Nullable
        default public Object getTransitGatewayRouteTableRoute() {
            return null;
        }

        @Nullable
        default public Object getVpc() {
            return null;
        }

        @Nullable
        default public Object getVpcEndpoint() {
            return null;
        }

        @Nullable
        default public Object getVpcPeeringConnection() {
            return null;
        }

        @Nullable
        default public Object getVpnConnection() {
            return null;
        }

        @Nullable
        default public Object getVpnGateway() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ExplanationProperty> {
            Object acl;
            Object aclRule;
            String address;
            List<String> addresses;
            Object attachedTo;
            List<String> availabilityZones;
            List<String> cidrs;
            Object classicLoadBalancerListener;
            Object component;
            String componentAccount;
            String componentRegion;
            Object customerGateway;
            Object destination;
            Object destinationVpc;
            String direction;
            Object elasticLoadBalancerListener;
            String explanationCode;
            Object ingressRouteTable;
            Object internetGateway;
            String loadBalancerArn;
            Number loadBalancerListenerPort;
            Object loadBalancerTarget;
            Object loadBalancerTargetGroup;
            Object loadBalancerTargetGroups;
            Number loadBalancerTargetPort;
            String missingComponent;
            Object natGateway;
            Object networkInterface;
            String packetField;
            Number port;
            Object portRanges;
            Object prefixList;
            List<String> protocols;
            Object routeTable;
            Object routeTableRoute;
            Object securityGroup;
            Object securityGroupRule;
            Object securityGroups;
            Object sourceVpc;
            String state;
            Object subnet;
            Object subnetRouteTable;
            Object transitGateway;
            Object transitGatewayAttachment;
            Object transitGatewayRouteTable;
            Object transitGatewayRouteTableRoute;
            Object vpc;
            Object vpcEndpoint;
            Object vpcPeeringConnection;
            Object vpnConnection;
            Object vpnGateway;

            public Builder acl(IResolvable acl) {
                this.acl = acl;
                return this;
            }

            public Builder acl(AnalysisComponentProperty acl) {
                this.acl = acl;
                return this;
            }

            public Builder aclRule(IResolvable aclRule) {
                this.aclRule = aclRule;
                return this;
            }

            public Builder aclRule(AnalysisAclRuleProperty aclRule) {
                this.aclRule = aclRule;
                return this;
            }

            public Builder address(String address) {
                this.address = address;
                return this;
            }

            public Builder addresses(List<String> addresses) {
                this.addresses = addresses;
                return this;
            }

            public Builder attachedTo(IResolvable attachedTo) {
                this.attachedTo = attachedTo;
                return this;
            }

            public Builder attachedTo(AnalysisComponentProperty attachedTo) {
                this.attachedTo = attachedTo;
                return this;
            }

            public Builder availabilityZones(List<String> availabilityZones) {
                this.availabilityZones = availabilityZones;
                return this;
            }

            public Builder cidrs(List<String> cidrs) {
                this.cidrs = cidrs;
                return this;
            }

            public Builder classicLoadBalancerListener(IResolvable classicLoadBalancerListener) {
                this.classicLoadBalancerListener = classicLoadBalancerListener;
                return this;
            }

            public Builder classicLoadBalancerListener(AnalysisLoadBalancerListenerProperty classicLoadBalancerListener) {
                this.classicLoadBalancerListener = classicLoadBalancerListener;
                return this;
            }

            public Builder component(IResolvable component) {
                this.component = component;
                return this;
            }

            public Builder component(AnalysisComponentProperty component) {
                this.component = component;
                return this;
            }

            public Builder componentAccount(String componentAccount) {
                this.componentAccount = componentAccount;
                return this;
            }

            public Builder componentRegion(String componentRegion) {
                this.componentRegion = componentRegion;
                return this;
            }

            public Builder customerGateway(IResolvable customerGateway) {
                this.customerGateway = customerGateway;
                return this;
            }

            public Builder customerGateway(AnalysisComponentProperty customerGateway) {
                this.customerGateway = customerGateway;
                return this;
            }

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(AnalysisComponentProperty destination) {
                this.destination = destination;
                return this;
            }

            public Builder destinationVpc(IResolvable destinationVpc) {
                this.destinationVpc = destinationVpc;
                return this;
            }

            public Builder destinationVpc(AnalysisComponentProperty destinationVpc) {
                this.destinationVpc = destinationVpc;
                return this;
            }

            public Builder direction(String direction) {
                this.direction = direction;
                return this;
            }

            public Builder elasticLoadBalancerListener(IResolvable elasticLoadBalancerListener) {
                this.elasticLoadBalancerListener = elasticLoadBalancerListener;
                return this;
            }

            public Builder elasticLoadBalancerListener(AnalysisComponentProperty elasticLoadBalancerListener) {
                this.elasticLoadBalancerListener = elasticLoadBalancerListener;
                return this;
            }

            public Builder explanationCode(String explanationCode) {
                this.explanationCode = explanationCode;
                return this;
            }

            public Builder ingressRouteTable(IResolvable ingressRouteTable) {
                this.ingressRouteTable = ingressRouteTable;
                return this;
            }

            public Builder ingressRouteTable(AnalysisComponentProperty ingressRouteTable) {
                this.ingressRouteTable = ingressRouteTable;
                return this;
            }

            public Builder internetGateway(IResolvable internetGateway) {
                this.internetGateway = internetGateway;
                return this;
            }

            public Builder internetGateway(AnalysisComponentProperty internetGateway) {
                this.internetGateway = internetGateway;
                return this;
            }

            public Builder loadBalancerArn(String loadBalancerArn) {
                this.loadBalancerArn = loadBalancerArn;
                return this;
            }

            public Builder loadBalancerListenerPort(Number loadBalancerListenerPort) {
                this.loadBalancerListenerPort = loadBalancerListenerPort;
                return this;
            }

            public Builder loadBalancerTarget(IResolvable loadBalancerTarget) {
                this.loadBalancerTarget = loadBalancerTarget;
                return this;
            }

            public Builder loadBalancerTarget(AnalysisLoadBalancerTargetProperty loadBalancerTarget) {
                this.loadBalancerTarget = loadBalancerTarget;
                return this;
            }

            public Builder loadBalancerTargetGroup(IResolvable loadBalancerTargetGroup) {
                this.loadBalancerTargetGroup = loadBalancerTargetGroup;
                return this;
            }

            public Builder loadBalancerTargetGroup(AnalysisComponentProperty loadBalancerTargetGroup) {
                this.loadBalancerTargetGroup = loadBalancerTargetGroup;
                return this;
            }

            public Builder loadBalancerTargetGroups(IResolvable loadBalancerTargetGroups) {
                this.loadBalancerTargetGroups = loadBalancerTargetGroups;
                return this;
            }

            public Builder loadBalancerTargetGroups(List<? extends Object> loadBalancerTargetGroups) {
                this.loadBalancerTargetGroups = loadBalancerTargetGroups;
                return this;
            }

            public Builder loadBalancerTargetPort(Number loadBalancerTargetPort) {
                this.loadBalancerTargetPort = loadBalancerTargetPort;
                return this;
            }

            public Builder missingComponent(String missingComponent) {
                this.missingComponent = missingComponent;
                return this;
            }

            public Builder natGateway(IResolvable natGateway) {
                this.natGateway = natGateway;
                return this;
            }

            public Builder natGateway(AnalysisComponentProperty natGateway) {
                this.natGateway = natGateway;
                return this;
            }

            public Builder networkInterface(IResolvable networkInterface) {
                this.networkInterface = networkInterface;
                return this;
            }

            public Builder networkInterface(AnalysisComponentProperty networkInterface) {
                this.networkInterface = networkInterface;
                return this;
            }

            public Builder packetField(String packetField) {
                this.packetField = packetField;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public Builder portRanges(IResolvable portRanges) {
                this.portRanges = portRanges;
                return this;
            }

            public Builder portRanges(List<? extends Object> portRanges) {
                this.portRanges = portRanges;
                return this;
            }

            public Builder prefixList(IResolvable prefixList) {
                this.prefixList = prefixList;
                return this;
            }

            public Builder prefixList(AnalysisComponentProperty prefixList) {
                this.prefixList = prefixList;
                return this;
            }

            public Builder protocols(List<String> protocols) {
                this.protocols = protocols;
                return this;
            }

            public Builder routeTable(IResolvable routeTable) {
                this.routeTable = routeTable;
                return this;
            }

            public Builder routeTable(AnalysisComponentProperty routeTable) {
                this.routeTable = routeTable;
                return this;
            }

            public Builder routeTableRoute(IResolvable routeTableRoute) {
                this.routeTableRoute = routeTableRoute;
                return this;
            }

            public Builder routeTableRoute(AnalysisRouteTableRouteProperty routeTableRoute) {
                this.routeTableRoute = routeTableRoute;
                return this;
            }

            public Builder securityGroup(IResolvable securityGroup) {
                this.securityGroup = securityGroup;
                return this;
            }

            public Builder securityGroup(AnalysisComponentProperty securityGroup) {
                this.securityGroup = securityGroup;
                return this;
            }

            public Builder securityGroupRule(IResolvable securityGroupRule) {
                this.securityGroupRule = securityGroupRule;
                return this;
            }

            public Builder securityGroupRule(AnalysisSecurityGroupRuleProperty securityGroupRule) {
                this.securityGroupRule = securityGroupRule;
                return this;
            }

            public Builder securityGroups(IResolvable securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public Builder securityGroups(List<? extends Object> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public Builder sourceVpc(IResolvable sourceVpc) {
                this.sourceVpc = sourceVpc;
                return this;
            }

            public Builder sourceVpc(AnalysisComponentProperty sourceVpc) {
                this.sourceVpc = sourceVpc;
                return this;
            }

            public Builder state(String state) {
                this.state = state;
                return this;
            }

            public Builder subnet(IResolvable subnet) {
                this.subnet = subnet;
                return this;
            }

            public Builder subnet(AnalysisComponentProperty subnet) {
                this.subnet = subnet;
                return this;
            }

            public Builder subnetRouteTable(IResolvable subnetRouteTable) {
                this.subnetRouteTable = subnetRouteTable;
                return this;
            }

            public Builder subnetRouteTable(AnalysisComponentProperty subnetRouteTable) {
                this.subnetRouteTable = subnetRouteTable;
                return this;
            }

            public Builder transitGateway(IResolvable transitGateway) {
                this.transitGateway = transitGateway;
                return this;
            }

            public Builder transitGateway(AnalysisComponentProperty transitGateway) {
                this.transitGateway = transitGateway;
                return this;
            }

            public Builder transitGatewayAttachment(IResolvable transitGatewayAttachment) {
                this.transitGatewayAttachment = transitGatewayAttachment;
                return this;
            }

            public Builder transitGatewayAttachment(AnalysisComponentProperty transitGatewayAttachment) {
                this.transitGatewayAttachment = transitGatewayAttachment;
                return this;
            }

            public Builder transitGatewayRouteTable(IResolvable transitGatewayRouteTable) {
                this.transitGatewayRouteTable = transitGatewayRouteTable;
                return this;
            }

            public Builder transitGatewayRouteTable(AnalysisComponentProperty transitGatewayRouteTable) {
                this.transitGatewayRouteTable = transitGatewayRouteTable;
                return this;
            }

            public Builder transitGatewayRouteTableRoute(IResolvable transitGatewayRouteTableRoute) {
                this.transitGatewayRouteTableRoute = transitGatewayRouteTableRoute;
                return this;
            }

            public Builder transitGatewayRouteTableRoute(TransitGatewayRouteTableRouteProperty transitGatewayRouteTableRoute) {
                this.transitGatewayRouteTableRoute = transitGatewayRouteTableRoute;
                return this;
            }

            public Builder vpc(IResolvable vpc) {
                this.vpc = vpc;
                return this;
            }

            public Builder vpc(AnalysisComponentProperty vpc) {
                this.vpc = vpc;
                return this;
            }

            public Builder vpcEndpoint(IResolvable vpcEndpoint) {
                this.vpcEndpoint = vpcEndpoint;
                return this;
            }

            public Builder vpcEndpoint(AnalysisComponentProperty vpcEndpoint) {
                this.vpcEndpoint = vpcEndpoint;
                return this;
            }

            public Builder vpcPeeringConnection(IResolvable vpcPeeringConnection) {
                this.vpcPeeringConnection = vpcPeeringConnection;
                return this;
            }

            public Builder vpcPeeringConnection(AnalysisComponentProperty vpcPeeringConnection) {
                this.vpcPeeringConnection = vpcPeeringConnection;
                return this;
            }

            public Builder vpnConnection(IResolvable vpnConnection) {
                this.vpnConnection = vpnConnection;
                return this;
            }

            public Builder vpnConnection(AnalysisComponentProperty vpnConnection) {
                this.vpnConnection = vpnConnection;
                return this;
            }

            public Builder vpnGateway(IResolvable vpnGateway) {
                this.vpnGateway = vpnGateway;
                return this;
            }

            public Builder vpnGateway(AnalysisComponentProperty vpnGateway) {
                this.vpnGateway = vpnGateway;
                return this;
            }

            public ExplanationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AnalysisSecurityGroupRuleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCidr() {
            return null;
        }

        @Nullable
        default public String getDirection() {
            return null;
        }

        @Nullable
        default public Object getPortRange() {
            return null;
        }

        @Nullable
        default public String getPrefixListId() {
            return null;
        }

        @Nullable
        default public String getProtocol() {
            return null;
        }

        @Nullable
        default public String getSecurityGroupId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AnalysisSecurityGroupRuleProperty> {
            String cidr;
            String direction;
            Object portRange;
            String prefixListId;
            String protocol;
            String securityGroupId;

            public Builder cidr(String cidr) {
                this.cidr = cidr;
                return this;
            }

            public Builder direction(String direction) {
                this.direction = direction;
                return this;
            }

            public Builder portRange(IResolvable portRange) {
                this.portRange = portRange;
                return this;
            }

            public Builder portRange(PortRangeProperty portRange) {
                this.portRange = portRange;
                return this;
            }

            public Builder prefixListId(String prefixListId) {
                this.prefixListId = prefixListId;
                return this;
            }

            public Builder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public Builder securityGroupId(String securityGroupId) {
                this.securityGroupId = securityGroupId;
                return this;
            }

            public AnalysisSecurityGroupRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AnalysisRouteTableRouteProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDestinationCidr() {
            return null;
        }

        @Nullable
        default public String getDestinationPrefixListId() {
            return null;
        }

        @Nullable
        default public String getEgressOnlyInternetGatewayId() {
            return null;
        }

        @Nullable
        default public String getGatewayId() {
            return null;
        }

        @Nullable
        default public String getInstanceId() {
            return null;
        }

        @Nullable
        default public String getNatGatewayId() {
            return null;
        }

        @Nullable
        default public String getNetworkInterfaceId() {
            return null;
        }

        @Nullable
        default public String getOrigin() {
            return null;
        }

        @Nullable
        default public String getState() {
            return null;
        }

        @Nullable
        default public String getTransitGatewayId() {
            return null;
        }

        @Nullable
        default public String getVpcPeeringConnectionId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AnalysisRouteTableRouteProperty> {
            String destinationCidr;
            String destinationPrefixListId;
            String egressOnlyInternetGatewayId;
            String gatewayId;
            String instanceId;
            String natGatewayId;
            String networkInterfaceId;
            String origin;
            String state;
            String transitGatewayId;
            String vpcPeeringConnectionId;

            public Builder destinationCidr(String destinationCidr) {
                this.destinationCidr = destinationCidr;
                return this;
            }

            public Builder destinationPrefixListId(String destinationPrefixListId) {
                this.destinationPrefixListId = destinationPrefixListId;
                return this;
            }

            public Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
                this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
                return this;
            }

            public Builder gatewayId(String gatewayId) {
                this.gatewayId = gatewayId;
                return this;
            }

            public Builder instanceId(String instanceId) {
                this.instanceId = instanceId;
                return this;
            }

            public Builder natGatewayId(String natGatewayId) {
                this.natGatewayId = natGatewayId;
                return this;
            }

            public Builder networkInterfaceId(String networkInterfaceId) {
                this.networkInterfaceId = networkInterfaceId;
                return this;
            }

            public Builder origin(String origin) {
                this.origin = origin;
                return this;
            }

            public Builder state(String state) {
                this.state = state;
                return this;
            }

            public Builder transitGatewayId(String transitGatewayId) {
                this.transitGatewayId = transitGatewayId;
                return this;
            }

            public Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
                this.vpcPeeringConnectionId = vpcPeeringConnectionId;
                return this;
            }

            public AnalysisRouteTableRouteProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AnalysisPacketHeaderProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getDestinationAddresses() {
            return null;
        }

        @Nullable
        default public Object getDestinationPortRanges() {
            return null;
        }

        @Nullable
        default public String getProtocol() {
            return null;
        }

        @Nullable
        default public List<String> getSourceAddresses() {
            return null;
        }

        @Nullable
        default public Object getSourcePortRanges() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AnalysisPacketHeaderProperty> {
            List<String> destinationAddresses;
            Object destinationPortRanges;
            String protocol;
            List<String> sourceAddresses;
            Object sourcePortRanges;

            public Builder destinationAddresses(List<String> destinationAddresses) {
                this.destinationAddresses = destinationAddresses;
                return this;
            }

            public Builder destinationPortRanges(IResolvable destinationPortRanges) {
                this.destinationPortRanges = destinationPortRanges;
                return this;
            }

            public Builder destinationPortRanges(List<? extends Object> destinationPortRanges) {
                this.destinationPortRanges = destinationPortRanges;
                return this;
            }

            public Builder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public Builder sourceAddresses(List<String> sourceAddresses) {
                this.sourceAddresses = sourceAddresses;
                return this;
            }

            public Builder sourcePortRanges(IResolvable sourcePortRanges) {
                this.sourcePortRanges = sourcePortRanges;
                return this;
            }

            public Builder sourcePortRanges(List<? extends Object> sourcePortRanges) {
                this.sourcePortRanges = sourcePortRanges;
                return this;
            }

            public AnalysisPacketHeaderProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnNetworkInsightsAnalysis.AnalysisLoadBalancerTargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AnalysisLoadBalancerTargetProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAddress() {
            return null;
        }

        @Nullable
        default public String getAvailabilityZone() {
            return null;
        }

        @Nullable
        default public Object getInstance() {
            return null;
        }

        @Nullable
        default public Number getPort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AnalysisLoadBalancerTargetProperty> {
            String address;
            String availabilityZone;
            Object instance;
            Number port;

            public Builder address(String address) {
                this.address = address;
                return this;
            }

            public Builder availabilityZone(String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            public Builder instance(IResolvable instance) {
                this.instance = instance;
                return this;
            }

            public Builder instance(AnalysisComponentProperty instance) {
                this.instance = instance;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public AnalysisLoadBalancerTargetProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnNetworkInsightsAnalysis.AnalysisLoadBalancerListenerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AnalysisLoadBalancerListenerProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getInstancePort() {
            return null;
        }

        @Nullable
        default public Number getLoadBalancerPort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AnalysisLoadBalancerListenerProperty> {
            Number instancePort;
            Number loadBalancerPort;

            public Builder instancePort(Number instancePort) {
                this.instancePort = instancePort;
                return this;
            }

            public Builder loadBalancerPort(Number loadBalancerPort) {
                this.loadBalancerPort = loadBalancerPort;
                return this;
            }

            public AnalysisLoadBalancerListenerProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AnalysisComponentProperty
    extends JsiiSerializable {
        @Nullable
        default public String getArn() {
            return null;
        }

        @Nullable
        default public String getId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AnalysisComponentProperty> {
            String arn;
            String id;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public AnalysisComponentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AnalysisAclRuleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCidr() {
            return null;
        }

        @Nullable
        default public Object getEgress() {
            return null;
        }

        @Nullable
        default public Object getPortRange() {
            return null;
        }

        @Nullable
        default public String getProtocol() {
            return null;
        }

        @Nullable
        default public String getRuleAction() {
            return null;
        }

        @Nullable
        default public Number getRuleNumber() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AnalysisAclRuleProperty> {
            String cidr;
            Object egress;
            Object portRange;
            String protocol;
            String ruleAction;
            Number ruleNumber;

            public Builder cidr(String cidr) {
                this.cidr = cidr;
                return this;
            }

            public Builder egress(Boolean egress) {
                this.egress = egress;
                return this;
            }

            public Builder egress(IResolvable egress) {
                this.egress = egress;
                return this;
            }

            public Builder portRange(IResolvable portRange) {
                this.portRange = portRange;
                return this;
            }

            public Builder portRange(PortRangeProperty portRange) {
                this.portRange = portRange;
                return this;
            }

            public Builder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public Builder ruleAction(String ruleAction) {
                this.ruleAction = ruleAction;
                return this;
            }

            public Builder ruleNumber(Number ruleNumber) {
                this.ruleNumber = ruleNumber;
                return this;
            }

            public AnalysisAclRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnNetworkInsightsAnalysis.AlternatePathHintProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AlternatePathHintProperty
    extends JsiiSerializable {
        @Nullable
        default public String getComponentArn() {
            return null;
        }

        @Nullable
        default public String getComponentId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AlternatePathHintProperty> {
            String componentArn;
            String componentId;

            public Builder componentArn(String componentArn) {
                this.componentArn = componentArn;
                return this;
            }

            public Builder componentId(String componentId) {
                this.componentId = componentId;
                return this;
            }

            public AlternatePathHintProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnNetworkInsightsAnalysis.AdditionalDetailProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AdditionalDetailProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAdditionalDetailType() {
            return null;
        }

        @Nullable
        default public Object getComponent() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AdditionalDetailProperty> {
            String additionalDetailType;
            Object component;

            public Builder additionalDetailType(String additionalDetailType) {
                this.additionalDetailType = additionalDetailType;
                return this;
            }

            public Builder component(IResolvable component) {
                this.component = component;
                return this;
            }

            public Builder component(AnalysisComponentProperty component) {
                this.component = component;
                return this;
            }

            public AdditionalDetailProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

