package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::VPCCidrBlock`.
 * <p>
 * Associates a CIDR block with your VPC. You can only associate a single IPv6 CIDR block with your VPC. The IPv6 CIDR block size is fixed at /56.
 * <p>
 * For more information about associating CIDR blocks with your VPC and applicable restrictions, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#VPC_Sizing">VPC and Subnet Sizing</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVPCCidrBlock cfnVPCCidrBlock = CfnVPCCidrBlock.Builder.create(this, "MyCfnVPCCidrBlock")
 *         .vpcId("vpcId")
 *         // the properties below are optional
 *         .amazonProvidedIpv6CidrBlock(false)
 *         .cidrBlock("cidrBlock")
 *         .ipv4IpamPoolId("ipv4IpamPoolId")
 *         .ipv4NetmaskLength(123)
 *         .ipv6CidrBlock("ipv6CidrBlock")
 *         .ipv6IpamPoolId("ipv6IpamPoolId")
 *         .ipv6NetmaskLength(123)
 *         .ipv6Pool("ipv6Pool")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.70.0 (build 03c2f6f)", date = "2022-10-27T14:10:45.575Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVPCCidrBlock")
public class CfnVPCCidrBlock extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnVPCCidrBlock(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVPCCidrBlock(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnVPCCidrBlock.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::VPCCidrBlock`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnVPCCidrBlock(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnVPCCidrBlockProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ID of the VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcId() {
        return software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpcId", java.util.Objects.requireNonNull(value, "vpcId is required"));
    }

    /**
     * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC.
     * <p>
     * You cannot specify the range of IPv6 addresses, or the size of the CIDR block.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAmazonProvidedIpv6CidrBlock() {
        return software.amazon.jsii.Kernel.get(this, "amazonProvidedIpv6CidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC.
     * <p>
     * You cannot specify the range of IPv6 addresses, or the size of the CIDR block.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAmazonProvidedIpv6CidrBlock(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "amazonProvidedIpv6CidrBlock", value);
    }

    /**
     * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC.
     * <p>
     * You cannot specify the range of IPv6 addresses, or the size of the CIDR block.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAmazonProvidedIpv6CidrBlock(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "amazonProvidedIpv6CidrBlock", value);
    }

    /**
     * An IPv4 CIDR block to associate with the VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCidrBlock() {
        return software.amazon.jsii.Kernel.get(this, "cidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An IPv4 CIDR block to associate with the VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCidrBlock(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cidrBlock", value);
    }

    /**
     * Associate a CIDR allocated from an IPv4 IPAM pool to a VPC.
     * <p>
     * For more information about Amazon VPC IP Address Manager (IPAM), see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <em>Amazon VPC IPAM User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIpv4IpamPoolId() {
        return software.amazon.jsii.Kernel.get(this, "ipv4IpamPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Associate a CIDR allocated from an IPv4 IPAM pool to a VPC.
     * <p>
     * For more information about Amazon VPC IP Address Manager (IPAM), see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <em>Amazon VPC IPAM User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpv4IpamPoolId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ipv4IpamPoolId", value);
    }

    /**
     * The netmask length of the IPv4 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool.
     * <p>
     * For more information about IPAM, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <em>Amazon VPC IPAM User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getIpv4NetmaskLength() {
        return software.amazon.jsii.Kernel.get(this, "ipv4NetmaskLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The netmask length of the IPv4 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool.
     * <p>
     * For more information about IPAM, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <em>Amazon VPC IPAM User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpv4NetmaskLength(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "ipv4NetmaskLength", value);
    }

    /**
     * An IPv6 CIDR block from the IPv6 address pool. You must also specify `Ipv6Pool` in the request.
     * <p>
     * To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIpv6CidrBlock() {
        return software.amazon.jsii.Kernel.get(this, "ipv6CidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An IPv6 CIDR block from the IPv6 address pool. You must also specify `Ipv6Pool` in the request.
     * <p>
     * To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpv6CidrBlock(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ipv6CidrBlock", value);
    }

    /**
     * Associates a CIDR allocated from an IPv6 IPAM pool to a VPC.
     * <p>
     * For more information about Amazon VPC IP Address Manager (IPAM), see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <em>Amazon VPC IPAM User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIpv6IpamPoolId() {
        return software.amazon.jsii.Kernel.get(this, "ipv6IpamPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Associates a CIDR allocated from an IPv6 IPAM pool to a VPC.
     * <p>
     * For more information about Amazon VPC IP Address Manager (IPAM), see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <em>Amazon VPC IPAM User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpv6IpamPoolId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ipv6IpamPoolId", value);
    }

    /**
     * The netmask length of the IPv6 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool.
     * <p>
     * For more information about IPAM, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <em>Amazon VPC IPAM User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getIpv6NetmaskLength() {
        return software.amazon.jsii.Kernel.get(this, "ipv6NetmaskLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The netmask length of the IPv6 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool.
     * <p>
     * For more information about IPAM, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <em>Amazon VPC IPAM User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpv6NetmaskLength(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "ipv6NetmaskLength", value);
    }

    /**
     * The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIpv6Pool() {
        return software.amazon.jsii.Kernel.get(this, "ipv6Pool", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpv6Pool(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ipv6Pool", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnVPCCidrBlock}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnVPCCidrBlock> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnVPCCidrBlockProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnVPCCidrBlockProps.Builder();
        }

        /**
         * The ID of the VPC.
         * <p>
         * @return {@code this}
         * @param vpcId The ID of the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(final java.lang.String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        /**
         * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC.
         * <p>
         * You cannot specify the range of IPv6 addresses, or the size of the CIDR block.
         * <p>
         * @return {@code this}
         * @param amazonProvidedIpv6CidrBlock Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amazonProvidedIpv6CidrBlock(final java.lang.Boolean amazonProvidedIpv6CidrBlock) {
            this.props.amazonProvidedIpv6CidrBlock(amazonProvidedIpv6CidrBlock);
            return this;
        }
        /**
         * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC.
         * <p>
         * You cannot specify the range of IPv6 addresses, or the size of the CIDR block.
         * <p>
         * @return {@code this}
         * @param amazonProvidedIpv6CidrBlock Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amazonProvidedIpv6CidrBlock(final software.amazon.awscdk.core.IResolvable amazonProvidedIpv6CidrBlock) {
            this.props.amazonProvidedIpv6CidrBlock(amazonProvidedIpv6CidrBlock);
            return this;
        }

        /**
         * An IPv4 CIDR block to associate with the VPC.
         * <p>
         * @return {@code this}
         * @param cidrBlock An IPv4 CIDR block to associate with the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrBlock(final java.lang.String cidrBlock) {
            this.props.cidrBlock(cidrBlock);
            return this;
        }

        /**
         * Associate a CIDR allocated from an IPv4 IPAM pool to a VPC.
         * <p>
         * For more information about Amazon VPC IP Address Manager (IPAM), see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <em>Amazon VPC IPAM User Guide</em> .
         * <p>
         * @return {@code this}
         * @param ipv4IpamPoolId Associate a CIDR allocated from an IPv4 IPAM pool to a VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv4IpamPoolId(final java.lang.String ipv4IpamPoolId) {
            this.props.ipv4IpamPoolId(ipv4IpamPoolId);
            return this;
        }

        /**
         * The netmask length of the IPv4 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool.
         * <p>
         * For more information about IPAM, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <em>Amazon VPC IPAM User Guide</em> .
         * <p>
         * @return {@code this}
         * @param ipv4NetmaskLength The netmask length of the IPv4 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv4NetmaskLength(final java.lang.Number ipv4NetmaskLength) {
            this.props.ipv4NetmaskLength(ipv4NetmaskLength);
            return this;
        }

        /**
         * An IPv6 CIDR block from the IPv6 address pool. You must also specify `Ipv6Pool` in the request.
         * <p>
         * To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
         * <p>
         * @return {@code this}
         * @param ipv6CidrBlock An IPv6 CIDR block from the IPv6 address pool. You must also specify `Ipv6Pool` in the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6CidrBlock(final java.lang.String ipv6CidrBlock) {
            this.props.ipv6CidrBlock(ipv6CidrBlock);
            return this;
        }

        /**
         * Associates a CIDR allocated from an IPv6 IPAM pool to a VPC.
         * <p>
         * For more information about Amazon VPC IP Address Manager (IPAM), see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <em>Amazon VPC IPAM User Guide</em> .
         * <p>
         * @return {@code this}
         * @param ipv6IpamPoolId Associates a CIDR allocated from an IPv6 IPAM pool to a VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6IpamPoolId(final java.lang.String ipv6IpamPoolId) {
            this.props.ipv6IpamPoolId(ipv6IpamPoolId);
            return this;
        }

        /**
         * The netmask length of the IPv6 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool.
         * <p>
         * For more information about IPAM, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <em>Amazon VPC IPAM User Guide</em> .
         * <p>
         * @return {@code this}
         * @param ipv6NetmaskLength The netmask length of the IPv6 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6NetmaskLength(final java.lang.Number ipv6NetmaskLength) {
            this.props.ipv6NetmaskLength(ipv6NetmaskLength);
            return this;
        }

        /**
         * The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
         * <p>
         * @return {@code this}
         * @param ipv6Pool The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Pool(final java.lang.String ipv6Pool) {
            this.props.ipv6Pool(ipv6Pool);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnVPCCidrBlock}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnVPCCidrBlock build() {
            return new software.amazon.awscdk.services.ec2.CfnVPCCidrBlock(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
