package software.amazon.awscdk.services.ec2;

/**
 * Options for a ClientVpnAuthorizationRule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ClientVpnEndpoint endpoint = vpc.addClientVpnEndpoint("Endpoint", ClientVpnEndpointOptions.builder()
 *         .cidr("10.100.0.0/16")
 *         .serverCertificateArn("arn:aws:acm:us-east-1:123456789012:certificate/server-certificate-id")
 *         .userBasedAuthentication(ClientVpnUserBasedAuthentication.federated(samlProvider))
 *         .authorizeAllUsersToVpcCidr(false)
 *         .build());
 * endpoint.addAuthorizationRule("Rule", ClientVpnAuthorizationRuleOptions.builder()
 *         .cidr("10.0.10.0/32")
 *         .groupId("group-id")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-14T20:30:49.396Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.ClientVpnAuthorizationRuleOptions")
@software.amazon.jsii.Jsii.Proxy(ClientVpnAuthorizationRuleOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ClientVpnAuthorizationRuleOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IPv4 address range, in CIDR notation, of the network for which access is being authorized.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCidr();

    /**
     * A brief description of the authorization rule.
     * <p>
     * Default: - no description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group.
     * <p>
     * Default: - authorize all groups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGroupId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ClientVpnAuthorizationRuleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClientVpnAuthorizationRuleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ClientVpnAuthorizationRuleOptions> {
        java.lang.String cidr;
        java.lang.String description;
        java.lang.String groupId;

        /**
         * Sets the value of {@link ClientVpnAuthorizationRuleOptions#getCidr}
         * @param cidr The IPv4 address range, in CIDR notation, of the network for which access is being authorized. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidr(java.lang.String cidr) {
            this.cidr = cidr;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnAuthorizationRuleOptions#getDescription}
         * @param description A brief description of the authorization rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnAuthorizationRuleOptions#getGroupId}
         * @param groupId The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupId(java.lang.String groupId) {
            this.groupId = groupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClientVpnAuthorizationRuleOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ClientVpnAuthorizationRuleOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ClientVpnAuthorizationRuleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientVpnAuthorizationRuleOptions {
        private final java.lang.String cidr;
        private final java.lang.String description;
        private final java.lang.String groupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cidr = software.amazon.jsii.Kernel.get(this, "cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.groupId = software.amazon.jsii.Kernel.get(this, "groupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cidr = java.util.Objects.requireNonNull(builder.cidr, "cidr is required");
            this.description = builder.description;
            this.groupId = builder.groupId;
        }

        @Override
        public final java.lang.String getCidr() {
            return this.cidr;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getGroupId() {
            return this.groupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cidr", om.valueToTree(this.getCidr()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getGroupId() != null) {
                data.set("groupId", om.valueToTree(this.getGroupId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.ClientVpnAuthorizationRuleOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClientVpnAuthorizationRuleOptions.Jsii$Proxy that = (ClientVpnAuthorizationRuleOptions.Jsii$Proxy) o;

            if (!cidr.equals(that.cidr)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.groupId != null ? this.groupId.equals(that.groupId) : that.groupId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cidr.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.groupId != null ? this.groupId.hashCode() : 0);
            return result;
        }
    }
}
