package software.amazon.awscdk.services.ec2;

/**
 * What size of instance to use.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseInstance sourceInstance;
 * DatabaseInstanceFromSnapshot.Builder.create(this, "Instance")
 *         .snapshotIdentifier("my-snapshot")
 *         .engine(DatabaseInstanceEngine.postgres(PostgresInstanceEngineProps.builder().version(PostgresEngineVersion.VER_12_3).build()))
 *         // optional, defaults to m5.large
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.LARGE))
 *         .vpc(vpc)
 *         .build();
 * DatabaseInstanceReadReplica.Builder.create(this, "ReadReplica")
 *         .sourceDatabaseInstance(sourceInstance)
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.LARGE))
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-14T20:30:49.524Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InstanceSize")
public enum InstanceSize {
    /**
     * Instance size NANO (nano).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NANO,
    /**
     * Instance size MICRO (micro).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MICRO,
    /**
     * Instance size SMALL (small).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SMALL,
    /**
     * Instance size MEDIUM (medium).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEDIUM,
    /**
     * Instance size LARGE (large).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LARGE,
    /**
     * Instance size XLARGE (xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE,
    /**
     * Instance size XLARGE2 (2xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE2,
    /**
     * Instance size XLARGE3 (3xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE3,
    /**
     * Instance size XLARGE4 (4xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE4,
    /**
     * Instance size XLARGE6 (6xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE6,
    /**
     * Instance size XLARGE8 (8xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE8,
    /**
     * Instance size XLARGE9 (9xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE9,
    /**
     * Instance size XLARGE10 (10xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE10,
    /**
     * Instance size XLARGE12 (12xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE12,
    /**
     * Instance size XLARGE16 (16xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE16,
    /**
     * Instance size XLARGE18 (18xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE18,
    /**
     * Instance size XLARGE24 (24xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE24,
    /**
     * Instance size XLARGE32 (32xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE32,
    /**
     * Instance size XLARGE48 (48xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE48,
    /**
     * Instance size XLARGE56 (56xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE56,
    /**
     * Instance size XLARGE56 (112xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE112,
    /**
     * Instance size METAL (metal).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    METAL,
}
