package software.amazon.awscdk.services.ec2;

/**
 * Properties of a LaunchTemplate.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserData bootHookConf = UserData.forLinux();
 * bootHookConf.addCommands("cloud-init-per once docker_options echo 'OPTIONS=\"${OPTIONS} --storage-opt dm.basesize=40G\"' &gt;&gt; /etc/sysconfig/docker");
 * UserData setupCommands = UserData.forLinux();
 * setupCommands.addCommands("sudo yum install awscli &amp;&amp; echo Packages installed らと &gt; /var/tmp/setup");
 * MultipartUserData multipartUserData = new MultipartUserData();
 * // The docker has to be configured at early stage, so content type is overridden to boothook
 * multipartUserData.addPart(MultipartBody.fromUserData(bootHookConf, "text/cloud-boothook; charset=\"us-ascii\""));
 * // Execute the rest of setup
 * multipartUserData.addPart(MultipartBody.fromUserData(setupCommands));
 * LaunchTemplate.Builder.create(this, "")
 *         .userData(multipartUserData)
 *         .blockDevices(List.of())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-14T20:30:49.540Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.LaunchTemplateProps")
@software.amazon.jsii.Jsii.Proxy(LaunchTemplateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LaunchTemplateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
     * <p>
     * Each instance that is launched has an associated root device volume,
     * either an Amazon EBS volume or an instance store volume.
     * You can use block device mappings to specify additional EBS volumes or
     * instance store volumes to attach to an instance when it is launched.
     * <p>
     * Default: - Uses the block device mapping of the AMI
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> getBlockDevices() {
        return null;
    }

    /**
     * CPU credit type for burstable EC2 instance types.
     * <p>
     * Default: - No credit type is specified in the Launch Template.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CpuCredits getCpuCredits() {
        return null;
    }

    /**
     * If set to true, then detailed monitoring will be enabled on instances created with this launch template.
     * <p>
     * Default: False - Detailed monitoring is disabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDetailedMonitoring() {
        return null;
    }

    /**
     * If you set this parameter to true, you cannot terminate the instances launched with this launch template using the Amazon EC2 console, CLI, or API;
     * <p>
     * otherwise, you can.
     * <p>
     * Default: - The API termination setting is not specified in the Launch Template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDisableApiTermination() {
        return null;
    }

    /**
     * Indicates whether the instances are optimized for Amazon EBS I/O.
     * <p>
     * This optimization provides dedicated throughput
     * to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization
     * isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
     * <p>
     * Default: - EBS optimization is not specified in the launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEbsOptimized() {
        return null;
    }

    /**
     * If you set this parameter to true, the instance is enabled for hibernation.
     * <p>
     * Default: - Hibernation configuration is not specified in the launch template; defaulting to false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getHibernationConfigured() {
        return null;
    }

    /**
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
     * <p>
     * Default: - Shutdown behavior is not specified in the launch template; defaults to STOP.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior getInstanceInitiatedShutdownBehavior() {
        return null;
    }

    /**
     * Type of instance to launch.
     * <p>
     * Default: - This Launch Template does not specify a default Instance Type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
        return null;
    }

    /**
     * Name of SSH keypair to grant access to instance.
     * <p>
     * Default: - No SSH access will be possible.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyName() {
        return null;
    }

    /**
     * Name for this launch template.
     * <p>
     * Default: Automatically generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateName() {
        return null;
    }

    /**
     * The AMI that will be used by instances.
     * <p>
     * Default: - This Launch Template does not specify a default AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IMachineImage getMachineImage() {
        return null;
    }

    /**
     * If this parameter is set to true, the instance is enabled for AWS Nitro Enclaves;
     * <p>
     * otherwise, it is not enabled for AWS Nitro Enclaves.
     * <p>
     * Default: - Enablement of Nitro enclaves is not specified in the launch template; defaulting to false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getNitroEnclaveEnabled() {
        return null;
    }

    /**
     * Whether IMDSv2 should be required on launched instances.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRequireImdsv2() {
        return null;
    }

    /**
     * An IAM role to associate with the instance profile that is used by instances.
     * <p>
     * The role must be assumable by the service principal <code>ec2.amazonaws.com</code>:
     * <p>
     * Default: - No new role is created.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * Role role = Role.Builder.create(this, "MyRole")
     *         .assumedBy(new ServicePrincipal("ec2.amazonaws.com"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * Security group to assign to instances created with the launch template.
     * <p>
     * Default: No security group is assigned.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * If this property is defined, then the Launch Template's InstanceMarketOptions will be set to use Spot instances, and the options for the Spot instances will be as defined.
     * <p>
     * Default: - Instance launched with this template will not be spot instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.LaunchTemplateSpotOptions getSpotOptions() {
        return null;
    }

    /**
     * The AMI that will be used by instances.
     * <p>
     * Default: - This Launch Template creates a UserData based on the type of provided
     * machineImage; no UserData is created if a machineImage is not provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.UserData getUserData() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LaunchTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LaunchTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LaunchTemplateProps> {
        java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> blockDevices;
        software.amazon.awscdk.services.ec2.CpuCredits cpuCredits;
        java.lang.Boolean detailedMonitoring;
        java.lang.Boolean disableApiTermination;
        java.lang.Boolean ebsOptimized;
        java.lang.Boolean hibernationConfigured;
        software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior instanceInitiatedShutdownBehavior;
        software.amazon.awscdk.services.ec2.InstanceType instanceType;
        java.lang.String keyName;
        java.lang.String launchTemplateName;
        software.amazon.awscdk.services.ec2.IMachineImage machineImage;
        java.lang.Boolean nitroEnclaveEnabled;
        java.lang.Boolean requireImdsv2;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        software.amazon.awscdk.services.ec2.LaunchTemplateSpotOptions spotOptions;
        software.amazon.awscdk.services.ec2.UserData userData;

        /**
         * Sets the value of {@link LaunchTemplateProps#getBlockDevices}
         * @param blockDevices Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
         *                     Each instance that is launched has an associated root device volume,
         *                     either an Amazon EBS volume or an instance store volume.
         *                     You can use block device mappings to specify additional EBS volumes or
         *                     instance store volumes to attach to an instance when it is launched.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder blockDevices(java.util.List<? extends software.amazon.awscdk.services.ec2.BlockDevice> blockDevices) {
            this.blockDevices = (java.util.List<software.amazon.awscdk.services.ec2.BlockDevice>)blockDevices;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getCpuCredits}
         * @param cpuCredits CPU credit type for burstable EC2 instance types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuCredits(software.amazon.awscdk.services.ec2.CpuCredits cpuCredits) {
            this.cpuCredits = cpuCredits;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getDetailedMonitoring}
         * @param detailedMonitoring If set to true, then detailed monitoring will be enabled on instances created with this launch template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detailedMonitoring(java.lang.Boolean detailedMonitoring) {
            this.detailedMonitoring = detailedMonitoring;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getDisableApiTermination}
         * @param disableApiTermination If you set this parameter to true, you cannot terminate the instances launched with this launch template using the Amazon EC2 console, CLI, or API;.
         *                              otherwise, you can.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableApiTermination(java.lang.Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getEbsOptimized}
         * @param ebsOptimized Indicates whether the instances are optimized for Amazon EBS I/O.
         *                     This optimization provides dedicated throughput
         *                     to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization
         *                     isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getHibernationConfigured}
         * @param hibernationConfigured If you set this parameter to true, the instance is enabled for hibernation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hibernationConfigured(java.lang.Boolean hibernationConfigured) {
            this.hibernationConfigured = hibernationConfigured;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getInstanceInitiatedShutdownBehavior}
         * @param instanceInitiatedShutdownBehavior Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceInitiatedShutdownBehavior(software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getInstanceType}
         * @param instanceType Type of instance to launch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getKeyName}
         * @param keyName Name of SSH keypair to grant access to instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getLaunchTemplateName}
         * @param launchTemplateName Name for this launch template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateName(java.lang.String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getMachineImage}
         * @param machineImage The AMI that will be used by instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImage(software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.machineImage = machineImage;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getNitroEnclaveEnabled}
         * @param nitroEnclaveEnabled If this parameter is set to true, the instance is enabled for AWS Nitro Enclaves;.
         *                            otherwise, it is not enabled for AWS Nitro Enclaves.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nitroEnclaveEnabled(java.lang.Boolean nitroEnclaveEnabled) {
            this.nitroEnclaveEnabled = nitroEnclaveEnabled;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getRequireImdsv2}
         * @param requireImdsv2 Whether IMDSv2 should be required on launched instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireImdsv2(java.lang.Boolean requireImdsv2) {
            this.requireImdsv2 = requireImdsv2;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getRole}
         * @param role An IAM role to associate with the instance profile that is used by instances.
         *             The role must be assumable by the service principal <code>ec2.amazonaws.com</code>:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getSecurityGroup}
         * @param securityGroup Security group to assign to instances created with the launch template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getSpotOptions}
         * @param spotOptions If this property is defined, then the Launch Template's InstanceMarketOptions will be set to use Spot instances, and the options for the Spot instances will be as defined.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotOptions(software.amazon.awscdk.services.ec2.LaunchTemplateSpotOptions spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateProps#getUserData}
         * @param userData The AMI that will be used by instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(software.amazon.awscdk.services.ec2.UserData userData) {
            this.userData = userData;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LaunchTemplateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LaunchTemplateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LaunchTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateProps {
        private final java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> blockDevices;
        private final software.amazon.awscdk.services.ec2.CpuCredits cpuCredits;
        private final java.lang.Boolean detailedMonitoring;
        private final java.lang.Boolean disableApiTermination;
        private final java.lang.Boolean ebsOptimized;
        private final java.lang.Boolean hibernationConfigured;
        private final software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior instanceInitiatedShutdownBehavior;
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final java.lang.String keyName;
        private final java.lang.String launchTemplateName;
        private final software.amazon.awscdk.services.ec2.IMachineImage machineImage;
        private final java.lang.Boolean nitroEnclaveEnabled;
        private final java.lang.Boolean requireImdsv2;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final software.amazon.awscdk.services.ec2.LaunchTemplateSpotOptions spotOptions;
        private final software.amazon.awscdk.services.ec2.UserData userData;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.blockDevices = software.amazon.jsii.Kernel.get(this, "blockDevices", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.BlockDevice.class)));
            this.cpuCredits = software.amazon.jsii.Kernel.get(this, "cpuCredits", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.CpuCredits.class));
            this.detailedMonitoring = software.amazon.jsii.Kernel.get(this, "detailedMonitoring", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.disableApiTermination = software.amazon.jsii.Kernel.get(this, "disableApiTermination", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ebsOptimized = software.amazon.jsii.Kernel.get(this, "ebsOptimized", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.hibernationConfigured = software.amazon.jsii.Kernel.get(this, "hibernationConfigured", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.instanceInitiatedShutdownBehavior = software.amazon.jsii.Kernel.get(this, "instanceInitiatedShutdownBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.launchTemplateName = software.amazon.jsii.Kernel.get(this, "launchTemplateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.machineImage = software.amazon.jsii.Kernel.get(this, "machineImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class));
            this.nitroEnclaveEnabled = software.amazon.jsii.Kernel.get(this, "nitroEnclaveEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.requireImdsv2 = software.amazon.jsii.Kernel.get(this, "requireImdsv2", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.spotOptions = software.amazon.jsii.Kernel.get(this, "spotOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LaunchTemplateSpotOptions.class));
            this.userData = software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.UserData.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.blockDevices = (java.util.List<software.amazon.awscdk.services.ec2.BlockDevice>)builder.blockDevices;
            this.cpuCredits = builder.cpuCredits;
            this.detailedMonitoring = builder.detailedMonitoring;
            this.disableApiTermination = builder.disableApiTermination;
            this.ebsOptimized = builder.ebsOptimized;
            this.hibernationConfigured = builder.hibernationConfigured;
            this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
            this.instanceType = builder.instanceType;
            this.keyName = builder.keyName;
            this.launchTemplateName = builder.launchTemplateName;
            this.machineImage = builder.machineImage;
            this.nitroEnclaveEnabled = builder.nitroEnclaveEnabled;
            this.requireImdsv2 = builder.requireImdsv2;
            this.role = builder.role;
            this.securityGroup = builder.securityGroup;
            this.spotOptions = builder.spotOptions;
            this.userData = builder.userData;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> getBlockDevices() {
            return this.blockDevices;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.CpuCredits getCpuCredits() {
            return this.cpuCredits;
        }

        @Override
        public final java.lang.Boolean getDetailedMonitoring() {
            return this.detailedMonitoring;
        }

        @Override
        public final java.lang.Boolean getDisableApiTermination() {
            return this.disableApiTermination;
        }

        @Override
        public final java.lang.Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final java.lang.Boolean getHibernationConfigured() {
            return this.hibernationConfigured;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        public final java.lang.String getLaunchTemplateName() {
            return this.launchTemplateName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IMachineImage getMachineImage() {
            return this.machineImage;
        }

        @Override
        public final java.lang.Boolean getNitroEnclaveEnabled() {
            return this.nitroEnclaveEnabled;
        }

        @Override
        public final java.lang.Boolean getRequireImdsv2() {
            return this.requireImdsv2;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.LaunchTemplateSpotOptions getSpotOptions() {
            return this.spotOptions;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.UserData getUserData() {
            return this.userData;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBlockDevices() != null) {
                data.set("blockDevices", om.valueToTree(this.getBlockDevices()));
            }
            if (this.getCpuCredits() != null) {
                data.set("cpuCredits", om.valueToTree(this.getCpuCredits()));
            }
            if (this.getDetailedMonitoring() != null) {
                data.set("detailedMonitoring", om.valueToTree(this.getDetailedMonitoring()));
            }
            if (this.getDisableApiTermination() != null) {
                data.set("disableApiTermination", om.valueToTree(this.getDisableApiTermination()));
            }
            if (this.getEbsOptimized() != null) {
                data.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
            }
            if (this.getHibernationConfigured() != null) {
                data.set("hibernationConfigured", om.valueToTree(this.getHibernationConfigured()));
            }
            if (this.getInstanceInitiatedShutdownBehavior() != null) {
                data.set("instanceInitiatedShutdownBehavior", om.valueToTree(this.getInstanceInitiatedShutdownBehavior()));
            }
            if (this.getInstanceType() != null) {
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
            }
            if (this.getKeyName() != null) {
                data.set("keyName", om.valueToTree(this.getKeyName()));
            }
            if (this.getLaunchTemplateName() != null) {
                data.set("launchTemplateName", om.valueToTree(this.getLaunchTemplateName()));
            }
            if (this.getMachineImage() != null) {
                data.set("machineImage", om.valueToTree(this.getMachineImage()));
            }
            if (this.getNitroEnclaveEnabled() != null) {
                data.set("nitroEnclaveEnabled", om.valueToTree(this.getNitroEnclaveEnabled()));
            }
            if (this.getRequireImdsv2() != null) {
                data.set("requireImdsv2", om.valueToTree(this.getRequireImdsv2()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getSpotOptions() != null) {
                data.set("spotOptions", om.valueToTree(this.getSpotOptions()));
            }
            if (this.getUserData() != null) {
                data.set("userData", om.valueToTree(this.getUserData()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.LaunchTemplateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LaunchTemplateProps.Jsii$Proxy that = (LaunchTemplateProps.Jsii$Proxy) o;

            if (this.blockDevices != null ? !this.blockDevices.equals(that.blockDevices) : that.blockDevices != null) return false;
            if (this.cpuCredits != null ? !this.cpuCredits.equals(that.cpuCredits) : that.cpuCredits != null) return false;
            if (this.detailedMonitoring != null ? !this.detailedMonitoring.equals(that.detailedMonitoring) : that.detailedMonitoring != null) return false;
            if (this.disableApiTermination != null ? !this.disableApiTermination.equals(that.disableApiTermination) : that.disableApiTermination != null) return false;
            if (this.ebsOptimized != null ? !this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized != null) return false;
            if (this.hibernationConfigured != null ? !this.hibernationConfigured.equals(that.hibernationConfigured) : that.hibernationConfigured != null) return false;
            if (this.instanceInitiatedShutdownBehavior != null ? !this.instanceInitiatedShutdownBehavior.equals(that.instanceInitiatedShutdownBehavior) : that.instanceInitiatedShutdownBehavior != null) return false;
            if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
            if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
            if (this.launchTemplateName != null ? !this.launchTemplateName.equals(that.launchTemplateName) : that.launchTemplateName != null) return false;
            if (this.machineImage != null ? !this.machineImage.equals(that.machineImage) : that.machineImage != null) return false;
            if (this.nitroEnclaveEnabled != null ? !this.nitroEnclaveEnabled.equals(that.nitroEnclaveEnabled) : that.nitroEnclaveEnabled != null) return false;
            if (this.requireImdsv2 != null ? !this.requireImdsv2.equals(that.requireImdsv2) : that.requireImdsv2 != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.spotOptions != null ? !this.spotOptions.equals(that.spotOptions) : that.spotOptions != null) return false;
            return this.userData != null ? this.userData.equals(that.userData) : that.userData == null;
        }

        @Override
        public final int hashCode() {
            int result = this.blockDevices != null ? this.blockDevices.hashCode() : 0;
            result = 31 * result + (this.cpuCredits != null ? this.cpuCredits.hashCode() : 0);
            result = 31 * result + (this.detailedMonitoring != null ? this.detailedMonitoring.hashCode() : 0);
            result = 31 * result + (this.disableApiTermination != null ? this.disableApiTermination.hashCode() : 0);
            result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
            result = 31 * result + (this.hibernationConfigured != null ? this.hibernationConfigured.hashCode() : 0);
            result = 31 * result + (this.instanceInitiatedShutdownBehavior != null ? this.instanceInitiatedShutdownBehavior.hashCode() : 0);
            result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
            result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
            result = 31 * result + (this.launchTemplateName != null ? this.launchTemplateName.hashCode() : 0);
            result = 31 * result + (this.machineImage != null ? this.machineImage.hashCode() : 0);
            result = 31 * result + (this.nitroEnclaveEnabled != null ? this.nitroEnclaveEnabled.hashCode() : 0);
            result = 31 * result + (this.requireImdsv2 != null ? this.requireImdsv2.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.spotOptions != null ? this.spotOptions.hashCode() : 0);
            result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
            return result;
        }
    }
}
