package software.amazon.awscdk.services.ec2;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * PublicSubnetProps publicSubnetProps = PublicSubnetProps.builder()
 *         .availabilityZone("availabilityZone")
 *         .cidrBlock("cidrBlock")
 *         .vpcId("vpcId")
 *         // the properties below are optional
 *         .mapPublicIpOnLaunch(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:41.396Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.PublicSubnetProps")
@software.amazon.jsii.Jsii.Proxy(PublicSubnetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PublicSubnetProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.SubnetProps {

    /**
     * @return a {@link Builder} of {@link PublicSubnetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PublicSubnetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PublicSubnetProps> {
        java.lang.String availabilityZone;
        java.lang.String cidrBlock;
        java.lang.String vpcId;
        java.lang.Boolean mapPublicIpOnLaunch;

        /**
         * Sets the value of {@link PublicSubnetProps#getAvailabilityZone}
         * @param availabilityZone The availability zone for the subnet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link PublicSubnetProps#getCidrBlock}
         * @param cidrBlock The CIDR notation for this subnet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrBlock(java.lang.String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link PublicSubnetProps#getVpcId}
         * @param vpcId The VPC which this subnet is part of. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link PublicSubnetProps#getMapPublicIpOnLaunch}
         * @param mapPublicIpOnLaunch Controls if a public IP is associated to an instance at launch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapPublicIpOnLaunch(java.lang.Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PublicSubnetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PublicSubnetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PublicSubnetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublicSubnetProps {
        private final java.lang.String availabilityZone;
        private final java.lang.String cidrBlock;
        private final java.lang.String vpcId;
        private final java.lang.Boolean mapPublicIpOnLaunch;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cidrBlock = software.amazon.jsii.Kernel.get(this, "cidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mapPublicIpOnLaunch = software.amazon.jsii.Kernel.get(this, "mapPublicIpOnLaunch", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZone = java.util.Objects.requireNonNull(builder.availabilityZone, "availabilityZone is required");
            this.cidrBlock = java.util.Objects.requireNonNull(builder.cidrBlock, "cidrBlock is required");
            this.vpcId = java.util.Objects.requireNonNull(builder.vpcId, "vpcId is required");
            this.mapPublicIpOnLaunch = builder.mapPublicIpOnLaunch;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final java.lang.Boolean getMapPublicIpOnLaunch() {
            return this.mapPublicIpOnLaunch;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            data.set("cidrBlock", om.valueToTree(this.getCidrBlock()));
            data.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getMapPublicIpOnLaunch() != null) {
                data.set("mapPublicIpOnLaunch", om.valueToTree(this.getMapPublicIpOnLaunch()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.PublicSubnetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PublicSubnetProps.Jsii$Proxy that = (PublicSubnetProps.Jsii$Proxy) o;

            if (!availabilityZone.equals(that.availabilityZone)) return false;
            if (!cidrBlock.equals(that.cidrBlock)) return false;
            if (!vpcId.equals(that.vpcId)) return false;
            return this.mapPublicIpOnLaunch != null ? this.mapPublicIpOnLaunch.equals(that.mapPublicIpOnLaunch) : that.mapPublicIpOnLaunch == null;
        }

        @Override
        public final int hashCode() {
            int result = this.availabilityZone.hashCode();
            result = 31 * result + (this.cidrBlock.hashCode());
            result = 31 * result + (this.vpcId.hashCode());
            result = 31 * result + (this.mapPublicIpOnLaunch != null ? this.mapPublicIpOnLaunch.hashCode() : 0);
            return result;
        }
    }
}
