package software.amazon.awscdk.services.ec2;

/**
 * Options for InitFile.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket myBucket;
 * InitServiceRestartHandle handle = new InitServiceRestartHandle();
 * CloudFormationInit.fromElements(InitFile.fromString("/etc/nginx/nginx.conf", "...", InitFileOptions.builder().serviceRestartHandles(List.of(handle)).build()), InitSource.fromS3Object("/var/www/html", myBucket, "html.zip", InitSourceOptions.builder().serviceRestartHandles(List.of(handle)).build()), InitService.enable("nginx", InitServiceOptions.builder()
 *         .serviceRestartHandle(handle)
 *         .build()));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-28T21:57:09.878Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InitFileOptions")
@software.amazon.jsii.Jsii.Proxy(InitFileOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InitFileOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * True if the inlined content (from a string or file) should be treated as base64 encoded.
     * <p>
     * Only applicable for inlined string and file content.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getBase64Encoded() {
        return null;
    }

    /**
     * The name of the owning group for this file.
     * <p>
     * Not supported for Windows systems.
     * <p>
     * Default: 'root'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGroup() {
        return null;
    }

    /**
     * A six-digit octal value representing the mode for this file.
     * <p>
     * Use the first three digits for symlinks and the last three digits for
     * setting permissions. To create a symlink, specify 120xxx, where xxx
     * defines the permissions of the target file. To specify permissions for a
     * file, use the last three digits, such as 000644.
     * <p>
     * Not supported for Windows systems.
     * <p>
     * Default: '000644'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
        return null;
    }

    /**
     * The name of the owning user for this file.
     * <p>
     * Not supported for Windows systems.
     * <p>
     * Default: 'root'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOwner() {
        return null;
    }

    /**
     * Restart the given service after this file has been written.
     * <p>
     * Default: - Do not restart any service
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> getServiceRestartHandles() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InitFileOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InitFileOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InitFileOptions> {
        java.lang.Boolean base64Encoded;
        java.lang.String group;
        java.lang.String mode;
        java.lang.String owner;
        java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles;

        /**
         * Sets the value of {@link InitFileOptions#getBase64Encoded}
         * @param base64Encoded True if the inlined content (from a string or file) should be treated as base64 encoded.
         *                      Only applicable for inlined string and file content.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder base64Encoded(java.lang.Boolean base64Encoded) {
            this.base64Encoded = base64Encoded;
            return this;
        }

        /**
         * Sets the value of {@link InitFileOptions#getGroup}
         * @param group The name of the owning group for this file.
         *              Not supported for Windows systems.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder group(java.lang.String group) {
            this.group = group;
            return this;
        }

        /**
         * Sets the value of {@link InitFileOptions#getMode}
         * @param mode A six-digit octal value representing the mode for this file.
         *             Use the first three digits for symlinks and the last three digits for
         *             setting permissions. To create a symlink, specify 120xxx, where xxx
         *             defines the permissions of the target file. To specify permissions for a
         *             file, use the last three digits, such as 000644.
         *             <p>
         *             Not supported for Windows systems.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mode(java.lang.String mode) {
            this.mode = mode;
            return this;
        }

        /**
         * Sets the value of {@link InitFileOptions#getOwner}
         * @param owner The name of the owning user for this file.
         *              Not supported for Windows systems.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder owner(java.lang.String owner) {
            this.owner = owner;
            return this;
        }

        /**
         * Sets the value of {@link InitFileOptions#getServiceRestartHandles}
         * @param serviceRestartHandles Restart the given service after this file has been written.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder serviceRestartHandles(java.util.List<? extends software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles) {
            this.serviceRestartHandles = (java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle>)serviceRestartHandles;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InitFileOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InitFileOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InitFileOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InitFileOptions {
        private final java.lang.Boolean base64Encoded;
        private final java.lang.String group;
        private final java.lang.String mode;
        private final java.lang.String owner;
        private final java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.base64Encoded = software.amazon.jsii.Kernel.get(this, "base64Encoded", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.group = software.amazon.jsii.Kernel.get(this, "group", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.owner = software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceRestartHandles = software.amazon.jsii.Kernel.get(this, "serviceRestartHandles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitServiceRestartHandle.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.base64Encoded = builder.base64Encoded;
            this.group = builder.group;
            this.mode = builder.mode;
            this.owner = builder.owner;
            this.serviceRestartHandles = (java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle>)builder.serviceRestartHandles;
        }

        @Override
        public final java.lang.Boolean getBase64Encoded() {
            return this.base64Encoded;
        }

        @Override
        public final java.lang.String getGroup() {
            return this.group;
        }

        @Override
        public final java.lang.String getMode() {
            return this.mode;
        }

        @Override
        public final java.lang.String getOwner() {
            return this.owner;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> getServiceRestartHandles() {
            return this.serviceRestartHandles;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBase64Encoded() != null) {
                data.set("base64Encoded", om.valueToTree(this.getBase64Encoded()));
            }
            if (this.getGroup() != null) {
                data.set("group", om.valueToTree(this.getGroup()));
            }
            if (this.getMode() != null) {
                data.set("mode", om.valueToTree(this.getMode()));
            }
            if (this.getOwner() != null) {
                data.set("owner", om.valueToTree(this.getOwner()));
            }
            if (this.getServiceRestartHandles() != null) {
                data.set("serviceRestartHandles", om.valueToTree(this.getServiceRestartHandles()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.InitFileOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InitFileOptions.Jsii$Proxy that = (InitFileOptions.Jsii$Proxy) o;

            if (this.base64Encoded != null ? !this.base64Encoded.equals(that.base64Encoded) : that.base64Encoded != null) return false;
            if (this.group != null ? !this.group.equals(that.group) : that.group != null) return false;
            if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
            if (this.owner != null ? !this.owner.equals(that.owner) : that.owner != null) return false;
            return this.serviceRestartHandles != null ? this.serviceRestartHandles.equals(that.serviceRestartHandles) : that.serviceRestartHandles == null;
        }

        @Override
        public final int hashCode() {
            int result = this.base64Encoded != null ? this.base64Encoded.hashCode() : 0;
            result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
            result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
            result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
            result = 31 * result + (this.serviceRestartHandles != null ? this.serviceRestartHandles.hashCode() : 0);
            return result;
        }
    }
}
