package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::FlowLog`.
 * <p>
 * Specifies a VPC flow log that captures IP traffic for a specified network interface, subnet, or VPC. To view the log data, use Amazon CloudWatch Logs (CloudWatch Logs) to help troubleshoot connection issues. For example, you can use a flow log to investigate why certain traffic isn't reaching an instance, which can help you diagnose overly restrictive security group rules. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html">VPC Flow Logs</a> in the <em>Amazon VPC User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * Object destinationOptions;
 * CfnFlowLog cfnFlowLog = CfnFlowLog.Builder.create(this, "MyCfnFlowLog")
 *         .resourceId("resourceId")
 *         .resourceType("resourceType")
 *         // the properties below are optional
 *         .deliverLogsPermissionArn("deliverLogsPermissionArn")
 *         .destinationOptions(destinationOptions)
 *         .logDestination("logDestination")
 *         .logDestinationType("logDestinationType")
 *         .logFormat("logFormat")
 *         .logGroupName("logGroupName")
 *         .maxAggregationInterval(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .trafficType("trafficType")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-03T16:22:32.718Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnFlowLog")
public class CfnFlowLog extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnFlowLog(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFlowLog(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnFlowLog.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::FlowLog`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFlowLog(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnFlowLogProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the flow log.
     * <p>
     * For example, <code>fl-123456abc123abc1</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags to apply to the flow logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The destination options. The following options are supported:.
     * <p>
     * <ul>
     * <li><code>FileFormat</code> - The format for the flow log ( <code>plain-text</code> | <code>parquet</code> ). The default is <code>plain-text</code> .</li>
     * <li><code>HiveCompatiblePartitions</code> - Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3 ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
     * <li><code>PerHourPartition</code> - Indicates whether to partition the flow log per hour ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDestinationOptions() {
        return software.amazon.jsii.Kernel.get(this, "destinationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The destination options. The following options are supported:.
     * <p>
     * <ul>
     * <li><code>FileFormat</code> - The format for the flow log ( <code>plain-text</code> | <code>parquet</code> ). The default is <code>plain-text</code> .</li>
     * <li><code>HiveCompatiblePartitions</code> - Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3 ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
     * <li><code>PerHourPartition</code> - Indicates whether to partition the flow log per hour ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinationOptions(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "destinationOptions", java.util.Objects.requireNonNull(value, "destinationOptions is required"));
    }

    /**
     * The ID of the resource to monitor.
     * <p>
     * For example, if the resource type is <code>VPC</code> , specify the ID of the VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceId() {
        return software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the resource to monitor.
     * <p>
     * For example, if the resource type is <code>VPC</code> , specify the ID of the VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceId", java.util.Objects.requireNonNull(value, "resourceId is required"));
    }

    /**
     * The type of resource to monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceType() {
        return software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of resource to monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceType", java.util.Objects.requireNonNull(value, "resourceType is required"));
    }

    /**
     * The ARN of the IAM role that allows Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.
     * <p>
     * This parameter is required if the destination type is <code>cloud-watch-logs</code> and unsupported otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeliverLogsPermissionArn() {
        return software.amazon.jsii.Kernel.get(this, "deliverLogsPermissionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the IAM role that allows Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.
     * <p>
     * This parameter is required if the destination type is <code>cloud-watch-logs</code> and unsupported otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliverLogsPermissionArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deliverLogsPermissionArn", value);
    }

    /**
     * The destination for the flow log data. The meaning of this parameter depends on the destination type.
     * <p>
     * <ul>
     * <li>If the destination type is <code>cloud-watch-logs</code> , specify the ARN of a CloudWatch Logs log group. For example:</li>
     * </ul>
     * <p>
     * arn:aws:logs: <em>region</em> : <em>account_id</em> :log-group: <em>my_group</em>
     * <p>
     * Alternatively, use the <code>LogGroupName</code> parameter.
     * <p>
     * <ul>
     * <li>If the destination type is <code>s3</code> , specify the ARN of an S3 bucket. For example:</li>
     * </ul>
     * <p>
     * arn:aws:s3::: <em>my_bucket</em> / <em>my_subfolder</em> /
     * <p>
     * The subfolder is optional. Note that you can't use <code>AWSLogs</code> as a subfolder name.
     * <p>
     * <ul>
     * <li>If the destination type is <code>kinesis-data-firehose</code> , specify the ARN of a Kinesis Data Firehose delivery stream. For example:</li>
     * </ul>
     * <p>
     * arn:aws:firehose: <em>region</em> : <em>account_id</em> :deliverystream: <em>my_stream</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLogDestination() {
        return software.amazon.jsii.Kernel.get(this, "logDestination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The destination for the flow log data. The meaning of this parameter depends on the destination type.
     * <p>
     * <ul>
     * <li>If the destination type is <code>cloud-watch-logs</code> , specify the ARN of a CloudWatch Logs log group. For example:</li>
     * </ul>
     * <p>
     * arn:aws:logs: <em>region</em> : <em>account_id</em> :log-group: <em>my_group</em>
     * <p>
     * Alternatively, use the <code>LogGroupName</code> parameter.
     * <p>
     * <ul>
     * <li>If the destination type is <code>s3</code> , specify the ARN of an S3 bucket. For example:</li>
     * </ul>
     * <p>
     * arn:aws:s3::: <em>my_bucket</em> / <em>my_subfolder</em> /
     * <p>
     * The subfolder is optional. Note that you can't use <code>AWSLogs</code> as a subfolder name.
     * <p>
     * <ul>
     * <li>If the destination type is <code>kinesis-data-firehose</code> , specify the ARN of a Kinesis Data Firehose delivery stream. For example:</li>
     * </ul>
     * <p>
     * arn:aws:firehose: <em>region</em> : <em>account_id</em> :deliverystream: <em>my_stream</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogDestination(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "logDestination", value);
    }

    /**
     * The type of destination for the flow log data.
     * <p>
     * Default: <code>cloud-watch-logs</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLogDestinationType() {
        return software.amazon.jsii.Kernel.get(this, "logDestinationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of destination for the flow log data.
     * <p>
     * Default: <code>cloud-watch-logs</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogDestinationType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "logDestinationType", value);
    }

    /**
     * The fields to include in the flow log record, in the order in which they should appear.
     * <p>
     * If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must include at least one field. For more information about the available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records</a> in the <em>Amazon VPC User Guide</em> or <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-flow-logs.html#flow-log-records">Transit Gateway Flow Log records</a> in the <em>AWS Transit Gateway Guide</em> .
     * <p>
     * Specify the fields using the <code>${field-id}</code> format, separated by spaces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLogFormat() {
        return software.amazon.jsii.Kernel.get(this, "logFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The fields to include in the flow log record, in the order in which they should appear.
     * <p>
     * If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must include at least one field. For more information about the available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records</a> in the <em>Amazon VPC User Guide</em> or <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-flow-logs.html#flow-log-records">Transit Gateway Flow Log records</a> in the <em>AWS Transit Gateway Guide</em> .
     * <p>
     * Specify the fields using the <code>${field-id}</code> format, separated by spaces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogFormat(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "logFormat", value);
    }

    /**
     * The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.
     * <p>
     * This parameter is valid only if the destination type is <code>cloud-watch-logs</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLogGroupName() {
        return software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.
     * <p>
     * This parameter is valid only if the destination type is <code>cloud-watch-logs</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "logGroupName", value);
    }

    /**
     * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
     * <p>
     * The possible values are 60 seconds (1 minute) or 600 seconds (10 minutes). This parameter must be 60 seconds for transit gateway resource types.
     * <p>
     * When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instance</a> , the aggregation interval is always 60 seconds or less, regardless of the value that you specify.
     * <p>
     * Default: 600
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxAggregationInterval() {
        return software.amazon.jsii.Kernel.get(this, "maxAggregationInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
     * <p>
     * The possible values are 60 seconds (1 minute) or 600 seconds (10 minutes). This parameter must be 60 seconds for transit gateway resource types.
     * <p>
     * When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instance</a> , the aggregation interval is always 60 seconds or less, regardless of the value that you specify.
     * <p>
     * Default: 600
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxAggregationInterval(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxAggregationInterval", value);
    }

    /**
     * The type of traffic to monitor (accepted traffic, rejected traffic, or all traffic).
     * <p>
     * This parameter is not supported for transit gateway resource types. It is required for the other resource types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTrafficType() {
        return software.amazon.jsii.Kernel.get(this, "trafficType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of traffic to monitor (accepted traffic, rejected traffic, or all traffic).
     * <p>
     * This parameter is not supported for transit gateway resource types. It is required for the other resource types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrafficType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "trafficType", value);
    }
    /**
     * Describes the destination options for a flow log.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * DestinationOptionsProperty destinationOptionsProperty = DestinationOptionsProperty.builder()
     *         .fileFormat("fileFormat")
     *         .hiveCompatiblePartitions(false)
     *         .perHourPartition(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnFlowLog.DestinationOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The format for the flow log.
         * <p>
         * The default is <code>plain-text</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFileFormat();

        /**
         * `CfnFlowLog.DestinationOptionsProperty.HiveCompatiblePartitions`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getHiveCompatiblePartitions();

        /**
         * Indicates whether to partition the flow log per hour.
         * <p>
         * This reduces the cost and response time for queries. The default is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPerHourPartition();

        /**
         * @return a {@link Builder} of {@link DestinationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationOptionsProperty> {
            java.lang.String fileFormat;
            java.lang.Object hiveCompatiblePartitions;
            java.lang.Object perHourPartition;

            /**
             * Sets the value of {@link DestinationOptionsProperty#getFileFormat}
             * @param fileFormat The format for the flow log. This parameter is required.
             *                   The default is <code>plain-text</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileFormat(java.lang.String fileFormat) {
                this.fileFormat = fileFormat;
                return this;
            }

            /**
             * Sets the value of {@link DestinationOptionsProperty#getHiveCompatiblePartitions}
             * @param hiveCompatiblePartitions `CfnFlowLog.DestinationOptionsProperty.HiveCompatiblePartitions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hiveCompatiblePartitions(java.lang.Boolean hiveCompatiblePartitions) {
                this.hiveCompatiblePartitions = hiveCompatiblePartitions;
                return this;
            }

            /**
             * Sets the value of {@link DestinationOptionsProperty#getHiveCompatiblePartitions}
             * @param hiveCompatiblePartitions `CfnFlowLog.DestinationOptionsProperty.HiveCompatiblePartitions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hiveCompatiblePartitions(software.amazon.awscdk.core.IResolvable hiveCompatiblePartitions) {
                this.hiveCompatiblePartitions = hiveCompatiblePartitions;
                return this;
            }

            /**
             * Sets the value of {@link DestinationOptionsProperty#getPerHourPartition}
             * @param perHourPartition Indicates whether to partition the flow log per hour. This parameter is required.
             *                         This reduces the cost and response time for queries. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder perHourPartition(java.lang.Boolean perHourPartition) {
                this.perHourPartition = perHourPartition;
                return this;
            }

            /**
             * Sets the value of {@link DestinationOptionsProperty#getPerHourPartition}
             * @param perHourPartition Indicates whether to partition the flow log per hour. This parameter is required.
             *                         This reduces the cost and response time for queries. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder perHourPartition(software.amazon.awscdk.core.IResolvable perHourPartition) {
                this.perHourPartition = perHourPartition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationOptionsProperty {
            private final java.lang.String fileFormat;
            private final java.lang.Object hiveCompatiblePartitions;
            private final java.lang.Object perHourPartition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fileFormat = software.amazon.jsii.Kernel.get(this, "fileFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hiveCompatiblePartitions = software.amazon.jsii.Kernel.get(this, "hiveCompatiblePartitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.perHourPartition = software.amazon.jsii.Kernel.get(this, "perHourPartition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fileFormat = java.util.Objects.requireNonNull(builder.fileFormat, "fileFormat is required");
                this.hiveCompatiblePartitions = java.util.Objects.requireNonNull(builder.hiveCompatiblePartitions, "hiveCompatiblePartitions is required");
                this.perHourPartition = java.util.Objects.requireNonNull(builder.perHourPartition, "perHourPartition is required");
            }

            @Override
            public final java.lang.String getFileFormat() {
                return this.fileFormat;
            }

            @Override
            public final java.lang.Object getHiveCompatiblePartitions() {
                return this.hiveCompatiblePartitions;
            }

            @Override
            public final java.lang.Object getPerHourPartition() {
                return this.perHourPartition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fileFormat", om.valueToTree(this.getFileFormat()));
                data.set("hiveCompatiblePartitions", om.valueToTree(this.getHiveCompatiblePartitions()));
                data.set("perHourPartition", om.valueToTree(this.getPerHourPartition()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnFlowLog.DestinationOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationOptionsProperty.Jsii$Proxy that = (DestinationOptionsProperty.Jsii$Proxy) o;

                if (!fileFormat.equals(that.fileFormat)) return false;
                if (!hiveCompatiblePartitions.equals(that.hiveCompatiblePartitions)) return false;
                return this.perHourPartition.equals(that.perHourPartition);
            }

            @Override
            public final int hashCode() {
                int result = this.fileFormat.hashCode();
                result = 31 * result + (this.hiveCompatiblePartitions.hashCode());
                result = 31 * result + (this.perHourPartition.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnFlowLog}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnFlowLog> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnFlowLogProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnFlowLogProps.Builder();
        }

        /**
         * The ID of the resource to monitor.
         * <p>
         * For example, if the resource type is <code>VPC</code> , specify the ID of the VPC.
         * <p>
         * @return {@code this}
         * @param resourceId The ID of the resource to monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(final java.lang.String resourceId) {
            this.props.resourceId(resourceId);
            return this;
        }

        /**
         * The type of resource to monitor.
         * <p>
         * @return {@code this}
         * @param resourceType The type of resource to monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(final java.lang.String resourceType) {
            this.props.resourceType(resourceType);
            return this;
        }

        /**
         * The ARN of the IAM role that allows Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.
         * <p>
         * This parameter is required if the destination type is <code>cloud-watch-logs</code> and unsupported otherwise.
         * <p>
         * @return {@code this}
         * @param deliverLogsPermissionArn The ARN of the IAM role that allows Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliverLogsPermissionArn(final java.lang.String deliverLogsPermissionArn) {
            this.props.deliverLogsPermissionArn(deliverLogsPermissionArn);
            return this;
        }

        /**
         * The destination options. The following options are supported:.
         * <p>
         * <ul>
         * <li><code>FileFormat</code> - The format for the flow log ( <code>plain-text</code> | <code>parquet</code> ). The default is <code>plain-text</code> .</li>
         * <li><code>HiveCompatiblePartitions</code> - Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3 ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
         * <li><code>PerHourPartition</code> - Indicates whether to partition the flow log per hour ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param destinationOptions The destination options. The following options are supported:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationOptions(final java.lang.Object destinationOptions) {
            this.props.destinationOptions(destinationOptions);
            return this;
        }

        /**
         * The destination for the flow log data. The meaning of this parameter depends on the destination type.
         * <p>
         * <ul>
         * <li>If the destination type is <code>cloud-watch-logs</code> , specify the ARN of a CloudWatch Logs log group. For example:</li>
         * </ul>
         * <p>
         * arn:aws:logs: <em>region</em> : <em>account_id</em> :log-group: <em>my_group</em>
         * <p>
         * Alternatively, use the <code>LogGroupName</code> parameter.
         * <p>
         * <ul>
         * <li>If the destination type is <code>s3</code> , specify the ARN of an S3 bucket. For example:</li>
         * </ul>
         * <p>
         * arn:aws:s3::: <em>my_bucket</em> / <em>my_subfolder</em> /
         * <p>
         * The subfolder is optional. Note that you can't use <code>AWSLogs</code> as a subfolder name.
         * <p>
         * <ul>
         * <li>If the destination type is <code>kinesis-data-firehose</code> , specify the ARN of a Kinesis Data Firehose delivery stream. For example:</li>
         * </ul>
         * <p>
         * arn:aws:firehose: <em>region</em> : <em>account_id</em> :deliverystream: <em>my_stream</em>
         * <p>
         * @return {@code this}
         * @param logDestination The destination for the flow log data. The meaning of this parameter depends on the destination type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDestination(final java.lang.String logDestination) {
            this.props.logDestination(logDestination);
            return this;
        }

        /**
         * The type of destination for the flow log data.
         * <p>
         * Default: <code>cloud-watch-logs</code>
         * <p>
         * @return {@code this}
         * @param logDestinationType The type of destination for the flow log data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDestinationType(final java.lang.String logDestinationType) {
            this.props.logDestinationType(logDestinationType);
            return this;
        }

        /**
         * The fields to include in the flow log record, in the order in which they should appear.
         * <p>
         * If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must include at least one field. For more information about the available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records</a> in the <em>Amazon VPC User Guide</em> or <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-flow-logs.html#flow-log-records">Transit Gateway Flow Log records</a> in the <em>AWS Transit Gateway Guide</em> .
         * <p>
         * Specify the fields using the <code>${field-id}</code> format, separated by spaces.
         * <p>
         * @return {@code this}
         * @param logFormat The fields to include in the flow log record, in the order in which they should appear. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logFormat(final java.lang.String logFormat) {
            this.props.logFormat(logFormat);
            return this;
        }

        /**
         * The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.
         * <p>
         * This parameter is valid only if the destination type is <code>cloud-watch-logs</code> .
         * <p>
         * @return {@code this}
         * @param logGroupName The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(final java.lang.String logGroupName) {
            this.props.logGroupName(logGroupName);
            return this;
        }

        /**
         * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
         * <p>
         * The possible values are 60 seconds (1 minute) or 600 seconds (10 minutes). This parameter must be 60 seconds for transit gateway resource types.
         * <p>
         * When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instance</a> , the aggregation interval is always 60 seconds or less, regardless of the value that you specify.
         * <p>
         * Default: 600
         * <p>
         * @return {@code this}
         * @param maxAggregationInterval The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAggregationInterval(final java.lang.Number maxAggregationInterval) {
            this.props.maxAggregationInterval(maxAggregationInterval);
            return this;
        }

        /**
         * The tags to apply to the flow logs.
         * <p>
         * @return {@code this}
         * @param tags The tags to apply to the flow logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The type of traffic to monitor (accepted traffic, rejected traffic, or all traffic).
         * <p>
         * This parameter is not supported for transit gateway resource types. It is required for the other resource types.
         * <p>
         * @return {@code this}
         * @param trafficType The type of traffic to monitor (accepted traffic, rejected traffic, or all traffic). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficType(final java.lang.String trafficType) {
            this.props.trafficType(trafficType);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnFlowLog}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnFlowLog build() {
            return new software.amazon.awscdk.services.ec2.CfnFlowLog(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
