package software.amazon.awscdk.services.ec2;

/**
 * Aspect that applies IMDS configuration on EC2 Instance constructs.
 * <p>
 * This aspect configures IMDS on an EC2 instance by creating a Launch Template with the
 * IMDS configuration and associating that Launch Template with the instance. If an Instance
 * is already associated with a Launch Template, a warning will (optionally) be added to the
 * construct node and it will be skipped.
 * <p>
 * To cover Instances already associated with Launch Templates, use <code>LaunchTemplateImdsAspect</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * InstanceRequireImdsv2Aspect aspect = new InstanceRequireImdsv2Aspect();
 * Aspects.of(this).add(aspect);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-03T16:22:33.345Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InstanceRequireImdsv2Aspect")
public class InstanceRequireImdsv2Aspect extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.IAspect {

    protected InstanceRequireImdsv2Aspect(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InstanceRequireImdsv2Aspect(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InstanceRequireImdsv2Aspect(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceRequireImdsv2AspectProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InstanceRequireImdsv2Aspect() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * All aspects can visit an IConstruct.
     * <p>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void visit(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IConstruct node) {
        software.amazon.jsii.Kernel.call(this, "visit", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * Adds a warning annotation to a node, unless `suppressWarnings` is true.
     * <p>
     * @param node This parameter is required.
     * @param message This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void warn(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IConstruct node, final @org.jetbrains.annotations.NotNull java.lang.String message) {
        software.amazon.jsii.Kernel.call(this, "warn", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(node, "node is required"), java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getSuppressWarnings() {
        return software.amazon.jsii.Kernel.get(this, "suppressWarnings", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.InstanceRequireImdsv2Aspect}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.InstanceRequireImdsv2Aspect> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.ec2.InstanceRequireImdsv2AspectProps.Builder props;

        private Builder() {
        }

        /**
         * Whether warnings that would be raised when an Instance is associated with an existing Launch Template should be suppressed or not.
         * <p>
         * You can set this to <code>true</code> if <code>LaunchTemplateImdsAspect</code> is being used alongside this Aspect to
         * suppress false-positive warnings because any Launch Templates associated with Instances will still be covered.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param suppressLaunchTemplateWarning Whether warnings that would be raised when an Instance is associated with an existing Launch Template should be suppressed or not. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suppressLaunchTemplateWarning(final java.lang.Boolean suppressLaunchTemplateWarning) {
            this.props().suppressLaunchTemplateWarning(suppressLaunchTemplateWarning);
            return this;
        }

        /**
         * Whether warning annotations from this Aspect should be suppressed or not.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param suppressWarnings Whether warning annotations from this Aspect should be suppressed or not. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suppressWarnings(final java.lang.Boolean suppressWarnings) {
            this.props().suppressWarnings(suppressWarnings);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.InstanceRequireImdsv2Aspect}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.InstanceRequireImdsv2Aspect build() {
            return new software.amazon.awscdk.services.ec2.InstanceRequireImdsv2Aspect(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.InstanceRequireImdsv2AspectProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.InstanceRequireImdsv2AspectProps.Builder();
            }
            return this.props;
        }
    }
}
