package software.amazon.awscdk.services.ec2;

/**
 * A interface VPC endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InterfaceVpcEndpoint.Builder.create(this, "VPC Endpoint")
 *         .vpc(vpc)
 *         .service(new InterfaceVpcEndpointService("com.amazonaws.vpce.us-east-1.vpce-svc-uuddlrlrbastrtsvc", 443))
 *         // Choose which availability zones to place the VPC endpoint in, based on
 *         // available AZs
 *         .subnets(SubnetSelection.builder()
 *                 .availabilityZones(List.of("us-east-1a", "us-east-1c"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:43.833Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InterfaceVpcEndpoint")
public class InterfaceVpcEndpoint extends software.amazon.awscdk.services.ec2.VpcEndpoint implements software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint {

    protected InterfaceVpcEndpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InterfaceVpcEndpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InterfaceVpcEndpoint(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InterfaceVpcEndpointProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports an existing interface VPC endpoint.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint fromInterfaceVpcEndpointAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint.class, "fromInterfaceVpcEndpointAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Access to network connections.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * (deprecated) The identifier of the first security group associated with this interface VPC endpoint.
     * <p>
     * @deprecated use the `connections` object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull java.lang.String getSecurityGroupId() {
        return software.amazon.jsii.Kernel.get(this, "securityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time the interface VPC endpoint was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcEndpointCreationTimestamp() {
        return software.amazon.jsii.Kernel.get(this, "vpcEndpointCreationTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The DNS entries for the interface VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getVpcEndpointDnsEntries() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "vpcEndpointDnsEntries", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The interface VPC endpoint identifier.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcEndpointId() {
        return software.amazon.jsii.Kernel.get(this, "vpcEndpointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * One or more network interfaces for the interface VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getVpcEndpointNetworkInterfaceIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "vpcEndpointNetworkInterfaceIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.InterfaceVpcEndpointProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.InterfaceVpcEndpointProps.Builder();
        }

        /**
         * The service to use for this interface VPC endpoint.
         * <p>
         * @return {@code this}
         * @param service The service to use for this interface VPC endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService service) {
            this.props.service(service);
            return this;
        }

        /**
         * Limit to only those availability zones where the endpoint service can be created.
         * <p>
         * Setting this to 'true' requires a lookup to be performed at synthesis time. Account
         * and region must be set on the containing stack for this to work.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param lookupSupportedAzs Limit to only those availability zones where the endpoint service can be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupSupportedAzs(final java.lang.Boolean lookupSupportedAzs) {
            this.props.lookupSupportedAzs(lookupSupportedAzs);
            return this;
        }

        /**
         * Whether to automatically allow VPC traffic to the endpoint.
         * <p>
         * If enabled, all traffic to the endpoint from within the VPC will be
         * automatically allowed. This is done based on the VPC's CIDR range.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param open Whether to automatically allow VPC traffic to the endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder open(final java.lang.Boolean open) {
            this.props.open(open);
            return this;
        }

        /**
         * Whether to associate a private hosted zone with the specified VPC.
         * <p>
         * This
         * allows you to make requests to the service using its default DNS hostname.
         * <p>
         * Default: set by the instance of IInterfaceVpcEndpointService, or true if
         * not defined by the instance of IInterfaceVpcEndpointService
         * <p>
         * @return {@code this}
         * @param privateDnsEnabled Whether to associate a private hosted zone with the specified VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsEnabled(final java.lang.Boolean privateDnsEnabled) {
            this.props.privateDnsEnabled(privateDnsEnabled);
            return this;
        }

        /**
         * The security groups to associate with this interface VPC endpoint.
         * <p>
         * Default: - a new security group is created
         * <p>
         * @return {@code this}
         * @param securityGroups The security groups to associate with this interface VPC endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * The subnets in which to create an endpoint network interface.
         * <p>
         * At most one
         * per availability zone.
         * <p>
         * Default: - private subnets
         * <p>
         * @return {@code this}
         * @param subnets The subnets in which to create an endpoint network interface. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(final software.amazon.awscdk.services.ec2.SubnetSelection subnets) {
            this.props.subnets(subnets);
            return this;
        }

        /**
         * The VPC network in which the interface endpoint will be used.
         * <p>
         * @return {@code this}
         * @param vpc The VPC network in which the interface endpoint will be used. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint build() {
            return new software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
