package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnClientVpnAuthorizationRule`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnClientVpnAuthorizationRuleProps cfnClientVpnAuthorizationRuleProps = CfnClientVpnAuthorizationRuleProps.builder()
 *         .clientVpnEndpointId("clientVpnEndpointId")
 *         .targetNetworkCidr("targetNetworkCidr")
 *         // the properties below are optional
 *         .accessGroupId("accessGroupId")
 *         .authorizeAllGroups(false)
 *         .description("description")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.73.0 (build 6faeda3)", date = "2023-01-19T00:07:37.076Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnAuthorizationRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnClientVpnAuthorizationRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnClientVpnAuthorizationRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the Client VPN endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClientVpnEndpointId();

    /**
     * The IPv4 address range, in CIDR notation, of the network for which access is being authorized.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetNetworkCidr();

    /**
     * The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group.
     * <p>
     * Required if <code>AuthorizeAllGroups</code> is <code>false</code> or not specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccessGroupId() {
        return null;
    }

    /**
     * Indicates whether to grant access to all clients.
     * <p>
     * Specify <code>true</code> to grant all clients who successfully establish a VPN connection access to the network. Must be set to <code>true</code> if <code>AccessGroupId</code> is not specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAuthorizeAllGroups() {
        return null;
    }

    /**
     * A brief description of the authorization rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnClientVpnAuthorizationRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClientVpnAuthorizationRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnClientVpnAuthorizationRuleProps> {
        java.lang.String clientVpnEndpointId;
        java.lang.String targetNetworkCidr;
        java.lang.String accessGroupId;
        java.lang.Object authorizeAllGroups;
        java.lang.String description;

        /**
         * Sets the value of {@link CfnClientVpnAuthorizationRuleProps#getClientVpnEndpointId}
         * @param clientVpnEndpointId The ID of the Client VPN endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientVpnEndpointId(java.lang.String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnAuthorizationRuleProps#getTargetNetworkCidr}
         * @param targetNetworkCidr The IPv4 address range, in CIDR notation, of the network for which access is being authorized. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetNetworkCidr(java.lang.String targetNetworkCidr) {
            this.targetNetworkCidr = targetNetworkCidr;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnAuthorizationRuleProps#getAccessGroupId}
         * @param accessGroupId The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group.
         *                      Required if <code>AuthorizeAllGroups</code> is <code>false</code> or not specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessGroupId(java.lang.String accessGroupId) {
            this.accessGroupId = accessGroupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnAuthorizationRuleProps#getAuthorizeAllGroups}
         * @param authorizeAllGroups Indicates whether to grant access to all clients.
         *                           Specify <code>true</code> to grant all clients who successfully establish a VPN connection access to the network. Must be set to <code>true</code> if <code>AccessGroupId</code> is not specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizeAllGroups(java.lang.Boolean authorizeAllGroups) {
            this.authorizeAllGroups = authorizeAllGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnAuthorizationRuleProps#getAuthorizeAllGroups}
         * @param authorizeAllGroups Indicates whether to grant access to all clients.
         *                           Specify <code>true</code> to grant all clients who successfully establish a VPN connection access to the network. Must be set to <code>true</code> if <code>AccessGroupId</code> is not specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizeAllGroups(software.amazon.awscdk.core.IResolvable authorizeAllGroups) {
            this.authorizeAllGroups = authorizeAllGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnAuthorizationRuleProps#getDescription}
         * @param description A brief description of the authorization rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClientVpnAuthorizationRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnClientVpnAuthorizationRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnClientVpnAuthorizationRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClientVpnAuthorizationRuleProps {
        private final java.lang.String clientVpnEndpointId;
        private final java.lang.String targetNetworkCidr;
        private final java.lang.String accessGroupId;
        private final java.lang.Object authorizeAllGroups;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clientVpnEndpointId = software.amazon.jsii.Kernel.get(this, "clientVpnEndpointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetNetworkCidr = software.amazon.jsii.Kernel.get(this, "targetNetworkCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessGroupId = software.amazon.jsii.Kernel.get(this, "accessGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizeAllGroups = software.amazon.jsii.Kernel.get(this, "authorizeAllGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientVpnEndpointId = java.util.Objects.requireNonNull(builder.clientVpnEndpointId, "clientVpnEndpointId is required");
            this.targetNetworkCidr = java.util.Objects.requireNonNull(builder.targetNetworkCidr, "targetNetworkCidr is required");
            this.accessGroupId = builder.accessGroupId;
            this.authorizeAllGroups = builder.authorizeAllGroups;
            this.description = builder.description;
        }

        @Override
        public final java.lang.String getClientVpnEndpointId() {
            return this.clientVpnEndpointId;
        }

        @Override
        public final java.lang.String getTargetNetworkCidr() {
            return this.targetNetworkCidr;
        }

        @Override
        public final java.lang.String getAccessGroupId() {
            return this.accessGroupId;
        }

        @Override
        public final java.lang.Object getAuthorizeAllGroups() {
            return this.authorizeAllGroups;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clientVpnEndpointId", om.valueToTree(this.getClientVpnEndpointId()));
            data.set("targetNetworkCidr", om.valueToTree(this.getTargetNetworkCidr()));
            if (this.getAccessGroupId() != null) {
                data.set("accessGroupId", om.valueToTree(this.getAccessGroupId()));
            }
            if (this.getAuthorizeAllGroups() != null) {
                data.set("authorizeAllGroups", om.valueToTree(this.getAuthorizeAllGroups()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnClientVpnAuthorizationRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClientVpnAuthorizationRuleProps.Jsii$Proxy that = (CfnClientVpnAuthorizationRuleProps.Jsii$Proxy) o;

            if (!clientVpnEndpointId.equals(that.clientVpnEndpointId)) return false;
            if (!targetNetworkCidr.equals(that.targetNetworkCidr)) return false;
            if (this.accessGroupId != null ? !this.accessGroupId.equals(that.accessGroupId) : that.accessGroupId != null) return false;
            if (this.authorizeAllGroups != null ? !this.authorizeAllGroups.equals(that.authorizeAllGroups) : that.authorizeAllGroups != null) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clientVpnEndpointId.hashCode();
            result = 31 * result + (this.targetNetworkCidr.hashCode());
            result = 31 * result + (this.accessGroupId != null ? this.accessGroupId.hashCode() : 0);
            result = 31 * result + (this.authorizeAllGroups != null ? this.authorizeAllGroups.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
