package software.amazon.awscdk.services.ec2;

/**
 * The type of resource to create the flow log for.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * LogGroup logGroup = new LogGroup(this, "MyCustomLogGroup");
 * Role role = Role.Builder.create(this, "MyCustomRole")
 *         .assumedBy(new ServicePrincipal("vpc-flow-logs.amazonaws.com"))
 *         .build();
 * FlowLog.Builder.create(this, "FlowLog")
 *         .resourceType(FlowLogResourceType.fromVpc(vpc))
 *         .destination(FlowLogDestination.toCloudWatchLogs(logGroup, role))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.73.0 (build 6faeda3)", date = "2023-01-19T00:07:37.749Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.FlowLogResourceType")
public abstract class FlowLogResourceType extends software.amazon.jsii.JsiiObject {

    protected FlowLogResourceType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FlowLogResourceType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected FlowLogResourceType() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * The Network Interface to attach the Flow Log to.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLogResourceType fromNetworkInterfaceId(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.FlowLogResourceType.class, "fromNetworkInterfaceId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLogResourceType.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * The subnet to attach the Flow Log to.
     * <p>
     * @param subnet This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLogResourceType fromSubnet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISubnet subnet) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.FlowLogResourceType.class, "fromSubnet", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLogResourceType.class), new Object[] { java.util.Objects.requireNonNull(subnet, "subnet is required") });
    }

    /**
     * The VPC to attach the Flow Log to.
     * <p>
     * @param vpc This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLogResourceType fromVpc(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.FlowLogResourceType.class, "fromVpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLogResourceType.class), new Object[] { java.util.Objects.requireNonNull(vpc, "vpc is required") });
    }

    /**
     * The Id of the resource that the flow log should be attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getResourceId();

    /**
     * The Id of the resource that the flow log should be attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract void setResourceId(final @org.jetbrains.annotations.NotNull java.lang.String value);

    /**
     * The type of resource to attach a flow log to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getResourceType();

    /**
     * The type of resource to attach a flow log to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract void setResourceType(final @org.jetbrains.annotations.NotNull java.lang.String value);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ec2.FlowLogResourceType {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The Id of the resource that the flow log should be attached to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getResourceId() {
            return software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The Id of the resource that the flow log should be attached to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final void setResourceId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
            software.amazon.jsii.Kernel.set(this, "resourceId", java.util.Objects.requireNonNull(value, "resourceId is required"));
        }

        /**
         * The type of resource to attach a flow log to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getResourceType() {
            return software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The type of resource to attach a flow log to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final void setResourceType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
            software.amazon.jsii.Kernel.set(this, "resourceType", java.util.Objects.requireNonNull(value, "resourceType is required"));
        }
    }
}
