package software.amazon.awscdk.services.ec2;

/**
 * Construct a Linux machine image from an AMI map.
 * 
 * <p>Linux images IDs are not published to SSM parameter store yet, so you'll have to
 * manually specify an AMI map.</p>
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.11 (build d4fd44f)", date = "2019-12-17T13:05:39.212Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.GenericLinuxImage")
public class GenericLinuxImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IMachineImage {

    protected GenericLinuxImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GenericLinuxImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param amiMap This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public GenericLinuxImage(final java.util.Map<java.lang.String, java.lang.String> amiMap, final software.amazon.awscdk.services.ec2.GenericLinuxImageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(amiMap, "amiMap is required"), props });
    }

    /**
     * @param amiMap This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public GenericLinuxImage(final java.util.Map<java.lang.String, java.lang.String> amiMap) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(amiMap, "amiMap is required") });
    }

    /**
     * Return the image to use in the given context.
     * 
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.ec2.MachineImageConfig getImage(final software.amazon.awscdk.core.Construct scope) {
        return this.jsiiCall("getImage", software.amazon.awscdk.services.ec2.MachineImageConfig.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.GenericLinuxImage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param amiMap This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.util.Map<java.lang.String, java.lang.String> amiMap) {
            return new Builder(amiMap);
        }

        private final java.util.Map<java.lang.String, java.lang.String> amiMap;
        private software.amazon.awscdk.services.ec2.GenericLinuxImageProps.Builder props;

        private Builder(final java.util.Map<java.lang.String, java.lang.String> amiMap) {
            this.amiMap = amiMap;
        }

        /**
         * Initial user data.
         * 
         * Default: - Empty UserData for Linux machines
         * 
         * @return {@code this}
         * @param userData Initial user data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final software.amazon.awscdk.services.ec2.UserData userData) {
            this.props().userData(userData);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.GenericLinuxImage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.ec2.GenericLinuxImage build() {
            return new software.amazon.awscdk.services.ec2.GenericLinuxImage(
                this.amiMap,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.GenericLinuxImageProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.GenericLinuxImageProps.Builder();
            }
            return this.props;
        }
    }
}
