package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::TransitGatewayMulticastDomain`.
 * <p>
 * Creates a multicast domain using the specified transit gateway.
 * <p>
 * The transit gateway must be in the available state before you create a domain.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * Object options;
 * CfnTransitGatewayMulticastDomain cfnTransitGatewayMulticastDomain = CfnTransitGatewayMulticastDomain.Builder.create(this, "MyCfnTransitGatewayMulticastDomain")
 *         .transitGatewayId("transitGatewayId")
 *         // the properties below are optional
 *         .options(options)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.73.0 (build 6faeda3)", date = "2023-01-31T18:36:53.158Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnTransitGatewayMulticastDomain")
public class CfnTransitGatewayMulticastDomain extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnTransitGatewayMulticastDomain(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTransitGatewayMulticastDomain(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnTransitGatewayMulticastDomain.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::TransitGatewayMulticastDomain`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTransitGatewayMulticastDomain(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnTransitGatewayMulticastDomainProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time the multicast domain was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of the multicast domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrState() {
        return software.amazon.jsii.Kernel.get(this, "attrState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the multicast domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTransitGatewayMulticastDomainArn() {
        return software.amazon.jsii.Kernel.get(this, "attrTransitGatewayMulticastDomainArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the multicast domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTransitGatewayMulticastDomainId() {
        return software.amazon.jsii.Kernel.get(this, "attrTransitGatewayMulticastDomainId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags for the transit gateway multicast domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The options for the transit gateway multicast domain.
     * <p>
     * <ul>
     * <li>AutoAcceptSharedAssociations (enable | disable)</li>
     * <li>Igmpv2Support (enable | disable)</li>
     * <li>StaticSourcesSupport (enable | disable)</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getOptions() {
        return software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The options for the transit gateway multicast domain.
     * <p>
     * <ul>
     * <li>AutoAcceptSharedAssociations (enable | disable)</li>
     * <li>Igmpv2Support (enable | disable)</li>
     * <li>StaticSourcesSupport (enable | disable)</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptions(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "options", java.util.Objects.requireNonNull(value, "options is required"));
    }

    /**
     * The ID of the transit gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTransitGatewayId() {
        return software.amazon.jsii.Kernel.get(this, "transitGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the transit gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransitGatewayId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "transitGatewayId", java.util.Objects.requireNonNull(value, "transitGatewayId is required"));
    }
    /**
     * The options for the transit gateway multicast domain.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * OptionsProperty optionsProperty = OptionsProperty.builder()
     *         .autoAcceptSharedAssociations("autoAcceptSharedAssociations")
     *         .igmpv2Support("igmpv2Support")
     *         .staticSourcesSupport("staticSourcesSupport")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnTransitGatewayMulticastDomain.OptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(OptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether to automatically accept cross-account subnet associations that are associated with the transit gateway multicast domain.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAutoAcceptSharedAssociations() {
            return null;
        }

        /**
         * Specify whether to enable Internet Group Management Protocol (IGMP) version 2 for the transit gateway multicast domain.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIgmpv2Support() {
            return null;
        }

        /**
         * Specify whether to enable support for statically configuring multicast group sources for a domain.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStaticSourcesSupport() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OptionsProperty> {
            java.lang.String autoAcceptSharedAssociations;
            java.lang.String igmpv2Support;
            java.lang.String staticSourcesSupport;

            /**
             * Sets the value of {@link OptionsProperty#getAutoAcceptSharedAssociations}
             * @param autoAcceptSharedAssociations Indicates whether to automatically accept cross-account subnet associations that are associated with the transit gateway multicast domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoAcceptSharedAssociations(java.lang.String autoAcceptSharedAssociations) {
                this.autoAcceptSharedAssociations = autoAcceptSharedAssociations;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getIgmpv2Support}
             * @param igmpv2Support Specify whether to enable Internet Group Management Protocol (IGMP) version 2 for the transit gateway multicast domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder igmpv2Support(java.lang.String igmpv2Support) {
                this.igmpv2Support = igmpv2Support;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getStaticSourcesSupport}
             * @param staticSourcesSupport Specify whether to enable support for statically configuring multicast group sources for a domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staticSourcesSupport(java.lang.String staticSourcesSupport) {
                this.staticSourcesSupport = staticSourcesSupport;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OptionsProperty {
            private final java.lang.String autoAcceptSharedAssociations;
            private final java.lang.String igmpv2Support;
            private final java.lang.String staticSourcesSupport;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoAcceptSharedAssociations = software.amazon.jsii.Kernel.get(this, "autoAcceptSharedAssociations", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.igmpv2Support = software.amazon.jsii.Kernel.get(this, "igmpv2Support", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.staticSourcesSupport = software.amazon.jsii.Kernel.get(this, "staticSourcesSupport", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoAcceptSharedAssociations = builder.autoAcceptSharedAssociations;
                this.igmpv2Support = builder.igmpv2Support;
                this.staticSourcesSupport = builder.staticSourcesSupport;
            }

            @Override
            public final java.lang.String getAutoAcceptSharedAssociations() {
                return this.autoAcceptSharedAssociations;
            }

            @Override
            public final java.lang.String getIgmpv2Support() {
                return this.igmpv2Support;
            }

            @Override
            public final java.lang.String getStaticSourcesSupport() {
                return this.staticSourcesSupport;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoAcceptSharedAssociations() != null) {
                    data.set("autoAcceptSharedAssociations", om.valueToTree(this.getAutoAcceptSharedAssociations()));
                }
                if (this.getIgmpv2Support() != null) {
                    data.set("igmpv2Support", om.valueToTree(this.getIgmpv2Support()));
                }
                if (this.getStaticSourcesSupport() != null) {
                    data.set("staticSourcesSupport", om.valueToTree(this.getStaticSourcesSupport()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnTransitGatewayMulticastDomain.OptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OptionsProperty.Jsii$Proxy that = (OptionsProperty.Jsii$Proxy) o;

                if (this.autoAcceptSharedAssociations != null ? !this.autoAcceptSharedAssociations.equals(that.autoAcceptSharedAssociations) : that.autoAcceptSharedAssociations != null) return false;
                if (this.igmpv2Support != null ? !this.igmpv2Support.equals(that.igmpv2Support) : that.igmpv2Support != null) return false;
                return this.staticSourcesSupport != null ? this.staticSourcesSupport.equals(that.staticSourcesSupport) : that.staticSourcesSupport == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoAcceptSharedAssociations != null ? this.autoAcceptSharedAssociations.hashCode() : 0;
                result = 31 * result + (this.igmpv2Support != null ? this.igmpv2Support.hashCode() : 0);
                result = 31 * result + (this.staticSourcesSupport != null ? this.staticSourcesSupport.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnTransitGatewayMulticastDomain}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnTransitGatewayMulticastDomain> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnTransitGatewayMulticastDomainProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnTransitGatewayMulticastDomainProps.Builder();
        }

        /**
         * The ID of the transit gateway.
         * <p>
         * @return {@code this}
         * @param transitGatewayId The ID of the transit gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayId(final java.lang.String transitGatewayId) {
            this.props.transitGatewayId(transitGatewayId);
            return this;
        }

        /**
         * The options for the transit gateway multicast domain.
         * <p>
         * <ul>
         * <li>AutoAcceptSharedAssociations (enable | disable)</li>
         * <li>Igmpv2Support (enable | disable)</li>
         * <li>StaticSourcesSupport (enable | disable)</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param options The options for the transit gateway multicast domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(final java.lang.Object options) {
            this.props.options(options);
            return this;
        }

        /**
         * The tags for the transit gateway multicast domain.
         * <p>
         * @return {@code this}
         * @param tags The tags for the transit gateway multicast domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnTransitGatewayMulticastDomain}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnTransitGatewayMulticastDomain build() {
            return new software.amazon.awscdk.services.ec2.CfnTransitGatewayMulticastDomain(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
