package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::VPNConnection`.
 * <p>
 * Specifies a VPN connection between a virtual private gateway and a VPN customer gateway or a transit gateway and a VPN customer gateway.
 * <p>
 * To specify a VPN connection between a transit gateway and customer gateway, use the <code>TransitGatewayId</code> and <code>CustomerGatewayId</code> properties.
 * <p>
 * To specify a VPN connection between a virtual private gateway and customer gateway, use the <code>VpnGatewayId</code> and <code>CustomerGatewayId</code> properties.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">AWS Site-to-Site VPN</a> in the <em>AWS Site-to-Site VPN User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVPNConnection cfnVPNConnection = CfnVPNConnection.Builder.create(this, "MyCfnVPNConnection")
 *         .customerGatewayId("customerGatewayId")
 *         .type("type")
 *         // the properties below are optional
 *         .staticRoutesOnly(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .transitGatewayId("transitGatewayId")
 *         .vpnGatewayId("vpnGatewayId")
 *         .vpnTunnelOptionsSpecifications(List.of(VpnTunnelOptionsSpecificationProperty.builder()
 *                 .preSharedKey("preSharedKey")
 *                 .tunnelInsideCidr("tunnelInsideCidr")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.73.0 (build 6faeda3)", date = "2023-01-31T18:36:53.236Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVPNConnection")
public class CfnVPNConnection extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnVPNConnection(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVPNConnection(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnVPNConnection.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::VPNConnection`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnVPNConnection(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnVPNConnectionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVpnConnectionId() {
        return software.amazon.jsii.Kernel.get(this, "attrVpnConnectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Any tags assigned to the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The ID of the customer gateway at your end of the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCustomerGatewayId() {
        return software.amazon.jsii.Kernel.get(this, "customerGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the customer gateway at your end of the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomerGatewayId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "customerGatewayId", java.util.Objects.requireNonNull(value, "customerGatewayId is required"));
    }

    /**
     * The type of VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * Indicates whether the VPN connection uses static routes only.
     * <p>
     * Static routes must be used for devices that don't support BGP.
     * <p>
     * If you are creating a VPN connection for a device that does not support Border Gateway Protocol (BGP), you must specify <code>true</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStaticRoutesOnly() {
        return software.amazon.jsii.Kernel.get(this, "staticRoutesOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether the VPN connection uses static routes only.
     * <p>
     * Static routes must be used for devices that don't support BGP.
     * <p>
     * If you are creating a VPN connection for a device that does not support Border Gateway Protocol (BGP), you must specify <code>true</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStaticRoutesOnly(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "staticRoutesOnly", value);
    }

    /**
     * Indicates whether the VPN connection uses static routes only.
     * <p>
     * Static routes must be used for devices that don't support BGP.
     * <p>
     * If you are creating a VPN connection for a device that does not support Border Gateway Protocol (BGP), you must specify <code>true</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStaticRoutesOnly(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "staticRoutesOnly", value);
    }

    /**
     * The ID of the transit gateway associated with the VPN connection.
     * <p>
     * You must specify either <code>TransitGatewayId</code> or <code>VpnGatewayId</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTransitGatewayId() {
        return software.amazon.jsii.Kernel.get(this, "transitGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the transit gateway associated with the VPN connection.
     * <p>
     * You must specify either <code>TransitGatewayId</code> or <code>VpnGatewayId</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransitGatewayId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "transitGatewayId", value);
    }

    /**
     * The ID of the virtual private gateway at the AWS side of the VPN connection.
     * <p>
     * You must specify either <code>TransitGatewayId</code> or <code>VpnGatewayId</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpnGatewayId() {
        return software.amazon.jsii.Kernel.get(this, "vpnGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the virtual private gateway at the AWS side of the VPN connection.
     * <p>
     * You must specify either <code>TransitGatewayId</code> or <code>VpnGatewayId</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpnGatewayId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpnGatewayId", value);
    }

    /**
     * The tunnel options for the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpnTunnelOptionsSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "vpnTunnelOptionsSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The tunnel options for the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpnTunnelOptionsSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpnTunnelOptionsSpecifications", value);
    }

    /**
     * The tunnel options for the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpnTunnelOptionsSpecifications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ec2.CfnVPNConnection.VpnTunnelOptionsSpecificationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.ec2.CfnVPNConnection.VpnTunnelOptionsSpecificationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "vpnTunnelOptionsSpecifications", value);
    }
    /**
     * The tunnel options for a single VPN tunnel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * VpnTunnelOptionsSpecificationProperty vpnTunnelOptionsSpecificationProperty = VpnTunnelOptionsSpecificationProperty.builder()
     *         .preSharedKey("preSharedKey")
     *         .tunnelInsideCidr("tunnelInsideCidr")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVPNConnection.VpnTunnelOptionsSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(VpnTunnelOptionsSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpnTunnelOptionsSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and customer gateway.
         * <p>
         * Constraints: Allowed characters are alphanumeric characters, periods (.), and underscores (_). Must be between 8 and 64 characters in length and cannot start with zero (0).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreSharedKey() {
            return null;
        }

        /**
         * The range of inside IP addresses for the tunnel.
         * <p>
         * Any specified CIDR blocks must be unique across all VPN connections that use the same virtual private gateway.
         * <p>
         * Constraints: A size /30 CIDR block from the <code>169.254.0.0/16</code> range. The following CIDR blocks are reserved and cannot be used:
         * <p>
         * <ul>
         * <li><code>169.254.0.0/30</code></li>
         * <li><code>169.254.1.0/30</code></li>
         * <li><code>169.254.2.0/30</code></li>
         * <li><code>169.254.3.0/30</code></li>
         * <li><code>169.254.4.0/30</code></li>
         * <li><code>169.254.5.0/30</code></li>
         * <li><code>169.254.169.252/30</code></li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTunnelInsideCidr() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpnTunnelOptionsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpnTunnelOptionsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpnTunnelOptionsSpecificationProperty> {
            java.lang.String preSharedKey;
            java.lang.String tunnelInsideCidr;

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getPreSharedKey}
             * @param preSharedKey The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and customer gateway.
             *                     Constraints: Allowed characters are alphanumeric characters, periods (.), and underscores (_). Must be between 8 and 64 characters in length and cannot start with zero (0).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preSharedKey(java.lang.String preSharedKey) {
                this.preSharedKey = preSharedKey;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getTunnelInsideCidr}
             * @param tunnelInsideCidr The range of inside IP addresses for the tunnel.
             *                         Any specified CIDR blocks must be unique across all VPN connections that use the same virtual private gateway.
             *                         <p>
             *                         Constraints: A size /30 CIDR block from the <code>169.254.0.0/16</code> range. The following CIDR blocks are reserved and cannot be used:
             *                         <p>
             *                         <ul>
             *                         <li><code>169.254.0.0/30</code></li>
             *                         <li><code>169.254.1.0/30</code></li>
             *                         <li><code>169.254.2.0/30</code></li>
             *                         <li><code>169.254.3.0/30</code></li>
             *                         <li><code>169.254.4.0/30</code></li>
             *                         <li><code>169.254.5.0/30</code></li>
             *                         <li><code>169.254.169.252/30</code></li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tunnelInsideCidr(java.lang.String tunnelInsideCidr) {
                this.tunnelInsideCidr = tunnelInsideCidr;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpnTunnelOptionsSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpnTunnelOptionsSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpnTunnelOptionsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpnTunnelOptionsSpecificationProperty {
            private final java.lang.String preSharedKey;
            private final java.lang.String tunnelInsideCidr;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.preSharedKey = software.amazon.jsii.Kernel.get(this, "preSharedKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tunnelInsideCidr = software.amazon.jsii.Kernel.get(this, "tunnelInsideCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.preSharedKey = builder.preSharedKey;
                this.tunnelInsideCidr = builder.tunnelInsideCidr;
            }

            @Override
            public final java.lang.String getPreSharedKey() {
                return this.preSharedKey;
            }

            @Override
            public final java.lang.String getTunnelInsideCidr() {
                return this.tunnelInsideCidr;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPreSharedKey() != null) {
                    data.set("preSharedKey", om.valueToTree(this.getPreSharedKey()));
                }
                if (this.getTunnelInsideCidr() != null) {
                    data.set("tunnelInsideCidr", om.valueToTree(this.getTunnelInsideCidr()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnVPNConnection.VpnTunnelOptionsSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpnTunnelOptionsSpecificationProperty.Jsii$Proxy that = (VpnTunnelOptionsSpecificationProperty.Jsii$Proxy) o;

                if (this.preSharedKey != null ? !this.preSharedKey.equals(that.preSharedKey) : that.preSharedKey != null) return false;
                return this.tunnelInsideCidr != null ? this.tunnelInsideCidr.equals(that.tunnelInsideCidr) : that.tunnelInsideCidr == null;
            }

            @Override
            public final int hashCode() {
                int result = this.preSharedKey != null ? this.preSharedKey.hashCode() : 0;
                result = 31 * result + (this.tunnelInsideCidr != null ? this.tunnelInsideCidr.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnVPNConnection}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnVPNConnection> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnVPNConnectionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnVPNConnectionProps.Builder();
        }

        /**
         * The ID of the customer gateway at your end of the VPN connection.
         * <p>
         * @return {@code this}
         * @param customerGatewayId The ID of the customer gateway at your end of the VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerGatewayId(final java.lang.String customerGatewayId) {
            this.props.customerGatewayId(customerGatewayId);
            return this;
        }

        /**
         * The type of VPN connection.
         * <p>
         * @return {@code this}
         * @param type The type of VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * Indicates whether the VPN connection uses static routes only.
         * <p>
         * Static routes must be used for devices that don't support BGP.
         * <p>
         * If you are creating a VPN connection for a device that does not support Border Gateway Protocol (BGP), you must specify <code>true</code> .
         * <p>
         * @return {@code this}
         * @param staticRoutesOnly Indicates whether the VPN connection uses static routes only. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder staticRoutesOnly(final java.lang.Boolean staticRoutesOnly) {
            this.props.staticRoutesOnly(staticRoutesOnly);
            return this;
        }
        /**
         * Indicates whether the VPN connection uses static routes only.
         * <p>
         * Static routes must be used for devices that don't support BGP.
         * <p>
         * If you are creating a VPN connection for a device that does not support Border Gateway Protocol (BGP), you must specify <code>true</code> .
         * <p>
         * @return {@code this}
         * @param staticRoutesOnly Indicates whether the VPN connection uses static routes only. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder staticRoutesOnly(final software.amazon.awscdk.core.IResolvable staticRoutesOnly) {
            this.props.staticRoutesOnly(staticRoutesOnly);
            return this;
        }

        /**
         * Any tags assigned to the VPN connection.
         * <p>
         * @return {@code this}
         * @param tags Any tags assigned to the VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The ID of the transit gateway associated with the VPN connection.
         * <p>
         * You must specify either <code>TransitGatewayId</code> or <code>VpnGatewayId</code> , but not both.
         * <p>
         * @return {@code this}
         * @param transitGatewayId The ID of the transit gateway associated with the VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayId(final java.lang.String transitGatewayId) {
            this.props.transitGatewayId(transitGatewayId);
            return this;
        }

        /**
         * The ID of the virtual private gateway at the AWS side of the VPN connection.
         * <p>
         * You must specify either <code>TransitGatewayId</code> or <code>VpnGatewayId</code> , but not both.
         * <p>
         * @return {@code this}
         * @param vpnGatewayId The ID of the virtual private gateway at the AWS side of the VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnGatewayId(final java.lang.String vpnGatewayId) {
            this.props.vpnGatewayId(vpnGatewayId);
            return this;
        }

        /**
         * The tunnel options for the VPN connection.
         * <p>
         * @return {@code this}
         * @param vpnTunnelOptionsSpecifications The tunnel options for the VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnTunnelOptionsSpecifications(final software.amazon.awscdk.core.IResolvable vpnTunnelOptionsSpecifications) {
            this.props.vpnTunnelOptionsSpecifications(vpnTunnelOptionsSpecifications);
            return this;
        }
        /**
         * The tunnel options for the VPN connection.
         * <p>
         * @return {@code this}
         * @param vpnTunnelOptionsSpecifications The tunnel options for the VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnTunnelOptionsSpecifications(final java.util.List<? extends java.lang.Object> vpnTunnelOptionsSpecifications) {
            this.props.vpnTunnelOptionsSpecifications(vpnTunnelOptionsSpecifications);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnVPNConnection}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnVPNConnection build() {
            return new software.amazon.awscdk.services.ec2.CfnVPNConnection(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
