package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnInstance`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnInstanceProps cfnInstanceProps = CfnInstanceProps.builder()
 *         .additionalInfo("additionalInfo")
 *         .affinity("affinity")
 *         .availabilityZone("availabilityZone")
 *         .blockDeviceMappings(List.of(BlockDeviceMappingProperty.builder()
 *                 .deviceName("deviceName")
 *                 // the properties below are optional
 *                 .ebs(EbsProperty.builder()
 *                         .deleteOnTermination(false)
 *                         .encrypted(false)
 *                         .iops(123)
 *                         .kmsKeyId("kmsKeyId")
 *                         .snapshotId("snapshotId")
 *                         .volumeSize(123)
 *                         .volumeType("volumeType")
 *                         .build())
 *                 .noDevice(NoDeviceProperty.builder().build())
 *                 .virtualName("virtualName")
 *                 .build()))
 *         .cpuOptions(CpuOptionsProperty.builder()
 *                 .coreCount(123)
 *                 .threadsPerCore(123)
 *                 .build())
 *         .creditSpecification(CreditSpecificationProperty.builder()
 *                 .cpuCredits("cpuCredits")
 *                 .build())
 *         .disableApiTermination(false)
 *         .ebsOptimized(false)
 *         .elasticGpuSpecifications(List.of(ElasticGpuSpecificationProperty.builder()
 *                 .type("type")
 *                 .build()))
 *         .elasticInferenceAccelerators(List.of(ElasticInferenceAcceleratorProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .count(123)
 *                 .build()))
 *         .enclaveOptions(EnclaveOptionsProperty.builder()
 *                 .enabled(false)
 *                 .build())
 *         .hibernationOptions(HibernationOptionsProperty.builder()
 *                 .configured(false)
 *                 .build())
 *         .hostId("hostId")
 *         .hostResourceGroupArn("hostResourceGroupArn")
 *         .iamInstanceProfile("iamInstanceProfile")
 *         .imageId("imageId")
 *         .instanceInitiatedShutdownBehavior("instanceInitiatedShutdownBehavior")
 *         .instanceType("instanceType")
 *         .ipv6AddressCount(123)
 *         .ipv6Addresses(List.of(InstanceIpv6AddressProperty.builder()
 *                 .ipv6Address("ipv6Address")
 *                 .build()))
 *         .kernelId("kernelId")
 *         .keyName("keyName")
 *         .launchTemplate(LaunchTemplateSpecificationProperty.builder()
 *                 .version("version")
 *                 // the properties below are optional
 *                 .launchTemplateId("launchTemplateId")
 *                 .launchTemplateName("launchTemplateName")
 *                 .build())
 *         .licenseSpecifications(List.of(LicenseSpecificationProperty.builder()
 *                 .licenseConfigurationArn("licenseConfigurationArn")
 *                 .build()))
 *         .monitoring(false)
 *         .networkInterfaces(List.of(NetworkInterfaceProperty.builder()
 *                 .deviceIndex("deviceIndex")
 *                 // the properties below are optional
 *                 .associateCarrierIpAddress(false)
 *                 .associatePublicIpAddress(false)
 *                 .deleteOnTermination(false)
 *                 .description("description")
 *                 .groupSet(List.of("groupSet"))
 *                 .ipv6AddressCount(123)
 *                 .ipv6Addresses(List.of(InstanceIpv6AddressProperty.builder()
 *                         .ipv6Address("ipv6Address")
 *                         .build()))
 *                 .networkInterfaceId("networkInterfaceId")
 *                 .privateIpAddress("privateIpAddress")
 *                 .privateIpAddresses(List.of(PrivateIpAddressSpecificationProperty.builder()
 *                         .primary(false)
 *                         .privateIpAddress("privateIpAddress")
 *                         .build()))
 *                 .secondaryPrivateIpAddressCount(123)
 *                 .subnetId("subnetId")
 *                 .build()))
 *         .placementGroupName("placementGroupName")
 *         .privateDnsNameOptions(PrivateDnsNameOptionsProperty.builder()
 *                 .enableResourceNameDnsAaaaRecord(false)
 *                 .enableResourceNameDnsARecord(false)
 *                 .hostnameType("hostnameType")
 *                 .build())
 *         .privateIpAddress("privateIpAddress")
 *         .propagateTagsToVolumeOnCreation(false)
 *         .ramdiskId("ramdiskId")
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .securityGroups(List.of("securityGroups"))
 *         .sourceDestCheck(false)
 *         .ssmAssociations(List.of(SsmAssociationProperty.builder()
 *                 .documentName("documentName")
 *                 // the properties below are optional
 *                 .associationParameters(List.of(AssociationParameterProperty.builder()
 *                         .key("key")
 *                         .value(List.of("value"))
 *                         .build()))
 *                 .build()))
 *         .subnetId("subnetId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tenancy("tenancy")
 *         .userData("userData")
 *         .volumes(List.of(VolumeProperty.builder()
 *                 .device("device")
 *                 .volumeId("volumeId")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-09T02:14:31.231Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstanceProps")
@software.amazon.jsii.Jsii.Proxy(CfnInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * This property is reserved for internal use.
     * <p>
     * If you use it, the stack fails with this error: <code>Bad property set: [Testing this property] (Service: AmazonEC2; Status Code: 400; Error Code: InvalidParameterCombination; Request ID: 0XXXXXX-49c7-4b40-8bcc-76885dcXXXXX)</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAdditionalInfo() {
        return null;
    }

    /**
     * Indicates whether the instance is associated with a dedicated host.
     * <p>
     * If you want the instance to always restart on the same host on which it was launched, specify <code>host</code> . If you want the instance to restart on any available host, but try to launch onto the last host it ran on (on a best-effort basis), specify <code>default</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAffinity() {
        return null;
    }

    /**
     * The Availability Zone of the instance.
     * <p>
     * If not specified, an Availability Zone will be automatically chosen for you based on the load balancing criteria for the Region.
     * <p>
     * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute.html">DescribeImageAttribute</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * The block device mapping entries that defines the block devices to attach to the instance at launch.
     * <p>
     * By default, the block devices specified in the block device mapping for the AMI are used. You can override the AMI block device mapping using the instance block device mapping. For the root volume, you can override only the volume size, volume type, volume encryption settings, and the <code>DeleteOnTermination</code> setting.
     * <p>
     * <blockquote>
     * <p>
     * After the instance is running, you can modify only the <code>DeleteOnTermination</code> parameter for the attached volumes without interrupting the instance. Modifying any other parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBlockDeviceMappings() {
        return null;
    }

    /**
     * The CPU options for the instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU options</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCpuOptions() {
        return null;
    }

    /**
     * The credit option for CPU usage of the burstable performance instance.
     * <p>
     * Valid values are <code>standard</code> and <code>unlimited</code> . To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html">ModifyInstanceCreditSpecification</a> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Default: <code>standard</code> (T2 instances) or <code>unlimited</code> (T3/T3a/T4g instances)
     * <p>
     * For T3 instances with <code>host</code> tenancy, only <code>standard</code> is supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCreditSpecification() {
        return null;
    }

    /**
     * If you set this parameter to `true` , you can't terminate the instance using the Amazon EC2 console, CLI, or API;
     * <p>
     * otherwise, you can. To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute</a> . Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code> , you can terminate the instance by running the shutdown command from the instance.
     * <p>
     * Default: <code>false</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDisableApiTermination() {
        return null;
    }

    /**
     * Indicates whether the instance is optimized for Amazon EBS I/O.
     * <p>
     * This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
     * <p>
     * Default: <code>false</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptimized() {
        return null;
    }

    /**
     * An elastic GPU to associate with the instance.
     * <p>
     * An Elastic GPU is a GPU resource that you can attach to your Windows instance to accelerate the graphics performance of your applications. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon EC2 Elastic GPUs</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getElasticGpuSpecifications() {
        return null;
    }

    /**
     * An elastic inference accelerator to associate with the instance.
     * <p>
     * Elastic inference accelerators are a resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference workloads.
     * <p>
     * You cannot specify accelerators from different generations in the same request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getElasticInferenceAccelerators() {
        return null;
    }

    /**
     * Indicates whether the instance is enabled for AWS Nitro Enclaves.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnclaveOptions() {
        return null;
    }

    /**
     * Indicates whether an instance is enabled for hibernation.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * You can't enable hibernation and AWS Nitro Enclaves on the same instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHibernationOptions() {
        return null;
    }

    /**
     * If you specify host for the `Affinity` property, the ID of a dedicated host that the instance is associated with.
     * <p>
     * If you don't specify an ID, Amazon EC2 launches the instance onto any available, compatible dedicated host in your account. This type of launch is called an untargeted launch. Note that for untargeted launches, you must have a compatible, dedicated host available to successfully launch instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHostId() {
        return null;
    }

    /**
     * The ARN of the host resource group in which to launch the instances.
     * <p>
     * If you specify a host resource group ARN, omit the <em>Tenancy</em> parameter or set it to <code>host</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHostResourceGroupArn() {
        return null;
    }

    /**
     * The name of an IAM instance profile.
     * <p>
     * To create a new IAM instance profile, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a> resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIamInstanceProfile() {
        return null;
    }

    /**
     * The ID of the AMI.
     * <p>
     * An AMI ID is required to launch an instance and must be specified here or in a launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageId() {
        return null;
    }

    /**
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
     * <p>
     * Default: <code>stop</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceInitiatedShutdownBehavior() {
        return null;
    }

    /**
     * The instance type. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide* .
     * <p>
     * Default: <code>m1.small</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
        return null;
    }

    /**
     * [EC2-VPC] The number of IPv6 addresses to associate with the primary network interface.
     * <p>
     * Amazon EC2 chooses the IPv6 addresses from the range of your subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number of instances to launch.
     * <p>
     * You cannot specify this option and the network interfaces option in the same request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIpv6AddressCount() {
        return null;
    }

    /**
     * [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface.
     * <p>
     * You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.
     * <p>
     * You cannot specify this option and the network interfaces option in the same request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIpv6Addresses() {
        return null;
    }

    /**
     * The ID of the kernel.
     * <p>
     * <blockquote>
     * <p>
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">PV-GRUB</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKernelId() {
        return null;
    }

    /**
     * The name of the key pair. You can create a key pair using [CreateKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html) or [ImportKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html) .
     * <p>
     * <blockquote>
     * <p>
     * If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is configured to allow users another way to log in.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyName() {
        return null;
    }

    /**
     * The launch template to use to launch the instances.
     * <p>
     * Any parameters that you specify in the AWS CloudFormation template override the same parameters in the launch template. You can specify either the name or ID of a launch template, but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchTemplate() {
        return null;
    }

    /**
     * The license configurations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLicenseSpecifications() {
        return null;
    }

    /**
     * Specifies whether detailed monitoring is enabled for the instance.
     * <p>
     * Specify <code>true</code> to enable detailed monitoring. Otherwise, basic monitoring is enabled. For more information about detailed monitoring, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off detailed monitoring for your instances</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMonitoring() {
        return null;
    }

    /**
     * The network interfaces to associate with the instance.
     * <p>
     * <blockquote>
     * <p>
     * If you use this property to point to a network interface, you must terminate the original interface before attaching a new one to allow the update of the instance to succeed.
     * <p>
     * If this resource has a public IP address and is also in a VPC that is defined in the same template, you must use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> to declare a dependency on the VPC-gateway attachment.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterfaces() {
        return null;
    }

    /**
     * The name of an existing placement group that you want to launch the instance into (cluster | partition | spread).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPlacementGroupName() {
        return null;
    }

    /**
     * The options for the instance hostname.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPrivateDnsNameOptions() {
        return null;
    }

    /**
     * [EC2-VPC] The primary IPv4 address. You must specify a value from the IPv4 address range of the subnet.
     * <p>
     * Only one private IP address can be designated as primary. You can't specify this option if you've specified the option to designate a private IP address as the primary IP address in a network interface specification. You cannot specify this option if you're launching more than one instance in the request.
     * <p>
     * You cannot specify this option and the network interfaces option in the same request.
     * <p>
     * If you make an update to an instance that requires replacement, you must assign a new private IP address. During a replacement, AWS CloudFormation creates a new instance but doesn't delete the old instance until the stack has successfully updated. If the stack update fails, AWS CloudFormation uses the old instance to roll back the stack to the previous working state. The old and new instances cannot have the same private IP address.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrivateIpAddress() {
        return null;
    }

    /**
     * Indicates whether to assign the tags from the instance to all of the volumes attached to the instance at launch.
     * <p>
     * If you specify <code>true</code> and you assign tags to the instance, those tags are automatically assigned to all of the volumes that you attach to the instance at launch. If you specify <code>false</code> , those tags are not assigned to the attached volumes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPropagateTagsToVolumeOnCreation() {
        return null;
    }

    /**
     * The ID of the RAM disk to select.
     * <p>
     * Some kernels require additional drivers at launch. Check the kernel requirements for information about whether you need to specify a RAM disk. To find kernel requirements, go to the AWS Resource Center and search for the kernel ID.
     * <p>
     * <blockquote>
     * <p>
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">PV-GRUB</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRamdiskId() {
        return null;
    }

    /**
     * The IDs of the security groups. You can create a security group using [CreateSecurityGroup](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html) .
     * <p>
     * If you specify a network interface, you must specify any security groups as part of the network interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return null;
    }

    /**
     * [EC2-Classic, default VPC] The names of the security groups.
     * <p>
     * For a nondefault VPC, you must use security group IDs instead.
     * <p>
     * You cannot specify this option and the network interfaces option in the same request. The list can contain both the name of existing Amazon EC2 security groups or references to AWS::EC2::SecurityGroup resources created in the template.
     * <p>
     * Default: Amazon EC2 uses the default security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
        return null;
    }

    /**
     * Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives.
     * <p>
     * If the value is <code>true</code> , source/destination checks are enabled; otherwise, they are disabled. The default value is <code>true</code> . You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSourceDestCheck() {
        return null;
    }

    /**
     * The SSM [document](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html) and parameter values in AWS Systems Manager to associate with this instance. To use this property, you must specify an IAM instance profile role for the instance. For more information, see [Create an IAM instance profile for Systems Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-configuring-access-role.html) in the *AWS Systems Manager User Guide* .
     * <p>
     * <blockquote>
     * <p>
     * You can currently associate only one document with an instance.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSsmAssociations() {
        return null;
    }

    /**
     * [EC2-VPC] The ID of the subnet to launch the instance into.
     * <p>
     * If you specify a network interface, you must specify any subnets as part of the network interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
        return null;
    }

    /**
     * The tags to add to the instance.
     * <p>
     * These tags are not applied to the EBS volumes, such as the root volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * The tenancy of the instance (if the instance is running in a VPC).
     * <p>
     * An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTenancy() {
        return null;
    }

    /**
     * The user data script to make available to the instance.
     * <p>
     * User data is limited to 16 KB. You must provide base64-encoded text. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-base64.html">Fn::Base64</a> .
     * <p>
     * User data runs only at instance launch. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Run commands on your Linux instance at launch</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-windows-user-data.html">Run commands on your Windows instance at launch</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserData() {
        return null;
    }

    /**
     * The volumes to attach to the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVolumes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInstanceProps> {
        java.lang.String additionalInfo;
        java.lang.String affinity;
        java.lang.String availabilityZone;
        java.lang.Object blockDeviceMappings;
        java.lang.Object cpuOptions;
        java.lang.Object creditSpecification;
        java.lang.Object disableApiTermination;
        java.lang.Object ebsOptimized;
        java.lang.Object elasticGpuSpecifications;
        java.lang.Object elasticInferenceAccelerators;
        java.lang.Object enclaveOptions;
        java.lang.Object hibernationOptions;
        java.lang.String hostId;
        java.lang.String hostResourceGroupArn;
        java.lang.String iamInstanceProfile;
        java.lang.String imageId;
        java.lang.String instanceInitiatedShutdownBehavior;
        java.lang.String instanceType;
        java.lang.Number ipv6AddressCount;
        java.lang.Object ipv6Addresses;
        java.lang.String kernelId;
        java.lang.String keyName;
        java.lang.Object launchTemplate;
        java.lang.Object licenseSpecifications;
        java.lang.Object monitoring;
        java.lang.Object networkInterfaces;
        java.lang.String placementGroupName;
        java.lang.Object privateDnsNameOptions;
        java.lang.String privateIpAddress;
        java.lang.Object propagateTagsToVolumeOnCreation;
        java.lang.String ramdiskId;
        java.util.List<java.lang.String> securityGroupIds;
        java.util.List<java.lang.String> securityGroups;
        java.lang.Object sourceDestCheck;
        java.lang.Object ssmAssociations;
        java.lang.String subnetId;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.String tenancy;
        java.lang.String userData;
        java.lang.Object volumes;

        /**
         * Sets the value of {@link CfnInstanceProps#getAdditionalInfo}
         * @param additionalInfo This property is reserved for internal use.
         *                       If you use it, the stack fails with this error: <code>Bad property set: [Testing this property] (Service: AmazonEC2; Status Code: 400; Error Code: InvalidParameterCombination; Request ID: 0XXXXXX-49c7-4b40-8bcc-76885dcXXXXX)</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInfo(java.lang.String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getAffinity}
         * @param affinity Indicates whether the instance is associated with a dedicated host.
         *                 If you want the instance to always restart on the same host on which it was launched, specify <code>host</code> . If you want the instance to restart on any available host, but try to launch onto the last host it ran on (on a best-effort basis), specify <code>default</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder affinity(java.lang.String affinity) {
            this.affinity = affinity;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getAvailabilityZone}
         * @param availabilityZone The Availability Zone of the instance.
         *                         If not specified, an Availability Zone will be automatically chosen for you based on the load balancing criteria for the Region.
         *                         <p>
         *                         This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute.html">DescribeImageAttribute</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getBlockDeviceMappings}
         * @param blockDeviceMappings The block device mapping entries that defines the block devices to attach to the instance at launch.
         *                            By default, the block devices specified in the block device mapping for the AMI are used. You can override the AMI block device mapping using the instance block device mapping. For the root volume, you can override only the volume size, volume type, volume encryption settings, and the <code>DeleteOnTermination</code> setting.
         *                            <p>
         *                            <blockquote>
         *                            <p>
         *                            After the instance is running, you can modify only the <code>DeleteOnTermination</code> parameter for the attached volumes without interrupting the instance. Modifying any other parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         *                            <p>
         *                            </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDeviceMappings(software.amazon.awscdk.core.IResolvable blockDeviceMappings) {
            this.blockDeviceMappings = blockDeviceMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getBlockDeviceMappings}
         * @param blockDeviceMappings The block device mapping entries that defines the block devices to attach to the instance at launch.
         *                            By default, the block devices specified in the block device mapping for the AMI are used. You can override the AMI block device mapping using the instance block device mapping. For the root volume, you can override only the volume size, volume type, volume encryption settings, and the <code>DeleteOnTermination</code> setting.
         *                            <p>
         *                            <blockquote>
         *                            <p>
         *                            After the instance is running, you can modify only the <code>DeleteOnTermination</code> parameter for the attached volumes without interrupting the instance. Modifying any other parameter results in instance <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         *                            <p>
         *                            </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDeviceMappings(java.util.List<? extends java.lang.Object> blockDeviceMappings) {
            this.blockDeviceMappings = blockDeviceMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getCpuOptions}
         * @param cpuOptions The CPU options for the instance.
         *                   For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU options</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuOptions(software.amazon.awscdk.core.IResolvable cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getCpuOptions}
         * @param cpuOptions The CPU options for the instance.
         *                   For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU options</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuOptions(software.amazon.awscdk.services.ec2.CfnInstance.CpuOptionsProperty cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getCreditSpecification}
         * @param creditSpecification The credit option for CPU usage of the burstable performance instance.
         *                            Valid values are <code>standard</code> and <code>unlimited</code> . To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html">ModifyInstanceCreditSpecification</a> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <em>Amazon EC2 User Guide</em> .
         *                            <p>
         *                            Default: <code>standard</code> (T2 instances) or <code>unlimited</code> (T3/T3a/T4g instances)
         *                            <p>
         *                            For T3 instances with <code>host</code> tenancy, only <code>standard</code> is supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creditSpecification(software.amazon.awscdk.core.IResolvable creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getCreditSpecification}
         * @param creditSpecification The credit option for CPU usage of the burstable performance instance.
         *                            Valid values are <code>standard</code> and <code>unlimited</code> . To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html">ModifyInstanceCreditSpecification</a> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <em>Amazon EC2 User Guide</em> .
         *                            <p>
         *                            Default: <code>standard</code> (T2 instances) or <code>unlimited</code> (T3/T3a/T4g instances)
         *                            <p>
         *                            For T3 instances with <code>host</code> tenancy, only <code>standard</code> is supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creditSpecification(software.amazon.awscdk.services.ec2.CfnInstance.CreditSpecificationProperty creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getDisableApiTermination}
         * @param disableApiTermination If you set this parameter to `true` , you can't terminate the instance using the Amazon EC2 console, CLI, or API;.
         *                              otherwise, you can. To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute</a> . Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code> , you can terminate the instance by running the shutdown command from the instance.
         *                              <p>
         *                              Default: <code>false</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableApiTermination(java.lang.Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getDisableApiTermination}
         * @param disableApiTermination If you set this parameter to `true` , you can't terminate the instance using the Amazon EC2 console, CLI, or API;.
         *                              otherwise, you can. To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute</a> . Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code> , you can terminate the instance by running the shutdown command from the instance.
         *                              <p>
         *                              Default: <code>false</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableApiTermination(software.amazon.awscdk.core.IResolvable disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getEbsOptimized}
         * @param ebsOptimized Indicates whether the instance is optimized for Amazon EBS I/O.
         *                     This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
         *                     <p>
         *                     Default: <code>false</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getEbsOptimized}
         * @param ebsOptimized Indicates whether the instance is optimized for Amazon EBS I/O.
         *                     This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
         *                     <p>
         *                     Default: <code>false</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(software.amazon.awscdk.core.IResolvable ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getElasticGpuSpecifications}
         * @param elasticGpuSpecifications An elastic GPU to associate with the instance.
         *                                 An Elastic GPU is a GPU resource that you can attach to your Windows instance to accelerate the graphics performance of your applications. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon EC2 Elastic GPUs</a> in the <em>Amazon EC2 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticGpuSpecifications(software.amazon.awscdk.core.IResolvable elasticGpuSpecifications) {
            this.elasticGpuSpecifications = elasticGpuSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getElasticGpuSpecifications}
         * @param elasticGpuSpecifications An elastic GPU to associate with the instance.
         *                                 An Elastic GPU is a GPU resource that you can attach to your Windows instance to accelerate the graphics performance of your applications. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon EC2 Elastic GPUs</a> in the <em>Amazon EC2 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticGpuSpecifications(java.util.List<? extends java.lang.Object> elasticGpuSpecifications) {
            this.elasticGpuSpecifications = elasticGpuSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getElasticInferenceAccelerators}
         * @param elasticInferenceAccelerators An elastic inference accelerator to associate with the instance.
         *                                     Elastic inference accelerators are a resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference workloads.
         *                                     <p>
         *                                     You cannot specify accelerators from different generations in the same request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticInferenceAccelerators(software.amazon.awscdk.core.IResolvable elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = elasticInferenceAccelerators;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getElasticInferenceAccelerators}
         * @param elasticInferenceAccelerators An elastic inference accelerator to associate with the instance.
         *                                     Elastic inference accelerators are a resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference workloads.
         *                                     <p>
         *                                     You cannot specify accelerators from different generations in the same request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticInferenceAccelerators(java.util.List<? extends java.lang.Object> elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = elasticInferenceAccelerators;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getEnclaveOptions}
         * @param enclaveOptions Indicates whether the instance is enabled for AWS Nitro Enclaves.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enclaveOptions(software.amazon.awscdk.core.IResolvable enclaveOptions) {
            this.enclaveOptions = enclaveOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getEnclaveOptions}
         * @param enclaveOptions Indicates whether the instance is enabled for AWS Nitro Enclaves.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enclaveOptions(software.amazon.awscdk.services.ec2.CfnInstance.EnclaveOptionsProperty enclaveOptions) {
            this.enclaveOptions = enclaveOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getHibernationOptions}
         * @param hibernationOptions Indicates whether an instance is enabled for hibernation.
         *                           For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <em>Amazon EC2 User Guide</em> .
         *                           <p>
         *                           You can't enable hibernation and AWS Nitro Enclaves on the same instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hibernationOptions(software.amazon.awscdk.core.IResolvable hibernationOptions) {
            this.hibernationOptions = hibernationOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getHibernationOptions}
         * @param hibernationOptions Indicates whether an instance is enabled for hibernation.
         *                           For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <em>Amazon EC2 User Guide</em> .
         *                           <p>
         *                           You can't enable hibernation and AWS Nitro Enclaves on the same instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hibernationOptions(software.amazon.awscdk.services.ec2.CfnInstance.HibernationOptionsProperty hibernationOptions) {
            this.hibernationOptions = hibernationOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getHostId}
         * @param hostId If you specify host for the `Affinity` property, the ID of a dedicated host that the instance is associated with.
         *               If you don't specify an ID, Amazon EC2 launches the instance onto any available, compatible dedicated host in your account. This type of launch is called an untargeted launch. Note that for untargeted launches, you must have a compatible, dedicated host available to successfully launch instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostId(java.lang.String hostId) {
            this.hostId = hostId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getHostResourceGroupArn}
         * @param hostResourceGroupArn The ARN of the host resource group in which to launch the instances.
         *                             If you specify a host resource group ARN, omit the <em>Tenancy</em> parameter or set it to <code>host</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostResourceGroupArn(java.lang.String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getIamInstanceProfile}
         * @param iamInstanceProfile The name of an IAM instance profile.
         *                           To create a new IAM instance profile, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a> resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamInstanceProfile(java.lang.String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getImageId}
         * @param imageId The ID of the AMI.
         *                An AMI ID is required to launch an instance and must be specified here or in a launch template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageId(java.lang.String imageId) {
            this.imageId = imageId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getInstanceInitiatedShutdownBehavior}
         * @param instanceInitiatedShutdownBehavior Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
         *                                          Default: <code>stop</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceInitiatedShutdownBehavior(java.lang.String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getInstanceType}
         * @param instanceType The instance type. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide* .
         *                     Default: <code>m1.small</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(java.lang.String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getIpv6AddressCount}
         * @param ipv6AddressCount [EC2-VPC] The number of IPv6 addresses to associate with the primary network interface.
         *                         Amazon EC2 chooses the IPv6 addresses from the range of your subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number of instances to launch.
         *                         <p>
         *                         You cannot specify this option and the network interfaces option in the same request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6AddressCount(java.lang.Number ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getIpv6Addresses}
         * @param ipv6Addresses [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface.
         *                      You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.
         *                      <p>
         *                      You cannot specify this option and the network interfaces option in the same request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Addresses(software.amazon.awscdk.core.IResolvable ipv6Addresses) {
            this.ipv6Addresses = ipv6Addresses;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getIpv6Addresses}
         * @param ipv6Addresses [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface.
         *                      You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.
         *                      <p>
         *                      You cannot specify this option and the network interfaces option in the same request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Addresses(java.util.List<? extends java.lang.Object> ipv6Addresses) {
            this.ipv6Addresses = ipv6Addresses;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getKernelId}
         * @param kernelId The ID of the kernel.
         *                 <blockquote>
         *                 <p>
         *                 We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">PV-GRUB</a> in the <em>Amazon EC2 User Guide</em> .
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kernelId(java.lang.String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getKeyName}
         * @param keyName The name of the key pair. You can create a key pair using [CreateKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html) or [ImportKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html) .
         *                <blockquote>
         *                <p>
         *                If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is configured to allow users another way to log in.
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getLaunchTemplate}
         * @param launchTemplate The launch template to use to launch the instances.
         *                       Any parameters that you specify in the AWS CloudFormation template override the same parameters in the launch template. You can specify either the name or ID of a launch template, but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplate(software.amazon.awscdk.core.IResolvable launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getLaunchTemplate}
         * @param launchTemplate The launch template to use to launch the instances.
         *                       Any parameters that you specify in the AWS CloudFormation template override the same parameters in the launch template. You can specify either the name or ID of a launch template, but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplate(software.amazon.awscdk.services.ec2.CfnInstance.LaunchTemplateSpecificationProperty launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getLicenseSpecifications}
         * @param licenseSpecifications The license configurations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseSpecifications(software.amazon.awscdk.core.IResolvable licenseSpecifications) {
            this.licenseSpecifications = licenseSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getLicenseSpecifications}
         * @param licenseSpecifications The license configurations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseSpecifications(java.util.List<? extends java.lang.Object> licenseSpecifications) {
            this.licenseSpecifications = licenseSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getMonitoring}
         * @param monitoring Specifies whether detailed monitoring is enabled for the instance.
         *                   Specify <code>true</code> to enable detailed monitoring. Otherwise, basic monitoring is enabled. For more information about detailed monitoring, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off detailed monitoring for your instances</a> in the <em>Amazon EC2 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoring(java.lang.Boolean monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getMonitoring}
         * @param monitoring Specifies whether detailed monitoring is enabled for the instance.
         *                   Specify <code>true</code> to enable detailed monitoring. Otherwise, basic monitoring is enabled. For more information about detailed monitoring, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off detailed monitoring for your instances</a> in the <em>Amazon EC2 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoring(software.amazon.awscdk.core.IResolvable monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getNetworkInterfaces}
         * @param networkInterfaces The network interfaces to associate with the instance.
         *                          <blockquote>
         *                          <p>
         *                          If you use this property to point to a network interface, you must terminate the original interface before attaching a new one to allow the update of the instance to succeed.
         *                          <p>
         *                          If this resource has a public IP address and is also in a VPC that is defined in the same template, you must use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> to declare a dependency on the VPC-gateway attachment.
         *                          <p>
         *                          </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaces(software.amazon.awscdk.core.IResolvable networkInterfaces) {
            this.networkInterfaces = networkInterfaces;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getNetworkInterfaces}
         * @param networkInterfaces The network interfaces to associate with the instance.
         *                          <blockquote>
         *                          <p>
         *                          If you use this property to point to a network interface, you must terminate the original interface before attaching a new one to allow the update of the instance to succeed.
         *                          <p>
         *                          If this resource has a public IP address and is also in a VPC that is defined in the same template, you must use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> to declare a dependency on the VPC-gateway attachment.
         *                          <p>
         *                          </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaces(java.util.List<? extends java.lang.Object> networkInterfaces) {
            this.networkInterfaces = networkInterfaces;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getPlacementGroupName}
         * @param placementGroupName The name of an existing placement group that you want to launch the instance into (cluster | partition | spread).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementGroupName(java.lang.String placementGroupName) {
            this.placementGroupName = placementGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getPrivateDnsNameOptions}
         * @param privateDnsNameOptions The options for the instance hostname.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsNameOptions(software.amazon.awscdk.core.IResolvable privateDnsNameOptions) {
            this.privateDnsNameOptions = privateDnsNameOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getPrivateDnsNameOptions}
         * @param privateDnsNameOptions The options for the instance hostname.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsNameOptions(software.amazon.awscdk.services.ec2.CfnInstance.PrivateDnsNameOptionsProperty privateDnsNameOptions) {
            this.privateDnsNameOptions = privateDnsNameOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getPrivateIpAddress}
         * @param privateIpAddress [EC2-VPC] The primary IPv4 address. You must specify a value from the IPv4 address range of the subnet.
         *                         Only one private IP address can be designated as primary. You can't specify this option if you've specified the option to designate a private IP address as the primary IP address in a network interface specification. You cannot specify this option if you're launching more than one instance in the request.
         *                         <p>
         *                         You cannot specify this option and the network interfaces option in the same request.
         *                         <p>
         *                         If you make an update to an instance that requires replacement, you must assign a new private IP address. During a replacement, AWS CloudFormation creates a new instance but doesn't delete the old instance until the stack has successfully updated. If the stack update fails, AWS CloudFormation uses the old instance to roll back the stack to the previous working state. The old and new instances cannot have the same private IP address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateIpAddress(java.lang.String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getPropagateTagsToVolumeOnCreation}
         * @param propagateTagsToVolumeOnCreation Indicates whether to assign the tags from the instance to all of the volumes attached to the instance at launch.
         *                                        If you specify <code>true</code> and you assign tags to the instance, those tags are automatically assigned to all of the volumes that you attach to the instance at launch. If you specify <code>false</code> , those tags are not assigned to the attached volumes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTagsToVolumeOnCreation(java.lang.Boolean propagateTagsToVolumeOnCreation) {
            this.propagateTagsToVolumeOnCreation = propagateTagsToVolumeOnCreation;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getPropagateTagsToVolumeOnCreation}
         * @param propagateTagsToVolumeOnCreation Indicates whether to assign the tags from the instance to all of the volumes attached to the instance at launch.
         *                                        If you specify <code>true</code> and you assign tags to the instance, those tags are automatically assigned to all of the volumes that you attach to the instance at launch. If you specify <code>false</code> , those tags are not assigned to the attached volumes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTagsToVolumeOnCreation(software.amazon.awscdk.core.IResolvable propagateTagsToVolumeOnCreation) {
            this.propagateTagsToVolumeOnCreation = propagateTagsToVolumeOnCreation;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getRamdiskId}
         * @param ramdiskId The ID of the RAM disk to select.
         *                  Some kernels require additional drivers at launch. Check the kernel requirements for information about whether you need to specify a RAM disk. To find kernel requirements, go to the AWS Resource Center and search for the kernel ID.
         *                  <p>
         *                  <blockquote>
         *                  <p>
         *                  We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">PV-GRUB</a> in the <em>Amazon EC2 User Guide</em> .
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ramdiskId(java.lang.String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getSecurityGroupIds}
         * @param securityGroupIds The IDs of the security groups. You can create a security group using [CreateSecurityGroup](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html) .
         *                         If you specify a network interface, you must specify any security groups as part of the network interface.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getSecurityGroups}
         * @param securityGroups [EC2-Classic, default VPC] The names of the security groups.
         *                       For a nondefault VPC, you must use security group IDs instead.
         *                       <p>
         *                       You cannot specify this option and the network interfaces option in the same request. The list can contain both the name of existing Amazon EC2 security groups or references to AWS::EC2::SecurityGroup resources created in the template.
         *                       <p>
         *                       Default: Amazon EC2 uses the default security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getSourceDestCheck}
         * @param sourceDestCheck Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives.
         *                        If the value is <code>true</code> , source/destination checks are enabled; otherwise, they are disabled. The default value is <code>true</code> . You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDestCheck(java.lang.Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getSourceDestCheck}
         * @param sourceDestCheck Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives.
         *                        If the value is <code>true</code> , source/destination checks are enabled; otherwise, they are disabled. The default value is <code>true</code> . You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDestCheck(software.amazon.awscdk.core.IResolvable sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getSsmAssociations}
         * @param ssmAssociations The SSM [document](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html) and parameter values in AWS Systems Manager to associate with this instance. To use this property, you must specify an IAM instance profile role for the instance. For more information, see [Create an IAM instance profile for Systems Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-configuring-access-role.html) in the *AWS Systems Manager User Guide* .
         *                        <blockquote>
         *                        <p>
         *                        You can currently associate only one document with an instance.
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ssmAssociations(software.amazon.awscdk.core.IResolvable ssmAssociations) {
            this.ssmAssociations = ssmAssociations;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getSsmAssociations}
         * @param ssmAssociations The SSM [document](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html) and parameter values in AWS Systems Manager to associate with this instance. To use this property, you must specify an IAM instance profile role for the instance. For more information, see [Create an IAM instance profile for Systems Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-configuring-access-role.html) in the *AWS Systems Manager User Guide* .
         *                        <blockquote>
         *                        <p>
         *                        You can currently associate only one document with an instance.
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ssmAssociations(java.util.List<? extends java.lang.Object> ssmAssociations) {
            this.ssmAssociations = ssmAssociations;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getSubnetId}
         * @param subnetId [EC2-VPC] The ID of the subnet to launch the instance into.
         *                 If you specify a network interface, you must specify any subnets as part of the network interface.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getTags}
         * @param tags The tags to add to the instance.
         *             These tags are not applied to the EBS volumes, such as the root volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getTenancy}
         * @param tenancy The tenancy of the instance (if the instance is running in a VPC).
         *                An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tenancy(java.lang.String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getUserData}
         * @param userData The user data script to make available to the instance.
         *                 User data is limited to 16 KB. You must provide base64-encoded text. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-base64.html">Fn::Base64</a> .
         *                 <p>
         *                 User data runs only at instance launch. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Run commands on your Linux instance at launch</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-windows-user-data.html">Run commands on your Windows instance at launch</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(java.lang.String userData) {
            this.userData = userData;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getVolumes}
         * @param volumes The volumes to attach to the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(software.amazon.awscdk.core.IResolvable volumes) {
            this.volumes = volumes;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getVolumes}
         * @param volumes The volumes to attach to the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(java.util.List<? extends java.lang.Object> volumes) {
            this.volumes = volumes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInstanceProps {
        private final java.lang.String additionalInfo;
        private final java.lang.String affinity;
        private final java.lang.String availabilityZone;
        private final java.lang.Object blockDeviceMappings;
        private final java.lang.Object cpuOptions;
        private final java.lang.Object creditSpecification;
        private final java.lang.Object disableApiTermination;
        private final java.lang.Object ebsOptimized;
        private final java.lang.Object elasticGpuSpecifications;
        private final java.lang.Object elasticInferenceAccelerators;
        private final java.lang.Object enclaveOptions;
        private final java.lang.Object hibernationOptions;
        private final java.lang.String hostId;
        private final java.lang.String hostResourceGroupArn;
        private final java.lang.String iamInstanceProfile;
        private final java.lang.String imageId;
        private final java.lang.String instanceInitiatedShutdownBehavior;
        private final java.lang.String instanceType;
        private final java.lang.Number ipv6AddressCount;
        private final java.lang.Object ipv6Addresses;
        private final java.lang.String kernelId;
        private final java.lang.String keyName;
        private final java.lang.Object launchTemplate;
        private final java.lang.Object licenseSpecifications;
        private final java.lang.Object monitoring;
        private final java.lang.Object networkInterfaces;
        private final java.lang.String placementGroupName;
        private final java.lang.Object privateDnsNameOptions;
        private final java.lang.String privateIpAddress;
        private final java.lang.Object propagateTagsToVolumeOnCreation;
        private final java.lang.String ramdiskId;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.util.List<java.lang.String> securityGroups;
        private final java.lang.Object sourceDestCheck;
        private final java.lang.Object ssmAssociations;
        private final java.lang.String subnetId;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.String tenancy;
        private final java.lang.String userData;
        private final java.lang.Object volumes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.additionalInfo = software.amazon.jsii.Kernel.get(this, "additionalInfo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.affinity = software.amazon.jsii.Kernel.get(this, "affinity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.blockDeviceMappings = software.amazon.jsii.Kernel.get(this, "blockDeviceMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cpuOptions = software.amazon.jsii.Kernel.get(this, "cpuOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.creditSpecification = software.amazon.jsii.Kernel.get(this, "creditSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.disableApiTermination = software.amazon.jsii.Kernel.get(this, "disableApiTermination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ebsOptimized = software.amazon.jsii.Kernel.get(this, "ebsOptimized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.elasticGpuSpecifications = software.amazon.jsii.Kernel.get(this, "elasticGpuSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.elasticInferenceAccelerators = software.amazon.jsii.Kernel.get(this, "elasticInferenceAccelerators", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enclaveOptions = software.amazon.jsii.Kernel.get(this, "enclaveOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.hibernationOptions = software.amazon.jsii.Kernel.get(this, "hibernationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.hostId = software.amazon.jsii.Kernel.get(this, "hostId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hostResourceGroupArn = software.amazon.jsii.Kernel.get(this, "hostResourceGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.iamInstanceProfile = software.amazon.jsii.Kernel.get(this, "iamInstanceProfile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageId = software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceInitiatedShutdownBehavior = software.amazon.jsii.Kernel.get(this, "instanceInitiatedShutdownBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipv6AddressCount = software.amazon.jsii.Kernel.get(this, "ipv6AddressCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ipv6Addresses = software.amazon.jsii.Kernel.get(this, "ipv6Addresses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kernelId = software.amazon.jsii.Kernel.get(this, "kernelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.launchTemplate = software.amazon.jsii.Kernel.get(this, "launchTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.licenseSpecifications = software.amazon.jsii.Kernel.get(this, "licenseSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.monitoring = software.amazon.jsii.Kernel.get(this, "monitoring", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.networkInterfaces = software.amazon.jsii.Kernel.get(this, "networkInterfaces", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.placementGroupName = software.amazon.jsii.Kernel.get(this, "placementGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.privateDnsNameOptions = software.amazon.jsii.Kernel.get(this, "privateDnsNameOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.privateIpAddress = software.amazon.jsii.Kernel.get(this, "privateIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.propagateTagsToVolumeOnCreation = software.amazon.jsii.Kernel.get(this, "propagateTagsToVolumeOnCreation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ramdiskId = software.amazon.jsii.Kernel.get(this, "ramdiskId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.sourceDestCheck = software.amazon.jsii.Kernel.get(this, "sourceDestCheck", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ssmAssociations = software.amazon.jsii.Kernel.get(this, "ssmAssociations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.tenancy = software.amazon.jsii.Kernel.get(this, "tenancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userData = software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.additionalInfo = builder.additionalInfo;
            this.affinity = builder.affinity;
            this.availabilityZone = builder.availabilityZone;
            this.blockDeviceMappings = builder.blockDeviceMappings;
            this.cpuOptions = builder.cpuOptions;
            this.creditSpecification = builder.creditSpecification;
            this.disableApiTermination = builder.disableApiTermination;
            this.ebsOptimized = builder.ebsOptimized;
            this.elasticGpuSpecifications = builder.elasticGpuSpecifications;
            this.elasticInferenceAccelerators = builder.elasticInferenceAccelerators;
            this.enclaveOptions = builder.enclaveOptions;
            this.hibernationOptions = builder.hibernationOptions;
            this.hostId = builder.hostId;
            this.hostResourceGroupArn = builder.hostResourceGroupArn;
            this.iamInstanceProfile = builder.iamInstanceProfile;
            this.imageId = builder.imageId;
            this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
            this.instanceType = builder.instanceType;
            this.ipv6AddressCount = builder.ipv6AddressCount;
            this.ipv6Addresses = builder.ipv6Addresses;
            this.kernelId = builder.kernelId;
            this.keyName = builder.keyName;
            this.launchTemplate = builder.launchTemplate;
            this.licenseSpecifications = builder.licenseSpecifications;
            this.monitoring = builder.monitoring;
            this.networkInterfaces = builder.networkInterfaces;
            this.placementGroupName = builder.placementGroupName;
            this.privateDnsNameOptions = builder.privateDnsNameOptions;
            this.privateIpAddress = builder.privateIpAddress;
            this.propagateTagsToVolumeOnCreation = builder.propagateTagsToVolumeOnCreation;
            this.ramdiskId = builder.ramdiskId;
            this.securityGroupIds = builder.securityGroupIds;
            this.securityGroups = builder.securityGroups;
            this.sourceDestCheck = builder.sourceDestCheck;
            this.ssmAssociations = builder.ssmAssociations;
            this.subnetId = builder.subnetId;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.tenancy = builder.tenancy;
            this.userData = builder.userData;
            this.volumes = builder.volumes;
        }

        @Override
        public final java.lang.String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final java.lang.String getAffinity() {
            return this.affinity;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.Object getBlockDeviceMappings() {
            return this.blockDeviceMappings;
        }

        @Override
        public final java.lang.Object getCpuOptions() {
            return this.cpuOptions;
        }

        @Override
        public final java.lang.Object getCreditSpecification() {
            return this.creditSpecification;
        }

        @Override
        public final java.lang.Object getDisableApiTermination() {
            return this.disableApiTermination;
        }

        @Override
        public final java.lang.Object getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final java.lang.Object getElasticGpuSpecifications() {
            return this.elasticGpuSpecifications;
        }

        @Override
        public final java.lang.Object getElasticInferenceAccelerators() {
            return this.elasticInferenceAccelerators;
        }

        @Override
        public final java.lang.Object getEnclaveOptions() {
            return this.enclaveOptions;
        }

        @Override
        public final java.lang.Object getHibernationOptions() {
            return this.hibernationOptions;
        }

        @Override
        public final java.lang.String getHostId() {
            return this.hostId;
        }

        @Override
        public final java.lang.String getHostResourceGroupArn() {
            return this.hostResourceGroupArn;
        }

        @Override
        public final java.lang.String getIamInstanceProfile() {
            return this.iamInstanceProfile;
        }

        @Override
        public final java.lang.String getImageId() {
            return this.imageId;
        }

        @Override
        public final java.lang.String getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        @Override
        public final java.lang.String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.Number getIpv6AddressCount() {
            return this.ipv6AddressCount;
        }

        @Override
        public final java.lang.Object getIpv6Addresses() {
            return this.ipv6Addresses;
        }

        @Override
        public final java.lang.String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        public final java.lang.Object getLaunchTemplate() {
            return this.launchTemplate;
        }

        @Override
        public final java.lang.Object getLicenseSpecifications() {
            return this.licenseSpecifications;
        }

        @Override
        public final java.lang.Object getMonitoring() {
            return this.monitoring;
        }

        @Override
        public final java.lang.Object getNetworkInterfaces() {
            return this.networkInterfaces;
        }

        @Override
        public final java.lang.String getPlacementGroupName() {
            return this.placementGroupName;
        }

        @Override
        public final java.lang.Object getPrivateDnsNameOptions() {
            return this.privateDnsNameOptions;
        }

        @Override
        public final java.lang.String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final java.lang.Object getPropagateTagsToVolumeOnCreation() {
            return this.propagateTagsToVolumeOnCreation;
        }

        @Override
        public final java.lang.String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final java.lang.Object getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final java.lang.Object getSsmAssociations() {
            return this.ssmAssociations;
        }

        @Override
        public final java.lang.String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTenancy() {
            return this.tenancy;
        }

        @Override
        public final java.lang.String getUserData() {
            return this.userData;
        }

        @Override
        public final java.lang.Object getVolumes() {
            return this.volumes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdditionalInfo() != null) {
                data.set("additionalInfo", om.valueToTree(this.getAdditionalInfo()));
            }
            if (this.getAffinity() != null) {
                data.set("affinity", om.valueToTree(this.getAffinity()));
            }
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getBlockDeviceMappings() != null) {
                data.set("blockDeviceMappings", om.valueToTree(this.getBlockDeviceMappings()));
            }
            if (this.getCpuOptions() != null) {
                data.set("cpuOptions", om.valueToTree(this.getCpuOptions()));
            }
            if (this.getCreditSpecification() != null) {
                data.set("creditSpecification", om.valueToTree(this.getCreditSpecification()));
            }
            if (this.getDisableApiTermination() != null) {
                data.set("disableApiTermination", om.valueToTree(this.getDisableApiTermination()));
            }
            if (this.getEbsOptimized() != null) {
                data.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
            }
            if (this.getElasticGpuSpecifications() != null) {
                data.set("elasticGpuSpecifications", om.valueToTree(this.getElasticGpuSpecifications()));
            }
            if (this.getElasticInferenceAccelerators() != null) {
                data.set("elasticInferenceAccelerators", om.valueToTree(this.getElasticInferenceAccelerators()));
            }
            if (this.getEnclaveOptions() != null) {
                data.set("enclaveOptions", om.valueToTree(this.getEnclaveOptions()));
            }
            if (this.getHibernationOptions() != null) {
                data.set("hibernationOptions", om.valueToTree(this.getHibernationOptions()));
            }
            if (this.getHostId() != null) {
                data.set("hostId", om.valueToTree(this.getHostId()));
            }
            if (this.getHostResourceGroupArn() != null) {
                data.set("hostResourceGroupArn", om.valueToTree(this.getHostResourceGroupArn()));
            }
            if (this.getIamInstanceProfile() != null) {
                data.set("iamInstanceProfile", om.valueToTree(this.getIamInstanceProfile()));
            }
            if (this.getImageId() != null) {
                data.set("imageId", om.valueToTree(this.getImageId()));
            }
            if (this.getInstanceInitiatedShutdownBehavior() != null) {
                data.set("instanceInitiatedShutdownBehavior", om.valueToTree(this.getInstanceInitiatedShutdownBehavior()));
            }
            if (this.getInstanceType() != null) {
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
            }
            if (this.getIpv6AddressCount() != null) {
                data.set("ipv6AddressCount", om.valueToTree(this.getIpv6AddressCount()));
            }
            if (this.getIpv6Addresses() != null) {
                data.set("ipv6Addresses", om.valueToTree(this.getIpv6Addresses()));
            }
            if (this.getKernelId() != null) {
                data.set("kernelId", om.valueToTree(this.getKernelId()));
            }
            if (this.getKeyName() != null) {
                data.set("keyName", om.valueToTree(this.getKeyName()));
            }
            if (this.getLaunchTemplate() != null) {
                data.set("launchTemplate", om.valueToTree(this.getLaunchTemplate()));
            }
            if (this.getLicenseSpecifications() != null) {
                data.set("licenseSpecifications", om.valueToTree(this.getLicenseSpecifications()));
            }
            if (this.getMonitoring() != null) {
                data.set("monitoring", om.valueToTree(this.getMonitoring()));
            }
            if (this.getNetworkInterfaces() != null) {
                data.set("networkInterfaces", om.valueToTree(this.getNetworkInterfaces()));
            }
            if (this.getPlacementGroupName() != null) {
                data.set("placementGroupName", om.valueToTree(this.getPlacementGroupName()));
            }
            if (this.getPrivateDnsNameOptions() != null) {
                data.set("privateDnsNameOptions", om.valueToTree(this.getPrivateDnsNameOptions()));
            }
            if (this.getPrivateIpAddress() != null) {
                data.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
            }
            if (this.getPropagateTagsToVolumeOnCreation() != null) {
                data.set("propagateTagsToVolumeOnCreation", om.valueToTree(this.getPropagateTagsToVolumeOnCreation()));
            }
            if (this.getRamdiskId() != null) {
                data.set("ramdiskId", om.valueToTree(this.getRamdiskId()));
            }
            if (this.getSecurityGroupIds() != null) {
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSourceDestCheck() != null) {
                data.set("sourceDestCheck", om.valueToTree(this.getSourceDestCheck()));
            }
            if (this.getSsmAssociations() != null) {
                data.set("ssmAssociations", om.valueToTree(this.getSsmAssociations()));
            }
            if (this.getSubnetId() != null) {
                data.set("subnetId", om.valueToTree(this.getSubnetId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTenancy() != null) {
                data.set("tenancy", om.valueToTree(this.getTenancy()));
            }
            if (this.getUserData() != null) {
                data.set("userData", om.valueToTree(this.getUserData()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInstanceProps.Jsii$Proxy that = (CfnInstanceProps.Jsii$Proxy) o;

            if (this.additionalInfo != null ? !this.additionalInfo.equals(that.additionalInfo) : that.additionalInfo != null) return false;
            if (this.affinity != null ? !this.affinity.equals(that.affinity) : that.affinity != null) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.blockDeviceMappings != null ? !this.blockDeviceMappings.equals(that.blockDeviceMappings) : that.blockDeviceMappings != null) return false;
            if (this.cpuOptions != null ? !this.cpuOptions.equals(that.cpuOptions) : that.cpuOptions != null) return false;
            if (this.creditSpecification != null ? !this.creditSpecification.equals(that.creditSpecification) : that.creditSpecification != null) return false;
            if (this.disableApiTermination != null ? !this.disableApiTermination.equals(that.disableApiTermination) : that.disableApiTermination != null) return false;
            if (this.ebsOptimized != null ? !this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized != null) return false;
            if (this.elasticGpuSpecifications != null ? !this.elasticGpuSpecifications.equals(that.elasticGpuSpecifications) : that.elasticGpuSpecifications != null) return false;
            if (this.elasticInferenceAccelerators != null ? !this.elasticInferenceAccelerators.equals(that.elasticInferenceAccelerators) : that.elasticInferenceAccelerators != null) return false;
            if (this.enclaveOptions != null ? !this.enclaveOptions.equals(that.enclaveOptions) : that.enclaveOptions != null) return false;
            if (this.hibernationOptions != null ? !this.hibernationOptions.equals(that.hibernationOptions) : that.hibernationOptions != null) return false;
            if (this.hostId != null ? !this.hostId.equals(that.hostId) : that.hostId != null) return false;
            if (this.hostResourceGroupArn != null ? !this.hostResourceGroupArn.equals(that.hostResourceGroupArn) : that.hostResourceGroupArn != null) return false;
            if (this.iamInstanceProfile != null ? !this.iamInstanceProfile.equals(that.iamInstanceProfile) : that.iamInstanceProfile != null) return false;
            if (this.imageId != null ? !this.imageId.equals(that.imageId) : that.imageId != null) return false;
            if (this.instanceInitiatedShutdownBehavior != null ? !this.instanceInitiatedShutdownBehavior.equals(that.instanceInitiatedShutdownBehavior) : that.instanceInitiatedShutdownBehavior != null) return false;
            if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
            if (this.ipv6AddressCount != null ? !this.ipv6AddressCount.equals(that.ipv6AddressCount) : that.ipv6AddressCount != null) return false;
            if (this.ipv6Addresses != null ? !this.ipv6Addresses.equals(that.ipv6Addresses) : that.ipv6Addresses != null) return false;
            if (this.kernelId != null ? !this.kernelId.equals(that.kernelId) : that.kernelId != null) return false;
            if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
            if (this.launchTemplate != null ? !this.launchTemplate.equals(that.launchTemplate) : that.launchTemplate != null) return false;
            if (this.licenseSpecifications != null ? !this.licenseSpecifications.equals(that.licenseSpecifications) : that.licenseSpecifications != null) return false;
            if (this.monitoring != null ? !this.monitoring.equals(that.monitoring) : that.monitoring != null) return false;
            if (this.networkInterfaces != null ? !this.networkInterfaces.equals(that.networkInterfaces) : that.networkInterfaces != null) return false;
            if (this.placementGroupName != null ? !this.placementGroupName.equals(that.placementGroupName) : that.placementGroupName != null) return false;
            if (this.privateDnsNameOptions != null ? !this.privateDnsNameOptions.equals(that.privateDnsNameOptions) : that.privateDnsNameOptions != null) return false;
            if (this.privateIpAddress != null ? !this.privateIpAddress.equals(that.privateIpAddress) : that.privateIpAddress != null) return false;
            if (this.propagateTagsToVolumeOnCreation != null ? !this.propagateTagsToVolumeOnCreation.equals(that.propagateTagsToVolumeOnCreation) : that.propagateTagsToVolumeOnCreation != null) return false;
            if (this.ramdiskId != null ? !this.ramdiskId.equals(that.ramdiskId) : that.ramdiskId != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.sourceDestCheck != null ? !this.sourceDestCheck.equals(that.sourceDestCheck) : that.sourceDestCheck != null) return false;
            if (this.ssmAssociations != null ? !this.ssmAssociations.equals(that.ssmAssociations) : that.ssmAssociations != null) return false;
            if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.tenancy != null ? !this.tenancy.equals(that.tenancy) : that.tenancy != null) return false;
            if (this.userData != null ? !this.userData.equals(that.userData) : that.userData != null) return false;
            return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.additionalInfo != null ? this.additionalInfo.hashCode() : 0;
            result = 31 * result + (this.affinity != null ? this.affinity.hashCode() : 0);
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.blockDeviceMappings != null ? this.blockDeviceMappings.hashCode() : 0);
            result = 31 * result + (this.cpuOptions != null ? this.cpuOptions.hashCode() : 0);
            result = 31 * result + (this.creditSpecification != null ? this.creditSpecification.hashCode() : 0);
            result = 31 * result + (this.disableApiTermination != null ? this.disableApiTermination.hashCode() : 0);
            result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
            result = 31 * result + (this.elasticGpuSpecifications != null ? this.elasticGpuSpecifications.hashCode() : 0);
            result = 31 * result + (this.elasticInferenceAccelerators != null ? this.elasticInferenceAccelerators.hashCode() : 0);
            result = 31 * result + (this.enclaveOptions != null ? this.enclaveOptions.hashCode() : 0);
            result = 31 * result + (this.hibernationOptions != null ? this.hibernationOptions.hashCode() : 0);
            result = 31 * result + (this.hostId != null ? this.hostId.hashCode() : 0);
            result = 31 * result + (this.hostResourceGroupArn != null ? this.hostResourceGroupArn.hashCode() : 0);
            result = 31 * result + (this.iamInstanceProfile != null ? this.iamInstanceProfile.hashCode() : 0);
            result = 31 * result + (this.imageId != null ? this.imageId.hashCode() : 0);
            result = 31 * result + (this.instanceInitiatedShutdownBehavior != null ? this.instanceInitiatedShutdownBehavior.hashCode() : 0);
            result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
            result = 31 * result + (this.ipv6AddressCount != null ? this.ipv6AddressCount.hashCode() : 0);
            result = 31 * result + (this.ipv6Addresses != null ? this.ipv6Addresses.hashCode() : 0);
            result = 31 * result + (this.kernelId != null ? this.kernelId.hashCode() : 0);
            result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
            result = 31 * result + (this.launchTemplate != null ? this.launchTemplate.hashCode() : 0);
            result = 31 * result + (this.licenseSpecifications != null ? this.licenseSpecifications.hashCode() : 0);
            result = 31 * result + (this.monitoring != null ? this.monitoring.hashCode() : 0);
            result = 31 * result + (this.networkInterfaces != null ? this.networkInterfaces.hashCode() : 0);
            result = 31 * result + (this.placementGroupName != null ? this.placementGroupName.hashCode() : 0);
            result = 31 * result + (this.privateDnsNameOptions != null ? this.privateDnsNameOptions.hashCode() : 0);
            result = 31 * result + (this.privateIpAddress != null ? this.privateIpAddress.hashCode() : 0);
            result = 31 * result + (this.propagateTagsToVolumeOnCreation != null ? this.propagateTagsToVolumeOnCreation.hashCode() : 0);
            result = 31 * result + (this.ramdiskId != null ? this.ramdiskId.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.sourceDestCheck != null ? this.sourceDestCheck.hashCode() : 0);
            result = 31 * result + (this.ssmAssociations != null ? this.ssmAssociations.hashCode() : 0);
            result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.tenancy != null ? this.tenancy.hashCode() : 0);
            result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            return result;
        }
    }
}
