package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 * <p>
 * Specifies the properties for creating a launch template.
 * <p>
 * The minimum required properties for specifying a launch template are as follows:
 * <p>
 * <ul>
 * <li>You must specify at least one property for the launch template data.</li>
 * <li>You do not need to specify a name for the launch template. If you do not specify a name, AWS CloudFormation creates the name for you.</li>
 * </ul>
 * <p>
 * A launch template can contain some or all of the configuration information to launch an instance. When you launch an instance using a launch template, instance properties that are not specified in the launch template use default values, except the <code>ImageId</code> property, which has no default value. If you do not specify an AMI ID for the launch template <code>ImageId</code> property, you must specify an AMI ID for the instance <code>ImageId</code> property.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launch an instance from a launch template</a> in the <em>Amazon EC2 User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * String userData = "MIME-Version: 1.0\nContent-Type: multipart/mixed; boundary=\"==MYBOUNDARY==\"\n\n--==MYBOUNDARY==\nContent-Type: text/x-shellscript; charset=\"us-ascii\"\n\n#!/bin/bash\necho \"Running custom user data script\"\n\n--==MYBOUNDARY==--\\\n";
 * CfnLaunchTemplate lt = CfnLaunchTemplate.Builder.create(this, "LaunchTemplate")
 *         .launchTemplateData(LaunchTemplateDataProperty.builder()
 *                 .instanceType("t3.small")
 *                 .userData(Fn.base64(userData))
 *                 .build())
 *         .build();
 * cluster.addNodegroupCapacity("extra-ng", NodegroupOptions.builder()
 *         .launchTemplateSpec(LaunchTemplateSpec.builder()
 *                 .id(lt.getRef())
 *                 .version(lt.getAttrLatestVersionNumber())
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-21T19:24:04.798Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate")
public class CfnLaunchTemplate extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnLaunchTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLaunchTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::LaunchTemplate`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLaunchTemplate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The default version of the launch template, such as 2.
     * <p>
     * The default version of a launch template cannot be specified in AWS CloudFormation . The default version can be set in the Amazon EC2 console or by using the <code>modify-launch-template</code> AWS CLI command.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDefaultVersionNumber() {
        return software.amazon.jsii.Kernel.get(this, "attrDefaultVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The latest version of the launch template, such as `5` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLatestVersionNumber() {
        return software.amazon.jsii.Kernel.get(this, "attrLatestVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The information for the launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getLaunchTemplateData() {
        return software.amazon.jsii.Kernel.get(this, "launchTemplateData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The information for the launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchTemplateData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "launchTemplateData", java.util.Objects.requireNonNull(value, "launchTemplateData is required"));
    }

    /**
     * The information for the launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchTemplateData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LaunchTemplateDataProperty value) {
        software.amazon.jsii.Kernel.set(this, "launchTemplateData", java.util.Objects.requireNonNull(value, "launchTemplateData is required"));
    }

    /**
     * A name for the launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateName() {
        return software.amazon.jsii.Kernel.get(this, "launchTemplateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchTemplateName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "launchTemplateName", value);
    }

    /**
     * The tags to apply to the launch template on creation.
     * <p>
     * To tag the launch template, the resource type must be <code>launch-template</code> .
     * <p>
     * <blockquote>
     * <p>
     * To specify the tags for the resources that are created when an instance is launched, you must use the <code>TagSpecifications</code> parameter in the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestLaunchTemplateData.html">launch template data</a> structure.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "tagSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The tags to apply to the launch template on creation.
     * <p>
     * To tag the launch template, the resource type must be <code>launch-template</code> .
     * <p>
     * <blockquote>
     * <p>
     * To specify the tags for the resources that are created when an instance is launched, you must use the <code>TagSpecifications</code> parameter in the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestLaunchTemplateData.html">launch template data</a> structure.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tagSpecifications", value);
    }

    /**
     * The tags to apply to the launch template on creation.
     * <p>
     * To tag the launch template, the resource type must be <code>launch-template</code> .
     * <p>
     * <blockquote>
     * <p>
     * To specify the tags for the resources that are created when an instance is launched, you must use the <code>TagSpecifications</code> parameter in the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestLaunchTemplateData.html">launch template data</a> structure.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagSpecifications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LaunchTemplateTagSpecificationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LaunchTemplateTagSpecificationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "tagSpecifications", value);
    }

    /**
     * A description for the first version of the launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVersionDescription() {
        return software.amazon.jsii.Kernel.get(this, "versionDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description for the first version of the launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersionDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "versionDescription", value);
    }
    /**
     * The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) on an instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AcceleratorCountProperty acceleratorCountProperty = AcceleratorCountProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.AcceleratorCountProperty")
    @software.amazon.jsii.Jsii.Proxy(AcceleratorCountProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AcceleratorCountProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of accelerators.
         * <p>
         * To specify no maximum limit, omit this parameter. To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum number of accelerators.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AcceleratorCountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AcceleratorCountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AcceleratorCountProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link AcceleratorCountProperty#getMax}
             * @param max The maximum number of accelerators.
             *            To specify no maximum limit, omit this parameter. To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link AcceleratorCountProperty#getMin}
             * @param min The minimum number of accelerators.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AcceleratorCountProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AcceleratorCountProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AcceleratorCountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorCountProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.AcceleratorCountProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AcceleratorCountProperty.Jsii$Proxy that = (AcceleratorCountProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of total accelerator memory, in MiB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AcceleratorTotalMemoryMiBProperty acceleratorTotalMemoryMiBProperty = AcceleratorTotalMemoryMiBProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.AcceleratorTotalMemoryMiBProperty")
    @software.amazon.jsii.Jsii.Proxy(AcceleratorTotalMemoryMiBProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AcceleratorTotalMemoryMiBProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of accelerator memory, in MiB.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of accelerator memory, in MiB.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AcceleratorTotalMemoryMiBProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AcceleratorTotalMemoryMiBProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AcceleratorTotalMemoryMiBProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link AcceleratorTotalMemoryMiBProperty#getMax}
             * @param max The maximum amount of accelerator memory, in MiB.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link AcceleratorTotalMemoryMiBProperty#getMin}
             * @param min The minimum amount of accelerator memory, in MiB.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AcceleratorTotalMemoryMiBProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AcceleratorTotalMemoryMiBProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AcceleratorTotalMemoryMiBProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorTotalMemoryMiBProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.AcceleratorTotalMemoryMiBProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AcceleratorTotalMemoryMiBProperty.Jsii$Proxy that = (AcceleratorTotalMemoryMiBProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * BaselineEbsBandwidthMbpsProperty baselineEbsBandwidthMbpsProperty = BaselineEbsBandwidthMbpsProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.BaselineEbsBandwidthMbpsProperty")
    @software.amazon.jsii.Jsii.Proxy(BaselineEbsBandwidthMbpsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BaselineEbsBandwidthMbpsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum baseline bandwidth, in Mbps.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum baseline bandwidth, in Mbps.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BaselineEbsBandwidthMbpsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BaselineEbsBandwidthMbpsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BaselineEbsBandwidthMbpsProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link BaselineEbsBandwidthMbpsProperty#getMax}
             * @param max The maximum baseline bandwidth, in Mbps.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link BaselineEbsBandwidthMbpsProperty#getMin}
             * @param min The minimum baseline bandwidth, in Mbps.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BaselineEbsBandwidthMbpsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BaselineEbsBandwidthMbpsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BaselineEbsBandwidthMbpsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaselineEbsBandwidthMbpsProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.BaselineEbsBandwidthMbpsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BaselineEbsBandwidthMbpsProperty.Jsii$Proxy that = (BaselineEbsBandwidthMbpsProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a block device mapping for an Amazon EC2 launch template.
     * <p>
     * <code>BlockDeviceMapping</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html">AWS::EC2::LaunchTemplate LaunchTemplateData</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * BlockDeviceMappingProperty blockDeviceMappingProperty = BlockDeviceMappingProperty.builder()
     *         .deviceName("deviceName")
     *         .ebs(EbsProperty.builder()
     *                 .deleteOnTermination(false)
     *                 .encrypted(false)
     *                 .iops(123)
     *                 .kmsKeyId("kmsKeyId")
     *                 .snapshotId("snapshotId")
     *                 .throughput(123)
     *                 .volumeSize(123)
     *                 .volumeType("volumeType")
     *                 .build())
     *         .noDevice("noDevice")
     *         .virtualName("virtualName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.BlockDeviceMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(BlockDeviceMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The device name (for example, /dev/sdh or xvdh).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeviceName() {
            return null;
        }

        /**
         * Parameters used to automatically set up EBS volumes when the instance is launched.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbs() {
            return null;
        }

        /**
         * To omit the device from the block device mapping, specify an empty string.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNoDevice() {
            return null;
        }

        /**
         * The virtual device name (ephemeralN).
         * <p>
         * Instance store volumes are numbered starting from 0. An instance type with 2 available instance store volumes can specify mappings for ephemeral0 and ephemeral1. The number of available instance store volumes depends on the instance type. After you connect to the instance, you must mount the volume.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVirtualName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BlockDeviceMappingProperty> {
            java.lang.String deviceName;
            java.lang.Object ebs;
            java.lang.String noDevice;
            java.lang.String virtualName;

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getDeviceName}
             * @param deviceName The device name (for example, /dev/sdh or xvdh).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceName(java.lang.String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getEbs}
             * @param ebs Parameters used to automatically set up EBS volumes when the instance is launched.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebs(software.amazon.awscdk.core.IResolvable ebs) {
                this.ebs = ebs;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getEbs}
             * @param ebs Parameters used to automatically set up EBS volumes when the instance is launched.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebs(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.EbsProperty ebs) {
                this.ebs = ebs;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getNoDevice}
             * @param noDevice To omit the device from the block device mapping, specify an empty string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noDevice(java.lang.String noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getVirtualName}
             * @param virtualName The virtual device name (ephemeralN).
             *                    Instance store volumes are numbered starting from 0. An instance type with 2 available instance store volumes can specify mappings for ephemeral0 and ephemeral1. The number of available instance store volumes depends on the instance type. After you connect to the instance, you must mount the volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder virtualName(java.lang.String virtualName) {
                this.virtualName = virtualName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockDeviceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BlockDeviceMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlockDeviceMappingProperty {
            private final java.lang.String deviceName;
            private final java.lang.Object ebs;
            private final java.lang.String noDevice;
            private final java.lang.String virtualName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deviceName = software.amazon.jsii.Kernel.get(this, "deviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ebs = software.amazon.jsii.Kernel.get(this, "ebs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noDevice = software.amazon.jsii.Kernel.get(this, "noDevice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.virtualName = software.amazon.jsii.Kernel.get(this, "virtualName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deviceName = builder.deviceName;
                this.ebs = builder.ebs;
                this.noDevice = builder.noDevice;
                this.virtualName = builder.virtualName;
            }

            @Override
            public final java.lang.String getDeviceName() {
                return this.deviceName;
            }

            @Override
            public final java.lang.Object getEbs() {
                return this.ebs;
            }

            @Override
            public final java.lang.String getNoDevice() {
                return this.noDevice;
            }

            @Override
            public final java.lang.String getVirtualName() {
                return this.virtualName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeviceName() != null) {
                    data.set("deviceName", om.valueToTree(this.getDeviceName()));
                }
                if (this.getEbs() != null) {
                    data.set("ebs", om.valueToTree(this.getEbs()));
                }
                if (this.getNoDevice() != null) {
                    data.set("noDevice", om.valueToTree(this.getNoDevice()));
                }
                if (this.getVirtualName() != null) {
                    data.set("virtualName", om.valueToTree(this.getVirtualName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.BlockDeviceMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BlockDeviceMappingProperty.Jsii$Proxy that = (BlockDeviceMappingProperty.Jsii$Proxy) o;

                if (this.deviceName != null ? !this.deviceName.equals(that.deviceName) : that.deviceName != null) return false;
                if (this.ebs != null ? !this.ebs.equals(that.ebs) : that.ebs != null) return false;
                if (this.noDevice != null ? !this.noDevice.equals(that.noDevice) : that.noDevice != null) return false;
                return this.virtualName != null ? this.virtualName.equals(that.virtualName) : that.virtualName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deviceName != null ? this.deviceName.hashCode() : 0;
                result = 31 * result + (this.ebs != null ? this.ebs.hashCode() : 0);
                result = 31 * result + (this.noDevice != null ? this.noDevice.hashCode() : 0);
                result = 31 * result + (this.virtualName != null ? this.virtualName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an instance's Capacity Reservation targeting option. You can specify only one option at a time.
     * <p>
     * <code>CapacityReservationSpecification</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html">AWS::EC2::LaunchTemplate LaunchTemplateData</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * CapacityReservationSpecificationProperty capacityReservationSpecificationProperty = CapacityReservationSpecificationProperty.builder()
     *         .capacityReservationPreference("capacityReservationPreference")
     *         .capacityReservationTarget(CapacityReservationTargetProperty.builder()
     *                 .capacityReservationId("capacityReservationId")
     *                 .capacityReservationResourceGroupArn("capacityReservationResourceGroupArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.CapacityReservationSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityReservationSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityReservationSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates the instance's Capacity Reservation preferences. Possible preferences include:.
         * <p>
         * <ul>
         * <li><code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</li>
         * <li><code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs in On-Demand capacity.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCapacityReservationPreference() {
            return null;
        }

        /**
         * Information about the target Capacity Reservation or Capacity Reservation group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityReservationTarget() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityReservationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityReservationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityReservationSpecificationProperty> {
            java.lang.String capacityReservationPreference;
            java.lang.Object capacityReservationTarget;

            /**
             * Sets the value of {@link CapacityReservationSpecificationProperty#getCapacityReservationPreference}
             * @param capacityReservationPreference Indicates the instance's Capacity Reservation preferences. Possible preferences include:.
             *                                      <ul>
             *                                      <li><code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</li>
             *                                      <li><code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs in On-Demand capacity.</li>
             *                                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationPreference(java.lang.String capacityReservationPreference) {
                this.capacityReservationPreference = capacityReservationPreference;
                return this;
            }

            /**
             * Sets the value of {@link CapacityReservationSpecificationProperty#getCapacityReservationTarget}
             * @param capacityReservationTarget Information about the target Capacity Reservation or Capacity Reservation group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationTarget(software.amazon.awscdk.core.IResolvable capacityReservationTarget) {
                this.capacityReservationTarget = capacityReservationTarget;
                return this;
            }

            /**
             * Sets the value of {@link CapacityReservationSpecificationProperty#getCapacityReservationTarget}
             * @param capacityReservationTarget Information about the target Capacity Reservation or Capacity Reservation group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationTarget(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CapacityReservationTargetProperty capacityReservationTarget) {
                this.capacityReservationTarget = capacityReservationTarget;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityReservationSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityReservationSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityReservationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityReservationSpecificationProperty {
            private final java.lang.String capacityReservationPreference;
            private final java.lang.Object capacityReservationTarget;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.capacityReservationPreference = software.amazon.jsii.Kernel.get(this, "capacityReservationPreference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.capacityReservationTarget = software.amazon.jsii.Kernel.get(this, "capacityReservationTarget", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.capacityReservationPreference = builder.capacityReservationPreference;
                this.capacityReservationTarget = builder.capacityReservationTarget;
            }

            @Override
            public final java.lang.String getCapacityReservationPreference() {
                return this.capacityReservationPreference;
            }

            @Override
            public final java.lang.Object getCapacityReservationTarget() {
                return this.capacityReservationTarget;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCapacityReservationPreference() != null) {
                    data.set("capacityReservationPreference", om.valueToTree(this.getCapacityReservationPreference()));
                }
                if (this.getCapacityReservationTarget() != null) {
                    data.set("capacityReservationTarget", om.valueToTree(this.getCapacityReservationTarget()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.CapacityReservationSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityReservationSpecificationProperty.Jsii$Proxy that = (CapacityReservationSpecificationProperty.Jsii$Proxy) o;

                if (this.capacityReservationPreference != null ? !this.capacityReservationPreference.equals(that.capacityReservationPreference) : that.capacityReservationPreference != null) return false;
                return this.capacityReservationTarget != null ? this.capacityReservationTarget.equals(that.capacityReservationTarget) : that.capacityReservationTarget == null;
            }

            @Override
            public final int hashCode() {
                int result = this.capacityReservationPreference != null ? this.capacityReservationPreference.hashCode() : 0;
                result = 31 * result + (this.capacityReservationTarget != null ? this.capacityReservationTarget.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a target Capacity Reservation.
     * <p>
     * <code>CapacityReservationTarget</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html">Amazon EC2 LaunchTemplate LaunchTemplateData</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * CapacityReservationTargetProperty capacityReservationTargetProperty = CapacityReservationTargetProperty.builder()
     *         .capacityReservationId("capacityReservationId")
     *         .capacityReservationResourceGroupArn("capacityReservationResourceGroupArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.CapacityReservationTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityReservationTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityReservationTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the Capacity Reservation in which to run the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCapacityReservationId() {
            return null;
        }

        /**
         * The ARN of the Capacity Reservation resource group in which to run the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCapacityReservationResourceGroupArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityReservationTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityReservationTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityReservationTargetProperty> {
            java.lang.String capacityReservationId;
            java.lang.String capacityReservationResourceGroupArn;

            /**
             * Sets the value of {@link CapacityReservationTargetProperty#getCapacityReservationId}
             * @param capacityReservationId The ID of the Capacity Reservation in which to run the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationId(java.lang.String capacityReservationId) {
                this.capacityReservationId = capacityReservationId;
                return this;
            }

            /**
             * Sets the value of {@link CapacityReservationTargetProperty#getCapacityReservationResourceGroupArn}
             * @param capacityReservationResourceGroupArn The ARN of the Capacity Reservation resource group in which to run the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationResourceGroupArn(java.lang.String capacityReservationResourceGroupArn) {
                this.capacityReservationResourceGroupArn = capacityReservationResourceGroupArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityReservationTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityReservationTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityReservationTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityReservationTargetProperty {
            private final java.lang.String capacityReservationId;
            private final java.lang.String capacityReservationResourceGroupArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.capacityReservationId = software.amazon.jsii.Kernel.get(this, "capacityReservationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.capacityReservationResourceGroupArn = software.amazon.jsii.Kernel.get(this, "capacityReservationResourceGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.capacityReservationId = builder.capacityReservationId;
                this.capacityReservationResourceGroupArn = builder.capacityReservationResourceGroupArn;
            }

            @Override
            public final java.lang.String getCapacityReservationId() {
                return this.capacityReservationId;
            }

            @Override
            public final java.lang.String getCapacityReservationResourceGroupArn() {
                return this.capacityReservationResourceGroupArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCapacityReservationId() != null) {
                    data.set("capacityReservationId", om.valueToTree(this.getCapacityReservationId()));
                }
                if (this.getCapacityReservationResourceGroupArn() != null) {
                    data.set("capacityReservationResourceGroupArn", om.valueToTree(this.getCapacityReservationResourceGroupArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.CapacityReservationTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityReservationTargetProperty.Jsii$Proxy that = (CapacityReservationTargetProperty.Jsii$Proxy) o;

                if (this.capacityReservationId != null ? !this.capacityReservationId.equals(that.capacityReservationId) : that.capacityReservationId != null) return false;
                return this.capacityReservationResourceGroupArn != null ? this.capacityReservationResourceGroupArn.equals(that.capacityReservationResourceGroupArn) : that.capacityReservationResourceGroupArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.capacityReservationId != null ? this.capacityReservationId.hashCode() : 0;
                result = 31 * result + (this.capacityReservationResourceGroupArn != null ? this.capacityReservationResourceGroupArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the CPU options for an instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU options</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
     * <p>
     * <code>CpuOptions</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html">AWS::EC2::LaunchTemplate LaunchTemplateData</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * CpuOptionsProperty cpuOptionsProperty = CpuOptionsProperty.builder()
     *         .coreCount(123)
     *         .threadsPerCore(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.CpuOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(CpuOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CpuOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of CPU cores for the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCoreCount() {
            return null;
        }

        /**
         * The number of threads per CPU core.
         * <p>
         * To disable multithreading for the instance, specify a value of <code>1</code> . Otherwise, specify the default value of <code>2</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThreadsPerCore() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CpuOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CpuOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CpuOptionsProperty> {
            java.lang.Number coreCount;
            java.lang.Number threadsPerCore;

            /**
             * Sets the value of {@link CpuOptionsProperty#getCoreCount}
             * @param coreCount The number of CPU cores for the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coreCount(java.lang.Number coreCount) {
                this.coreCount = coreCount;
                return this;
            }

            /**
             * Sets the value of {@link CpuOptionsProperty#getThreadsPerCore}
             * @param threadsPerCore The number of threads per CPU core.
             *                       To disable multithreading for the instance, specify a value of <code>1</code> . Otherwise, specify the default value of <code>2</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threadsPerCore(java.lang.Number threadsPerCore) {
                this.threadsPerCore = threadsPerCore;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CpuOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CpuOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CpuOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CpuOptionsProperty {
            private final java.lang.Number coreCount;
            private final java.lang.Number threadsPerCore;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.coreCount = software.amazon.jsii.Kernel.get(this, "coreCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.threadsPerCore = software.amazon.jsii.Kernel.get(this, "threadsPerCore", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.coreCount = builder.coreCount;
                this.threadsPerCore = builder.threadsPerCore;
            }

            @Override
            public final java.lang.Number getCoreCount() {
                return this.coreCount;
            }

            @Override
            public final java.lang.Number getThreadsPerCore() {
                return this.threadsPerCore;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCoreCount() != null) {
                    data.set("coreCount", om.valueToTree(this.getCoreCount()));
                }
                if (this.getThreadsPerCore() != null) {
                    data.set("threadsPerCore", om.valueToTree(this.getThreadsPerCore()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.CpuOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CpuOptionsProperty.Jsii$Proxy that = (CpuOptionsProperty.Jsii$Proxy) o;

                if (this.coreCount != null ? !this.coreCount.equals(that.coreCount) : that.coreCount != null) return false;
                return this.threadsPerCore != null ? this.threadsPerCore.equals(that.threadsPerCore) : that.threadsPerCore == null;
            }

            @Override
            public final int hashCode() {
                int result = this.coreCount != null ? this.coreCount.hashCode() : 0;
                result = 31 * result + (this.threadsPerCore != null ? this.threadsPerCore.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the credit option for CPU usage of a T2, T3, or T3a instance.
     * <p>
     * <code>CreditSpecification</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html">AWS::EC2::LaunchTemplate LaunchTemplateData</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * CreditSpecificationProperty creditSpecificationProperty = CreditSpecificationProperty.builder()
     *         .cpuCredits("cpuCredits")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.CreditSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CreditSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CreditSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The credit option for CPU usage of a T instance.
         * <p>
         * Valid values: <code>standard</code> | <code>unlimited</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCpuCredits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CreditSpecificationProperty> {
            java.lang.String cpuCredits;

            /**
             * Sets the value of {@link CreditSpecificationProperty#getCpuCredits}
             * @param cpuCredits The credit option for CPU usage of a T instance.
             *                   Valid values: <code>standard</code> | <code>unlimited</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuCredits(java.lang.String cpuCredits) {
                this.cpuCredits = cpuCredits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreditSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CreditSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreditSpecificationProperty {
            private final java.lang.String cpuCredits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpuCredits = software.amazon.jsii.Kernel.get(this, "cpuCredits", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpuCredits = builder.cpuCredits;
            }

            @Override
            public final java.lang.String getCpuCredits() {
                return this.cpuCredits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCpuCredits() != null) {
                    data.set("cpuCredits", om.valueToTree(this.getCpuCredits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.CreditSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreditSpecificationProperty.Jsii$Proxy that = (CreditSpecificationProperty.Jsii$Proxy) o;

                return this.cpuCredits != null ? this.cpuCredits.equals(that.cpuCredits) : that.cpuCredits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cpuCredits != null ? this.cpuCredits.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Parameters for a block device for an EBS volume in an Amazon EC2 launch template.
     * <p>
     * <code>Ebs</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html">AWS::EC2::LaunchTemplate BlockDeviceMapping</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * EbsProperty ebsProperty = EbsProperty.builder()
     *         .deleteOnTermination(false)
     *         .encrypted(false)
     *         .iops(123)
     *         .kmsKeyId("kmsKeyId")
     *         .snapshotId("snapshotId")
     *         .throughput(123)
     *         .volumeSize(123)
     *         .volumeType("volumeType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.EbsProperty")
    @software.amazon.jsii.Jsii.Proxy(EbsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EbsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the EBS volume is deleted on instance termination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteOnTermination() {
            return null;
        }

        /**
         * Indicates whether the EBS volume is encrypted.
         * <p>
         * Encrypted volumes can only be attached to instances that support Amazon EBS encryption. If you are creating a volume from a snapshot, you can't specify an encryption value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncrypted() {
            return null;
        }

        /**
         * The number of I/O operations per second (IOPS).
         * <p>
         * For <code>gp3</code> , <code>io1</code> , and <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
         * <p>
         * The following are the supported values for each volume type:
         * <p>
         * <ul>
         * <li><code>gp3</code> : 3,000-16,000 IOPS</li>
         * <li><code>io1</code> : 100-64,000 IOPS</li>
         * <li><code>io2</code> : 100-64,000 IOPS</li>
         * </ul>
         * <p>
         * For <code>io1</code> and <code>io2</code> volumes, we guarantee 64,000 IOPS only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> . Other instance families guarantee performance up to 32,000 IOPS.
         * <p>
         * This parameter is supported for <code>io1</code> , <code>io2</code> , and <code>gp3</code> volumes only. This parameter is not supported for <code>gp2</code> , <code>st1</code> , <code>sc1</code> , or <code>standard</code> volumes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * The ARN of the symmetric AWS Key Management Service ( AWS KMS ) CMK used for encryption.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * The ID of the snapshot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotId() {
            return null;
        }

        /**
         * The throughput to provision for a `gp3` volume, with a maximum of 1,000 MiB/s.
         * <p>
         * Valid Range: Minimum value of 125. Maximum value of 1000.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThroughput() {
            return null;
        }

        /**
         * The size of the volume, in GiBs.
         * <p>
         * You must specify either a snapshot ID or a volume size. The following are the supported volumes sizes for each volume type:
         * <p>
         * <ul>
         * <li><code>gp2</code> and <code>gp3</code> : 1-16,384</li>
         * <li><code>io1</code> and <code>io2</code> : 4-16,384</li>
         * <li><code>st1</code> and <code>sc1</code> : 125-16,384</li>
         * <li><code>standard</code> : 1-1,024</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeSize() {
            return null;
        }

        /**
         * The volume type.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EbsProperty> {
            java.lang.Object deleteOnTermination;
            java.lang.Object encrypted;
            java.lang.Number iops;
            java.lang.String kmsKeyId;
            java.lang.String snapshotId;
            java.lang.Number throughput;
            java.lang.Number volumeSize;
            java.lang.String volumeType;

            /**
             * Sets the value of {@link EbsProperty#getDeleteOnTermination}
             * @param deleteOnTermination Indicates whether the EBS volume is deleted on instance termination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(java.lang.Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getDeleteOnTermination}
             * @param deleteOnTermination Indicates whether the EBS volume is deleted on instance termination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(software.amazon.awscdk.core.IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getEncrypted}
             * @param encrypted Indicates whether the EBS volume is encrypted.
             *                  Encrypted volumes can only be attached to instances that support Amazon EBS encryption. If you are creating a volume from a snapshot, you can't specify an encryption value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(java.lang.Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getEncrypted}
             * @param encrypted Indicates whether the EBS volume is encrypted.
             *                  Encrypted volumes can only be attached to instances that support Amazon EBS encryption. If you are creating a volume from a snapshot, you can't specify an encryption value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(software.amazon.awscdk.core.IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getIops}
             * @param iops The number of I/O operations per second (IOPS).
             *             For <code>gp3</code> , <code>io1</code> , and <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
             *             <p>
             *             The following are the supported values for each volume type:
             *             <p>
             *             <ul>
             *             <li><code>gp3</code> : 3,000-16,000 IOPS</li>
             *             <li><code>io1</code> : 100-64,000 IOPS</li>
             *             <li><code>io2</code> : 100-64,000 IOPS</li>
             *             </ul>
             *             <p>
             *             For <code>io1</code> and <code>io2</code> volumes, we guarantee 64,000 IOPS only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> . Other instance families guarantee performance up to 32,000 IOPS.
             *             <p>
             *             This parameter is supported for <code>io1</code> , <code>io2</code> , and <code>gp3</code> volumes only. This parameter is not supported for <code>gp2</code> , <code>st1</code> , <code>sc1</code> , or <code>standard</code> volumes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getKmsKeyId}
             * @param kmsKeyId The ARN of the symmetric AWS Key Management Service ( AWS KMS ) CMK used for encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getSnapshotId}
             * @param snapshotId The ID of the snapshot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotId(java.lang.String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getThroughput}
             * @param throughput The throughput to provision for a `gp3` volume, with a maximum of 1,000 MiB/s.
             *                   Valid Range: Minimum value of 125. Maximum value of 1000.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughput(java.lang.Number throughput) {
                this.throughput = throughput;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getVolumeSize}
             * @param volumeSize The size of the volume, in GiBs.
             *                   You must specify either a snapshot ID or a volume size. The following are the supported volumes sizes for each volume type:
             *                   <p>
             *                   <ul>
             *                   <li><code>gp2</code> and <code>gp3</code> : 1-16,384</li>
             *                   <li><code>io1</code> and <code>io2</code> : 4-16,384</li>
             *                   <li><code>st1</code> and <code>sc1</code> : 125-16,384</li>
             *                   <li><code>standard</code> : 1-1,024</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSize(java.lang.Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            /**
             * Sets the value of {@link EbsProperty#getVolumeType}
             * @param volumeType The volume type.
             *                   For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeType(java.lang.String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EbsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsProperty {
            private final java.lang.Object deleteOnTermination;
            private final java.lang.Object encrypted;
            private final java.lang.Number iops;
            private final java.lang.String kmsKeyId;
            private final java.lang.String snapshotId;
            private final java.lang.Number throughput;
            private final java.lang.Number volumeSize;
            private final java.lang.String volumeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deleteOnTermination = software.amazon.jsii.Kernel.get(this, "deleteOnTermination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.snapshotId = software.amazon.jsii.Kernel.get(this, "snapshotId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.throughput = software.amazon.jsii.Kernel.get(this, "throughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeSize = software.amazon.jsii.Kernel.get(this, "volumeSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deleteOnTermination = builder.deleteOnTermination;
                this.encrypted = builder.encrypted;
                this.iops = builder.iops;
                this.kmsKeyId = builder.kmsKeyId;
                this.snapshotId = builder.snapshotId;
                this.throughput = builder.throughput;
                this.volumeSize = builder.volumeSize;
                this.volumeType = builder.volumeType;
            }

            @Override
            public final java.lang.Object getDeleteOnTermination() {
                return this.deleteOnTermination;
            }

            @Override
            public final java.lang.Object getEncrypted() {
                return this.encrypted;
            }

            @Override
            public final java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.String getSnapshotId() {
                return this.snapshotId;
            }

            @Override
            public final java.lang.Number getThroughput() {
                return this.throughput;
            }

            @Override
            public final java.lang.Number getVolumeSize() {
                return this.volumeSize;
            }

            @Override
            public final java.lang.String getVolumeType() {
                return this.volumeType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeleteOnTermination() != null) {
                    data.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                }
                if (this.getEncrypted() != null) {
                    data.set("encrypted", om.valueToTree(this.getEncrypted()));
                }
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getSnapshotId() != null) {
                    data.set("snapshotId", om.valueToTree(this.getSnapshotId()));
                }
                if (this.getThroughput() != null) {
                    data.set("throughput", om.valueToTree(this.getThroughput()));
                }
                if (this.getVolumeSize() != null) {
                    data.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                }
                if (this.getVolumeType() != null) {
                    data.set("volumeType", om.valueToTree(this.getVolumeType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.EbsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsProperty.Jsii$Proxy that = (EbsProperty.Jsii$Proxy) o;

                if (this.deleteOnTermination != null ? !this.deleteOnTermination.equals(that.deleteOnTermination) : that.deleteOnTermination != null) return false;
                if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                if (this.snapshotId != null ? !this.snapshotId.equals(that.snapshotId) : that.snapshotId != null) return false;
                if (this.throughput != null ? !this.throughput.equals(that.throughput) : that.throughput != null) return false;
                if (this.volumeSize != null ? !this.volumeSize.equals(that.volumeSize) : that.volumeSize != null) return false;
                return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deleteOnTermination != null ? this.deleteOnTermination.hashCode() : 0;
                result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                result = 31 * result + (this.snapshotId != null ? this.snapshotId.hashCode() : 0);
                result = 31 * result + (this.throughput != null ? this.throughput.hashCode() : 0);
                result = 31 * result + (this.volumeSize != null ? this.volumeSize.hashCode() : 0);
                result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a specification for an Elastic GPU for an Amazon EC2 launch template.
     * <p>
     * <code>ElasticGpuSpecification</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html">AWS::EC2::LaunchTemplate LaunchTemplateData</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * ElasticGpuSpecificationProperty elasticGpuSpecificationProperty = ElasticGpuSpecificationProperty.builder()
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.ElasticGpuSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticGpuSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticGpuSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of Elastic Graphics accelerator.
         * <p>
         * For more information about the values to specify for <code>Type</code> , see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html#elastic-graphics-basics">Elastic Graphics Basics</a> , specifically the Elastic Graphics accelerator column, in the <em>Amazon Elastic Compute Cloud User Guide for Windows Instances</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticGpuSpecificationProperty> {
            java.lang.String type;

            /**
             * Sets the value of {@link ElasticGpuSpecificationProperty#getType}
             * @param type The type of Elastic Graphics accelerator.
             *             For more information about the values to specify for <code>Type</code> , see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html#elastic-graphics-basics">Elastic Graphics Basics</a> , specifically the Elastic Graphics accelerator column, in the <em>Amazon Elastic Compute Cloud User Guide for Windows Instances</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticGpuSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticGpuSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticGpuSpecificationProperty {
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.ElasticGpuSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticGpuSpecificationProperty.Jsii$Proxy that = (ElasticGpuSpecificationProperty.Jsii$Proxy) o;

                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type != null ? this.type.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Indicates whether the instance is enabled for AWS Nitro Enclaves.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * EnclaveOptionsProperty enclaveOptionsProperty = EnclaveOptionsProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.EnclaveOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(EnclaveOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnclaveOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If this parameter is set to `true` , the instance is enabled for AWS Nitro Enclaves;
         * <p>
         * otherwise, it is not enabled for AWS Nitro Enclaves.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnclaveOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnclaveOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnclaveOptionsProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link EnclaveOptionsProperty#getEnabled}
             * @param enabled If this parameter is set to `true` , the instance is enabled for AWS Nitro Enclaves;.
             *                otherwise, it is not enabled for AWS Nitro Enclaves.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link EnclaveOptionsProperty#getEnabled}
             * @param enabled If this parameter is set to `true` , the instance is enabled for AWS Nitro Enclaves;.
             *                otherwise, it is not enabled for AWS Nitro Enclaves.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnclaveOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnclaveOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnclaveOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnclaveOptionsProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.EnclaveOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnclaveOptionsProperty.Jsii$Proxy that = (EnclaveOptionsProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies whether your instance is configured for hibernation.
     * <p>
     * This parameter is valid only if the instance meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites">hibernation prerequisites</a> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate Your Instance</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * <code>HibernationOptions</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html">AWS::EC2::LaunchTemplate LaunchTemplateData</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * HibernationOptionsProperty hibernationOptionsProperty = HibernationOptionsProperty.builder()
     *         .configured(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.HibernationOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(HibernationOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HibernationOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If you set this parameter to `true` , the instance is enabled for hibernation.
         * <p>
         * Default: <code>false</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigured() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HibernationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HibernationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HibernationOptionsProperty> {
            java.lang.Object configured;

            /**
             * Sets the value of {@link HibernationOptionsProperty#getConfigured}
             * @param configured If you set this parameter to `true` , the instance is enabled for hibernation.
             *                   Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configured(java.lang.Boolean configured) {
                this.configured = configured;
                return this;
            }

            /**
             * Sets the value of {@link HibernationOptionsProperty#getConfigured}
             * @param configured If you set this parameter to `true` , the instance is enabled for hibernation.
             *                   Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configured(software.amazon.awscdk.core.IResolvable configured) {
                this.configured = configured;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HibernationOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HibernationOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HibernationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HibernationOptionsProperty {
            private final java.lang.Object configured;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configured = software.amazon.jsii.Kernel.get(this, "configured", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configured = builder.configured;
            }

            @Override
            public final java.lang.Object getConfigured() {
                return this.configured;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfigured() != null) {
                    data.set("configured", om.valueToTree(this.getConfigured()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.HibernationOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HibernationOptionsProperty.Jsii$Proxy that = (HibernationOptionsProperty.Jsii$Proxy) o;

                return this.configured != null ? this.configured.equals(that.configured) : that.configured == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configured != null ? this.configured.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies an IAM instance profile, which is a container for an IAM role for your instance.
     * <p>
     * You can use an IAM role to distribute your AWS credentials to your instances.
     * <p>
     * If you are creating the launch template for use with an Amazon EC2 Auto Scaling group, you can specify either the name or the ARN of the instance profile, but not both.
     * <p>
     * <code>IamInstanceProfile</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html">AWS::EC2::LaunchTemplate LaunchTemplateData</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * IamInstanceProfileProperty iamInstanceProfileProperty = IamInstanceProfileProperty.builder()
     *         .arn("arn")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.IamInstanceProfileProperty")
    @software.amazon.jsii.Jsii.Proxy(IamInstanceProfileProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IamInstanceProfileProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the instance profile.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * The name of the instance profile.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IamInstanceProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IamInstanceProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IamInstanceProfileProperty> {
            java.lang.String arn;
            java.lang.String name;

            /**
             * Sets the value of {@link IamInstanceProfileProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the instance profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link IamInstanceProfileProperty#getName}
             * @param name The name of the instance profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IamInstanceProfileProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IamInstanceProfileProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IamInstanceProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IamInstanceProfileProperty {
            private final java.lang.String arn;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = builder.arn;
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.IamInstanceProfileProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IamInstanceProfileProperty.Jsii$Proxy that = (IamInstanceProfileProperty.Jsii$Proxy) o;

                if (this.arn != null ? !this.arn.equals(that.arn) : that.arn != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the market (purchasing) option for an instance.
     * <p>
     * <code>InstanceMarketOptions</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html">AWS::EC2::LaunchTemplate LaunchTemplateData</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * InstanceMarketOptionsProperty instanceMarketOptionsProperty = InstanceMarketOptionsProperty.builder()
     *         .marketType("marketType")
     *         .spotOptions(SpotOptionsProperty.builder()
     *                 .blockDurationMinutes(123)
     *                 .instanceInterruptionBehavior("instanceInterruptionBehavior")
     *                 .maxPrice("maxPrice")
     *                 .spotInstanceType("spotInstanceType")
     *                 .validUntil("validUntil")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceMarketOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceMarketOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The market type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMarketType() {
            return null;
        }

        /**
         * The options for Spot Instances.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSpotOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceMarketOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceMarketOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceMarketOptionsProperty> {
            java.lang.String marketType;
            java.lang.Object spotOptions;

            /**
             * Sets the value of {@link InstanceMarketOptionsProperty#getMarketType}
             * @param marketType The market type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketType(java.lang.String marketType) {
                this.marketType = marketType;
                return this;
            }

            /**
             * Sets the value of {@link InstanceMarketOptionsProperty#getSpotOptions}
             * @param spotOptions The options for Spot Instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotOptions(software.amazon.awscdk.core.IResolvable spotOptions) {
                this.spotOptions = spotOptions;
                return this;
            }

            /**
             * Sets the value of {@link InstanceMarketOptionsProperty#getSpotOptions}
             * @param spotOptions The options for Spot Instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotOptions(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.SpotOptionsProperty spotOptions) {
                this.spotOptions = spotOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceMarketOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceMarketOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceMarketOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceMarketOptionsProperty {
            private final java.lang.String marketType;
            private final java.lang.Object spotOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.marketType = software.amazon.jsii.Kernel.get(this, "marketType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.spotOptions = software.amazon.jsii.Kernel.get(this, "spotOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.marketType = builder.marketType;
                this.spotOptions = builder.spotOptions;
            }

            @Override
            public final java.lang.String getMarketType() {
                return this.marketType;
            }

            @Override
            public final java.lang.Object getSpotOptions() {
                return this.spotOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMarketType() != null) {
                    data.set("marketType", om.valueToTree(this.getMarketType()));
                }
                if (this.getSpotOptions() != null) {
                    data.set("spotOptions", om.valueToTree(this.getSpotOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceMarketOptionsProperty.Jsii$Proxy that = (InstanceMarketOptionsProperty.Jsii$Proxy) o;

                if (this.marketType != null ? !this.marketType.equals(that.marketType) : that.marketType != null) return false;
                return this.spotOptions != null ? this.spotOptions.equals(that.spotOptions) : that.spotOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.marketType != null ? this.marketType.hashCode() : 0;
                result = 31 * result + (this.spotOptions != null ? this.spotOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The attributes for the instance types.
     * <p>
     * When you specify instance attributes, Amazon EC2 will identify instance types with these attributes.
     * <p>
     * When you specify multiple attributes, you get instance types that satisfy all of the specified attributes. If you specify multiple values for an attribute, you get instance types that satisfy any of the specified values.
     * <p>
     * To limit the list of instance types from which Amazon EC2 can identify matching instance types, you can use one of the following parameters, but not both in the same request:
     * <p>
     * <ul>
     * <li><code>AllowedInstanceTypes</code> - The instance types to include in the list. All other instance types are ignored, even if they match your specified attributes.</li>
     * <li><code>ExcludedInstanceTypes</code> - The instance types to exclude from the list, even if they match your specified attributes.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * You must specify <code>VCpuCount</code> and <code>MemoryMiB</code> . All other attributes are optional. Any unspecified optional attribute is set to its default.
     * <p>
     * </blockquote>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html">Attribute-based instance type selection for EC2 Fleet</a> , <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-attribute-based-instance-type-selection.html">Attribute-based instance type selection for Spot Fleet</a> , and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-placement-score.html">Spot placement score</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * InstanceRequirementsProperty instanceRequirementsProperty = InstanceRequirementsProperty.builder()
     *         .acceleratorCount(AcceleratorCountProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *         .acceleratorNames(List.of("acceleratorNames"))
     *         .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .acceleratorTypes(List.of("acceleratorTypes"))
     *         .allowedInstanceTypes(List.of("allowedInstanceTypes"))
     *         .bareMetal("bareMetal")
     *         .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .burstablePerformance("burstablePerformance")
     *         .cpuManufacturers(List.of("cpuManufacturers"))
     *         .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *         .instanceGenerations(List.of("instanceGenerations"))
     *         .localStorage("localStorage")
     *         .localStorageTypes(List.of("localStorageTypes"))
     *         .memoryGiBPerVCpu(MemoryGiBPerVCpuProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .memoryMiB(MemoryMiBProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .networkBandwidthGbps(NetworkBandwidthGbpsProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .networkInterfaceCount(NetworkInterfaceCountProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .onDemandMaxPricePercentageOverLowestPrice(123)
     *         .requireHibernateSupport(false)
     *         .spotMaxPricePercentageOverLowestPrice(123)
     *         .totalLocalStorageGb(TotalLocalStorageGBProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .vCpuCount(VCpuCountProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.InstanceRequirementsProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceRequirementsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceRequirementsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) on an instance.
         * <p>
         * To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcceleratorCount() {
            return null;
        }

        /**
         * Indicates whether instance types must have accelerators by specific manufacturers.
         * <p>
         * <ul>
         * <li>For instance types with NVIDIA devices, specify <code>nvidia</code> .</li>
         * <li>For instance types with AMD devices, specify <code>amd</code> .</li>
         * <li>For instance types with AWS devices, specify <code>amazon-web-services</code> .</li>
         * <li>For instance types with Xilinx devices, specify <code>xilinx</code> .</li>
         * </ul>
         * <p>
         * Default: Any manufacturer
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorManufacturers() {
            return null;
        }

        /**
         * The accelerators that must be on the instance type.
         * <p>
         * <ul>
         * <li>For instance types with NVIDIA A100 GPUs, specify <code>a100</code> .</li>
         * <li>For instance types with NVIDIA V100 GPUs, specify <code>v100</code> .</li>
         * <li>For instance types with NVIDIA K80 GPUs, specify <code>k80</code> .</li>
         * <li>For instance types with NVIDIA T4 GPUs, specify <code>t4</code> .</li>
         * <li>For instance types with NVIDIA M60 GPUs, specify <code>m60</code> .</li>
         * <li>For instance types with AMD Radeon Pro V520 GPUs, specify <code>radeon-pro-v520</code> .</li>
         * <li>For instance types with Xilinx VU9P FPGAs, specify <code>vu9p</code> .</li>
         * <li>For instance types with AWS Inferentia chips, specify <code>inferentia</code> .</li>
         * <li>For instance types with NVIDIA GRID K520 GPUs, specify <code>k520</code> .</li>
         * </ul>
         * <p>
         * Default: Any accelerator
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorNames() {
            return null;
        }

        /**
         * The minimum and maximum amount of total accelerator memory, in MiB.
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcceleratorTotalMemoryMiB() {
            return null;
        }

        /**
         * The accelerator types that must be on the instance type.
         * <p>
         * <ul>
         * <li>For instance types with GPU accelerators, specify <code>gpu</code> .</li>
         * <li>For instance types with FPGA accelerators, specify <code>fpga</code> .</li>
         * <li>For instance types with inference accelerators, specify <code>inference</code> .</li>
         * </ul>
         * <p>
         * Default: Any accelerator type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorTypes() {
            return null;
        }

        /**
         * The instance types to apply your specified attributes against.
         * <p>
         * All other instance types are ignored, even if they match your specified attributes.
         * <p>
         * You can use strings with one or more wild cards, represented by an asterisk ( <code>*</code> ), to allow an instance type, size, or generation. The following are examples: <code>m5.8xlarge</code> , <code>c5*.*</code> , <code>m5a.*</code> , <code>r*</code> , <code>*3*</code> .
         * <p>
         * For example, if you specify <code>c5*</code> ,Amazon EC2 will allow the entire C5 instance family, which includes all C5a and C5n instance types. If you specify <code>m5a.*</code> , Amazon EC2 will allow all the M5a instance types, but not the M5n instance types.
         * <p>
         * <blockquote>
         * <p>
         * If you specify <code>AllowedInstanceTypes</code> , you can't specify <code>ExcludedInstanceTypes</code> .
         * <p>
         * </blockquote>
         * <p>
         * Default: All instance types
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedInstanceTypes() {
            return null;
        }

        /**
         * Indicates whether bare metal instance types must be included, excluded, or required.
         * <p>
         * <ul>
         * <li>To include bare metal instance types, specify <code>included</code> .</li>
         * <li>To require only bare metal instance types, specify <code>required</code> .</li>
         * <li>To exclude bare metal instance types, specify <code>excluded</code> .</li>
         * </ul>
         * <p>
         * Default: <code>excluded</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBareMetal() {
            return null;
        }

        /**
         * The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBaselineEbsBandwidthMbps() {
            return null;
        }

        /**
         * Indicates whether burstable performance T instance types are included, excluded, or required.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> .
         * <p>
         * <ul>
         * <li>To include burstable performance instance types, specify <code>included</code> .</li>
         * <li>To require only burstable performance instance types, specify <code>required</code> .</li>
         * <li>To exclude burstable performance instance types, specify <code>excluded</code> .</li>
         * </ul>
         * <p>
         * Default: <code>excluded</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBurstablePerformance() {
            return null;
        }

        /**
         * The CPU manufacturers to include.
         * <p>
         * <ul>
         * <li>For instance types with Intel CPUs, specify <code>intel</code> .</li>
         * <li>For instance types with AMD CPUs, specify <code>amd</code> .</li>
         * <li>For instance types with AWS CPUs, specify <code>amazon-web-services</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Don't confuse the CPU manufacturer with the CPU architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
         * <p>
         * </blockquote>
         * <p>
         * Default: Any manufacturer
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCpuManufacturers() {
            return null;
        }

        /**
         * The instance types to exclude.
         * <p>
         * You can use strings with one or more wild cards, represented by an asterisk ( <code>*</code> ), to exclude an instance type, size, or generation. The following are examples: <code>m5.8xlarge</code> , <code>c5*.*</code> , <code>m5a.*</code> , <code>r*</code> , <code>*3*</code> .
         * <p>
         * For example, if you specify <code>c5*</code> ,Amazon EC2 will exclude the entire C5 instance family, which includes all C5a and C5n instance types. If you specify <code>m5a.*</code> , Amazon EC2 will exclude all the M5a instance types, but not the M5n instance types.
         * <p>
         * <blockquote>
         * <p>
         * If you specify <code>ExcludedInstanceTypes</code> , you can't specify <code>AllowedInstanceTypes</code> .
         * <p>
         * </blockquote>
         * <p>
         * Default: No excluded instance types
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedInstanceTypes() {
            return null;
        }

        /**
         * Indicates whether current or previous generation instance types are included.
         * <p>
         * The current generation instance types are recommended for use. Current generation instance types are typically the latest two to three generations in each instance family. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * For current generation instance types, specify <code>current</code> .
         * <p>
         * For previous generation instance types, specify <code>previous</code> .
         * <p>
         * Default: Current and previous generation instance types
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstanceGenerations() {
            return null;
        }

        /**
         * Indicates whether instance types with instance store volumes are included, excluded, or required.
         * <p>
         * For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 instance store</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * <ul>
         * <li>To include instance types with instance store volumes, specify <code>included</code> .</li>
         * <li>To require only instance types with instance store volumes, specify <code>required</code> .</li>
         * <li>To exclude instance types with instance store volumes, specify <code>excluded</code> .</li>
         * </ul>
         * <p>
         * Default: <code>included</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocalStorage() {
            return null;
        }

        /**
         * The type of local storage that is required.
         * <p>
         * <ul>
         * <li>For instance types with hard disk drive (HDD) storage, specify <code>hdd</code> .</li>
         * <li>For instance types with solid state drive (SSD) storage, specify <code>ssd</code> .</li>
         * </ul>
         * <p>
         * Default: <code>hdd</code> and <code>ssd</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLocalStorageTypes() {
            return null;
        }

        /**
         * The minimum and maximum amount of memory per vCPU, in GiB.
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMemoryGiBPerVCpu() {
            return null;
        }

        /**
         * The minimum and maximum amount of memory, in MiB.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMemoryMiB() {
            return null;
        }

        /**
         * The minimum and maximum amount of network bandwidth, in gigabits per second (Gbps).
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkBandwidthGbps() {
            return null;
        }

        /**
         * The minimum and maximum number of network interfaces.
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterfaceCount() {
            return null;
        }

        /**
         * The price protection threshold for On-Demand Instances.
         * <p>
         * This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage above the least expensive current generation M, C, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above your threshold.
         * <p>
         * The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
         * <p>
         * To turn off price protection, specify a high value, such as <code>999999</code> .
         * <p>
         * This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements.html">GetInstanceTypesFromInstanceRequirements</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you set <code>TargetCapacityUnitType</code> to <code>vcpu</code> or <code>memory-mib</code> , the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
         * <p>
         * </blockquote>
         * <p>
         * Default: <code>20</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOnDemandMaxPricePercentageOverLowestPrice() {
            return null;
        }

        /**
         * Indicates whether instance types must support hibernation for On-Demand Instances.
         * <p>
         * This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> .
         * <p>
         * Default: <code>false</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireHibernateSupport() {
            return null;
        }

        /**
         * The price protection threshold for Spot Instances.
         * <p>
         * This is the maximum you’ll pay for a Spot Instance, expressed as a percentage above the least expensive current generation M, C, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above your threshold.
         * <p>
         * The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
         * <p>
         * To turn off price protection, specify a high value, such as <code>999999</code> .
         * <p>
         * This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements.html">GetInstanceTypesFromInstanceRequirements</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you set <code>TargetCapacityUnitType</code> to <code>vcpu</code> or <code>memory-mib</code> , the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
         * <p>
         * </blockquote>
         * <p>
         * Default: <code>100</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSpotMaxPricePercentageOverLowestPrice() {
            return null;
        }

        /**
         * The minimum and maximum amount of total local storage, in GB.
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTotalLocalStorageGb() {
            return null;
        }

        /**
         * The minimum and maximum number of vCPUs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVCpuCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceRequirementsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceRequirementsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceRequirementsProperty> {
            java.lang.Object acceleratorCount;
            java.util.List<java.lang.String> acceleratorManufacturers;
            java.util.List<java.lang.String> acceleratorNames;
            java.lang.Object acceleratorTotalMemoryMiB;
            java.util.List<java.lang.String> acceleratorTypes;
            java.util.List<java.lang.String> allowedInstanceTypes;
            java.lang.String bareMetal;
            java.lang.Object baselineEbsBandwidthMbps;
            java.lang.String burstablePerformance;
            java.util.List<java.lang.String> cpuManufacturers;
            java.util.List<java.lang.String> excludedInstanceTypes;
            java.util.List<java.lang.String> instanceGenerations;
            java.lang.String localStorage;
            java.util.List<java.lang.String> localStorageTypes;
            java.lang.Object memoryGiBPerVCpu;
            java.lang.Object memoryMiB;
            java.lang.Object networkBandwidthGbps;
            java.lang.Object networkInterfaceCount;
            java.lang.Number onDemandMaxPricePercentageOverLowestPrice;
            java.lang.Object requireHibernateSupport;
            java.lang.Number spotMaxPricePercentageOverLowestPrice;
            java.lang.Object totalLocalStorageGb;
            java.lang.Object vCpuCount;

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getAcceleratorCount}
             * @param acceleratorCount The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) on an instance.
             *                         To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
             *                         <p>
             *                         Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorCount(software.amazon.awscdk.core.IResolvable acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getAcceleratorCount}
             * @param acceleratorCount The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) on an instance.
             *                         To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
             *                         <p>
             *                         Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorCount(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.AcceleratorCountProperty acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getAcceleratorManufacturers}
             * @param acceleratorManufacturers Indicates whether instance types must have accelerators by specific manufacturers.
             *                                 <ul>
             *                                 <li>For instance types with NVIDIA devices, specify <code>nvidia</code> .</li>
             *                                 <li>For instance types with AMD devices, specify <code>amd</code> .</li>
             *                                 <li>For instance types with AWS devices, specify <code>amazon-web-services</code> .</li>
             *                                 <li>For instance types with Xilinx devices, specify <code>xilinx</code> .</li>
             *                                 </ul>
             *                                 <p>
             *                                 Default: Any manufacturer
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorManufacturers(java.util.List<java.lang.String> acceleratorManufacturers) {
                this.acceleratorManufacturers = acceleratorManufacturers;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getAcceleratorNames}
             * @param acceleratorNames The accelerators that must be on the instance type.
             *                         <ul>
             *                         <li>For instance types with NVIDIA A100 GPUs, specify <code>a100</code> .</li>
             *                         <li>For instance types with NVIDIA V100 GPUs, specify <code>v100</code> .</li>
             *                         <li>For instance types with NVIDIA K80 GPUs, specify <code>k80</code> .</li>
             *                         <li>For instance types with NVIDIA T4 GPUs, specify <code>t4</code> .</li>
             *                         <li>For instance types with NVIDIA M60 GPUs, specify <code>m60</code> .</li>
             *                         <li>For instance types with AMD Radeon Pro V520 GPUs, specify <code>radeon-pro-v520</code> .</li>
             *                         <li>For instance types with Xilinx VU9P FPGAs, specify <code>vu9p</code> .</li>
             *                         <li>For instance types with AWS Inferentia chips, specify <code>inferentia</code> .</li>
             *                         <li>For instance types with NVIDIA GRID K520 GPUs, specify <code>k520</code> .</li>
             *                         </ul>
             *                         <p>
             *                         Default: Any accelerator
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorNames(java.util.List<java.lang.String> acceleratorNames) {
                this.acceleratorNames = acceleratorNames;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getAcceleratorTotalMemoryMiB}
             * @param acceleratorTotalMemoryMiB The minimum and maximum amount of total accelerator memory, in MiB.
             *                                  Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTotalMemoryMiB(software.amazon.awscdk.core.IResolvable acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getAcceleratorTotalMemoryMiB}
             * @param acceleratorTotalMemoryMiB The minimum and maximum amount of total accelerator memory, in MiB.
             *                                  Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTotalMemoryMiB(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.AcceleratorTotalMemoryMiBProperty acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getAcceleratorTypes}
             * @param acceleratorTypes The accelerator types that must be on the instance type.
             *                         <ul>
             *                         <li>For instance types with GPU accelerators, specify <code>gpu</code> .</li>
             *                         <li>For instance types with FPGA accelerators, specify <code>fpga</code> .</li>
             *                         <li>For instance types with inference accelerators, specify <code>inference</code> .</li>
             *                         </ul>
             *                         <p>
             *                         Default: Any accelerator type
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTypes(java.util.List<java.lang.String> acceleratorTypes) {
                this.acceleratorTypes = acceleratorTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getAllowedInstanceTypes}
             * @param allowedInstanceTypes The instance types to apply your specified attributes against.
             *                             All other instance types are ignored, even if they match your specified attributes.
             *                             <p>
             *                             You can use strings with one or more wild cards, represented by an asterisk ( <code>*</code> ), to allow an instance type, size, or generation. The following are examples: <code>m5.8xlarge</code> , <code>c5*.*</code> , <code>m5a.*</code> , <code>r*</code> , <code>*3*</code> .
             *                             <p>
             *                             For example, if you specify <code>c5*</code> ,Amazon EC2 will allow the entire C5 instance family, which includes all C5a and C5n instance types. If you specify <code>m5a.*</code> , Amazon EC2 will allow all the M5a instance types, but not the M5n instance types.
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             If you specify <code>AllowedInstanceTypes</code> , you can't specify <code>ExcludedInstanceTypes</code> .
             *                             <p>
             *                             </blockquote>
             *                             <p>
             *                             Default: All instance types
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedInstanceTypes(java.util.List<java.lang.String> allowedInstanceTypes) {
                this.allowedInstanceTypes = allowedInstanceTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getBareMetal}
             * @param bareMetal Indicates whether bare metal instance types must be included, excluded, or required.
             *                  <ul>
             *                  <li>To include bare metal instance types, specify <code>included</code> .</li>
             *                  <li>To require only bare metal instance types, specify <code>required</code> .</li>
             *                  <li>To exclude bare metal instance types, specify <code>excluded</code> .</li>
             *                  </ul>
             *                  <p>
             *                  Default: <code>excluded</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bareMetal(java.lang.String bareMetal) {
                this.bareMetal = bareMetal;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getBaselineEbsBandwidthMbps}
             * @param baselineEbsBandwidthMbps The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps.
             *                                 For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
             *                                 <p>
             *                                 Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baselineEbsBandwidthMbps(software.amazon.awscdk.core.IResolvable baselineEbsBandwidthMbps) {
                this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getBaselineEbsBandwidthMbps}
             * @param baselineEbsBandwidthMbps The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps.
             *                                 For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
             *                                 <p>
             *                                 Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baselineEbsBandwidthMbps(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.BaselineEbsBandwidthMbpsProperty baselineEbsBandwidthMbps) {
                this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getBurstablePerformance}
             * @param burstablePerformance Indicates whether burstable performance T instance types are included, excluded, or required.
             *                             For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> .
             *                             <p>
             *                             <ul>
             *                             <li>To include burstable performance instance types, specify <code>included</code> .</li>
             *                             <li>To require only burstable performance instance types, specify <code>required</code> .</li>
             *                             <li>To exclude burstable performance instance types, specify <code>excluded</code> .</li>
             *                             </ul>
             *                             <p>
             *                             Default: <code>excluded</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder burstablePerformance(java.lang.String burstablePerformance) {
                this.burstablePerformance = burstablePerformance;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getCpuManufacturers}
             * @param cpuManufacturers The CPU manufacturers to include.
             *                         <ul>
             *                         <li>For instance types with Intel CPUs, specify <code>intel</code> .</li>
             *                         <li>For instance types with AMD CPUs, specify <code>amd</code> .</li>
             *                         <li>For instance types with AWS CPUs, specify <code>amazon-web-services</code> .</li>
             *                         </ul>
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         Don't confuse the CPU manufacturer with the CPU architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
             *                         <p>
             *                         </blockquote>
             *                         <p>
             *                         Default: Any manufacturer
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuManufacturers(java.util.List<java.lang.String> cpuManufacturers) {
                this.cpuManufacturers = cpuManufacturers;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getExcludedInstanceTypes}
             * @param excludedInstanceTypes The instance types to exclude.
             *                              You can use strings with one or more wild cards, represented by an asterisk ( <code>*</code> ), to exclude an instance type, size, or generation. The following are examples: <code>m5.8xlarge</code> , <code>c5*.*</code> , <code>m5a.*</code> , <code>r*</code> , <code>*3*</code> .
             *                              <p>
             *                              For example, if you specify <code>c5*</code> ,Amazon EC2 will exclude the entire C5 instance family, which includes all C5a and C5n instance types. If you specify <code>m5a.*</code> , Amazon EC2 will exclude all the M5a instance types, but not the M5n instance types.
             *                              <p>
             *                              <blockquote>
             *                              <p>
             *                              If you specify <code>ExcludedInstanceTypes</code> , you can't specify <code>AllowedInstanceTypes</code> .
             *                              <p>
             *                              </blockquote>
             *                              <p>
             *                              Default: No excluded instance types
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedInstanceTypes(java.util.List<java.lang.String> excludedInstanceTypes) {
                this.excludedInstanceTypes = excludedInstanceTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getInstanceGenerations}
             * @param instanceGenerations Indicates whether current or previous generation instance types are included.
             *                            The current generation instance types are recommended for use. Current generation instance types are typically the latest two to three generations in each instance family. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <em>Amazon EC2 User Guide</em> .
             *                            <p>
             *                            For current generation instance types, specify <code>current</code> .
             *                            <p>
             *                            For previous generation instance types, specify <code>previous</code> .
             *                            <p>
             *                            Default: Current and previous generation instance types
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceGenerations(java.util.List<java.lang.String> instanceGenerations) {
                this.instanceGenerations = instanceGenerations;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getLocalStorage}
             * @param localStorage Indicates whether instance types with instance store volumes are included, excluded, or required.
             *                     For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 instance store</a> in the <em>Amazon EC2 User Guide</em> .
             *                     <p>
             *                     <ul>
             *                     <li>To include instance types with instance store volumes, specify <code>included</code> .</li>
             *                     <li>To require only instance types with instance store volumes, specify <code>required</code> .</li>
             *                     <li>To exclude instance types with instance store volumes, specify <code>excluded</code> .</li>
             *                     </ul>
             *                     <p>
             *                     Default: <code>included</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localStorage(java.lang.String localStorage) {
                this.localStorage = localStorage;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getLocalStorageTypes}
             * @param localStorageTypes The type of local storage that is required.
             *                          <ul>
             *                          <li>For instance types with hard disk drive (HDD) storage, specify <code>hdd</code> .</li>
             *                          <li>For instance types with solid state drive (SSD) storage, specify <code>ssd</code> .</li>
             *                          </ul>
             *                          <p>
             *                          Default: <code>hdd</code> and <code>ssd</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localStorageTypes(java.util.List<java.lang.String> localStorageTypes) {
                this.localStorageTypes = localStorageTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getMemoryGiBPerVCpu}
             * @param memoryGiBPerVCpu The minimum and maximum amount of memory per vCPU, in GiB.
             *                         Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryGiBPerVCpu(software.amazon.awscdk.core.IResolvable memoryGiBPerVCpu) {
                this.memoryGiBPerVCpu = memoryGiBPerVCpu;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getMemoryGiBPerVCpu}
             * @param memoryGiBPerVCpu The minimum and maximum amount of memory per vCPU, in GiB.
             *                         Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryGiBPerVCpu(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.MemoryGiBPerVCpuProperty memoryGiBPerVCpu) {
                this.memoryGiBPerVCpu = memoryGiBPerVCpu;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getMemoryMiB}
             * @param memoryMiB The minimum and maximum amount of memory, in MiB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryMiB(software.amazon.awscdk.core.IResolvable memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getMemoryMiB}
             * @param memoryMiB The minimum and maximum amount of memory, in MiB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryMiB(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.MemoryMiBProperty memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getNetworkBandwidthGbps}
             * @param networkBandwidthGbps The minimum and maximum amount of network bandwidth, in gigabits per second (Gbps).
             *                             Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkBandwidthGbps(software.amazon.awscdk.core.IResolvable networkBandwidthGbps) {
                this.networkBandwidthGbps = networkBandwidthGbps;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getNetworkBandwidthGbps}
             * @param networkBandwidthGbps The minimum and maximum amount of network bandwidth, in gigabits per second (Gbps).
             *                             Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkBandwidthGbps(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.NetworkBandwidthGbpsProperty networkBandwidthGbps) {
                this.networkBandwidthGbps = networkBandwidthGbps;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getNetworkInterfaceCount}
             * @param networkInterfaceCount The minimum and maximum number of network interfaces.
             *                              Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceCount(software.amazon.awscdk.core.IResolvable networkInterfaceCount) {
                this.networkInterfaceCount = networkInterfaceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getNetworkInterfaceCount}
             * @param networkInterfaceCount The minimum and maximum number of network interfaces.
             *                              Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceCount(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.NetworkInterfaceCountProperty networkInterfaceCount) {
                this.networkInterfaceCount = networkInterfaceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getOnDemandMaxPricePercentageOverLowestPrice}
             * @param onDemandMaxPricePercentageOverLowestPrice The price protection threshold for On-Demand Instances.
             *                                                  This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage above the least expensive current generation M, C, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above your threshold.
             *                                                  <p>
             *                                                  The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
             *                                                  <p>
             *                                                  To turn off price protection, specify a high value, such as <code>999999</code> .
             *                                                  <p>
             *                                                  This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements.html">GetInstanceTypesFromInstanceRequirements</a> .
             *                                                  <p>
             *                                                  <blockquote>
             *                                                  <p>
             *                                                  If you set <code>TargetCapacityUnitType</code> to <code>vcpu</code> or <code>memory-mib</code> , the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
             *                                                  <p>
             *                                                  </blockquote>
             *                                                  <p>
             *                                                  Default: <code>20</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandMaxPricePercentageOverLowestPrice(java.lang.Number onDemandMaxPricePercentageOverLowestPrice) {
                this.onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getRequireHibernateSupport}
             * @param requireHibernateSupport Indicates whether instance types must support hibernation for On-Demand Instances.
             *                                This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> .
             *                                <p>
             *                                Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireHibernateSupport(java.lang.Boolean requireHibernateSupport) {
                this.requireHibernateSupport = requireHibernateSupport;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getRequireHibernateSupport}
             * @param requireHibernateSupport Indicates whether instance types must support hibernation for On-Demand Instances.
             *                                This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> .
             *                                <p>
             *                                Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireHibernateSupport(software.amazon.awscdk.core.IResolvable requireHibernateSupport) {
                this.requireHibernateSupport = requireHibernateSupport;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getSpotMaxPricePercentageOverLowestPrice}
             * @param spotMaxPricePercentageOverLowestPrice The price protection threshold for Spot Instances.
             *                                              This is the maximum you’ll pay for a Spot Instance, expressed as a percentage above the least expensive current generation M, C, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above your threshold.
             *                                              <p>
             *                                              The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
             *                                              <p>
             *                                              To turn off price protection, specify a high value, such as <code>999999</code> .
             *                                              <p>
             *                                              This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements.html">GetInstanceTypesFromInstanceRequirements</a> .
             *                                              <p>
             *                                              <blockquote>
             *                                              <p>
             *                                              If you set <code>TargetCapacityUnitType</code> to <code>vcpu</code> or <code>memory-mib</code> , the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
             *                                              <p>
             *                                              </blockquote>
             *                                              <p>
             *                                              Default: <code>100</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotMaxPricePercentageOverLowestPrice(java.lang.Number spotMaxPricePercentageOverLowestPrice) {
                this.spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getTotalLocalStorageGb}
             * @param totalLocalStorageGb The minimum and maximum amount of total local storage, in GB.
             *                            Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalLocalStorageGb(software.amazon.awscdk.core.IResolvable totalLocalStorageGb) {
                this.totalLocalStorageGb = totalLocalStorageGb;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getTotalLocalStorageGb}
             * @param totalLocalStorageGb The minimum and maximum amount of total local storage, in GB.
             *                            Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalLocalStorageGb(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.TotalLocalStorageGBProperty totalLocalStorageGb) {
                this.totalLocalStorageGb = totalLocalStorageGb;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getVCpuCount}
             * @param vCpuCount The minimum and maximum number of vCPUs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vCpuCount(software.amazon.awscdk.core.IResolvable vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getVCpuCount}
             * @param vCpuCount The minimum and maximum number of vCPUs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vCpuCount(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.VCpuCountProperty vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceRequirementsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceRequirementsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceRequirementsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceRequirementsProperty {
            private final java.lang.Object acceleratorCount;
            private final java.util.List<java.lang.String> acceleratorManufacturers;
            private final java.util.List<java.lang.String> acceleratorNames;
            private final java.lang.Object acceleratorTotalMemoryMiB;
            private final java.util.List<java.lang.String> acceleratorTypes;
            private final java.util.List<java.lang.String> allowedInstanceTypes;
            private final java.lang.String bareMetal;
            private final java.lang.Object baselineEbsBandwidthMbps;
            private final java.lang.String burstablePerformance;
            private final java.util.List<java.lang.String> cpuManufacturers;
            private final java.util.List<java.lang.String> excludedInstanceTypes;
            private final java.util.List<java.lang.String> instanceGenerations;
            private final java.lang.String localStorage;
            private final java.util.List<java.lang.String> localStorageTypes;
            private final java.lang.Object memoryGiBPerVCpu;
            private final java.lang.Object memoryMiB;
            private final java.lang.Object networkBandwidthGbps;
            private final java.lang.Object networkInterfaceCount;
            private final java.lang.Number onDemandMaxPricePercentageOverLowestPrice;
            private final java.lang.Object requireHibernateSupport;
            private final java.lang.Number spotMaxPricePercentageOverLowestPrice;
            private final java.lang.Object totalLocalStorageGb;
            private final java.lang.Object vCpuCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.acceleratorCount = software.amazon.jsii.Kernel.get(this, "acceleratorCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.acceleratorManufacturers = software.amazon.jsii.Kernel.get(this, "acceleratorManufacturers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.acceleratorNames = software.amazon.jsii.Kernel.get(this, "acceleratorNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.acceleratorTotalMemoryMiB = software.amazon.jsii.Kernel.get(this, "acceleratorTotalMemoryMiB", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.acceleratorTypes = software.amazon.jsii.Kernel.get(this, "acceleratorTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowedInstanceTypes = software.amazon.jsii.Kernel.get(this, "allowedInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.bareMetal = software.amazon.jsii.Kernel.get(this, "bareMetal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.baselineEbsBandwidthMbps = software.amazon.jsii.Kernel.get(this, "baselineEbsBandwidthMbps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.burstablePerformance = software.amazon.jsii.Kernel.get(this, "burstablePerformance", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cpuManufacturers = software.amazon.jsii.Kernel.get(this, "cpuManufacturers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.excludedInstanceTypes = software.amazon.jsii.Kernel.get(this, "excludedInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.instanceGenerations = software.amazon.jsii.Kernel.get(this, "instanceGenerations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.localStorage = software.amazon.jsii.Kernel.get(this, "localStorage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localStorageTypes = software.amazon.jsii.Kernel.get(this, "localStorageTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.memoryGiBPerVCpu = software.amazon.jsii.Kernel.get(this, "memoryGiBPerVCpu", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.memoryMiB = software.amazon.jsii.Kernel.get(this, "memoryMiB", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkBandwidthGbps = software.amazon.jsii.Kernel.get(this, "networkBandwidthGbps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkInterfaceCount = software.amazon.jsii.Kernel.get(this, "networkInterfaceCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onDemandMaxPricePercentageOverLowestPrice = software.amazon.jsii.Kernel.get(this, "onDemandMaxPricePercentageOverLowestPrice", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.requireHibernateSupport = software.amazon.jsii.Kernel.get(this, "requireHibernateSupport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.spotMaxPricePercentageOverLowestPrice = software.amazon.jsii.Kernel.get(this, "spotMaxPricePercentageOverLowestPrice", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.totalLocalStorageGb = software.amazon.jsii.Kernel.get(this, "totalLocalStorageGb", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vCpuCount = software.amazon.jsii.Kernel.get(this, "vCpuCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.acceleratorCount = builder.acceleratorCount;
                this.acceleratorManufacturers = builder.acceleratorManufacturers;
                this.acceleratorNames = builder.acceleratorNames;
                this.acceleratorTotalMemoryMiB = builder.acceleratorTotalMemoryMiB;
                this.acceleratorTypes = builder.acceleratorTypes;
                this.allowedInstanceTypes = builder.allowedInstanceTypes;
                this.bareMetal = builder.bareMetal;
                this.baselineEbsBandwidthMbps = builder.baselineEbsBandwidthMbps;
                this.burstablePerformance = builder.burstablePerformance;
                this.cpuManufacturers = builder.cpuManufacturers;
                this.excludedInstanceTypes = builder.excludedInstanceTypes;
                this.instanceGenerations = builder.instanceGenerations;
                this.localStorage = builder.localStorage;
                this.localStorageTypes = builder.localStorageTypes;
                this.memoryGiBPerVCpu = builder.memoryGiBPerVCpu;
                this.memoryMiB = builder.memoryMiB;
                this.networkBandwidthGbps = builder.networkBandwidthGbps;
                this.networkInterfaceCount = builder.networkInterfaceCount;
                this.onDemandMaxPricePercentageOverLowestPrice = builder.onDemandMaxPricePercentageOverLowestPrice;
                this.requireHibernateSupport = builder.requireHibernateSupport;
                this.spotMaxPricePercentageOverLowestPrice = builder.spotMaxPricePercentageOverLowestPrice;
                this.totalLocalStorageGb = builder.totalLocalStorageGb;
                this.vCpuCount = builder.vCpuCount;
            }

            @Override
            public final java.lang.Object getAcceleratorCount() {
                return this.acceleratorCount;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorManufacturers() {
                return this.acceleratorManufacturers;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorNames() {
                return this.acceleratorNames;
            }

            @Override
            public final java.lang.Object getAcceleratorTotalMemoryMiB() {
                return this.acceleratorTotalMemoryMiB;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorTypes() {
                return this.acceleratorTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedInstanceTypes() {
                return this.allowedInstanceTypes;
            }

            @Override
            public final java.lang.String getBareMetal() {
                return this.bareMetal;
            }

            @Override
            public final java.lang.Object getBaselineEbsBandwidthMbps() {
                return this.baselineEbsBandwidthMbps;
            }

            @Override
            public final java.lang.String getBurstablePerformance() {
                return this.burstablePerformance;
            }

            @Override
            public final java.util.List<java.lang.String> getCpuManufacturers() {
                return this.cpuManufacturers;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludedInstanceTypes() {
                return this.excludedInstanceTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getInstanceGenerations() {
                return this.instanceGenerations;
            }

            @Override
            public final java.lang.String getLocalStorage() {
                return this.localStorage;
            }

            @Override
            public final java.util.List<java.lang.String> getLocalStorageTypes() {
                return this.localStorageTypes;
            }

            @Override
            public final java.lang.Object getMemoryGiBPerVCpu() {
                return this.memoryGiBPerVCpu;
            }

            @Override
            public final java.lang.Object getMemoryMiB() {
                return this.memoryMiB;
            }

            @Override
            public final java.lang.Object getNetworkBandwidthGbps() {
                return this.networkBandwidthGbps;
            }

            @Override
            public final java.lang.Object getNetworkInterfaceCount() {
                return this.networkInterfaceCount;
            }

            @Override
            public final java.lang.Number getOnDemandMaxPricePercentageOverLowestPrice() {
                return this.onDemandMaxPricePercentageOverLowestPrice;
            }

            @Override
            public final java.lang.Object getRequireHibernateSupport() {
                return this.requireHibernateSupport;
            }

            @Override
            public final java.lang.Number getSpotMaxPricePercentageOverLowestPrice() {
                return this.spotMaxPricePercentageOverLowestPrice;
            }

            @Override
            public final java.lang.Object getTotalLocalStorageGb() {
                return this.totalLocalStorageGb;
            }

            @Override
            public final java.lang.Object getVCpuCount() {
                return this.vCpuCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAcceleratorCount() != null) {
                    data.set("acceleratorCount", om.valueToTree(this.getAcceleratorCount()));
                }
                if (this.getAcceleratorManufacturers() != null) {
                    data.set("acceleratorManufacturers", om.valueToTree(this.getAcceleratorManufacturers()));
                }
                if (this.getAcceleratorNames() != null) {
                    data.set("acceleratorNames", om.valueToTree(this.getAcceleratorNames()));
                }
                if (this.getAcceleratorTotalMemoryMiB() != null) {
                    data.set("acceleratorTotalMemoryMiB", om.valueToTree(this.getAcceleratorTotalMemoryMiB()));
                }
                if (this.getAcceleratorTypes() != null) {
                    data.set("acceleratorTypes", om.valueToTree(this.getAcceleratorTypes()));
                }
                if (this.getAllowedInstanceTypes() != null) {
                    data.set("allowedInstanceTypes", om.valueToTree(this.getAllowedInstanceTypes()));
                }
                if (this.getBareMetal() != null) {
                    data.set("bareMetal", om.valueToTree(this.getBareMetal()));
                }
                if (this.getBaselineEbsBandwidthMbps() != null) {
                    data.set("baselineEbsBandwidthMbps", om.valueToTree(this.getBaselineEbsBandwidthMbps()));
                }
                if (this.getBurstablePerformance() != null) {
                    data.set("burstablePerformance", om.valueToTree(this.getBurstablePerformance()));
                }
                if (this.getCpuManufacturers() != null) {
                    data.set("cpuManufacturers", om.valueToTree(this.getCpuManufacturers()));
                }
                if (this.getExcludedInstanceTypes() != null) {
                    data.set("excludedInstanceTypes", om.valueToTree(this.getExcludedInstanceTypes()));
                }
                if (this.getInstanceGenerations() != null) {
                    data.set("instanceGenerations", om.valueToTree(this.getInstanceGenerations()));
                }
                if (this.getLocalStorage() != null) {
                    data.set("localStorage", om.valueToTree(this.getLocalStorage()));
                }
                if (this.getLocalStorageTypes() != null) {
                    data.set("localStorageTypes", om.valueToTree(this.getLocalStorageTypes()));
                }
                if (this.getMemoryGiBPerVCpu() != null) {
                    data.set("memoryGiBPerVCpu", om.valueToTree(this.getMemoryGiBPerVCpu()));
                }
                if (this.getMemoryMiB() != null) {
                    data.set("memoryMiB", om.valueToTree(this.getMemoryMiB()));
                }
                if (this.getNetworkBandwidthGbps() != null) {
                    data.set("networkBandwidthGbps", om.valueToTree(this.getNetworkBandwidthGbps()));
                }
                if (this.getNetworkInterfaceCount() != null) {
                    data.set("networkInterfaceCount", om.valueToTree(this.getNetworkInterfaceCount()));
                }
                if (this.getOnDemandMaxPricePercentageOverLowestPrice() != null) {
                    data.set("onDemandMaxPricePercentageOverLowestPrice", om.valueToTree(this.getOnDemandMaxPricePercentageOverLowestPrice()));
                }
                if (this.getRequireHibernateSupport() != null) {
                    data.set("requireHibernateSupport", om.valueToTree(this.getRequireHibernateSupport()));
                }
                if (this.getSpotMaxPricePercentageOverLowestPrice() != null) {
                    data.set("spotMaxPricePercentageOverLowestPrice", om.valueToTree(this.getSpotMaxPricePercentageOverLowestPrice()));
                }
                if (this.getTotalLocalStorageGb() != null) {
                    data.set("totalLocalStorageGb", om.valueToTree(this.getTotalLocalStorageGb()));
                }
                if (this.getVCpuCount() != null) {
                    data.set("vCpuCount", om.valueToTree(this.getVCpuCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.InstanceRequirementsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceRequirementsProperty.Jsii$Proxy that = (InstanceRequirementsProperty.Jsii$Proxy) o;

                if (this.acceleratorCount != null ? !this.acceleratorCount.equals(that.acceleratorCount) : that.acceleratorCount != null) return false;
                if (this.acceleratorManufacturers != null ? !this.acceleratorManufacturers.equals(that.acceleratorManufacturers) : that.acceleratorManufacturers != null) return false;
                if (this.acceleratorNames != null ? !this.acceleratorNames.equals(that.acceleratorNames) : that.acceleratorNames != null) return false;
                if (this.acceleratorTotalMemoryMiB != null ? !this.acceleratorTotalMemoryMiB.equals(that.acceleratorTotalMemoryMiB) : that.acceleratorTotalMemoryMiB != null) return false;
                if (this.acceleratorTypes != null ? !this.acceleratorTypes.equals(that.acceleratorTypes) : that.acceleratorTypes != null) return false;
                if (this.allowedInstanceTypes != null ? !this.allowedInstanceTypes.equals(that.allowedInstanceTypes) : that.allowedInstanceTypes != null) return false;
                if (this.bareMetal != null ? !this.bareMetal.equals(that.bareMetal) : that.bareMetal != null) return false;
                if (this.baselineEbsBandwidthMbps != null ? !this.baselineEbsBandwidthMbps.equals(that.baselineEbsBandwidthMbps) : that.baselineEbsBandwidthMbps != null) return false;
                if (this.burstablePerformance != null ? !this.burstablePerformance.equals(that.burstablePerformance) : that.burstablePerformance != null) return false;
                if (this.cpuManufacturers != null ? !this.cpuManufacturers.equals(that.cpuManufacturers) : that.cpuManufacturers != null) return false;
                if (this.excludedInstanceTypes != null ? !this.excludedInstanceTypes.equals(that.excludedInstanceTypes) : that.excludedInstanceTypes != null) return false;
                if (this.instanceGenerations != null ? !this.instanceGenerations.equals(that.instanceGenerations) : that.instanceGenerations != null) return false;
                if (this.localStorage != null ? !this.localStorage.equals(that.localStorage) : that.localStorage != null) return false;
                if (this.localStorageTypes != null ? !this.localStorageTypes.equals(that.localStorageTypes) : that.localStorageTypes != null) return false;
                if (this.memoryGiBPerVCpu != null ? !this.memoryGiBPerVCpu.equals(that.memoryGiBPerVCpu) : that.memoryGiBPerVCpu != null) return false;
                if (this.memoryMiB != null ? !this.memoryMiB.equals(that.memoryMiB) : that.memoryMiB != null) return false;
                if (this.networkBandwidthGbps != null ? !this.networkBandwidthGbps.equals(that.networkBandwidthGbps) : that.networkBandwidthGbps != null) return false;
                if (this.networkInterfaceCount != null ? !this.networkInterfaceCount.equals(that.networkInterfaceCount) : that.networkInterfaceCount != null) return false;
                if (this.onDemandMaxPricePercentageOverLowestPrice != null ? !this.onDemandMaxPricePercentageOverLowestPrice.equals(that.onDemandMaxPricePercentageOverLowestPrice) : that.onDemandMaxPricePercentageOverLowestPrice != null) return false;
                if (this.requireHibernateSupport != null ? !this.requireHibernateSupport.equals(that.requireHibernateSupport) : that.requireHibernateSupport != null) return false;
                if (this.spotMaxPricePercentageOverLowestPrice != null ? !this.spotMaxPricePercentageOverLowestPrice.equals(that.spotMaxPricePercentageOverLowestPrice) : that.spotMaxPricePercentageOverLowestPrice != null) return false;
                if (this.totalLocalStorageGb != null ? !this.totalLocalStorageGb.equals(that.totalLocalStorageGb) : that.totalLocalStorageGb != null) return false;
                return this.vCpuCount != null ? this.vCpuCount.equals(that.vCpuCount) : that.vCpuCount == null;
            }

            @Override
            public final int hashCode() {
                int result = this.acceleratorCount != null ? this.acceleratorCount.hashCode() : 0;
                result = 31 * result + (this.acceleratorManufacturers != null ? this.acceleratorManufacturers.hashCode() : 0);
                result = 31 * result + (this.acceleratorNames != null ? this.acceleratorNames.hashCode() : 0);
                result = 31 * result + (this.acceleratorTotalMemoryMiB != null ? this.acceleratorTotalMemoryMiB.hashCode() : 0);
                result = 31 * result + (this.acceleratorTypes != null ? this.acceleratorTypes.hashCode() : 0);
                result = 31 * result + (this.allowedInstanceTypes != null ? this.allowedInstanceTypes.hashCode() : 0);
                result = 31 * result + (this.bareMetal != null ? this.bareMetal.hashCode() : 0);
                result = 31 * result + (this.baselineEbsBandwidthMbps != null ? this.baselineEbsBandwidthMbps.hashCode() : 0);
                result = 31 * result + (this.burstablePerformance != null ? this.burstablePerformance.hashCode() : 0);
                result = 31 * result + (this.cpuManufacturers != null ? this.cpuManufacturers.hashCode() : 0);
                result = 31 * result + (this.excludedInstanceTypes != null ? this.excludedInstanceTypes.hashCode() : 0);
                result = 31 * result + (this.instanceGenerations != null ? this.instanceGenerations.hashCode() : 0);
                result = 31 * result + (this.localStorage != null ? this.localStorage.hashCode() : 0);
                result = 31 * result + (this.localStorageTypes != null ? this.localStorageTypes.hashCode() : 0);
                result = 31 * result + (this.memoryGiBPerVCpu != null ? this.memoryGiBPerVCpu.hashCode() : 0);
                result = 31 * result + (this.memoryMiB != null ? this.memoryMiB.hashCode() : 0);
                result = 31 * result + (this.networkBandwidthGbps != null ? this.networkBandwidthGbps.hashCode() : 0);
                result = 31 * result + (this.networkInterfaceCount != null ? this.networkInterfaceCount.hashCode() : 0);
                result = 31 * result + (this.onDemandMaxPricePercentageOverLowestPrice != null ? this.onDemandMaxPricePercentageOverLowestPrice.hashCode() : 0);
                result = 31 * result + (this.requireHibernateSupport != null ? this.requireHibernateSupport.hashCode() : 0);
                result = 31 * result + (this.spotMaxPricePercentageOverLowestPrice != null ? this.spotMaxPricePercentageOverLowestPrice.hashCode() : 0);
                result = 31 * result + (this.totalLocalStorageGb != null ? this.totalLocalStorageGb.hashCode() : 0);
                result = 31 * result + (this.vCpuCount != null ? this.vCpuCount.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an IPv4 prefix for a network interface.
     * <p>
     * <code>Ipv4PrefixSpecification</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html">AWS::EC2::LaunchTemplate NetworkInterface</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * Ipv4PrefixSpecificationProperty ipv4PrefixSpecificationProperty = Ipv4PrefixSpecificationProperty.builder()
     *         .ipv4Prefix("ipv4Prefix")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.Ipv4PrefixSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(Ipv4PrefixSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Ipv4PrefixSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IPv4 prefix.
         * <p>
         * For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html">Assigning prefixes to Amazon EC2 network interfaces</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIpv4Prefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Ipv4PrefixSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Ipv4PrefixSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Ipv4PrefixSpecificationProperty> {
            java.lang.String ipv4Prefix;

            /**
             * Sets the value of {@link Ipv4PrefixSpecificationProperty#getIpv4Prefix}
             * @param ipv4Prefix The IPv4 prefix.
             *                   For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html">Assigning prefixes to Amazon EC2 network interfaces</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv4Prefix(java.lang.String ipv4Prefix) {
                this.ipv4Prefix = ipv4Prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Ipv4PrefixSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Ipv4PrefixSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Ipv4PrefixSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Ipv4PrefixSpecificationProperty {
            private final java.lang.String ipv4Prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ipv4Prefix = software.amazon.jsii.Kernel.get(this, "ipv4Prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipv4Prefix = builder.ipv4Prefix;
            }

            @Override
            public final java.lang.String getIpv4Prefix() {
                return this.ipv4Prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIpv4Prefix() != null) {
                    data.set("ipv4Prefix", om.valueToTree(this.getIpv4Prefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.Ipv4PrefixSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Ipv4PrefixSpecificationProperty.Jsii$Proxy that = (Ipv4PrefixSpecificationProperty.Jsii$Proxy) o;

                return this.ipv4Prefix != null ? this.ipv4Prefix.equals(that.ipv4Prefix) : that.ipv4Prefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ipv4Prefix != null ? this.ipv4Prefix.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies an IPv6 address in an Amazon EC2 launch template.
     * <p>
     * <code>Ipv6Add</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html">AWS::EC2::LaunchTemplate NetworkInterface</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * Ipv6AddProperty ipv6AddProperty = Ipv6AddProperty.builder()
     *         .ipv6Address("ipv6Address")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.Ipv6AddProperty")
    @software.amazon.jsii.Jsii.Proxy(Ipv6AddProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Ipv6AddProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet.
         * <p>
         * You can't use this option if you're specifying a number of IPv6 addresses.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIpv6Address() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Ipv6AddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Ipv6AddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Ipv6AddProperty> {
            java.lang.String ipv6Address;

            /**
             * Sets the value of {@link Ipv6AddProperty#getIpv6Address}
             * @param ipv6Address One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet.
             *                    You can't use this option if you're specifying a number of IPv6 addresses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Address(java.lang.String ipv6Address) {
                this.ipv6Address = ipv6Address;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Ipv6AddProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Ipv6AddProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Ipv6AddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Ipv6AddProperty {
            private final java.lang.String ipv6Address;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ipv6Address = software.amazon.jsii.Kernel.get(this, "ipv6Address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipv6Address = builder.ipv6Address;
            }

            @Override
            public final java.lang.String getIpv6Address() {
                return this.ipv6Address;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIpv6Address() != null) {
                    data.set("ipv6Address", om.valueToTree(this.getIpv6Address()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.Ipv6AddProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Ipv6AddProperty.Jsii$Proxy that = (Ipv6AddProperty.Jsii$Proxy) o;

                return this.ipv6Address != null ? this.ipv6Address.equals(that.ipv6Address) : that.ipv6Address == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ipv6Address != null ? this.ipv6Address.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies an IPv6 prefix for a network interface.
     * <p>
     * <code>Ipv6PrefixSpecification</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html">AWS::EC2::LaunchTemplate NetworkInterface</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * Ipv6PrefixSpecificationProperty ipv6PrefixSpecificationProperty = Ipv6PrefixSpecificationProperty.builder()
     *         .ipv6Prefix("ipv6Prefix")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.Ipv6PrefixSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(Ipv6PrefixSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Ipv6PrefixSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IPv6 prefix.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIpv6Prefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Ipv6PrefixSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Ipv6PrefixSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Ipv6PrefixSpecificationProperty> {
            java.lang.String ipv6Prefix;

            /**
             * Sets the value of {@link Ipv6PrefixSpecificationProperty#getIpv6Prefix}
             * @param ipv6Prefix The IPv6 prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Prefix(java.lang.String ipv6Prefix) {
                this.ipv6Prefix = ipv6Prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Ipv6PrefixSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Ipv6PrefixSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Ipv6PrefixSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Ipv6PrefixSpecificationProperty {
            private final java.lang.String ipv6Prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ipv6Prefix = software.amazon.jsii.Kernel.get(this, "ipv6Prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipv6Prefix = builder.ipv6Prefix;
            }

            @Override
            public final java.lang.String getIpv6Prefix() {
                return this.ipv6Prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIpv6Prefix() != null) {
                    data.set("ipv6Prefix", om.valueToTree(this.getIpv6Prefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.Ipv6PrefixSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Ipv6PrefixSpecificationProperty.Jsii$Proxy that = (Ipv6PrefixSpecificationProperty.Jsii$Proxy) o;

                return this.ipv6Prefix != null ? this.ipv6Prefix.equals(that.ipv6Prefix) : that.ipv6Prefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ipv6Prefix != null ? this.ipv6Prefix.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The information to include in the launch template.
     * <p>
     * <blockquote>
     * <p>
     * You must specify at least one parameter for the launch template data.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * LaunchTemplateDataProperty launchTemplateDataProperty = LaunchTemplateDataProperty.builder()
     *         .blockDeviceMappings(List.of(BlockDeviceMappingProperty.builder()
     *                 .deviceName("deviceName")
     *                 .ebs(EbsProperty.builder()
     *                         .deleteOnTermination(false)
     *                         .encrypted(false)
     *                         .iops(123)
     *                         .kmsKeyId("kmsKeyId")
     *                         .snapshotId("snapshotId")
     *                         .throughput(123)
     *                         .volumeSize(123)
     *                         .volumeType("volumeType")
     *                         .build())
     *                 .noDevice("noDevice")
     *                 .virtualName("virtualName")
     *                 .build()))
     *         .capacityReservationSpecification(CapacityReservationSpecificationProperty.builder()
     *                 .capacityReservationPreference("capacityReservationPreference")
     *                 .capacityReservationTarget(CapacityReservationTargetProperty.builder()
     *                         .capacityReservationId("capacityReservationId")
     *                         .capacityReservationResourceGroupArn("capacityReservationResourceGroupArn")
     *                         .build())
     *                 .build())
     *         .cpuOptions(CpuOptionsProperty.builder()
     *                 .coreCount(123)
     *                 .threadsPerCore(123)
     *                 .build())
     *         .creditSpecification(CreditSpecificationProperty.builder()
     *                 .cpuCredits("cpuCredits")
     *                 .build())
     *         .disableApiStop(false)
     *         .disableApiTermination(false)
     *         .ebsOptimized(false)
     *         .elasticGpuSpecifications(List.of(ElasticGpuSpecificationProperty.builder()
     *                 .type("type")
     *                 .build()))
     *         .elasticInferenceAccelerators(List.of(LaunchTemplateElasticInferenceAcceleratorProperty.builder()
     *                 .count(123)
     *                 .type("type")
     *                 .build()))
     *         .enclaveOptions(EnclaveOptionsProperty.builder()
     *                 .enabled(false)
     *                 .build())
     *         .hibernationOptions(HibernationOptionsProperty.builder()
     *                 .configured(false)
     *                 .build())
     *         .iamInstanceProfile(IamInstanceProfileProperty.builder()
     *                 .arn("arn")
     *                 .name("name")
     *                 .build())
     *         .imageId("imageId")
     *         .instanceInitiatedShutdownBehavior("instanceInitiatedShutdownBehavior")
     *         .instanceMarketOptions(InstanceMarketOptionsProperty.builder()
     *                 .marketType("marketType")
     *                 .spotOptions(SpotOptionsProperty.builder()
     *                         .blockDurationMinutes(123)
     *                         .instanceInterruptionBehavior("instanceInterruptionBehavior")
     *                         .maxPrice("maxPrice")
     *                         .spotInstanceType("spotInstanceType")
     *                         .validUntil("validUntil")
     *                         .build())
     *                 .build())
     *         .instanceRequirements(InstanceRequirementsProperty.builder()
     *                 .acceleratorCount(AcceleratorCountProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *                 .acceleratorNames(List.of("acceleratorNames"))
     *                 .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .acceleratorTypes(List.of("acceleratorTypes"))
     *                 .allowedInstanceTypes(List.of("allowedInstanceTypes"))
     *                 .bareMetal("bareMetal")
     *                 .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .burstablePerformance("burstablePerformance")
     *                 .cpuManufacturers(List.of("cpuManufacturers"))
     *                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *                 .instanceGenerations(List.of("instanceGenerations"))
     *                 .localStorage("localStorage")
     *                 .localStorageTypes(List.of("localStorageTypes"))
     *                 .memoryGiBPerVCpu(MemoryGiBPerVCpuProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .memoryMiB(MemoryMiBProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .networkBandwidthGbps(NetworkBandwidthGbpsProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .networkInterfaceCount(NetworkInterfaceCountProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .onDemandMaxPricePercentageOverLowestPrice(123)
     *                 .requireHibernateSupport(false)
     *                 .spotMaxPricePercentageOverLowestPrice(123)
     *                 .totalLocalStorageGb(TotalLocalStorageGBProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .vCpuCount(VCpuCountProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .build())
     *         .instanceType("instanceType")
     *         .kernelId("kernelId")
     *         .keyName("keyName")
     *         .licenseSpecifications(List.of(LicenseSpecificationProperty.builder()
     *                 .licenseConfigurationArn("licenseConfigurationArn")
     *                 .build()))
     *         .maintenanceOptions(MaintenanceOptionsProperty.builder()
     *                 .autoRecovery("autoRecovery")
     *                 .build())
     *         .metadataOptions(MetadataOptionsProperty.builder()
     *                 .httpEndpoint("httpEndpoint")
     *                 .httpProtocolIpv6("httpProtocolIpv6")
     *                 .httpPutResponseHopLimit(123)
     *                 .httpTokens("httpTokens")
     *                 .instanceMetadataTags("instanceMetadataTags")
     *                 .build())
     *         .monitoring(MonitoringProperty.builder()
     *                 .enabled(false)
     *                 .build())
     *         .networkInterfaces(List.of(NetworkInterfaceProperty.builder()
     *                 .associateCarrierIpAddress(false)
     *                 .associatePublicIpAddress(false)
     *                 .deleteOnTermination(false)
     *                 .description("description")
     *                 .deviceIndex(123)
     *                 .groups(List.of("groups"))
     *                 .interfaceType("interfaceType")
     *                 .ipv4PrefixCount(123)
     *                 .ipv4Prefixes(List.of(Ipv4PrefixSpecificationProperty.builder()
     *                         .ipv4Prefix("ipv4Prefix")
     *                         .build()))
     *                 .ipv6AddressCount(123)
     *                 .ipv6Addresses(List.of(Ipv6AddProperty.builder()
     *                         .ipv6Address("ipv6Address")
     *                         .build()))
     *                 .ipv6PrefixCount(123)
     *                 .ipv6Prefixes(List.of(Ipv6PrefixSpecificationProperty.builder()
     *                         .ipv6Prefix("ipv6Prefix")
     *                         .build()))
     *                 .networkCardIndex(123)
     *                 .networkInterfaceId("networkInterfaceId")
     *                 .privateIpAddress("privateIpAddress")
     *                 .privateIpAddresses(List.of(PrivateIpAddProperty.builder()
     *                         .primary(false)
     *                         .privateIpAddress("privateIpAddress")
     *                         .build()))
     *                 .secondaryPrivateIpAddressCount(123)
     *                 .subnetId("subnetId")
     *                 .build()))
     *         .placement(PlacementProperty.builder()
     *                 .affinity("affinity")
     *                 .availabilityZone("availabilityZone")
     *                 .groupId("groupId")
     *                 .groupName("groupName")
     *                 .hostId("hostId")
     *                 .hostResourceGroupArn("hostResourceGroupArn")
     *                 .partitionNumber(123)
     *                 .spreadDomain("spreadDomain")
     *                 .tenancy("tenancy")
     *                 .build())
     *         .privateDnsNameOptions(PrivateDnsNameOptionsProperty.builder()
     *                 .enableResourceNameDnsAaaaRecord(false)
     *                 .enableResourceNameDnsARecord(false)
     *                 .hostnameType("hostnameType")
     *                 .build())
     *         .ramDiskId("ramDiskId")
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .securityGroups(List.of("securityGroups"))
     *         .tagSpecifications(List.of(TagSpecificationProperty.builder()
     *                 .resourceType("resourceType")
     *                 .tags(List.of(CfnTag.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .build()))
     *         .userData("userData")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.LaunchTemplateDataProperty")
    @software.amazon.jsii.Jsii.Proxy(LaunchTemplateDataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LaunchTemplateDataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The block device mapping.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockDeviceMappings() {
            return null;
        }

        /**
         * The Capacity Reservation targeting option.
         * <p>
         * If you do not specify this parameter, the instance's Capacity Reservation preference defaults to <code>open</code> , which enables it to run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityReservationSpecification() {
            return null;
        }

        /**
         * The CPU options for the instance.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU Options</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCpuOptions() {
            return null;
        }

        /**
         * The credit option for CPU usage of the instance.
         * <p>
         * Valid only for T instances.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreditSpecification() {
            return null;
        }

        /**
         * Indicates whether to enable the instance for stop protection.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection">Stop protection</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableApiStop() {
            return null;
        }

        /**
         * If you set this parameter to `true` , you can't terminate the instance using the Amazon EC2 console, CLI, or API;
         * <p>
         * otherwise, you can. To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute</a> . Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code> , you can terminate the instance by running the shutdown command from the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableApiTermination() {
            return null;
        }

        /**
         * Indicates whether the instance is optimized for Amazon EBS I/O.
         * <p>
         * This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptimized() {
            return null;
        }

        /**
         * An elastic GPU to associate with the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getElasticGpuSpecifications() {
            return null;
        }

        /**
         * The elastic inference accelerator for the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getElasticInferenceAccelerators() {
            return null;
        }

        /**
         * Indicates whether the instance is enabled for AWS Nitro Enclaves.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html">What is AWS Nitro Enclaves?</a> in the <em>AWS Nitro Enclaves User Guide</em> .
         * <p>
         * You can't enable AWS Nitro Enclaves and hibernation on the same instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnclaveOptions() {
            return null;
        }

        /**
         * Indicates whether an instance is enabled for hibernation.
         * <p>
         * This parameter is valid only if the instance meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hibernating-prerequisites.html">hibernation prerequisites</a> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHibernationOptions() {
            return null;
        }

        /**
         * The name or Amazon Resource Name (ARN) of an IAM instance profile.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIamInstanceProfile() {
            return null;
        }

        /**
         * The ID of the AMI.
         * <p>
         * Alternatively, you can specify a Systems Manager parameter, which will resolve to an AMI ID on launch.
         * <p>
         * Valid formats:
         * <p>
         * <ul>
         * <li><code>ami-17characters00000</code></li>
         * <li><code>resolve:ssm:parameter-name</code></li>
         * <li><code>resolve:ssm:parameter-name:version-number</code></li>
         * <li><code>resolve:ssm:parameter-name:label</code></li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html#using-systems-manager-parameter-to-find-AMI">Use a Systems Manager parameter to find an AMI</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImageId() {
            return null;
        }

        /**
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
         * <p>
         * Default: <code>stop</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceInitiatedShutdownBehavior() {
            return null;
        }

        /**
         * The market (purchasing) option for the instances.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceMarketOptions() {
            return null;
        }

        /**
         * The attributes for the instance types.
         * <p>
         * When you specify instance attributes, Amazon EC2 will identify instance types with these attributes.
         * <p>
         * If you specify <code>InstanceRequirements</code> , you can't specify <code>InstanceType</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceRequirements() {
            return null;
        }

        /**
         * The instance type. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon Elastic Compute Cloud User Guide* .
         * <p>
         * If you specify <code>InstanceType</code> , you can't specify <code>InstanceRequirements</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * The ID of the kernel.
         * <p>
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User Provided Kernels</a> in the <em>Amazon EC2 User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKernelId() {
            return null;
        }

        /**
         * The name of the key pair. You can create a key pair using [CreateKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html) or [ImportKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html) .
         * <p>
         * <blockquote>
         * <p>
         * If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is configured to allow users another way to log in.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyName() {
            return null;
        }

        /**
         * The license configurations.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLicenseSpecifications() {
            return null;
        }

        /**
         * The maintenance options of your instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceOptions() {
            return null;
        }

        /**
         * The metadata options for the instance.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetadataOptions() {
            return null;
        }

        /**
         * The monitoring for the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMonitoring() {
            return null;
        }

        /**
         * One or more network interfaces.
         * <p>
         * If you specify a network interface, you must specify any security groups and subnets as part of the network interface.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterfaces() {
            return null;
        }

        /**
         * The placement for the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlacement() {
            return null;
        }

        /**
         * The options for the instance hostname.
         * <p>
         * The default values are inherited from the subnet.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrivateDnsNameOptions() {
            return null;
        }

        /**
         * The ID of the RAM disk.
         * <p>
         * <blockquote>
         * <p>
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User provided kernels</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRamDiskId() {
            return null;
        }

        /**
         * One or more security group IDs.
         * <p>
         * You can create a security group using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html">CreateSecurityGroup</a> . You cannot specify both a security group ID and security name in the same request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * One or more security group names.
         * <p>
         * For a nondefault VPC, you must use security group IDs instead. You cannot specify both a security group ID and security name in the same request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
            return null;
        }

        /**
         * The tags to apply to the resources that are created during instance launch.
         * <p>
         * You can specify tags for the following resources only:
         * <p>
         * <ul>
         * <li>Instances</li>
         * <li>Volumes</li>
         * <li>Elastic graphics</li>
         * <li>Spot Instance requests</li>
         * <li>Network interfaces</li>
         * </ul>
         * <p>
         * To tag a resource after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a> .
         * <p>
         * <blockquote>
         * <p>
         * To tag the launch template itself, you must use the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html">TagSpecification</a> parameter.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
            return null;
        }

        /**
         * The user data to make available to the instance.
         * <p>
         * You must provide base64-encoded text. User data is limited to 16 KB. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Run commands on your Linux instance at launch</a> (Linux) or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instancedata-add-user-data.html">Work with instance user data</a> (Windows) in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         * <p>
         * If you are creating the launch template for use with AWS Batch , the user data must be provided in the <a href="https://docs.aws.amazon.com/https://cloudinit.readthedocs.io/en/latest/topics/format.html#mime-multi-part-archive">MIME multi-part archive format</a> . For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Amazon EC2 user data in launch templates</a> in the <em>AWS Batch User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserData() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LaunchTemplateDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LaunchTemplateDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LaunchTemplateDataProperty> {
            java.lang.Object blockDeviceMappings;
            java.lang.Object capacityReservationSpecification;
            java.lang.Object cpuOptions;
            java.lang.Object creditSpecification;
            java.lang.Object disableApiStop;
            java.lang.Object disableApiTermination;
            java.lang.Object ebsOptimized;
            java.lang.Object elasticGpuSpecifications;
            java.lang.Object elasticInferenceAccelerators;
            java.lang.Object enclaveOptions;
            java.lang.Object hibernationOptions;
            java.lang.Object iamInstanceProfile;
            java.lang.String imageId;
            java.lang.String instanceInitiatedShutdownBehavior;
            java.lang.Object instanceMarketOptions;
            java.lang.Object instanceRequirements;
            java.lang.String instanceType;
            java.lang.String kernelId;
            java.lang.String keyName;
            java.lang.Object licenseSpecifications;
            java.lang.Object maintenanceOptions;
            java.lang.Object metadataOptions;
            java.lang.Object monitoring;
            java.lang.Object networkInterfaces;
            java.lang.Object placement;
            java.lang.Object privateDnsNameOptions;
            java.lang.String ramDiskId;
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> securityGroups;
            java.lang.Object tagSpecifications;
            java.lang.String userData;

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getBlockDeviceMappings}
             * @param blockDeviceMappings The block device mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockDeviceMappings(software.amazon.awscdk.core.IResolvable blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getBlockDeviceMappings}
             * @param blockDeviceMappings The block device mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockDeviceMappings(java.util.List<? extends java.lang.Object> blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getCapacityReservationSpecification}
             * @param capacityReservationSpecification The Capacity Reservation targeting option.
             *                                         If you do not specify this parameter, the instance's Capacity Reservation preference defaults to <code>open</code> , which enables it to run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationSpecification(software.amazon.awscdk.core.IResolvable capacityReservationSpecification) {
                this.capacityReservationSpecification = capacityReservationSpecification;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getCapacityReservationSpecification}
             * @param capacityReservationSpecification The Capacity Reservation targeting option.
             *                                         If you do not specify this parameter, the instance's Capacity Reservation preference defaults to <code>open</code> , which enables it to run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationSpecification(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CapacityReservationSpecificationProperty capacityReservationSpecification) {
                this.capacityReservationSpecification = capacityReservationSpecification;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getCpuOptions}
             * @param cpuOptions The CPU options for the instance.
             *                   For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU Options</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuOptions(software.amazon.awscdk.core.IResolvable cpuOptions) {
                this.cpuOptions = cpuOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getCpuOptions}
             * @param cpuOptions The CPU options for the instance.
             *                   For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU Options</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuOptions(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CpuOptionsProperty cpuOptions) {
                this.cpuOptions = cpuOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getCreditSpecification}
             * @param creditSpecification The credit option for CPU usage of the instance.
             *                            Valid only for T instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder creditSpecification(software.amazon.awscdk.core.IResolvable creditSpecification) {
                this.creditSpecification = creditSpecification;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getCreditSpecification}
             * @param creditSpecification The credit option for CPU usage of the instance.
             *                            Valid only for T instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder creditSpecification(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CreditSpecificationProperty creditSpecification) {
                this.creditSpecification = creditSpecification;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getDisableApiStop}
             * @param disableApiStop Indicates whether to enable the instance for stop protection.
             *                       For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection">Stop protection</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableApiStop(java.lang.Boolean disableApiStop) {
                this.disableApiStop = disableApiStop;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getDisableApiStop}
             * @param disableApiStop Indicates whether to enable the instance for stop protection.
             *                       For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection">Stop protection</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableApiStop(software.amazon.awscdk.core.IResolvable disableApiStop) {
                this.disableApiStop = disableApiStop;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getDisableApiTermination}
             * @param disableApiTermination If you set this parameter to `true` , you can't terminate the instance using the Amazon EC2 console, CLI, or API;.
             *                              otherwise, you can. To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute</a> . Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code> , you can terminate the instance by running the shutdown command from the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableApiTermination(java.lang.Boolean disableApiTermination) {
                this.disableApiTermination = disableApiTermination;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getDisableApiTermination}
             * @param disableApiTermination If you set this parameter to `true` , you can't terminate the instance using the Amazon EC2 console, CLI, or API;.
             *                              otherwise, you can. To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute</a> . Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code> , you can terminate the instance by running the shutdown command from the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableApiTermination(software.amazon.awscdk.core.IResolvable disableApiTermination) {
                this.disableApiTermination = disableApiTermination;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getEbsOptimized}
             * @param ebsOptimized Indicates whether the instance is optimized for Amazon EBS I/O.
             *                     This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getEbsOptimized}
             * @param ebsOptimized Indicates whether the instance is optimized for Amazon EBS I/O.
             *                     This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsOptimized(software.amazon.awscdk.core.IResolvable ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getElasticGpuSpecifications}
             * @param elasticGpuSpecifications An elastic GPU to associate with the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticGpuSpecifications(software.amazon.awscdk.core.IResolvable elasticGpuSpecifications) {
                this.elasticGpuSpecifications = elasticGpuSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getElasticGpuSpecifications}
             * @param elasticGpuSpecifications An elastic GPU to associate with the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticGpuSpecifications(java.util.List<? extends java.lang.Object> elasticGpuSpecifications) {
                this.elasticGpuSpecifications = elasticGpuSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getElasticInferenceAccelerators}
             * @param elasticInferenceAccelerators The elastic inference accelerator for the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticInferenceAccelerators(software.amazon.awscdk.core.IResolvable elasticInferenceAccelerators) {
                this.elasticInferenceAccelerators = elasticInferenceAccelerators;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getElasticInferenceAccelerators}
             * @param elasticInferenceAccelerators The elastic inference accelerator for the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticInferenceAccelerators(java.util.List<? extends java.lang.Object> elasticInferenceAccelerators) {
                this.elasticInferenceAccelerators = elasticInferenceAccelerators;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getEnclaveOptions}
             * @param enclaveOptions Indicates whether the instance is enabled for AWS Nitro Enclaves.
             *                       For more information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html">What is AWS Nitro Enclaves?</a> in the <em>AWS Nitro Enclaves User Guide</em> .
             *                       <p>
             *                       You can't enable AWS Nitro Enclaves and hibernation on the same instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enclaveOptions(software.amazon.awscdk.core.IResolvable enclaveOptions) {
                this.enclaveOptions = enclaveOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getEnclaveOptions}
             * @param enclaveOptions Indicates whether the instance is enabled for AWS Nitro Enclaves.
             *                       For more information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html">What is AWS Nitro Enclaves?</a> in the <em>AWS Nitro Enclaves User Guide</em> .
             *                       <p>
             *                       You can't enable AWS Nitro Enclaves and hibernation on the same instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enclaveOptions(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.EnclaveOptionsProperty enclaveOptions) {
                this.enclaveOptions = enclaveOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getHibernationOptions}
             * @param hibernationOptions Indicates whether an instance is enabled for hibernation.
             *                           This parameter is valid only if the instance meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hibernating-prerequisites.html">hibernation prerequisites</a> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hibernationOptions(software.amazon.awscdk.core.IResolvable hibernationOptions) {
                this.hibernationOptions = hibernationOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getHibernationOptions}
             * @param hibernationOptions Indicates whether an instance is enabled for hibernation.
             *                           This parameter is valid only if the instance meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hibernating-prerequisites.html">hibernation prerequisites</a> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hibernationOptions(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.HibernationOptionsProperty hibernationOptions) {
                this.hibernationOptions = hibernationOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getIamInstanceProfile}
             * @param iamInstanceProfile The name or Amazon Resource Name (ARN) of an IAM instance profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamInstanceProfile(software.amazon.awscdk.core.IResolvable iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getIamInstanceProfile}
             * @param iamInstanceProfile The name or Amazon Resource Name (ARN) of an IAM instance profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamInstanceProfile(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.IamInstanceProfileProperty iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getImageId}
             * @param imageId The ID of the AMI.
             *                Alternatively, you can specify a Systems Manager parameter, which will resolve to an AMI ID on launch.
             *                <p>
             *                Valid formats:
             *                <p>
             *                <ul>
             *                <li><code>ami-17characters00000</code></li>
             *                <li><code>resolve:ssm:parameter-name</code></li>
             *                <li><code>resolve:ssm:parameter-name:version-number</code></li>
             *                <li><code>resolve:ssm:parameter-name:label</code></li>
             *                </ul>
             *                <p>
             *                For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html#using-systems-manager-parameter-to-find-AMI">Use a Systems Manager parameter to find an AMI</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageId(java.lang.String imageId) {
                this.imageId = imageId;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getInstanceInitiatedShutdownBehavior}
             * @param instanceInitiatedShutdownBehavior Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
             *                                          Default: <code>stop</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceInitiatedShutdownBehavior(java.lang.String instanceInitiatedShutdownBehavior) {
                this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getInstanceMarketOptions}
             * @param instanceMarketOptions The market (purchasing) option for the instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceMarketOptions(software.amazon.awscdk.core.IResolvable instanceMarketOptions) {
                this.instanceMarketOptions = instanceMarketOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getInstanceMarketOptions}
             * @param instanceMarketOptions The market (purchasing) option for the instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceMarketOptions(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty instanceMarketOptions) {
                this.instanceMarketOptions = instanceMarketOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getInstanceRequirements}
             * @param instanceRequirements The attributes for the instance types.
             *                             When you specify instance attributes, Amazon EC2 will identify instance types with these attributes.
             *                             <p>
             *                             If you specify <code>InstanceRequirements</code> , you can't specify <code>InstanceType</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceRequirements(software.amazon.awscdk.core.IResolvable instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getInstanceRequirements}
             * @param instanceRequirements The attributes for the instance types.
             *                             When you specify instance attributes, Amazon EC2 will identify instance types with these attributes.
             *                             <p>
             *                             If you specify <code>InstanceRequirements</code> , you can't specify <code>InstanceType</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceRequirements(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.InstanceRequirementsProperty instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getInstanceType}
             * @param instanceType The instance type. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon Elastic Compute Cloud User Guide* .
             *                     If you specify <code>InstanceType</code> , you can't specify <code>InstanceRequirements</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getKernelId}
             * @param kernelId The ID of the kernel.
             *                 We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User Provided Kernels</a> in the <em>Amazon EC2 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kernelId(java.lang.String kernelId) {
                this.kernelId = kernelId;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getKeyName}
             * @param keyName The name of the key pair. You can create a key pair using [CreateKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html) or [ImportKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html) .
             *                <blockquote>
             *                <p>
             *                If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is configured to allow users another way to log in.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyName(java.lang.String keyName) {
                this.keyName = keyName;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getLicenseSpecifications}
             * @param licenseSpecifications The license configurations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder licenseSpecifications(software.amazon.awscdk.core.IResolvable licenseSpecifications) {
                this.licenseSpecifications = licenseSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getLicenseSpecifications}
             * @param licenseSpecifications The license configurations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder licenseSpecifications(java.util.List<? extends java.lang.Object> licenseSpecifications) {
                this.licenseSpecifications = licenseSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getMaintenanceOptions}
             * @param maintenanceOptions The maintenance options of your instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maintenanceOptions(software.amazon.awscdk.core.IResolvable maintenanceOptions) {
                this.maintenanceOptions = maintenanceOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getMaintenanceOptions}
             * @param maintenanceOptions The maintenance options of your instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maintenanceOptions(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.MaintenanceOptionsProperty maintenanceOptions) {
                this.maintenanceOptions = maintenanceOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getMetadataOptions}
             * @param metadataOptions The metadata options for the instance.
             *                        For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataOptions(software.amazon.awscdk.core.IResolvable metadataOptions) {
                this.metadataOptions = metadataOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getMetadataOptions}
             * @param metadataOptions The metadata options for the instance.
             *                        For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataOptions(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.MetadataOptionsProperty metadataOptions) {
                this.metadataOptions = metadataOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getMonitoring}
             * @param monitoring The monitoring for the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoring(software.amazon.awscdk.core.IResolvable monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getMonitoring}
             * @param monitoring The monitoring for the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoring(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.MonitoringProperty monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getNetworkInterfaces}
             * @param networkInterfaces One or more network interfaces.
             *                          If you specify a network interface, you must specify any security groups and subnets as part of the network interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaces(software.amazon.awscdk.core.IResolvable networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getNetworkInterfaces}
             * @param networkInterfaces One or more network interfaces.
             *                          If you specify a network interface, you must specify any security groups and subnets as part of the network interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaces(java.util.List<? extends java.lang.Object> networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getPlacement}
             * @param placement The placement for the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placement(software.amazon.awscdk.core.IResolvable placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getPlacement}
             * @param placement The placement for the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placement(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.PlacementProperty placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getPrivateDnsNameOptions}
             * @param privateDnsNameOptions The options for the instance hostname.
             *                              The default values are inherited from the subnet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateDnsNameOptions(software.amazon.awscdk.core.IResolvable privateDnsNameOptions) {
                this.privateDnsNameOptions = privateDnsNameOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getPrivateDnsNameOptions}
             * @param privateDnsNameOptions The options for the instance hostname.
             *                              The default values are inherited from the subnet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateDnsNameOptions(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.PrivateDnsNameOptionsProperty privateDnsNameOptions) {
                this.privateDnsNameOptions = privateDnsNameOptions;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getRamDiskId}
             * @param ramDiskId The ID of the RAM disk.
             *                  <blockquote>
             *                  <p>
             *                  We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User provided kernels</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ramDiskId(java.lang.String ramDiskId) {
                this.ramDiskId = ramDiskId;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getSecurityGroupIds}
             * @param securityGroupIds One or more security group IDs.
             *                         You can create a security group using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html">CreateSecurityGroup</a> . You cannot specify both a security group ID and security name in the same request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getSecurityGroups}
             * @param securityGroups One or more security group names.
             *                       For a nondefault VPC, you must use security group IDs instead. You cannot specify both a security group ID and security name in the same request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getTagSpecifications}
             * @param tagSpecifications The tags to apply to the resources that are created during instance launch.
             *                          You can specify tags for the following resources only:
             *                          <p>
             *                          <ul>
             *                          <li>Instances</li>
             *                          <li>Volumes</li>
             *                          <li>Elastic graphics</li>
             *                          <li>Spot Instance requests</li>
             *                          <li>Network interfaces</li>
             *                          </ul>
             *                          <p>
             *                          To tag a resource after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a> .
             *                          <p>
             *                          <blockquote>
             *                          <p>
             *                          To tag the launch template itself, you must use the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html">TagSpecification</a> parameter.
             *                          <p>
             *                          </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagSpecifications(software.amazon.awscdk.core.IResolvable tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getTagSpecifications}
             * @param tagSpecifications The tags to apply to the resources that are created during instance launch.
             *                          You can specify tags for the following resources only:
             *                          <p>
             *                          <ul>
             *                          <li>Instances</li>
             *                          <li>Volumes</li>
             *                          <li>Elastic graphics</li>
             *                          <li>Spot Instance requests</li>
             *                          <li>Network interfaces</li>
             *                          </ul>
             *                          <p>
             *                          To tag a resource after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a> .
             *                          <p>
             *                          <blockquote>
             *                          <p>
             *                          To tag the launch template itself, you must use the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html">TagSpecification</a> parameter.
             *                          <p>
             *                          </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagSpecifications(java.util.List<? extends java.lang.Object> tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateDataProperty#getUserData}
             * @param userData The user data to make available to the instance.
             *                 You must provide base64-encoded text. User data is limited to 16 KB. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Run commands on your Linux instance at launch</a> (Linux) or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instancedata-add-user-data.html">Work with instance user data</a> (Windows) in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             *                 <p>
             *                 If you are creating the launch template for use with AWS Batch , the user data must be provided in the <a href="https://docs.aws.amazon.com/https://cloudinit.readthedocs.io/en/latest/topics/format.html#mime-multi-part-archive">MIME multi-part archive format</a> . For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Amazon EC2 user data in launch templates</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userData(java.lang.String userData) {
                this.userData = userData;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LaunchTemplateDataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LaunchTemplateDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateDataProperty {
            private final java.lang.Object blockDeviceMappings;
            private final java.lang.Object capacityReservationSpecification;
            private final java.lang.Object cpuOptions;
            private final java.lang.Object creditSpecification;
            private final java.lang.Object disableApiStop;
            private final java.lang.Object disableApiTermination;
            private final java.lang.Object ebsOptimized;
            private final java.lang.Object elasticGpuSpecifications;
            private final java.lang.Object elasticInferenceAccelerators;
            private final java.lang.Object enclaveOptions;
            private final java.lang.Object hibernationOptions;
            private final java.lang.Object iamInstanceProfile;
            private final java.lang.String imageId;
            private final java.lang.String instanceInitiatedShutdownBehavior;
            private final java.lang.Object instanceMarketOptions;
            private final java.lang.Object instanceRequirements;
            private final java.lang.String instanceType;
            private final java.lang.String kernelId;
            private final java.lang.String keyName;
            private final java.lang.Object licenseSpecifications;
            private final java.lang.Object maintenanceOptions;
            private final java.lang.Object metadataOptions;
            private final java.lang.Object monitoring;
            private final java.lang.Object networkInterfaces;
            private final java.lang.Object placement;
            private final java.lang.Object privateDnsNameOptions;
            private final java.lang.String ramDiskId;
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> securityGroups;
            private final java.lang.Object tagSpecifications;
            private final java.lang.String userData;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blockDeviceMappings = software.amazon.jsii.Kernel.get(this, "blockDeviceMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.capacityReservationSpecification = software.amazon.jsii.Kernel.get(this, "capacityReservationSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cpuOptions = software.amazon.jsii.Kernel.get(this, "cpuOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.creditSpecification = software.amazon.jsii.Kernel.get(this, "creditSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.disableApiStop = software.amazon.jsii.Kernel.get(this, "disableApiStop", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.disableApiTermination = software.amazon.jsii.Kernel.get(this, "disableApiTermination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ebsOptimized = software.amazon.jsii.Kernel.get(this, "ebsOptimized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.elasticGpuSpecifications = software.amazon.jsii.Kernel.get(this, "elasticGpuSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.elasticInferenceAccelerators = software.amazon.jsii.Kernel.get(this, "elasticInferenceAccelerators", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enclaveOptions = software.amazon.jsii.Kernel.get(this, "enclaveOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hibernationOptions = software.amazon.jsii.Kernel.get(this, "hibernationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iamInstanceProfile = software.amazon.jsii.Kernel.get(this, "iamInstanceProfile", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.imageId = software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceInitiatedShutdownBehavior = software.amazon.jsii.Kernel.get(this, "instanceInitiatedShutdownBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceMarketOptions = software.amazon.jsii.Kernel.get(this, "instanceMarketOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.instanceRequirements = software.amazon.jsii.Kernel.get(this, "instanceRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kernelId = software.amazon.jsii.Kernel.get(this, "kernelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.licenseSpecifications = software.amazon.jsii.Kernel.get(this, "licenseSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maintenanceOptions = software.amazon.jsii.Kernel.get(this, "maintenanceOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metadataOptions = software.amazon.jsii.Kernel.get(this, "metadataOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.monitoring = software.amazon.jsii.Kernel.get(this, "monitoring", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkInterfaces = software.amazon.jsii.Kernel.get(this, "networkInterfaces", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.placement = software.amazon.jsii.Kernel.get(this, "placement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.privateDnsNameOptions = software.amazon.jsii.Kernel.get(this, "privateDnsNameOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ramDiskId = software.amazon.jsii.Kernel.get(this, "ramDiskId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.tagSpecifications = software.amazon.jsii.Kernel.get(this, "tagSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.userData = software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockDeviceMappings = builder.blockDeviceMappings;
                this.capacityReservationSpecification = builder.capacityReservationSpecification;
                this.cpuOptions = builder.cpuOptions;
                this.creditSpecification = builder.creditSpecification;
                this.disableApiStop = builder.disableApiStop;
                this.disableApiTermination = builder.disableApiTermination;
                this.ebsOptimized = builder.ebsOptimized;
                this.elasticGpuSpecifications = builder.elasticGpuSpecifications;
                this.elasticInferenceAccelerators = builder.elasticInferenceAccelerators;
                this.enclaveOptions = builder.enclaveOptions;
                this.hibernationOptions = builder.hibernationOptions;
                this.iamInstanceProfile = builder.iamInstanceProfile;
                this.imageId = builder.imageId;
                this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
                this.instanceMarketOptions = builder.instanceMarketOptions;
                this.instanceRequirements = builder.instanceRequirements;
                this.instanceType = builder.instanceType;
                this.kernelId = builder.kernelId;
                this.keyName = builder.keyName;
                this.licenseSpecifications = builder.licenseSpecifications;
                this.maintenanceOptions = builder.maintenanceOptions;
                this.metadataOptions = builder.metadataOptions;
                this.monitoring = builder.monitoring;
                this.networkInterfaces = builder.networkInterfaces;
                this.placement = builder.placement;
                this.privateDnsNameOptions = builder.privateDnsNameOptions;
                this.ramDiskId = builder.ramDiskId;
                this.securityGroupIds = builder.securityGroupIds;
                this.securityGroups = builder.securityGroups;
                this.tagSpecifications = builder.tagSpecifications;
                this.userData = builder.userData;
            }

            @Override
            public final java.lang.Object getBlockDeviceMappings() {
                return this.blockDeviceMappings;
            }

            @Override
            public final java.lang.Object getCapacityReservationSpecification() {
                return this.capacityReservationSpecification;
            }

            @Override
            public final java.lang.Object getCpuOptions() {
                return this.cpuOptions;
            }

            @Override
            public final java.lang.Object getCreditSpecification() {
                return this.creditSpecification;
            }

            @Override
            public final java.lang.Object getDisableApiStop() {
                return this.disableApiStop;
            }

            @Override
            public final java.lang.Object getDisableApiTermination() {
                return this.disableApiTermination;
            }

            @Override
            public final java.lang.Object getEbsOptimized() {
                return this.ebsOptimized;
            }

            @Override
            public final java.lang.Object getElasticGpuSpecifications() {
                return this.elasticGpuSpecifications;
            }

            @Override
            public final java.lang.Object getElasticInferenceAccelerators() {
                return this.elasticInferenceAccelerators;
            }

            @Override
            public final java.lang.Object getEnclaveOptions() {
                return this.enclaveOptions;
            }

            @Override
            public final java.lang.Object getHibernationOptions() {
                return this.hibernationOptions;
            }

            @Override
            public final java.lang.Object getIamInstanceProfile() {
                return this.iamInstanceProfile;
            }

            @Override
            public final java.lang.String getImageId() {
                return this.imageId;
            }

            @Override
            public final java.lang.String getInstanceInitiatedShutdownBehavior() {
                return this.instanceInitiatedShutdownBehavior;
            }

            @Override
            public final java.lang.Object getInstanceMarketOptions() {
                return this.instanceMarketOptions;
            }

            @Override
            public final java.lang.Object getInstanceRequirements() {
                return this.instanceRequirements;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getKernelId() {
                return this.kernelId;
            }

            @Override
            public final java.lang.String getKeyName() {
                return this.keyName;
            }

            @Override
            public final java.lang.Object getLicenseSpecifications() {
                return this.licenseSpecifications;
            }

            @Override
            public final java.lang.Object getMaintenanceOptions() {
                return this.maintenanceOptions;
            }

            @Override
            public final java.lang.Object getMetadataOptions() {
                return this.metadataOptions;
            }

            @Override
            public final java.lang.Object getMonitoring() {
                return this.monitoring;
            }

            @Override
            public final java.lang.Object getNetworkInterfaces() {
                return this.networkInterfaces;
            }

            @Override
            public final java.lang.Object getPlacement() {
                return this.placement;
            }

            @Override
            public final java.lang.Object getPrivateDnsNameOptions() {
                return this.privateDnsNameOptions;
            }

            @Override
            public final java.lang.String getRamDiskId() {
                return this.ramDiskId;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            public final java.lang.Object getTagSpecifications() {
                return this.tagSpecifications;
            }

            @Override
            public final java.lang.String getUserData() {
                return this.userData;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlockDeviceMappings() != null) {
                    data.set("blockDeviceMappings", om.valueToTree(this.getBlockDeviceMappings()));
                }
                if (this.getCapacityReservationSpecification() != null) {
                    data.set("capacityReservationSpecification", om.valueToTree(this.getCapacityReservationSpecification()));
                }
                if (this.getCpuOptions() != null) {
                    data.set("cpuOptions", om.valueToTree(this.getCpuOptions()));
                }
                if (this.getCreditSpecification() != null) {
                    data.set("creditSpecification", om.valueToTree(this.getCreditSpecification()));
                }
                if (this.getDisableApiStop() != null) {
                    data.set("disableApiStop", om.valueToTree(this.getDisableApiStop()));
                }
                if (this.getDisableApiTermination() != null) {
                    data.set("disableApiTermination", om.valueToTree(this.getDisableApiTermination()));
                }
                if (this.getEbsOptimized() != null) {
                    data.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
                }
                if (this.getElasticGpuSpecifications() != null) {
                    data.set("elasticGpuSpecifications", om.valueToTree(this.getElasticGpuSpecifications()));
                }
                if (this.getElasticInferenceAccelerators() != null) {
                    data.set("elasticInferenceAccelerators", om.valueToTree(this.getElasticInferenceAccelerators()));
                }
                if (this.getEnclaveOptions() != null) {
                    data.set("enclaveOptions", om.valueToTree(this.getEnclaveOptions()));
                }
                if (this.getHibernationOptions() != null) {
                    data.set("hibernationOptions", om.valueToTree(this.getHibernationOptions()));
                }
                if (this.getIamInstanceProfile() != null) {
                    data.set("iamInstanceProfile", om.valueToTree(this.getIamInstanceProfile()));
                }
                if (this.getImageId() != null) {
                    data.set("imageId", om.valueToTree(this.getImageId()));
                }
                if (this.getInstanceInitiatedShutdownBehavior() != null) {
                    data.set("instanceInitiatedShutdownBehavior", om.valueToTree(this.getInstanceInitiatedShutdownBehavior()));
                }
                if (this.getInstanceMarketOptions() != null) {
                    data.set("instanceMarketOptions", om.valueToTree(this.getInstanceMarketOptions()));
                }
                if (this.getInstanceRequirements() != null) {
                    data.set("instanceRequirements", om.valueToTree(this.getInstanceRequirements()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getKernelId() != null) {
                    data.set("kernelId", om.valueToTree(this.getKernelId()));
                }
                if (this.getKeyName() != null) {
                    data.set("keyName", om.valueToTree(this.getKeyName()));
                }
                if (this.getLicenseSpecifications() != null) {
                    data.set("licenseSpecifications", om.valueToTree(this.getLicenseSpecifications()));
                }
                if (this.getMaintenanceOptions() != null) {
                    data.set("maintenanceOptions", om.valueToTree(this.getMaintenanceOptions()));
                }
                if (this.getMetadataOptions() != null) {
                    data.set("metadataOptions", om.valueToTree(this.getMetadataOptions()));
                }
                if (this.getMonitoring() != null) {
                    data.set("monitoring", om.valueToTree(this.getMonitoring()));
                }
                if (this.getNetworkInterfaces() != null) {
                    data.set("networkInterfaces", om.valueToTree(this.getNetworkInterfaces()));
                }
                if (this.getPlacement() != null) {
                    data.set("placement", om.valueToTree(this.getPlacement()));
                }
                if (this.getPrivateDnsNameOptions() != null) {
                    data.set("privateDnsNameOptions", om.valueToTree(this.getPrivateDnsNameOptions()));
                }
                if (this.getRamDiskId() != null) {
                    data.set("ramDiskId", om.valueToTree(this.getRamDiskId()));
                }
                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }
                if (this.getSecurityGroups() != null) {
                    data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }
                if (this.getTagSpecifications() != null) {
                    data.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
                }
                if (this.getUserData() != null) {
                    data.set("userData", om.valueToTree(this.getUserData()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.LaunchTemplateDataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LaunchTemplateDataProperty.Jsii$Proxy that = (LaunchTemplateDataProperty.Jsii$Proxy) o;

                if (this.blockDeviceMappings != null ? !this.blockDeviceMappings.equals(that.blockDeviceMappings) : that.blockDeviceMappings != null) return false;
                if (this.capacityReservationSpecification != null ? !this.capacityReservationSpecification.equals(that.capacityReservationSpecification) : that.capacityReservationSpecification != null) return false;
                if (this.cpuOptions != null ? !this.cpuOptions.equals(that.cpuOptions) : that.cpuOptions != null) return false;
                if (this.creditSpecification != null ? !this.creditSpecification.equals(that.creditSpecification) : that.creditSpecification != null) return false;
                if (this.disableApiStop != null ? !this.disableApiStop.equals(that.disableApiStop) : that.disableApiStop != null) return false;
                if (this.disableApiTermination != null ? !this.disableApiTermination.equals(that.disableApiTermination) : that.disableApiTermination != null) return false;
                if (this.ebsOptimized != null ? !this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized != null) return false;
                if (this.elasticGpuSpecifications != null ? !this.elasticGpuSpecifications.equals(that.elasticGpuSpecifications) : that.elasticGpuSpecifications != null) return false;
                if (this.elasticInferenceAccelerators != null ? !this.elasticInferenceAccelerators.equals(that.elasticInferenceAccelerators) : that.elasticInferenceAccelerators != null) return false;
                if (this.enclaveOptions != null ? !this.enclaveOptions.equals(that.enclaveOptions) : that.enclaveOptions != null) return false;
                if (this.hibernationOptions != null ? !this.hibernationOptions.equals(that.hibernationOptions) : that.hibernationOptions != null) return false;
                if (this.iamInstanceProfile != null ? !this.iamInstanceProfile.equals(that.iamInstanceProfile) : that.iamInstanceProfile != null) return false;
                if (this.imageId != null ? !this.imageId.equals(that.imageId) : that.imageId != null) return false;
                if (this.instanceInitiatedShutdownBehavior != null ? !this.instanceInitiatedShutdownBehavior.equals(that.instanceInitiatedShutdownBehavior) : that.instanceInitiatedShutdownBehavior != null) return false;
                if (this.instanceMarketOptions != null ? !this.instanceMarketOptions.equals(that.instanceMarketOptions) : that.instanceMarketOptions != null) return false;
                if (this.instanceRequirements != null ? !this.instanceRequirements.equals(that.instanceRequirements) : that.instanceRequirements != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.kernelId != null ? !this.kernelId.equals(that.kernelId) : that.kernelId != null) return false;
                if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
                if (this.licenseSpecifications != null ? !this.licenseSpecifications.equals(that.licenseSpecifications) : that.licenseSpecifications != null) return false;
                if (this.maintenanceOptions != null ? !this.maintenanceOptions.equals(that.maintenanceOptions) : that.maintenanceOptions != null) return false;
                if (this.metadataOptions != null ? !this.metadataOptions.equals(that.metadataOptions) : that.metadataOptions != null) return false;
                if (this.monitoring != null ? !this.monitoring.equals(that.monitoring) : that.monitoring != null) return false;
                if (this.networkInterfaces != null ? !this.networkInterfaces.equals(that.networkInterfaces) : that.networkInterfaces != null) return false;
                if (this.placement != null ? !this.placement.equals(that.placement) : that.placement != null) return false;
                if (this.privateDnsNameOptions != null ? !this.privateDnsNameOptions.equals(that.privateDnsNameOptions) : that.privateDnsNameOptions != null) return false;
                if (this.ramDiskId != null ? !this.ramDiskId.equals(that.ramDiskId) : that.ramDiskId != null) return false;
                if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
                if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
                if (this.tagSpecifications != null ? !this.tagSpecifications.equals(that.tagSpecifications) : that.tagSpecifications != null) return false;
                return this.userData != null ? this.userData.equals(that.userData) : that.userData == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blockDeviceMappings != null ? this.blockDeviceMappings.hashCode() : 0;
                result = 31 * result + (this.capacityReservationSpecification != null ? this.capacityReservationSpecification.hashCode() : 0);
                result = 31 * result + (this.cpuOptions != null ? this.cpuOptions.hashCode() : 0);
                result = 31 * result + (this.creditSpecification != null ? this.creditSpecification.hashCode() : 0);
                result = 31 * result + (this.disableApiStop != null ? this.disableApiStop.hashCode() : 0);
                result = 31 * result + (this.disableApiTermination != null ? this.disableApiTermination.hashCode() : 0);
                result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
                result = 31 * result + (this.elasticGpuSpecifications != null ? this.elasticGpuSpecifications.hashCode() : 0);
                result = 31 * result + (this.elasticInferenceAccelerators != null ? this.elasticInferenceAccelerators.hashCode() : 0);
                result = 31 * result + (this.enclaveOptions != null ? this.enclaveOptions.hashCode() : 0);
                result = 31 * result + (this.hibernationOptions != null ? this.hibernationOptions.hashCode() : 0);
                result = 31 * result + (this.iamInstanceProfile != null ? this.iamInstanceProfile.hashCode() : 0);
                result = 31 * result + (this.imageId != null ? this.imageId.hashCode() : 0);
                result = 31 * result + (this.instanceInitiatedShutdownBehavior != null ? this.instanceInitiatedShutdownBehavior.hashCode() : 0);
                result = 31 * result + (this.instanceMarketOptions != null ? this.instanceMarketOptions.hashCode() : 0);
                result = 31 * result + (this.instanceRequirements != null ? this.instanceRequirements.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.kernelId != null ? this.kernelId.hashCode() : 0);
                result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
                result = 31 * result + (this.licenseSpecifications != null ? this.licenseSpecifications.hashCode() : 0);
                result = 31 * result + (this.maintenanceOptions != null ? this.maintenanceOptions.hashCode() : 0);
                result = 31 * result + (this.metadataOptions != null ? this.metadataOptions.hashCode() : 0);
                result = 31 * result + (this.monitoring != null ? this.monitoring.hashCode() : 0);
                result = 31 * result + (this.networkInterfaces != null ? this.networkInterfaces.hashCode() : 0);
                result = 31 * result + (this.placement != null ? this.placement.hashCode() : 0);
                result = 31 * result + (this.privateDnsNameOptions != null ? this.privateDnsNameOptions.hashCode() : 0);
                result = 31 * result + (this.ramDiskId != null ? this.ramDiskId.hashCode() : 0);
                result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
                result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
                result = 31 * result + (this.tagSpecifications != null ? this.tagSpecifications.hashCode() : 0);
                result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an elastic inference accelerator.
     * <p>
     * <code>LaunchTemplateElasticInferenceAccelerator</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html">AWS::EC2::LaunchTemplate LaunchTemplateData</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * LaunchTemplateElasticInferenceAcceleratorProperty launchTemplateElasticInferenceAcceleratorProperty = LaunchTemplateElasticInferenceAcceleratorProperty.builder()
     *         .count(123)
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty")
    @software.amazon.jsii.Jsii.Proxy(LaunchTemplateElasticInferenceAcceleratorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LaunchTemplateElasticInferenceAcceleratorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of elastic inference accelerators to attach to the instance.
         * <p>
         * Default: 1
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCount() {
            return null;
        }

        /**
         * The type of elastic inference accelerator.
         * <p>
         * The possible values are eia1.medium, eia1.large, and eia1.xlarge.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LaunchTemplateElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LaunchTemplateElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LaunchTemplateElasticInferenceAcceleratorProperty> {
            java.lang.Number count;
            java.lang.String type;

            /**
             * Sets the value of {@link LaunchTemplateElasticInferenceAcceleratorProperty#getCount}
             * @param count The number of elastic inference accelerators to attach to the instance.
             *              Default: 1
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(java.lang.Number count) {
                this.count = count;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateElasticInferenceAcceleratorProperty#getType}
             * @param type The type of elastic inference accelerator.
             *             The possible values are eia1.medium, eia1.large, and eia1.xlarge.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateElasticInferenceAcceleratorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LaunchTemplateElasticInferenceAcceleratorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LaunchTemplateElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateElasticInferenceAcceleratorProperty {
            private final java.lang.Number count;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.count = builder.count;
                this.type = builder.type;
            }

            @Override
            public final java.lang.Number getCount() {
                return this.count;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCount() != null) {
                    data.set("count", om.valueToTree(this.getCount()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LaunchTemplateElasticInferenceAcceleratorProperty.Jsii$Proxy that = (LaunchTemplateElasticInferenceAcceleratorProperty.Jsii$Proxy) o;

                if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.count != null ? this.count.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the tags to apply to the launch template during creation.
     * <p>
     * <code>LaunchTemplateTagSpecification</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html">AWS::EC2::LaunchTemplate</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * LaunchTemplateTagSpecificationProperty launchTemplateTagSpecificationProperty = LaunchTemplateTagSpecificationProperty.builder()
     *         .resourceType("resourceType")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.LaunchTemplateTagSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(LaunchTemplateTagSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LaunchTemplateTagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of resource.
         * <p>
         * To tag the launch template, <code>ResourceType</code> must be <code>launch-template</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
            return null;
        }

        /**
         * The tags for the resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LaunchTemplateTagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LaunchTemplateTagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LaunchTemplateTagSpecificationProperty> {
            java.lang.String resourceType;
            java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Sets the value of {@link LaunchTemplateTagSpecificationProperty#getResourceType}
             * @param resourceType The type of resource.
             *                     To tag the launch template, <code>ResourceType</code> must be <code>launch-template</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateTagSpecificationProperty#getTags}
             * @param tags The tags for the resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateTagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LaunchTemplateTagSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LaunchTemplateTagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateTagSpecificationProperty {
            private final java.lang.String resourceType;
            private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = builder.resourceType;
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResourceType() != null) {
                    data.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.LaunchTemplateTagSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LaunchTemplateTagSpecificationProperty.Jsii$Proxy that = (LaunchTemplateTagSpecificationProperty.Jsii$Proxy) o;

                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceType != null ? this.resourceType.hashCode() : 0;
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a license configuration for an instance.
     * <p>
     * <code>LicenseSpecification</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html">AWS::EC2::LaunchTemplate LaunchTemplateData</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * LicenseSpecificationProperty licenseSpecificationProperty = LicenseSpecificationProperty.builder()
     *         .licenseConfigurationArn("licenseConfigurationArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.LicenseSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(LicenseSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LicenseSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the license configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLicenseConfigurationArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LicenseSpecificationProperty> {
            java.lang.String licenseConfigurationArn;

            /**
             * Sets the value of {@link LicenseSpecificationProperty#getLicenseConfigurationArn}
             * @param licenseConfigurationArn The Amazon Resource Name (ARN) of the license configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder licenseConfigurationArn(java.lang.String licenseConfigurationArn) {
                this.licenseConfigurationArn = licenseConfigurationArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LicenseSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LicenseSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LicenseSpecificationProperty {
            private final java.lang.String licenseConfigurationArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.licenseConfigurationArn = software.amazon.jsii.Kernel.get(this, "licenseConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.licenseConfigurationArn = builder.licenseConfigurationArn;
            }

            @Override
            public final java.lang.String getLicenseConfigurationArn() {
                return this.licenseConfigurationArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLicenseConfigurationArn() != null) {
                    data.set("licenseConfigurationArn", om.valueToTree(this.getLicenseConfigurationArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.LicenseSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LicenseSpecificationProperty.Jsii$Proxy that = (LicenseSpecificationProperty.Jsii$Proxy) o;

                return this.licenseConfigurationArn != null ? this.licenseConfigurationArn.equals(that.licenseConfigurationArn) : that.licenseConfigurationArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.licenseConfigurationArn != null ? this.licenseConfigurationArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The maintenance options of your instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * MaintenanceOptionsProperty maintenanceOptionsProperty = MaintenanceOptionsProperty.builder()
     *         .autoRecovery("autoRecovery")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.MaintenanceOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(MaintenanceOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaintenanceOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Disables the automatic recovery behavior of your instance or sets it to default.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAutoRecovery() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MaintenanceOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaintenanceOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaintenanceOptionsProperty> {
            java.lang.String autoRecovery;

            /**
             * Sets the value of {@link MaintenanceOptionsProperty#getAutoRecovery}
             * @param autoRecovery Disables the automatic recovery behavior of your instance or sets it to default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoRecovery(java.lang.String autoRecovery) {
                this.autoRecovery = autoRecovery;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaintenanceOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaintenanceOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaintenanceOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaintenanceOptionsProperty {
            private final java.lang.String autoRecovery;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoRecovery = software.amazon.jsii.Kernel.get(this, "autoRecovery", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoRecovery = builder.autoRecovery;
            }

            @Override
            public final java.lang.String getAutoRecovery() {
                return this.autoRecovery;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoRecovery() != null) {
                    data.set("autoRecovery", om.valueToTree(this.getAutoRecovery()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.MaintenanceOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaintenanceOptionsProperty.Jsii$Proxy that = (MaintenanceOptionsProperty.Jsii$Proxy) o;

                return this.autoRecovery != null ? this.autoRecovery.equals(that.autoRecovery) : that.autoRecovery == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoRecovery != null ? this.autoRecovery.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of memory per vCPU, in GiB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * MemoryGiBPerVCpuProperty memoryGiBPerVCpuProperty = MemoryGiBPerVCpuProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.MemoryGiBPerVCpuProperty")
    @software.amazon.jsii.Jsii.Proxy(MemoryGiBPerVCpuProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemoryGiBPerVCpuProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of memory per vCPU, in GiB.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of memory per vCPU, in GiB.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemoryGiBPerVCpuProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemoryGiBPerVCpuProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemoryGiBPerVCpuProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link MemoryGiBPerVCpuProperty#getMax}
             * @param max The maximum amount of memory per vCPU, in GiB.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link MemoryGiBPerVCpuProperty#getMin}
             * @param min The minimum amount of memory per vCPU, in GiB.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemoryGiBPerVCpuProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemoryGiBPerVCpuProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemoryGiBPerVCpuProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemoryGiBPerVCpuProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.MemoryGiBPerVCpuProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemoryGiBPerVCpuProperty.Jsii$Proxy that = (MemoryGiBPerVCpuProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of memory, in MiB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * MemoryMiBProperty memoryMiBProperty = MemoryMiBProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.MemoryMiBProperty")
    @software.amazon.jsii.Jsii.Proxy(MemoryMiBProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemoryMiBProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of memory, in MiB.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of memory, in MiB.
         * <p>
         * To specify no minimum limit, specify <code>0</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemoryMiBProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemoryMiBProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemoryMiBProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link MemoryMiBProperty#getMax}
             * @param max The maximum amount of memory, in MiB.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link MemoryMiBProperty#getMin}
             * @param min The minimum amount of memory, in MiB.
             *            To specify no minimum limit, specify <code>0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemoryMiBProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemoryMiBProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemoryMiBProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemoryMiBProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.MemoryMiBProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemoryMiBProperty.Jsii$Proxy that = (MemoryMiBProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The metadata options for the instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * <code>MetadataOptions</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html">AWS::EC2::LaunchTemplate LaunchTemplateData</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * MetadataOptionsProperty metadataOptionsProperty = MetadataOptionsProperty.builder()
     *         .httpEndpoint("httpEndpoint")
     *         .httpProtocolIpv6("httpProtocolIpv6")
     *         .httpPutResponseHopLimit(123)
     *         .httpTokens("httpTokens")
     *         .instanceMetadataTags("instanceMetadataTags")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.MetadataOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(MetadataOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetadataOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables or disables the HTTP metadata endpoint on your instances.
         * <p>
         * If the parameter is not specified, the default state is <code>enabled</code> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify a value of <code>disabled</code> , you will not be able to access your instance metadata.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpEndpoint() {
            return null;
        }

        /**
         * Enables or disables the IPv6 endpoint for the instance metadata service.
         * <p>
         * Default: <code>disabled</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpProtocolIpv6() {
            return null;
        }

        /**
         * The desired HTTP PUT response hop limit for instance metadata requests.
         * <p>
         * The larger the number, the further instance metadata requests can travel.
         * <p>
         * Default: <code>1</code>
         * <p>
         * Possible values: Integers from 1 to 64
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHttpPutResponseHopLimit() {
            return null;
        }

        /**
         * IMDSv2 uses token-backed sessions.
         * <p>
         * Set the use of HTTP tokens to <code>optional</code> (in other words, set the use of IMDSv2 to <code>optional</code> ) or <code>required</code> (in other words, set the use of IMDSv2 to <code>required</code> ).
         * <p>
         * <ul>
         * <li><code>optional</code> - When IMDSv2 is optional, you can choose to retrieve instance metadata with or without a session token in your request. If you retrieve the IAM role credentials without a token, the IMDSv1 role credentials are returned. If you retrieve the IAM role credentials using a valid session token, the IMDSv2 role credentials are returned.</li>
         * <li><code>required</code> - When IMDSv2 is required, you must send a session token with any instance metadata retrieval requests. In this state, retrieving the IAM role credentials always returns IMDSv2 credentials; IMDSv1 credentials are not available.</li>
         * </ul>
         * <p>
         * Default: <code>optional</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpTokens() {
            return null;
        }

        /**
         * Set to `enabled` to allow access to instance tags from the instance metadata.
         * <p>
         * Set to <code>disabled</code> to turn off access to instance tags from the instance metadata. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with instance tags using the instance metadata</a> .
         * <p>
         * Default: <code>disabled</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceMetadataTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetadataOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetadataOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetadataOptionsProperty> {
            java.lang.String httpEndpoint;
            java.lang.String httpProtocolIpv6;
            java.lang.Number httpPutResponseHopLimit;
            java.lang.String httpTokens;
            java.lang.String instanceMetadataTags;

            /**
             * Sets the value of {@link MetadataOptionsProperty#getHttpEndpoint}
             * @param httpEndpoint Enables or disables the HTTP metadata endpoint on your instances.
             *                     If the parameter is not specified, the default state is <code>enabled</code> .
             *                     <p>
             *                     <blockquote>
             *                     <p>
             *                     If you specify a value of <code>disabled</code> , you will not be able to access your instance metadata.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpEndpoint(java.lang.String httpEndpoint) {
                this.httpEndpoint = httpEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link MetadataOptionsProperty#getHttpProtocolIpv6}
             * @param httpProtocolIpv6 Enables or disables the IPv6 endpoint for the instance metadata service.
             *                         Default: <code>disabled</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpProtocolIpv6(java.lang.String httpProtocolIpv6) {
                this.httpProtocolIpv6 = httpProtocolIpv6;
                return this;
            }

            /**
             * Sets the value of {@link MetadataOptionsProperty#getHttpPutResponseHopLimit}
             * @param httpPutResponseHopLimit The desired HTTP PUT response hop limit for instance metadata requests.
             *                                The larger the number, the further instance metadata requests can travel.
             *                                <p>
             *                                Default: <code>1</code>
             *                                <p>
             *                                Possible values: Integers from 1 to 64
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpPutResponseHopLimit(java.lang.Number httpPutResponseHopLimit) {
                this.httpPutResponseHopLimit = httpPutResponseHopLimit;
                return this;
            }

            /**
             * Sets the value of {@link MetadataOptionsProperty#getHttpTokens}
             * @param httpTokens IMDSv2 uses token-backed sessions.
             *                   Set the use of HTTP tokens to <code>optional</code> (in other words, set the use of IMDSv2 to <code>optional</code> ) or <code>required</code> (in other words, set the use of IMDSv2 to <code>required</code> ).
             *                   <p>
             *                   <ul>
             *                   <li><code>optional</code> - When IMDSv2 is optional, you can choose to retrieve instance metadata with or without a session token in your request. If you retrieve the IAM role credentials without a token, the IMDSv1 role credentials are returned. If you retrieve the IAM role credentials using a valid session token, the IMDSv2 role credentials are returned.</li>
             *                   <li><code>required</code> - When IMDSv2 is required, you must send a session token with any instance metadata retrieval requests. In this state, retrieving the IAM role credentials always returns IMDSv2 credentials; IMDSv1 credentials are not available.</li>
             *                   </ul>
             *                   <p>
             *                   Default: <code>optional</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpTokens(java.lang.String httpTokens) {
                this.httpTokens = httpTokens;
                return this;
            }

            /**
             * Sets the value of {@link MetadataOptionsProperty#getInstanceMetadataTags}
             * @param instanceMetadataTags Set to `enabled` to allow access to instance tags from the instance metadata.
             *                             Set to <code>disabled</code> to turn off access to instance tags from the instance metadata. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with instance tags using the instance metadata</a> .
             *                             <p>
             *                             Default: <code>disabled</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceMetadataTags(java.lang.String instanceMetadataTags) {
                this.instanceMetadataTags = instanceMetadataTags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetadataOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetadataOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetadataOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetadataOptionsProperty {
            private final java.lang.String httpEndpoint;
            private final java.lang.String httpProtocolIpv6;
            private final java.lang.Number httpPutResponseHopLimit;
            private final java.lang.String httpTokens;
            private final java.lang.String instanceMetadataTags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.httpEndpoint = software.amazon.jsii.Kernel.get(this, "httpEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.httpProtocolIpv6 = software.amazon.jsii.Kernel.get(this, "httpProtocolIpv6", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.httpPutResponseHopLimit = software.amazon.jsii.Kernel.get(this, "httpPutResponseHopLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.httpTokens = software.amazon.jsii.Kernel.get(this, "httpTokens", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceMetadataTags = software.amazon.jsii.Kernel.get(this, "instanceMetadataTags", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.httpEndpoint = builder.httpEndpoint;
                this.httpProtocolIpv6 = builder.httpProtocolIpv6;
                this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
                this.httpTokens = builder.httpTokens;
                this.instanceMetadataTags = builder.instanceMetadataTags;
            }

            @Override
            public final java.lang.String getHttpEndpoint() {
                return this.httpEndpoint;
            }

            @Override
            public final java.lang.String getHttpProtocolIpv6() {
                return this.httpProtocolIpv6;
            }

            @Override
            public final java.lang.Number getHttpPutResponseHopLimit() {
                return this.httpPutResponseHopLimit;
            }

            @Override
            public final java.lang.String getHttpTokens() {
                return this.httpTokens;
            }

            @Override
            public final java.lang.String getInstanceMetadataTags() {
                return this.instanceMetadataTags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHttpEndpoint() != null) {
                    data.set("httpEndpoint", om.valueToTree(this.getHttpEndpoint()));
                }
                if (this.getHttpProtocolIpv6() != null) {
                    data.set("httpProtocolIpv6", om.valueToTree(this.getHttpProtocolIpv6()));
                }
                if (this.getHttpPutResponseHopLimit() != null) {
                    data.set("httpPutResponseHopLimit", om.valueToTree(this.getHttpPutResponseHopLimit()));
                }
                if (this.getHttpTokens() != null) {
                    data.set("httpTokens", om.valueToTree(this.getHttpTokens()));
                }
                if (this.getInstanceMetadataTags() != null) {
                    data.set("instanceMetadataTags", om.valueToTree(this.getInstanceMetadataTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.MetadataOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetadataOptionsProperty.Jsii$Proxy that = (MetadataOptionsProperty.Jsii$Proxy) o;

                if (this.httpEndpoint != null ? !this.httpEndpoint.equals(that.httpEndpoint) : that.httpEndpoint != null) return false;
                if (this.httpProtocolIpv6 != null ? !this.httpProtocolIpv6.equals(that.httpProtocolIpv6) : that.httpProtocolIpv6 != null) return false;
                if (this.httpPutResponseHopLimit != null ? !this.httpPutResponseHopLimit.equals(that.httpPutResponseHopLimit) : that.httpPutResponseHopLimit != null) return false;
                if (this.httpTokens != null ? !this.httpTokens.equals(that.httpTokens) : that.httpTokens != null) return false;
                return this.instanceMetadataTags != null ? this.instanceMetadataTags.equals(that.instanceMetadataTags) : that.instanceMetadataTags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.httpEndpoint != null ? this.httpEndpoint.hashCode() : 0;
                result = 31 * result + (this.httpProtocolIpv6 != null ? this.httpProtocolIpv6.hashCode() : 0);
                result = 31 * result + (this.httpPutResponseHopLimit != null ? this.httpPutResponseHopLimit.hashCode() : 0);
                result = 31 * result + (this.httpTokens != null ? this.httpTokens.hashCode() : 0);
                result = 31 * result + (this.instanceMetadataTags != null ? this.instanceMetadataTags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies whether detailed monitoring is enabled for an instance.
     * <p>
     * For more information about detailed monitoring, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off detailed monitoring for your instances</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * <code>Monitoring</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html">AWS::EC2::LaunchTemplate LaunchTemplateData</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * MonitoringProperty monitoringProperty = MonitoringProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.MonitoringProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify `true` to enable detailed monitoring.
         * <p>
         * Otherwise, basic monitoring is enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link MonitoringProperty#getEnabled}
             * @param enabled Specify `true` to enable detailed monitoring.
             *                Otherwise, basic monitoring is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringProperty#getEnabled}
             * @param enabled Specify `true` to enable detailed monitoring.
             *                Otherwise, basic monitoring is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.MonitoringProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringProperty.Jsii$Proxy that = (MonitoringProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of network bandwidth, in gigabits per second (Gbps).
     * <p>
     * <blockquote>
     * <p>
     * Setting the minimum bandwidth does not guarantee that your instance will achieve the minimum bandwidth. Amazon EC2 will identify instance types that support the specified minimum bandwidth, but the actual bandwidth of your instance might go below the specified minimum at times. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-network-bandwidth.html#available-instance-bandwidth">Available instance bandwidth</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * NetworkBandwidthGbpsProperty networkBandwidthGbpsProperty = NetworkBandwidthGbpsProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.NetworkBandwidthGbpsProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkBandwidthGbpsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkBandwidthGbpsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of network bandwidth, in Gbps.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of network bandwidth, in Gbps.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkBandwidthGbpsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkBandwidthGbpsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkBandwidthGbpsProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link NetworkBandwidthGbpsProperty#getMax}
             * @param max The maximum amount of network bandwidth, in Gbps.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link NetworkBandwidthGbpsProperty#getMin}
             * @param min The minimum amount of network bandwidth, in Gbps.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkBandwidthGbpsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkBandwidthGbpsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkBandwidthGbpsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkBandwidthGbpsProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.NetworkBandwidthGbpsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkBandwidthGbpsProperty.Jsii$Proxy that = (NetworkBandwidthGbpsProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum number of network interfaces.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * NetworkInterfaceCountProperty networkInterfaceCountProperty = NetworkInterfaceCountProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.NetworkInterfaceCountProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkInterfaceCountProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkInterfaceCountProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of network interfaces.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum number of network interfaces.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkInterfaceCountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkInterfaceCountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkInterfaceCountProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link NetworkInterfaceCountProperty#getMax}
             * @param max The maximum number of network interfaces.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceCountProperty#getMin}
             * @param min The minimum number of network interfaces.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfaceCountProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkInterfaceCountProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkInterfaceCountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkInterfaceCountProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.NetworkInterfaceCountProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkInterfaceCountProperty.Jsii$Proxy that = (NetworkInterfaceCountProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the parameters for a network interface.
     * <p>
     * <code>NetworkInterface</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html">AWS::EC2::LaunchTemplate LaunchTemplateData</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * NetworkInterfaceProperty networkInterfaceProperty = NetworkInterfaceProperty.builder()
     *         .associateCarrierIpAddress(false)
     *         .associatePublicIpAddress(false)
     *         .deleteOnTermination(false)
     *         .description("description")
     *         .deviceIndex(123)
     *         .groups(List.of("groups"))
     *         .interfaceType("interfaceType")
     *         .ipv4PrefixCount(123)
     *         .ipv4Prefixes(List.of(Ipv4PrefixSpecificationProperty.builder()
     *                 .ipv4Prefix("ipv4Prefix")
     *                 .build()))
     *         .ipv6AddressCount(123)
     *         .ipv6Addresses(List.of(Ipv6AddProperty.builder()
     *                 .ipv6Address("ipv6Address")
     *                 .build()))
     *         .ipv6PrefixCount(123)
     *         .ipv6Prefixes(List.of(Ipv6PrefixSpecificationProperty.builder()
     *                 .ipv6Prefix("ipv6Prefix")
     *                 .build()))
     *         .networkCardIndex(123)
     *         .networkInterfaceId("networkInterfaceId")
     *         .privateIpAddress("privateIpAddress")
     *         .privateIpAddresses(List.of(PrivateIpAddProperty.builder()
     *                 .primary(false)
     *                 .privateIpAddress("privateIpAddress")
     *                 .build()))
     *         .secondaryPrivateIpAddressCount(123)
     *         .subnetId("subnetId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.NetworkInterfaceProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkInterfaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkInterfaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether to associate a Carrier IP address with eth0 for a new network interface.
         * <p>
         * Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with the network interface. For more information about Carrier IP addresses, see <a href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip">Carrier IP addresses</a> in the <em>AWS Wavelength Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAssociateCarrierIpAddress() {
            return null;
        }

        /**
         * Associates a public IPv4 address with eth0 for a new network interface.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAssociatePublicIpAddress() {
            return null;
        }

        /**
         * Indicates whether the network interface is deleted when the instance is terminated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteOnTermination() {
            return null;
        }

        /**
         * A description for the network interface.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The device index for the network interface attachment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDeviceIndex() {
            return null;
        }

        /**
         * The IDs of one or more security groups.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGroups() {
            return null;
        }

        /**
         * The type of network interface.
         * <p>
         * To create an Elastic Fabric Adapter (EFA), specify <code>efa</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html">Elastic Fabric Adapter</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         * <p>
         * If you are not creating an EFA, specify <code>interface</code> or omit this parameter.
         * <p>
         * Valid values: <code>interface</code> | <code>efa</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInterfaceType() {
            return null;
        }

        /**
         * The number of IPv4 prefixes to be automatically assigned to the network interface.
         * <p>
         * You cannot use this option if you use the <code>Ipv4Prefix</code> option.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIpv4PrefixCount() {
            return null;
        }

        /**
         * One or more IPv4 prefixes to be assigned to the network interface.
         * <p>
         * You cannot use this option if you use the <code>Ipv4PrefixCount</code> option.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpv4Prefixes() {
            return null;
        }

        /**
         * The number of IPv6 addresses to assign to a network interface.
         * <p>
         * Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIpv6AddressCount() {
            return null;
        }

        /**
         * One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet.
         * <p>
         * You can't use this option if you're specifying a number of IPv6 addresses.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpv6Addresses() {
            return null;
        }

        /**
         * The number of IPv6 prefixes to be automatically assigned to the network interface.
         * <p>
         * You cannot use this option if you use the <code>Ipv6Prefix</code> option.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIpv6PrefixCount() {
            return null;
        }

        /**
         * One or more IPv6 prefixes to be assigned to the network interface.
         * <p>
         * You cannot use this option if you use the <code>Ipv6PrefixCount</code> option.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpv6Prefixes() {
            return null;
        }

        /**
         * The index of the network card.
         * <p>
         * Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNetworkCardIndex() {
            return null;
        }

        /**
         * The ID of the network interface.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNetworkInterfaceId() {
            return null;
        }

        /**
         * The primary private IPv4 address of the network interface.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrivateIpAddress() {
            return null;
        }

        /**
         * One or more private IPv4 addresses.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrivateIpAddresses() {
            return null;
        }

        /**
         * The number of secondary private IPv4 addresses to assign to a network interface.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSecondaryPrivateIpAddressCount() {
            return null;
        }

        /**
         * The ID of the subnet for the network interface.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkInterfaceProperty> {
            java.lang.Object associateCarrierIpAddress;
            java.lang.Object associatePublicIpAddress;
            java.lang.Object deleteOnTermination;
            java.lang.String description;
            java.lang.Number deviceIndex;
            java.util.List<java.lang.String> groups;
            java.lang.String interfaceType;
            java.lang.Number ipv4PrefixCount;
            java.lang.Object ipv4Prefixes;
            java.lang.Number ipv6AddressCount;
            java.lang.Object ipv6Addresses;
            java.lang.Number ipv6PrefixCount;
            java.lang.Object ipv6Prefixes;
            java.lang.Number networkCardIndex;
            java.lang.String networkInterfaceId;
            java.lang.String privateIpAddress;
            java.lang.Object privateIpAddresses;
            java.lang.Number secondaryPrivateIpAddressCount;
            java.lang.String subnetId;

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getAssociateCarrierIpAddress}
             * @param associateCarrierIpAddress Indicates whether to associate a Carrier IP address with eth0 for a new network interface.
             *                                  Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with the network interface. For more information about Carrier IP addresses, see <a href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip">Carrier IP addresses</a> in the <em>AWS Wavelength Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associateCarrierIpAddress(java.lang.Boolean associateCarrierIpAddress) {
                this.associateCarrierIpAddress = associateCarrierIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getAssociateCarrierIpAddress}
             * @param associateCarrierIpAddress Indicates whether to associate a Carrier IP address with eth0 for a new network interface.
             *                                  Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with the network interface. For more information about Carrier IP addresses, see <a href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip">Carrier IP addresses</a> in the <em>AWS Wavelength Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associateCarrierIpAddress(software.amazon.awscdk.core.IResolvable associateCarrierIpAddress) {
                this.associateCarrierIpAddress = associateCarrierIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getAssociatePublicIpAddress}
             * @param associatePublicIpAddress Associates a public IPv4 address with eth0 for a new network interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associatePublicIpAddress(java.lang.Boolean associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getAssociatePublicIpAddress}
             * @param associatePublicIpAddress Associates a public IPv4 address with eth0 for a new network interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associatePublicIpAddress(software.amazon.awscdk.core.IResolvable associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getDeleteOnTermination}
             * @param deleteOnTermination Indicates whether the network interface is deleted when the instance is terminated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(java.lang.Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getDeleteOnTermination}
             * @param deleteOnTermination Indicates whether the network interface is deleted when the instance is terminated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(software.amazon.awscdk.core.IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getDescription}
             * @param description A description for the network interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getDeviceIndex}
             * @param deviceIndex The device index for the network interface attachment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceIndex(java.lang.Number deviceIndex) {
                this.deviceIndex = deviceIndex;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getGroups}
             * @param groups The IDs of one or more security groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groups(java.util.List<java.lang.String> groups) {
                this.groups = groups;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getInterfaceType}
             * @param interfaceType The type of network interface.
             *                      To create an Elastic Fabric Adapter (EFA), specify <code>efa</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html">Elastic Fabric Adapter</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             *                      <p>
             *                      If you are not creating an EFA, specify <code>interface</code> or omit this parameter.
             *                      <p>
             *                      Valid values: <code>interface</code> | <code>efa</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interfaceType(java.lang.String interfaceType) {
                this.interfaceType = interfaceType;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getIpv4PrefixCount}
             * @param ipv4PrefixCount The number of IPv4 prefixes to be automatically assigned to the network interface.
             *                        You cannot use this option if you use the <code>Ipv4Prefix</code> option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv4PrefixCount(java.lang.Number ipv4PrefixCount) {
                this.ipv4PrefixCount = ipv4PrefixCount;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getIpv4Prefixes}
             * @param ipv4Prefixes One or more IPv4 prefixes to be assigned to the network interface.
             *                     You cannot use this option if you use the <code>Ipv4PrefixCount</code> option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv4Prefixes(software.amazon.awscdk.core.IResolvable ipv4Prefixes) {
                this.ipv4Prefixes = ipv4Prefixes;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getIpv4Prefixes}
             * @param ipv4Prefixes One or more IPv4 prefixes to be assigned to the network interface.
             *                     You cannot use this option if you use the <code>Ipv4PrefixCount</code> option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv4Prefixes(java.util.List<? extends java.lang.Object> ipv4Prefixes) {
                this.ipv4Prefixes = ipv4Prefixes;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getIpv6AddressCount}
             * @param ipv6AddressCount The number of IPv6 addresses to assign to a network interface.
             *                         Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6AddressCount(java.lang.Number ipv6AddressCount) {
                this.ipv6AddressCount = ipv6AddressCount;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getIpv6Addresses}
             * @param ipv6Addresses One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet.
             *                      You can't use this option if you're specifying a number of IPv6 addresses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Addresses(software.amazon.awscdk.core.IResolvable ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getIpv6Addresses}
             * @param ipv6Addresses One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet.
             *                      You can't use this option if you're specifying a number of IPv6 addresses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Addresses(java.util.List<? extends java.lang.Object> ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getIpv6PrefixCount}
             * @param ipv6PrefixCount The number of IPv6 prefixes to be automatically assigned to the network interface.
             *                        You cannot use this option if you use the <code>Ipv6Prefix</code> option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6PrefixCount(java.lang.Number ipv6PrefixCount) {
                this.ipv6PrefixCount = ipv6PrefixCount;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getIpv6Prefixes}
             * @param ipv6Prefixes One or more IPv6 prefixes to be assigned to the network interface.
             *                     You cannot use this option if you use the <code>Ipv6PrefixCount</code> option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Prefixes(software.amazon.awscdk.core.IResolvable ipv6Prefixes) {
                this.ipv6Prefixes = ipv6Prefixes;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getIpv6Prefixes}
             * @param ipv6Prefixes One or more IPv6 prefixes to be assigned to the network interface.
             *                     You cannot use this option if you use the <code>Ipv6PrefixCount</code> option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Prefixes(java.util.List<? extends java.lang.Object> ipv6Prefixes) {
                this.ipv6Prefixes = ipv6Prefixes;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getNetworkCardIndex}
             * @param networkCardIndex The index of the network card.
             *                         Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkCardIndex(java.lang.Number networkCardIndex) {
                this.networkCardIndex = networkCardIndex;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getNetworkInterfaceId}
             * @param networkInterfaceId The ID of the network interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
                this.networkInterfaceId = networkInterfaceId;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getPrivateIpAddress}
             * @param privateIpAddress The primary private IPv4 address of the network interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddress(java.lang.String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getPrivateIpAddresses}
             * @param privateIpAddresses One or more private IPv4 addresses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddresses(software.amazon.awscdk.core.IResolvable privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getPrivateIpAddresses}
             * @param privateIpAddresses One or more private IPv4 addresses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddresses(java.util.List<? extends java.lang.Object> privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getSecondaryPrivateIpAddressCount}
             * @param secondaryPrivateIpAddressCount The number of secondary private IPv4 addresses to assign to a network interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryPrivateIpAddressCount(java.lang.Number secondaryPrivateIpAddressCount) {
                this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getSubnetId}
             * @param subnetId The ID of the subnet for the network interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkInterfaceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkInterfaceProperty {
            private final java.lang.Object associateCarrierIpAddress;
            private final java.lang.Object associatePublicIpAddress;
            private final java.lang.Object deleteOnTermination;
            private final java.lang.String description;
            private final java.lang.Number deviceIndex;
            private final java.util.List<java.lang.String> groups;
            private final java.lang.String interfaceType;
            private final java.lang.Number ipv4PrefixCount;
            private final java.lang.Object ipv4Prefixes;
            private final java.lang.Number ipv6AddressCount;
            private final java.lang.Object ipv6Addresses;
            private final java.lang.Number ipv6PrefixCount;
            private final java.lang.Object ipv6Prefixes;
            private final java.lang.Number networkCardIndex;
            private final java.lang.String networkInterfaceId;
            private final java.lang.String privateIpAddress;
            private final java.lang.Object privateIpAddresses;
            private final java.lang.Number secondaryPrivateIpAddressCount;
            private final java.lang.String subnetId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.associateCarrierIpAddress = software.amazon.jsii.Kernel.get(this, "associateCarrierIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.associatePublicIpAddress = software.amazon.jsii.Kernel.get(this, "associatePublicIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deleteOnTermination = software.amazon.jsii.Kernel.get(this, "deleteOnTermination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deviceIndex = software.amazon.jsii.Kernel.get(this, "deviceIndex", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.groups = software.amazon.jsii.Kernel.get(this, "groups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.interfaceType = software.amazon.jsii.Kernel.get(this, "interfaceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ipv4PrefixCount = software.amazon.jsii.Kernel.get(this, "ipv4PrefixCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ipv4Prefixes = software.amazon.jsii.Kernel.get(this, "ipv4Prefixes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ipv6AddressCount = software.amazon.jsii.Kernel.get(this, "ipv6AddressCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ipv6Addresses = software.amazon.jsii.Kernel.get(this, "ipv6Addresses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ipv6PrefixCount = software.amazon.jsii.Kernel.get(this, "ipv6PrefixCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ipv6Prefixes = software.amazon.jsii.Kernel.get(this, "ipv6Prefixes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkCardIndex = software.amazon.jsii.Kernel.get(this, "networkCardIndex", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.networkInterfaceId = software.amazon.jsii.Kernel.get(this, "networkInterfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.privateIpAddress = software.amazon.jsii.Kernel.get(this, "privateIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.privateIpAddresses = software.amazon.jsii.Kernel.get(this, "privateIpAddresses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secondaryPrivateIpAddressCount = software.amazon.jsii.Kernel.get(this, "secondaryPrivateIpAddressCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.associateCarrierIpAddress = builder.associateCarrierIpAddress;
                this.associatePublicIpAddress = builder.associatePublicIpAddress;
                this.deleteOnTermination = builder.deleteOnTermination;
                this.description = builder.description;
                this.deviceIndex = builder.deviceIndex;
                this.groups = builder.groups;
                this.interfaceType = builder.interfaceType;
                this.ipv4PrefixCount = builder.ipv4PrefixCount;
                this.ipv4Prefixes = builder.ipv4Prefixes;
                this.ipv6AddressCount = builder.ipv6AddressCount;
                this.ipv6Addresses = builder.ipv6Addresses;
                this.ipv6PrefixCount = builder.ipv6PrefixCount;
                this.ipv6Prefixes = builder.ipv6Prefixes;
                this.networkCardIndex = builder.networkCardIndex;
                this.networkInterfaceId = builder.networkInterfaceId;
                this.privateIpAddress = builder.privateIpAddress;
                this.privateIpAddresses = builder.privateIpAddresses;
                this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
                this.subnetId = builder.subnetId;
            }

            @Override
            public final java.lang.Object getAssociateCarrierIpAddress() {
                return this.associateCarrierIpAddress;
            }

            @Override
            public final java.lang.Object getAssociatePublicIpAddress() {
                return this.associatePublicIpAddress;
            }

            @Override
            public final java.lang.Object getDeleteOnTermination() {
                return this.deleteOnTermination;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Number getDeviceIndex() {
                return this.deviceIndex;
            }

            @Override
            public final java.util.List<java.lang.String> getGroups() {
                return this.groups;
            }

            @Override
            public final java.lang.String getInterfaceType() {
                return this.interfaceType;
            }

            @Override
            public final java.lang.Number getIpv4PrefixCount() {
                return this.ipv4PrefixCount;
            }

            @Override
            public final java.lang.Object getIpv4Prefixes() {
                return this.ipv4Prefixes;
            }

            @Override
            public final java.lang.Number getIpv6AddressCount() {
                return this.ipv6AddressCount;
            }

            @Override
            public final java.lang.Object getIpv6Addresses() {
                return this.ipv6Addresses;
            }

            @Override
            public final java.lang.Number getIpv6PrefixCount() {
                return this.ipv6PrefixCount;
            }

            @Override
            public final java.lang.Object getIpv6Prefixes() {
                return this.ipv6Prefixes;
            }

            @Override
            public final java.lang.Number getNetworkCardIndex() {
                return this.networkCardIndex;
            }

            @Override
            public final java.lang.String getNetworkInterfaceId() {
                return this.networkInterfaceId;
            }

            @Override
            public final java.lang.String getPrivateIpAddress() {
                return this.privateIpAddress;
            }

            @Override
            public final java.lang.Object getPrivateIpAddresses() {
                return this.privateIpAddresses;
            }

            @Override
            public final java.lang.Number getSecondaryPrivateIpAddressCount() {
                return this.secondaryPrivateIpAddressCount;
            }

            @Override
            public final java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAssociateCarrierIpAddress() != null) {
                    data.set("associateCarrierIpAddress", om.valueToTree(this.getAssociateCarrierIpAddress()));
                }
                if (this.getAssociatePublicIpAddress() != null) {
                    data.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
                }
                if (this.getDeleteOnTermination() != null) {
                    data.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getDeviceIndex() != null) {
                    data.set("deviceIndex", om.valueToTree(this.getDeviceIndex()));
                }
                if (this.getGroups() != null) {
                    data.set("groups", om.valueToTree(this.getGroups()));
                }
                if (this.getInterfaceType() != null) {
                    data.set("interfaceType", om.valueToTree(this.getInterfaceType()));
                }
                if (this.getIpv4PrefixCount() != null) {
                    data.set("ipv4PrefixCount", om.valueToTree(this.getIpv4PrefixCount()));
                }
                if (this.getIpv4Prefixes() != null) {
                    data.set("ipv4Prefixes", om.valueToTree(this.getIpv4Prefixes()));
                }
                if (this.getIpv6AddressCount() != null) {
                    data.set("ipv6AddressCount", om.valueToTree(this.getIpv6AddressCount()));
                }
                if (this.getIpv6Addresses() != null) {
                    data.set("ipv6Addresses", om.valueToTree(this.getIpv6Addresses()));
                }
                if (this.getIpv6PrefixCount() != null) {
                    data.set("ipv6PrefixCount", om.valueToTree(this.getIpv6PrefixCount()));
                }
                if (this.getIpv6Prefixes() != null) {
                    data.set("ipv6Prefixes", om.valueToTree(this.getIpv6Prefixes()));
                }
                if (this.getNetworkCardIndex() != null) {
                    data.set("networkCardIndex", om.valueToTree(this.getNetworkCardIndex()));
                }
                if (this.getNetworkInterfaceId() != null) {
                    data.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
                }
                if (this.getPrivateIpAddress() != null) {
                    data.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                }
                if (this.getPrivateIpAddresses() != null) {
                    data.set("privateIpAddresses", om.valueToTree(this.getPrivateIpAddresses()));
                }
                if (this.getSecondaryPrivateIpAddressCount() != null) {
                    data.set("secondaryPrivateIpAddressCount", om.valueToTree(this.getSecondaryPrivateIpAddressCount()));
                }
                if (this.getSubnetId() != null) {
                    data.set("subnetId", om.valueToTree(this.getSubnetId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.NetworkInterfaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkInterfaceProperty.Jsii$Proxy that = (NetworkInterfaceProperty.Jsii$Proxy) o;

                if (this.associateCarrierIpAddress != null ? !this.associateCarrierIpAddress.equals(that.associateCarrierIpAddress) : that.associateCarrierIpAddress != null) return false;
                if (this.associatePublicIpAddress != null ? !this.associatePublicIpAddress.equals(that.associatePublicIpAddress) : that.associatePublicIpAddress != null) return false;
                if (this.deleteOnTermination != null ? !this.deleteOnTermination.equals(that.deleteOnTermination) : that.deleteOnTermination != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.deviceIndex != null ? !this.deviceIndex.equals(that.deviceIndex) : that.deviceIndex != null) return false;
                if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) return false;
                if (this.interfaceType != null ? !this.interfaceType.equals(that.interfaceType) : that.interfaceType != null) return false;
                if (this.ipv4PrefixCount != null ? !this.ipv4PrefixCount.equals(that.ipv4PrefixCount) : that.ipv4PrefixCount != null) return false;
                if (this.ipv4Prefixes != null ? !this.ipv4Prefixes.equals(that.ipv4Prefixes) : that.ipv4Prefixes != null) return false;
                if (this.ipv6AddressCount != null ? !this.ipv6AddressCount.equals(that.ipv6AddressCount) : that.ipv6AddressCount != null) return false;
                if (this.ipv6Addresses != null ? !this.ipv6Addresses.equals(that.ipv6Addresses) : that.ipv6Addresses != null) return false;
                if (this.ipv6PrefixCount != null ? !this.ipv6PrefixCount.equals(that.ipv6PrefixCount) : that.ipv6PrefixCount != null) return false;
                if (this.ipv6Prefixes != null ? !this.ipv6Prefixes.equals(that.ipv6Prefixes) : that.ipv6Prefixes != null) return false;
                if (this.networkCardIndex != null ? !this.networkCardIndex.equals(that.networkCardIndex) : that.networkCardIndex != null) return false;
                if (this.networkInterfaceId != null ? !this.networkInterfaceId.equals(that.networkInterfaceId) : that.networkInterfaceId != null) return false;
                if (this.privateIpAddress != null ? !this.privateIpAddress.equals(that.privateIpAddress) : that.privateIpAddress != null) return false;
                if (this.privateIpAddresses != null ? !this.privateIpAddresses.equals(that.privateIpAddresses) : that.privateIpAddresses != null) return false;
                if (this.secondaryPrivateIpAddressCount != null ? !this.secondaryPrivateIpAddressCount.equals(that.secondaryPrivateIpAddressCount) : that.secondaryPrivateIpAddressCount != null) return false;
                return this.subnetId != null ? this.subnetId.equals(that.subnetId) : that.subnetId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.associateCarrierIpAddress != null ? this.associateCarrierIpAddress.hashCode() : 0;
                result = 31 * result + (this.associatePublicIpAddress != null ? this.associatePublicIpAddress.hashCode() : 0);
                result = 31 * result + (this.deleteOnTermination != null ? this.deleteOnTermination.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.deviceIndex != null ? this.deviceIndex.hashCode() : 0);
                result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
                result = 31 * result + (this.interfaceType != null ? this.interfaceType.hashCode() : 0);
                result = 31 * result + (this.ipv4PrefixCount != null ? this.ipv4PrefixCount.hashCode() : 0);
                result = 31 * result + (this.ipv4Prefixes != null ? this.ipv4Prefixes.hashCode() : 0);
                result = 31 * result + (this.ipv6AddressCount != null ? this.ipv6AddressCount.hashCode() : 0);
                result = 31 * result + (this.ipv6Addresses != null ? this.ipv6Addresses.hashCode() : 0);
                result = 31 * result + (this.ipv6PrefixCount != null ? this.ipv6PrefixCount.hashCode() : 0);
                result = 31 * result + (this.ipv6Prefixes != null ? this.ipv6Prefixes.hashCode() : 0);
                result = 31 * result + (this.networkCardIndex != null ? this.networkCardIndex.hashCode() : 0);
                result = 31 * result + (this.networkInterfaceId != null ? this.networkInterfaceId.hashCode() : 0);
                result = 31 * result + (this.privateIpAddress != null ? this.privateIpAddress.hashCode() : 0);
                result = 31 * result + (this.privateIpAddresses != null ? this.privateIpAddresses.hashCode() : 0);
                result = 31 * result + (this.secondaryPrivateIpAddressCount != null ? this.secondaryPrivateIpAddressCount.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the placement of an instance.
     * <p>
     * <code>Placement</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html">AWS::EC2::LaunchTemplate LaunchTemplateData</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * PlacementProperty placementProperty = PlacementProperty.builder()
     *         .affinity("affinity")
     *         .availabilityZone("availabilityZone")
     *         .groupId("groupId")
     *         .groupName("groupName")
     *         .hostId("hostId")
     *         .hostResourceGroupArn("hostResourceGroupArn")
     *         .partitionNumber(123)
     *         .spreadDomain("spreadDomain")
     *         .tenancy("tenancy")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.PlacementProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlacementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The affinity setting for an instance on a Dedicated Host.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAffinity() {
            return null;
        }

        /**
         * The Availability Zone for the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * The Group Id of a placement group.
         * <p>
         * You must specify the Placement Group <em>Group Id</em> to launch an instance in a shared placement group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupId() {
            return null;
        }

        /**
         * The name of the placement group for the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
            return null;
        }

        /**
         * The ID of the Dedicated Host for the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostId() {
            return null;
        }

        /**
         * The ARN of the host resource group in which to launch the instances.
         * <p>
         * If you specify a host resource group ARN, omit the <em>Tenancy</em> parameter or set it to <code>host</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostResourceGroupArn() {
            return null;
        }

        /**
         * The number of the partition the instance should launch in.
         * <p>
         * Valid only if the placement group strategy is set to <code>partition</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPartitionNumber() {
            return null;
        }

        /**
         * Reserved for future use.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpreadDomain() {
            return null;
        }

        /**
         * The tenancy of the instance (if the instance is running in a VPC).
         * <p>
         * An instance with a tenancy of dedicated runs on single-tenant hardware.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTenancy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementProperty> {
            java.lang.String affinity;
            java.lang.String availabilityZone;
            java.lang.String groupId;
            java.lang.String groupName;
            java.lang.String hostId;
            java.lang.String hostResourceGroupArn;
            java.lang.Number partitionNumber;
            java.lang.String spreadDomain;
            java.lang.String tenancy;

            /**
             * Sets the value of {@link PlacementProperty#getAffinity}
             * @param affinity The affinity setting for an instance on a Dedicated Host.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder affinity(java.lang.String affinity) {
                this.affinity = affinity;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getAvailabilityZone}
             * @param availabilityZone The Availability Zone for the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getGroupId}
             * @param groupId The Group Id of a placement group.
             *                You must specify the Placement Group <em>Group Id</em> to launch an instance in a shared placement group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupId(java.lang.String groupId) {
                this.groupId = groupId;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getGroupName}
             * @param groupName The name of the placement group for the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupName(java.lang.String groupName) {
                this.groupName = groupName;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getHostId}
             * @param hostId The ID of the Dedicated Host for the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostId(java.lang.String hostId) {
                this.hostId = hostId;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getHostResourceGroupArn}
             * @param hostResourceGroupArn The ARN of the host resource group in which to launch the instances.
             *                             If you specify a host resource group ARN, omit the <em>Tenancy</em> parameter or set it to <code>host</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostResourceGroupArn(java.lang.String hostResourceGroupArn) {
                this.hostResourceGroupArn = hostResourceGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getPartitionNumber}
             * @param partitionNumber The number of the partition the instance should launch in.
             *                        Valid only if the placement group strategy is set to <code>partition</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionNumber(java.lang.Number partitionNumber) {
                this.partitionNumber = partitionNumber;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getSpreadDomain}
             * @param spreadDomain Reserved for future use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spreadDomain(java.lang.String spreadDomain) {
                this.spreadDomain = spreadDomain;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getTenancy}
             * @param tenancy The tenancy of the instance (if the instance is running in a VPC).
             *                An instance with a tenancy of dedicated runs on single-tenant hardware.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tenancy(java.lang.String tenancy) {
                this.tenancy = tenancy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlacementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementProperty {
            private final java.lang.String affinity;
            private final java.lang.String availabilityZone;
            private final java.lang.String groupId;
            private final java.lang.String groupName;
            private final java.lang.String hostId;
            private final java.lang.String hostResourceGroupArn;
            private final java.lang.Number partitionNumber;
            private final java.lang.String spreadDomain;
            private final java.lang.String tenancy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.affinity = software.amazon.jsii.Kernel.get(this, "affinity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupId = software.amazon.jsii.Kernel.get(this, "groupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostId = software.amazon.jsii.Kernel.get(this, "hostId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostResourceGroupArn = software.amazon.jsii.Kernel.get(this, "hostResourceGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.partitionNumber = software.amazon.jsii.Kernel.get(this, "partitionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.spreadDomain = software.amazon.jsii.Kernel.get(this, "spreadDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tenancy = software.amazon.jsii.Kernel.get(this, "tenancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.affinity = builder.affinity;
                this.availabilityZone = builder.availabilityZone;
                this.groupId = builder.groupId;
                this.groupName = builder.groupName;
                this.hostId = builder.hostId;
                this.hostResourceGroupArn = builder.hostResourceGroupArn;
                this.partitionNumber = builder.partitionNumber;
                this.spreadDomain = builder.spreadDomain;
                this.tenancy = builder.tenancy;
            }

            @Override
            public final java.lang.String getAffinity() {
                return this.affinity;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.lang.String getGroupId() {
                return this.groupId;
            }

            @Override
            public final java.lang.String getGroupName() {
                return this.groupName;
            }

            @Override
            public final java.lang.String getHostId() {
                return this.hostId;
            }

            @Override
            public final java.lang.String getHostResourceGroupArn() {
                return this.hostResourceGroupArn;
            }

            @Override
            public final java.lang.Number getPartitionNumber() {
                return this.partitionNumber;
            }

            @Override
            public final java.lang.String getSpreadDomain() {
                return this.spreadDomain;
            }

            @Override
            public final java.lang.String getTenancy() {
                return this.tenancy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAffinity() != null) {
                    data.set("affinity", om.valueToTree(this.getAffinity()));
                }
                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getGroupId() != null) {
                    data.set("groupId", om.valueToTree(this.getGroupId()));
                }
                if (this.getGroupName() != null) {
                    data.set("groupName", om.valueToTree(this.getGroupName()));
                }
                if (this.getHostId() != null) {
                    data.set("hostId", om.valueToTree(this.getHostId()));
                }
                if (this.getHostResourceGroupArn() != null) {
                    data.set("hostResourceGroupArn", om.valueToTree(this.getHostResourceGroupArn()));
                }
                if (this.getPartitionNumber() != null) {
                    data.set("partitionNumber", om.valueToTree(this.getPartitionNumber()));
                }
                if (this.getSpreadDomain() != null) {
                    data.set("spreadDomain", om.valueToTree(this.getSpreadDomain()));
                }
                if (this.getTenancy() != null) {
                    data.set("tenancy", om.valueToTree(this.getTenancy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.PlacementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementProperty.Jsii$Proxy that = (PlacementProperty.Jsii$Proxy) o;

                if (this.affinity != null ? !this.affinity.equals(that.affinity) : that.affinity != null) return false;
                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) return false;
                if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
                if (this.hostId != null ? !this.hostId.equals(that.hostId) : that.hostId != null) return false;
                if (this.hostResourceGroupArn != null ? !this.hostResourceGroupArn.equals(that.hostResourceGroupArn) : that.hostResourceGroupArn != null) return false;
                if (this.partitionNumber != null ? !this.partitionNumber.equals(that.partitionNumber) : that.partitionNumber != null) return false;
                if (this.spreadDomain != null ? !this.spreadDomain.equals(that.spreadDomain) : that.spreadDomain != null) return false;
                return this.tenancy != null ? this.tenancy.equals(that.tenancy) : that.tenancy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.affinity != null ? this.affinity.hashCode() : 0;
                result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
                result = 31 * result + (this.groupId != null ? this.groupId.hashCode() : 0);
                result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
                result = 31 * result + (this.hostId != null ? this.hostId.hashCode() : 0);
                result = 31 * result + (this.hostResourceGroupArn != null ? this.hostResourceGroupArn.hashCode() : 0);
                result = 31 * result + (this.partitionNumber != null ? this.partitionNumber.hashCode() : 0);
                result = 31 * result + (this.spreadDomain != null ? this.spreadDomain.hashCode() : 0);
                result = 31 * result + (this.tenancy != null ? this.tenancy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the options for instance hostnames.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * PrivateDnsNameOptionsProperty privateDnsNameOptionsProperty = PrivateDnsNameOptionsProperty.builder()
     *         .enableResourceNameDnsAaaaRecord(false)
     *         .enableResourceNameDnsARecord(false)
     *         .hostnameType("hostnameType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.PrivateDnsNameOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(PrivateDnsNameOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrivateDnsNameOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableResourceNameDnsAaaaRecord() {
            return null;
        }

        /**
         * Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableResourceNameDnsARecord() {
            return null;
        }

        /**
         * The type of hostname for EC2 instances.
         * <p>
         * For IPv4 only subnets, an instance DNS name must be based on the instance IPv4 address. For IPv6 only subnets, an instance DNS name must be based on the instance ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">Amazon EC2 instance hostname types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostnameType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PrivateDnsNameOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrivateDnsNameOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrivateDnsNameOptionsProperty> {
            java.lang.Object enableResourceNameDnsAaaaRecord;
            java.lang.Object enableResourceNameDnsARecord;
            java.lang.String hostnameType;

            /**
             * Sets the value of {@link PrivateDnsNameOptionsProperty#getEnableResourceNameDnsAaaaRecord}
             * @param enableResourceNameDnsAaaaRecord Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableResourceNameDnsAaaaRecord(java.lang.Boolean enableResourceNameDnsAaaaRecord) {
                this.enableResourceNameDnsAaaaRecord = enableResourceNameDnsAaaaRecord;
                return this;
            }

            /**
             * Sets the value of {@link PrivateDnsNameOptionsProperty#getEnableResourceNameDnsAaaaRecord}
             * @param enableResourceNameDnsAaaaRecord Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableResourceNameDnsAaaaRecord(software.amazon.awscdk.core.IResolvable enableResourceNameDnsAaaaRecord) {
                this.enableResourceNameDnsAaaaRecord = enableResourceNameDnsAaaaRecord;
                return this;
            }

            /**
             * Sets the value of {@link PrivateDnsNameOptionsProperty#getEnableResourceNameDnsARecord}
             * @param enableResourceNameDnsARecord Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableResourceNameDnsARecord(java.lang.Boolean enableResourceNameDnsARecord) {
                this.enableResourceNameDnsARecord = enableResourceNameDnsARecord;
                return this;
            }

            /**
             * Sets the value of {@link PrivateDnsNameOptionsProperty#getEnableResourceNameDnsARecord}
             * @param enableResourceNameDnsARecord Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableResourceNameDnsARecord(software.amazon.awscdk.core.IResolvable enableResourceNameDnsARecord) {
                this.enableResourceNameDnsARecord = enableResourceNameDnsARecord;
                return this;
            }

            /**
             * Sets the value of {@link PrivateDnsNameOptionsProperty#getHostnameType}
             * @param hostnameType The type of hostname for EC2 instances.
             *                     For IPv4 only subnets, an instance DNS name must be based on the instance IPv4 address. For IPv6 only subnets, an instance DNS name must be based on the instance ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">Amazon EC2 instance hostname types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostnameType(java.lang.String hostnameType) {
                this.hostnameType = hostnameType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateDnsNameOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrivateDnsNameOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrivateDnsNameOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivateDnsNameOptionsProperty {
            private final java.lang.Object enableResourceNameDnsAaaaRecord;
            private final java.lang.Object enableResourceNameDnsARecord;
            private final java.lang.String hostnameType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableResourceNameDnsAaaaRecord = software.amazon.jsii.Kernel.get(this, "enableResourceNameDnsAaaaRecord", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableResourceNameDnsARecord = software.amazon.jsii.Kernel.get(this, "enableResourceNameDnsARecord", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hostnameType = software.amazon.jsii.Kernel.get(this, "hostnameType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableResourceNameDnsAaaaRecord = builder.enableResourceNameDnsAaaaRecord;
                this.enableResourceNameDnsARecord = builder.enableResourceNameDnsARecord;
                this.hostnameType = builder.hostnameType;
            }

            @Override
            public final java.lang.Object getEnableResourceNameDnsAaaaRecord() {
                return this.enableResourceNameDnsAaaaRecord;
            }

            @Override
            public final java.lang.Object getEnableResourceNameDnsARecord() {
                return this.enableResourceNameDnsARecord;
            }

            @Override
            public final java.lang.String getHostnameType() {
                return this.hostnameType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnableResourceNameDnsAaaaRecord() != null) {
                    data.set("enableResourceNameDnsAaaaRecord", om.valueToTree(this.getEnableResourceNameDnsAaaaRecord()));
                }
                if (this.getEnableResourceNameDnsARecord() != null) {
                    data.set("enableResourceNameDnsARecord", om.valueToTree(this.getEnableResourceNameDnsARecord()));
                }
                if (this.getHostnameType() != null) {
                    data.set("hostnameType", om.valueToTree(this.getHostnameType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.PrivateDnsNameOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrivateDnsNameOptionsProperty.Jsii$Proxy that = (PrivateDnsNameOptionsProperty.Jsii$Proxy) o;

                if (this.enableResourceNameDnsAaaaRecord != null ? !this.enableResourceNameDnsAaaaRecord.equals(that.enableResourceNameDnsAaaaRecord) : that.enableResourceNameDnsAaaaRecord != null) return false;
                if (this.enableResourceNameDnsARecord != null ? !this.enableResourceNameDnsARecord.equals(that.enableResourceNameDnsARecord) : that.enableResourceNameDnsARecord != null) return false;
                return this.hostnameType != null ? this.hostnameType.equals(that.hostnameType) : that.hostnameType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableResourceNameDnsAaaaRecord != null ? this.enableResourceNameDnsAaaaRecord.hashCode() : 0;
                result = 31 * result + (this.enableResourceNameDnsARecord != null ? this.enableResourceNameDnsARecord.hashCode() : 0);
                result = 31 * result + (this.hostnameType != null ? this.hostnameType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a secondary private IPv4 address for a network interface.
     * <p>
     * <code>PrivateIpAdd</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html">AWS::EC2::LaunchTemplate NetworkInterface</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * PrivateIpAddProperty privateIpAddProperty = PrivateIpAddProperty.builder()
     *         .primary(false)
     *         .privateIpAddress("privateIpAddress")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.PrivateIpAddProperty")
    @software.amazon.jsii.Jsii.Proxy(PrivateIpAddProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrivateIpAddProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the private IPv4 address is the primary private IPv4 address.
         * <p>
         * Only one IPv4 address can be designated as primary.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrimary() {
            return null;
        }

        /**
         * The private IPv4 address.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrivateIpAddress() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PrivateIpAddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrivateIpAddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrivateIpAddProperty> {
            java.lang.Object primary;
            java.lang.String privateIpAddress;

            /**
             * Sets the value of {@link PrivateIpAddProperty#getPrimary}
             * @param primary Indicates whether the private IPv4 address is the primary private IPv4 address.
             *                Only one IPv4 address can be designated as primary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primary(java.lang.Boolean primary) {
                this.primary = primary;
                return this;
            }

            /**
             * Sets the value of {@link PrivateIpAddProperty#getPrimary}
             * @param primary Indicates whether the private IPv4 address is the primary private IPv4 address.
             *                Only one IPv4 address can be designated as primary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primary(software.amazon.awscdk.core.IResolvable primary) {
                this.primary = primary;
                return this;
            }

            /**
             * Sets the value of {@link PrivateIpAddProperty#getPrivateIpAddress}
             * @param privateIpAddress The private IPv4 address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddress(java.lang.String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateIpAddProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrivateIpAddProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrivateIpAddProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivateIpAddProperty {
            private final java.lang.Object primary;
            private final java.lang.String privateIpAddress;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.primary = software.amazon.jsii.Kernel.get(this, "primary", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.privateIpAddress = software.amazon.jsii.Kernel.get(this, "privateIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.primary = builder.primary;
                this.privateIpAddress = builder.privateIpAddress;
            }

            @Override
            public final java.lang.Object getPrimary() {
                return this.primary;
            }

            @Override
            public final java.lang.String getPrivateIpAddress() {
                return this.privateIpAddress;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPrimary() != null) {
                    data.set("primary", om.valueToTree(this.getPrimary()));
                }
                if (this.getPrivateIpAddress() != null) {
                    data.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.PrivateIpAddProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrivateIpAddProperty.Jsii$Proxy that = (PrivateIpAddProperty.Jsii$Proxy) o;

                if (this.primary != null ? !this.primary.equals(that.primary) : that.primary != null) return false;
                return this.privateIpAddress != null ? this.privateIpAddress.equals(that.privateIpAddress) : that.privateIpAddress == null;
            }

            @Override
            public final int hashCode() {
                int result = this.primary != null ? this.primary.hashCode() : 0;
                result = 31 * result + (this.privateIpAddress != null ? this.privateIpAddress.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies options for Spot Instances.
     * <p>
     * <code>SpotOptions</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html">AWS::EC2::LaunchTemplate InstanceMarketOptions</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * SpotOptionsProperty spotOptionsProperty = SpotOptionsProperty.builder()
     *         .blockDurationMinutes(123)
     *         .instanceInterruptionBehavior("instanceInterruptionBehavior")
     *         .maxPrice("maxPrice")
     *         .spotInstanceType("spotInstanceType")
     *         .validUntil("validUntil")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.SpotOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Deprecated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBlockDurationMinutes() {
            return null;
        }

        /**
         * The behavior when a Spot Instance is interrupted.
         * <p>
         * The default is <code>terminate</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceInterruptionBehavior() {
            return null;
        }

        /**
         * The maximum hourly price you're willing to pay for the Spot Instances.
         * <p>
         * We do not recommend using this parameter because it can lead to increased interruptions. If you do not specify this parameter, you will pay the current Spot price.
         * <p>
         * <blockquote>
         * <p>
         * If you specify a maximum price, your Spot Instances will be interrupted more frequently than if you do not specify this parameter.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxPrice() {
            return null;
        }

        /**
         * The Spot Instance request type.
         * <p>
         * If you are using Spot Instances with an Auto Scaling group, use <code>one-time</code> requests, as the Amazon EC2 Auto Scaling service handles requesting new Spot Instances whenever the group is below its desired capacity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpotInstanceType() {
            return null;
        }

        /**
         * The end date of the request, in UTC format ( *YYYY-MM-DD* T *HH:MM:SS* Z). Supported only for persistent requests.
         * <p>
         * <ul>
         * <li>For a persistent request, the request remains active until the <code>ValidUntil</code> date and time is reached. Otherwise, the request remains active until you cancel it.</li>
         * <li>For a one-time request, <code>ValidUntil</code> is not supported. The request remains active until all instances launch or you cancel the request.</li>
         * </ul>
         * <p>
         * Default: 7 days from the current date
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValidUntil() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotOptionsProperty> {
            java.lang.Number blockDurationMinutes;
            java.lang.String instanceInterruptionBehavior;
            java.lang.String maxPrice;
            java.lang.String spotInstanceType;
            java.lang.String validUntil;

            /**
             * Sets the value of {@link SpotOptionsProperty#getBlockDurationMinutes}
             * @param blockDurationMinutes Deprecated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockDurationMinutes(java.lang.Number blockDurationMinutes) {
                this.blockDurationMinutes = blockDurationMinutes;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsProperty#getInstanceInterruptionBehavior}
             * @param instanceInterruptionBehavior The behavior when a Spot Instance is interrupted.
             *                                     The default is <code>terminate</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceInterruptionBehavior(java.lang.String instanceInterruptionBehavior) {
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsProperty#getMaxPrice}
             * @param maxPrice The maximum hourly price you're willing to pay for the Spot Instances.
             *                 We do not recommend using this parameter because it can lead to increased interruptions. If you do not specify this parameter, you will pay the current Spot price.
             *                 <p>
             *                 <blockquote>
             *                 <p>
             *                 If you specify a maximum price, your Spot Instances will be interrupted more frequently than if you do not specify this parameter.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxPrice(java.lang.String maxPrice) {
                this.maxPrice = maxPrice;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsProperty#getSpotInstanceType}
             * @param spotInstanceType The Spot Instance request type.
             *                         If you are using Spot Instances with an Auto Scaling group, use <code>one-time</code> requests, as the Amazon EC2 Auto Scaling service handles requesting new Spot Instances whenever the group is below its desired capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotInstanceType(java.lang.String spotInstanceType) {
                this.spotInstanceType = spotInstanceType;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsProperty#getValidUntil}
             * @param validUntil The end date of the request, in UTC format ( *YYYY-MM-DD* T *HH:MM:SS* Z). Supported only for persistent requests.
             *                   <ul>
             *                   <li>For a persistent request, the request remains active until the <code>ValidUntil</code> date and time is reached. Otherwise, the request remains active until you cancel it.</li>
             *                   <li>For a one-time request, <code>ValidUntil</code> is not supported. The request remains active until all instances launch or you cancel the request.</li>
             *                   </ul>
             *                   <p>
             *                   Default: 7 days from the current date
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validUntil(java.lang.String validUntil) {
                this.validUntil = validUntil;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotOptionsProperty {
            private final java.lang.Number blockDurationMinutes;
            private final java.lang.String instanceInterruptionBehavior;
            private final java.lang.String maxPrice;
            private final java.lang.String spotInstanceType;
            private final java.lang.String validUntil;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blockDurationMinutes = software.amazon.jsii.Kernel.get(this, "blockDurationMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceInterruptionBehavior = software.amazon.jsii.Kernel.get(this, "instanceInterruptionBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxPrice = software.amazon.jsii.Kernel.get(this, "maxPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.spotInstanceType = software.amazon.jsii.Kernel.get(this, "spotInstanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.validUntil = software.amazon.jsii.Kernel.get(this, "validUntil", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockDurationMinutes = builder.blockDurationMinutes;
                this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
                this.maxPrice = builder.maxPrice;
                this.spotInstanceType = builder.spotInstanceType;
                this.validUntil = builder.validUntil;
            }

            @Override
            public final java.lang.Number getBlockDurationMinutes() {
                return this.blockDurationMinutes;
            }

            @Override
            public final java.lang.String getInstanceInterruptionBehavior() {
                return this.instanceInterruptionBehavior;
            }

            @Override
            public final java.lang.String getMaxPrice() {
                return this.maxPrice;
            }

            @Override
            public final java.lang.String getSpotInstanceType() {
                return this.spotInstanceType;
            }

            @Override
            public final java.lang.String getValidUntil() {
                return this.validUntil;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlockDurationMinutes() != null) {
                    data.set("blockDurationMinutes", om.valueToTree(this.getBlockDurationMinutes()));
                }
                if (this.getInstanceInterruptionBehavior() != null) {
                    data.set("instanceInterruptionBehavior", om.valueToTree(this.getInstanceInterruptionBehavior()));
                }
                if (this.getMaxPrice() != null) {
                    data.set("maxPrice", om.valueToTree(this.getMaxPrice()));
                }
                if (this.getSpotInstanceType() != null) {
                    data.set("spotInstanceType", om.valueToTree(this.getSpotInstanceType()));
                }
                if (this.getValidUntil() != null) {
                    data.set("validUntil", om.valueToTree(this.getValidUntil()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.SpotOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotOptionsProperty.Jsii$Proxy that = (SpotOptionsProperty.Jsii$Proxy) o;

                if (this.blockDurationMinutes != null ? !this.blockDurationMinutes.equals(that.blockDurationMinutes) : that.blockDurationMinutes != null) return false;
                if (this.instanceInterruptionBehavior != null ? !this.instanceInterruptionBehavior.equals(that.instanceInterruptionBehavior) : that.instanceInterruptionBehavior != null) return false;
                if (this.maxPrice != null ? !this.maxPrice.equals(that.maxPrice) : that.maxPrice != null) return false;
                if (this.spotInstanceType != null ? !this.spotInstanceType.equals(that.spotInstanceType) : that.spotInstanceType != null) return false;
                return this.validUntil != null ? this.validUntil.equals(that.validUntil) : that.validUntil == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blockDurationMinutes != null ? this.blockDurationMinutes.hashCode() : 0;
                result = 31 * result + (this.instanceInterruptionBehavior != null ? this.instanceInterruptionBehavior.hashCode() : 0);
                result = 31 * result + (this.maxPrice != null ? this.maxPrice.hashCode() : 0);
                result = 31 * result + (this.spotInstanceType != null ? this.spotInstanceType.hashCode() : 0);
                result = 31 * result + (this.validUntil != null ? this.validUntil.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the tags to apply to a resource when the resource is created for the launch template.
     * <p>
     * <code>TagSpecification</code> is a property type of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications"><code>TagSpecifications</code></a> . <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications"><code>TagSpecifications</code></a> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html">AWS::EC2::LaunchTemplate LaunchTemplateData</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TagSpecificationProperty tagSpecificationProperty = TagSpecificationProperty.builder()
     *         .resourceType("resourceType")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.TagSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(TagSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of resource to tag.
         * <p>
         * The <code>Valid Values</code> are all the resource types that can be tagged. However, when creating a launch template, you can specify tags for the following resource types only: <code>instance</code> | <code>volume</code> | <code>elastic-gpu</code> | <code>network-interface</code> | <code>spot-instances-request</code>
         * <p>
         * To tag a resource after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
            return null;
        }

        /**
         * The tags to apply to the resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagSpecificationProperty> {
            java.lang.String resourceType;
            java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Sets the value of {@link TagSpecificationProperty#getResourceType}
             * @param resourceType The type of resource to tag.
             *                     The <code>Valid Values</code> are all the resource types that can be tagged. However, when creating a launch template, you can specify tags for the following resource types only: <code>instance</code> | <code>volume</code> | <code>elastic-gpu</code> | <code>network-interface</code> | <code>spot-instances-request</code>
             *                     <p>
             *                     To tag a resource after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link TagSpecificationProperty#getTags}
             * @param tags The tags to apply to the resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagSpecificationProperty {
            private final java.lang.String resourceType;
            private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = builder.resourceType;
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResourceType() != null) {
                    data.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.TagSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagSpecificationProperty.Jsii$Proxy that = (TagSpecificationProperty.Jsii$Proxy) o;

                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceType != null ? this.resourceType.hashCode() : 0;
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of total local storage, in GB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TotalLocalStorageGBProperty totalLocalStorageGBProperty = TotalLocalStorageGBProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.TotalLocalStorageGBProperty")
    @software.amazon.jsii.Jsii.Proxy(TotalLocalStorageGBProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TotalLocalStorageGBProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of total local storage, in GB.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of total local storage, in GB.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TotalLocalStorageGBProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TotalLocalStorageGBProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TotalLocalStorageGBProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link TotalLocalStorageGBProperty#getMax}
             * @param max The maximum amount of total local storage, in GB.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link TotalLocalStorageGBProperty#getMin}
             * @param min The minimum amount of total local storage, in GB.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TotalLocalStorageGBProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TotalLocalStorageGBProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TotalLocalStorageGBProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TotalLocalStorageGBProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.TotalLocalStorageGBProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TotalLocalStorageGBProperty.Jsii$Proxy that = (TotalLocalStorageGBProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum number of vCPUs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * VCpuCountProperty vCpuCountProperty = VCpuCountProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate.VCpuCountProperty")
    @software.amazon.jsii.Jsii.Proxy(VCpuCountProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VCpuCountProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of vCPUs.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum number of vCPUs.
         * <p>
         * To specify no minimum limit, specify <code>0</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VCpuCountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VCpuCountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VCpuCountProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link VCpuCountProperty#getMax}
             * @param max The maximum number of vCPUs.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link VCpuCountProperty#getMin}
             * @param min The minimum number of vCPUs.
             *            To specify no minimum limit, specify <code>0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VCpuCountProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VCpuCountProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VCpuCountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VCpuCountProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLaunchTemplate.VCpuCountProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VCpuCountProperty.Jsii$Proxy that = (VCpuCountProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnLaunchTemplate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnLaunchTemplate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps.Builder();
        }

        /**
         * The information for the launch template.
         * <p>
         * @return {@code this}
         * @param launchTemplateData The information for the launch template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateData(final software.amazon.awscdk.core.IResolvable launchTemplateData) {
            this.props.launchTemplateData(launchTemplateData);
            return this;
        }
        /**
         * The information for the launch template.
         * <p>
         * @return {@code this}
         * @param launchTemplateData The information for the launch template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateData(final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LaunchTemplateDataProperty launchTemplateData) {
            this.props.launchTemplateData(launchTemplateData);
            return this;
        }

        /**
         * A name for the launch template.
         * <p>
         * @return {@code this}
         * @param launchTemplateName A name for the launch template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateName(final java.lang.String launchTemplateName) {
            this.props.launchTemplateName(launchTemplateName);
            return this;
        }

        /**
         * The tags to apply to the launch template on creation.
         * <p>
         * To tag the launch template, the resource type must be <code>launch-template</code> .
         * <p>
         * <blockquote>
         * <p>
         * To specify the tags for the resources that are created when an instance is launched, you must use the <code>TagSpecifications</code> parameter in the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestLaunchTemplateData.html">launch template data</a> structure.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param tagSpecifications The tags to apply to the launch template on creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(final software.amazon.awscdk.core.IResolvable tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }
        /**
         * The tags to apply to the launch template on creation.
         * <p>
         * To tag the launch template, the resource type must be <code>launch-template</code> .
         * <p>
         * <blockquote>
         * <p>
         * To specify the tags for the resources that are created when an instance is launched, you must use the <code>TagSpecifications</code> parameter in the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestLaunchTemplateData.html">launch template data</a> structure.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param tagSpecifications The tags to apply to the launch template on creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(final java.util.List<? extends java.lang.Object> tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }

        /**
         * A description for the first version of the launch template.
         * <p>
         * @return {@code this}
         * @param versionDescription A description for the first version of the launch template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionDescription(final java.lang.String versionDescription) {
            this.props.versionDescription(versionDescription);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnLaunchTemplate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnLaunchTemplate build() {
            return new software.amazon.awscdk.services.ec2.CfnLaunchTemplate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
