package software.amazon.awscdk.services.ec2;

/**
 * Type of router used in route.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc = Vpc.Builder.create(this, "VPC")
 *         .subnetConfiguration(List.of(SubnetConfiguration.builder()
 *                 .subnetType(SubnetType.PUBLIC)
 *                 .name("Public")
 *                 .build(), SubnetConfiguration.builder()
 *                 .subnetType(SubnetType.PRIVATE_ISOLATED)
 *                 .name("Isolated")
 *                 .build()))
 *         .build();
 * ((Subnet)vpc.isolatedSubnets[0]).addRoute("StaticRoute", AddRouteOptions.builder()
 *         .routerId(vpc.getInternetGatewayId())
 *         .routerType(RouterType.GATEWAY)
 *         .destinationCidrBlock("8.8.8.8/32")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-02T14:17:20.128Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.RouterType")
public enum RouterType {
    /**
     * Carrier gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CARRIER_GATEWAY,
    /**
     * Egress-only Internet Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EGRESS_ONLY_INTERNET_GATEWAY,
    /**
     * Internet Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GATEWAY,
    /**
     * Instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INSTANCE,
    /**
     * Local Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LOCAL_GATEWAY,
    /**
     * NAT Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NAT_GATEWAY,
    /**
     * Network Interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NETWORK_INTERFACE,
    /**
     * Transit Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TRANSIT_GATEWAY,
    /**
     * VPC peering connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VPC_PEERING_CONNECTION,
    /**
     * VPC Endpoint for gateway load balancers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VPC_ENDPOINT,
}
