/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.core.Size;
import software.amazon.awscdk.services.ec2.$Module;
import software.amazon.awscdk.services.ec2.EbsDeviceVolumeType;
import software.amazon.awscdk.services.ec2.IInstance;
import software.amazon.awscdk.services.ec2.IVolume;
import software.amazon.awscdk.services.ec2.VolumeAttributes;
import software.amazon.awscdk.services.ec2.VolumeProps;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.Volume")
public class Volume
extends Resource
implements IVolume {
    protected Volume(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Volume(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Volume(@NotNull Construct scope, @NotNull String id, @NotNull VolumeProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IVolume fromVolumeAttributes(@NotNull Construct scope, @NotNull String id, @NotNull VolumeAttributes attrs) {
        return (IVolume)JsiiObject.jsiiStaticCall(Volume.class, (String)"fromVolumeAttributes", (NativeType)NativeType.forClass(IVolume.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public Grant grantAttachVolume(@NotNull IGrantable grantee, @Nullable List<IInstance> instances) {
        return (Grant)Kernel.call((Object)this, (String)"grantAttachVolume", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required"), instances});
    }

    @Override
    @NotNull
    public Grant grantAttachVolume(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantAttachVolume", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantAttachVolumeByResourceTag(@NotNull IGrantable grantee, @NotNull List<Construct> constructs, @Nullable String tagKeySuffix) {
        return (Grant)Kernel.call((Object)this, (String)"grantAttachVolumeByResourceTag", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required"), Objects.requireNonNull(constructs, "constructs is required"), tagKeySuffix});
    }

    @Override
    @NotNull
    public Grant grantAttachVolumeByResourceTag(@NotNull IGrantable grantee, @NotNull List<Construct> constructs) {
        return (Grant)Kernel.call((Object)this, (String)"grantAttachVolumeByResourceTag", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required"), Objects.requireNonNull(constructs, "constructs is required")});
    }

    @Override
    @NotNull
    public Grant grantDetachVolume(@NotNull IGrantable grantee, @Nullable List<IInstance> instances) {
        return (Grant)Kernel.call((Object)this, (String)"grantDetachVolume", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required"), instances});
    }

    @Override
    @NotNull
    public Grant grantDetachVolume(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantDetachVolume", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantDetachVolumeByResourceTag(@NotNull IGrantable grantee, @NotNull List<Construct> constructs, @Nullable String tagKeySuffix) {
        return (Grant)Kernel.call((Object)this, (String)"grantDetachVolumeByResourceTag", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required"), Objects.requireNonNull(constructs, "constructs is required"), tagKeySuffix});
    }

    @Override
    @NotNull
    public Grant grantDetachVolumeByResourceTag(@NotNull IGrantable grantee, @NotNull List<Construct> constructs) {
        return (Grant)Kernel.call((Object)this, (String)"grantDetachVolumeByResourceTag", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required"), Objects.requireNonNull(constructs, "constructs is required")});
    }

    protected void validateProps(@NotNull VolumeProps props) {
        Kernel.call((Object)this, (String)"validateProps", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public String getAvailabilityZone() {
        return (String)Kernel.get((Object)this, (String)"availabilityZone", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getVolumeId() {
        return (String)Kernel.get((Object)this, (String)"volumeId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public IKey getEncryptionKey() {
        return (IKey)Kernel.get((Object)this, (String)"encryptionKey", (NativeType)NativeType.forClass(IKey.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Volume> {
        private final Construct scope;
        private final String id;
        private final VolumeProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new VolumeProps.Builder();
        }

        public Builder availabilityZone(String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        public Builder autoEnableIo(Boolean autoEnableIo) {
            this.props.autoEnableIo(autoEnableIo);
            return this;
        }

        public Builder enableMultiAttach(Boolean enableMultiAttach) {
            this.props.enableMultiAttach(enableMultiAttach);
            return this;
        }

        public Builder encrypted(Boolean encrypted) {
            this.props.encrypted(encrypted);
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        public Builder iops(Number iops) {
            this.props.iops(iops);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder size(Size size) {
            this.props.size(size);
            return this;
        }

        public Builder snapshotId(String snapshotId) {
            this.props.snapshotId(snapshotId);
            return this;
        }

        public Builder volumeName(String volumeName) {
            this.props.volumeName(volumeName);
            return this;
        }

        public Builder volumeType(EbsDeviceVolumeType volumeType) {
            this.props.volumeType(volumeType);
            return this;
        }

        public Volume build() {
            return new Volume(this.scope, this.id, this.props.build());
        }
    }
}

