package software.amazon.awscdk.services.ec2;

/**
 * Properties for looking up an existing VPC.
 * <p>
 * The combination of properties must specify filter down to exactly one
 * non-default VPC, otherwise an error is raised.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // create a cloud9 ec2 environment in a new VPC
 * Vpc vpc = Vpc.Builder.create(this, "VPC").maxAzs(3).build();
 * Ec2Environment.Builder.create(this, "Cloud9Env").vpc(vpc).build();
 * // or create the cloud9 environment in the default VPC with specific instanceType
 * IVpc defaultVpc = Vpc.fromLookup(this, "DefaultVPC", VpcLookupOptions.builder().isDefault(true).build());
 * Ec2Environment.Builder.create(this, "Cloud9Env2")
 *         .vpc(defaultVpc)
 *         .instanceType(new InstanceType("t3.large"))
 *         .build();
 * // or specify in a different subnetSelection
 * Ec2Environment c9env = Ec2Environment.Builder.create(this, "Cloud9Env3")
 *         .vpc(vpc)
 *         .subnetSelection(SubnetSelection.builder()
 *                 .subnetType(SubnetType.PRIVATE_WITH_NAT)
 *                 .build())
 *         .build();
 * // print the Cloud9 IDE URL in the output
 * // print the Cloud9 IDE URL in the output
 * CfnOutput.Builder.create(this, "URL").value(c9env.getIdeUrl()).build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-08T16:00:26.774Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.VpcLookupOptions")
@software.amazon.jsii.Jsii.Proxy(VpcLookupOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcLookupOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether to match the default VPC.
     * <p>
     * Default: Don't care whether we return the default VPC
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIsDefault() {
        return null;
    }

    /**
     * Optional to override inferred region.
     * <p>
     * Default: Current stack's environment region
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * Optional tag for subnet group name.
     * <p>
     * If not provided, we'll look at the aws-cdk:subnet-name tag.
     * If the subnet does not have the specified tag,
     * we'll use its type as the name.
     * <p>
     * Default: aws-cdk:subnet-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubnetGroupNameTag() {
        return null;
    }

    /**
     * Tags on the VPC.
     * <p>
     * The VPC must have all of these tags
     * <p>
     * Default: Don't filter on tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * The ID of the VPC.
     * <p>
     * If given, will import exactly this VPC.
     * <p>
     * Default: Don't filter on vpcId
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
        return null;
    }

    /**
     * The name of the VPC.
     * <p>
     * If given, will import the VPC with this name.
     * <p>
     * Default: Don't filter on vpcName
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VpcLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VpcLookupOptions> {
        java.lang.Boolean isDefault;
        java.lang.String region;
        java.lang.String subnetGroupNameTag;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.String vpcId;
        java.lang.String vpcName;

        /**
         * Sets the value of {@link VpcLookupOptions#getIsDefault}
         * @param isDefault Whether to match the default VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isDefault(java.lang.Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        /**
         * Sets the value of {@link VpcLookupOptions#getRegion}
         * @param region Optional to override inferred region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link VpcLookupOptions#getSubnetGroupNameTag}
         * @param subnetGroupNameTag Optional tag for subnet group name.
         *                           If not provided, we'll look at the aws-cdk:subnet-name tag.
         *                           If the subnet does not have the specified tag,
         *                           we'll use its type as the name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetGroupNameTag(java.lang.String subnetGroupNameTag) {
            this.subnetGroupNameTag = subnetGroupNameTag;
            return this;
        }

        /**
         * Sets the value of {@link VpcLookupOptions#getTags}
         * @param tags Tags on the VPC.
         *             The VPC must have all of these tags
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link VpcLookupOptions#getVpcId}
         * @param vpcId The ID of the VPC.
         *              If given, will import exactly this VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link VpcLookupOptions#getVpcName}
         * @param vpcName The name of the VPC.
         *                If given, will import the VPC with this name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcName(java.lang.String vpcName) {
            this.vpcName = vpcName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcLookupOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VpcLookupOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VpcLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcLookupOptions {
        private final java.lang.Boolean isDefault;
        private final java.lang.String region;
        private final java.lang.String subnetGroupNameTag;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.String vpcId;
        private final java.lang.String vpcName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.isDefault = software.amazon.jsii.Kernel.get(this, "isDefault", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetGroupNameTag = software.amazon.jsii.Kernel.get(this, "subnetGroupNameTag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcName = software.amazon.jsii.Kernel.get(this, "vpcName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.isDefault = builder.isDefault;
            this.region = builder.region;
            this.subnetGroupNameTag = builder.subnetGroupNameTag;
            this.tags = builder.tags;
            this.vpcId = builder.vpcId;
            this.vpcName = builder.vpcName;
        }

        @Override
        public final java.lang.Boolean getIsDefault() {
            return this.isDefault;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getSubnetGroupNameTag() {
            return this.subnetGroupNameTag;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final java.lang.String getVpcName() {
            return this.vpcName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getIsDefault() != null) {
                data.set("isDefault", om.valueToTree(this.getIsDefault()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getSubnetGroupNameTag() != null) {
                data.set("subnetGroupNameTag", om.valueToTree(this.getSubnetGroupNameTag()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpcId() != null) {
                data.set("vpcId", om.valueToTree(this.getVpcId()));
            }
            if (this.getVpcName() != null) {
                data.set("vpcName", om.valueToTree(this.getVpcName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.VpcLookupOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcLookupOptions.Jsii$Proxy that = (VpcLookupOptions.Jsii$Proxy) o;

            if (this.isDefault != null ? !this.isDefault.equals(that.isDefault) : that.isDefault != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.subnetGroupNameTag != null ? !this.subnetGroupNameTag.equals(that.subnetGroupNameTag) : that.subnetGroupNameTag != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.vpcId != null ? !this.vpcId.equals(that.vpcId) : that.vpcId != null) return false;
            return this.vpcName != null ? this.vpcName.equals(that.vpcName) : that.vpcName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.isDefault != null ? this.isDefault.hashCode() : 0;
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.subnetGroupNameTag != null ? this.subnetGroupNameTag.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
            result = 31 * result + (this.vpcName != null ? this.vpcName.hashCode() : 0);
            return result;
        }
    }
}
