package software.amazon.awscdk.services.ec2;

/**
 * A collection of configuration elements.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * IMachineImage machineImage;
 * Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(machineImage)
 *         // Showing the most complex setup, if you have simpler requirements
 *         // you can use `CloudFormationInit.fromElements()`.
 *         .init(CloudFormationInit.fromConfigSets(ConfigSetProps.builder()
 *                 .configSets(Map.of(
 *                         // Applies the configs below in this order
 *                         "default", List.of("yumPreinstall", "config")))
 *                 .configs(Map.of(
 *                         "yumPreinstall", new InitConfig(List.of(InitPackage.yum("git"))),
 *                         "config", new InitConfig(List.of(InitFile.fromObject("/etc/stack.json", Map.of(
 *                                 "stackId", Stack.of(this).getStackId(),
 *                                 "stackName", Stack.of(this).getStackName(),
 *                                 "region", Stack.of(this).getRegion())), InitGroup.fromName("my-group"), InitUser.fromName("my-user"), InitPackage.rpm("http://mirrors.ukfast.co.uk/sites/dl.fedoraproject.org/pub/epel/8/Everything/x86_64/Packages/r/rubygem-git-1.5.0-2.el8.noarch.rpm")))))
 *                 .build()))
 *         .initOptions(ApplyCloudFormationInitOptions.builder()
 *                 // Optional, which configsets to activate (['default'] by default)
 *                 .configSets(List.of("default"))
 *                 // Optional, how long the installation is expected to take (5 minutes by default)
 *                 .timeout(Duration.minutes(30))
 *                 // Optional, whether to include the --url argument when running cfn-init and cfn-signal commands (false by default)
 *                 .includeUrl(true)
 *                 // Optional, whether to include the --role argument when running cfn-init and cfn-signal commands (false by default)
 *                 .includeRole(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-14T16:25:28.617Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InitConfig")
public class InitConfig extends software.amazon.jsii.JsiiObject {

    protected InitConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InitConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param elements This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InitConfig(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.InitElement> elements) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(elements, "elements is required") });
    }

    /**
     * Add one or more elements to the config.
     * <p>
     * @param elements This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void add(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitElement... elements) {
        software.amazon.jsii.Kernel.call(this, "add", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(elements).toArray(Object[]::new));
    }

    /**
     * Whether this configset has elements or not.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean isEmpty() {
        return software.amazon.jsii.Kernel.call(this, "isEmpty", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }
}
