package software.amazon.awscdk.services.ec2;

/**
 * Properties for `InstanceRequireImdsv2Aspect`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * InstanceRequireImdsv2AspectProps instanceRequireImdsv2AspectProps = InstanceRequireImdsv2AspectProps.builder()
 *         .suppressLaunchTemplateWarning(false)
 *         .suppressWarnings(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-14T16:25:28.656Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InstanceRequireImdsv2AspectProps")
@software.amazon.jsii.Jsii.Proxy(InstanceRequireImdsv2AspectProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InstanceRequireImdsv2AspectProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether warnings that would be raised when an Instance is associated with an existing Launch Template should be suppressed or not.
     * <p>
     * You can set this to <code>true</code> if <code>LaunchTemplateImdsAspect</code> is being used alongside this Aspect to
     * suppress false-positive warnings because any Launch Templates associated with Instances will still be covered.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSuppressLaunchTemplateWarning() {
        return null;
    }

    /**
     * Whether warning annotations from this Aspect should be suppressed or not.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSuppressWarnings() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InstanceRequireImdsv2AspectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InstanceRequireImdsv2AspectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InstanceRequireImdsv2AspectProps> {
        java.lang.Boolean suppressLaunchTemplateWarning;
        java.lang.Boolean suppressWarnings;

        /**
         * Sets the value of {@link InstanceRequireImdsv2AspectProps#getSuppressLaunchTemplateWarning}
         * @param suppressLaunchTemplateWarning Whether warnings that would be raised when an Instance is associated with an existing Launch Template should be suppressed or not.
         *                                      You can set this to <code>true</code> if <code>LaunchTemplateImdsAspect</code> is being used alongside this Aspect to
         *                                      suppress false-positive warnings because any Launch Templates associated with Instances will still be covered.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suppressLaunchTemplateWarning(java.lang.Boolean suppressLaunchTemplateWarning) {
            this.suppressLaunchTemplateWarning = suppressLaunchTemplateWarning;
            return this;
        }

        /**
         * Sets the value of {@link InstanceRequireImdsv2AspectProps#getSuppressWarnings}
         * @param suppressWarnings Whether warning annotations from this Aspect should be suppressed or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suppressWarnings(java.lang.Boolean suppressWarnings) {
            this.suppressWarnings = suppressWarnings;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InstanceRequireImdsv2AspectProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InstanceRequireImdsv2AspectProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InstanceRequireImdsv2AspectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceRequireImdsv2AspectProps {
        private final java.lang.Boolean suppressLaunchTemplateWarning;
        private final java.lang.Boolean suppressWarnings;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.suppressLaunchTemplateWarning = software.amazon.jsii.Kernel.get(this, "suppressLaunchTemplateWarning", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.suppressWarnings = software.amazon.jsii.Kernel.get(this, "suppressWarnings", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.suppressLaunchTemplateWarning = builder.suppressLaunchTemplateWarning;
            this.suppressWarnings = builder.suppressWarnings;
        }

        @Override
        public final java.lang.Boolean getSuppressLaunchTemplateWarning() {
            return this.suppressLaunchTemplateWarning;
        }

        @Override
        public final java.lang.Boolean getSuppressWarnings() {
            return this.suppressWarnings;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getSuppressLaunchTemplateWarning() != null) {
                data.set("suppressLaunchTemplateWarning", om.valueToTree(this.getSuppressLaunchTemplateWarning()));
            }
            if (this.getSuppressWarnings() != null) {
                data.set("suppressWarnings", om.valueToTree(this.getSuppressWarnings()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.InstanceRequireImdsv2AspectProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InstanceRequireImdsv2AspectProps.Jsii$Proxy that = (InstanceRequireImdsv2AspectProps.Jsii$Proxy) o;

            if (this.suppressLaunchTemplateWarning != null ? !this.suppressLaunchTemplateWarning.equals(that.suppressLaunchTemplateWarning) : that.suppressLaunchTemplateWarning != null) return false;
            return this.suppressWarnings != null ? this.suppressWarnings.equals(that.suppressWarnings) : that.suppressWarnings == null;
        }

        @Override
        public final int hashCode() {
            int result = this.suppressLaunchTemplateWarning != null ? this.suppressLaunchTemplateWarning.hashCode() : 0;
            result = 31 * result + (this.suppressWarnings != null ? this.suppressWarnings.hashCode() : 0);
            return result;
        }
    }
}
