package software.amazon.awscdk.services.ec2;

/**
 * An AWS service for an interface VPC endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Add gateway endpoints when creating the VPC
 * Vpc vpc = Vpc.Builder.create(this, "MyVpc")
 *         .gatewayEndpoints(Map.of(
 *                 "S3", GatewayVpcEndpointOptions.builder()
 *                         .service(GatewayVpcEndpointAwsService.S3)
 *                         .build()))
 *         .build();
 * // Alternatively gateway endpoints can be added on the VPC
 * GatewayVpcEndpoint dynamoDbEndpoint = vpc.addGatewayEndpoint("DynamoDbEndpoint", GatewayVpcEndpointOptions.builder()
 *         .service(GatewayVpcEndpointAwsService.DYNAMODB)
 *         .build());
 * // This allows to customize the endpoint policy
 * dynamoDbEndpoint.addToPolicy(
 * PolicyStatement.Builder.create() // Restrict to listing and describing tables
 *         .principals(List.of(new AnyPrincipal()))
 *         .actions(List.of("dynamodb:DescribeTable", "dynamodb:ListTables"))
 *         .resources(List.of("*")).build());
 * // Add an interface endpoint
 * vpc.addInterfaceEndpoint("EcrDockerEndpoint", InterfaceVpcEndpointOptions.builder()
 *         .service(InterfaceVpcEndpointAwsService.ECR_DOCKER)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-22T19:35:43.068Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InterfaceVpcEndpointAwsService")
public class InterfaceVpcEndpointAwsService extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService {

    protected InterfaceVpcEndpointAwsService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InterfaceVpcEndpointAwsService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        APIGATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "APIGATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ATHENA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ATHENA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUDFORMATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUDFORMATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUDTRAIL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUDTRAIL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUDWATCH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUDWATCH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUDWATCH_EVENTS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUDWATCH_EVENTS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CLOUDWATCH_LOGS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CLOUDWATCH_LOGS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODEBUILD = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODEBUILD", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODEBUILD_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODEBUILD_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODECOMMIT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODECOMMIT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODECOMMIT_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODECOMMIT_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODECOMMIT_GIT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODECOMMIT_GIT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODECOMMIT_GIT_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODECOMMIT_GIT_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODEGURU_PROFILER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODEGURU_PROFILER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODEGURU_REVIEWER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODEGURU_REVIEWER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CODEPIPELINE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CODEPIPELINE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        CONFIG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "CONFIG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        EC2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "EC2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        EC2_MESSAGES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "EC2_MESSAGES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ECR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ECR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ECR_DOCKER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ECR_DOCKER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ECS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ECS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ECS_AGENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ECS_AGENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ECS_TELEMETRY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ECS_TELEMETRY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ELASTIC_FILESYSTEM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ELASTIC_FILESYSTEM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ELASTIC_FILESYSTEM_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ELASTIC_FILESYSTEM_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ELASTIC_INFERENCE_RUNTIME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ELASTIC_INFERENCE_RUNTIME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        ELASTIC_LOAD_BALANCING = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "ELASTIC_LOAD_BALANCING", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        GLUE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "GLUE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        KEYSPACES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "KEYSPACES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        KINESIS_FIREHOSE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "KINESIS_FIREHOSE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        KINESIS_STREAMS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "KINESIS_STREAMS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        KMS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "KMS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        LAMBDA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "LAMBDA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        RDS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "RDS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        RDS_DATA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "RDS_DATA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        REKOGNITION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "REKOGNITION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        REKOGNITION_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "REKOGNITION_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SAGEMAKER_API = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SAGEMAKER_API", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SAGEMAKER_NOTEBOOK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SAGEMAKER_NOTEBOOK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SAGEMAKER_RUNTIME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SAGEMAKER_RUNTIME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SAGEMAKER_RUNTIME_FIPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SAGEMAKER_RUNTIME_FIPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SECRETS_MANAGER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SECRETS_MANAGER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SERVICE_CATALOG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SERVICE_CATALOG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SNS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SNS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SQS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SQS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SSM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SSM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        SSM_MESSAGES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "SSM_MESSAGES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        STEP_FUNCTIONS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "STEP_FUNCTIONS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        STORAGE_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "STORAGE_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        STS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "STS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        TRANSCRIBE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "TRANSCRIBE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        TRANSFER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "TRANSFER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
        XRAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class, "XRAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class));
    }

    /**
     * @param name This parameter is required.
     * @param prefix
     * @param port
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InterfaceVpcEndpointAwsService(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable java.lang.String prefix, final @org.jetbrains.annotations.Nullable java.lang.Number port) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), prefix, port });
    }

    /**
     * @param name This parameter is required.
     * @param prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InterfaceVpcEndpointAwsService(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable java.lang.String prefix) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), prefix });
    }

    /**
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InterfaceVpcEndpointAwsService(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService APIGATEWAY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ATHENA;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUDFORMATION;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUDTRAIL;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUDWATCH;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUDWATCH_EVENTS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CLOUDWATCH_LOGS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODEBUILD;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODEBUILD_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODECOMMIT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODECOMMIT_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODECOMMIT_GIT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODECOMMIT_GIT_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODEGURU_PROFILER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODEGURU_REVIEWER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CODEPIPELINE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService CONFIG;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService EC2;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService EC2_MESSAGES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ECR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ECR_DOCKER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ECS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ECS_AGENT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ECS_TELEMETRY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ELASTIC_FILESYSTEM;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ELASTIC_FILESYSTEM_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ELASTIC_INFERENCE_RUNTIME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService ELASTIC_LOAD_BALANCING;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService GLUE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService KEYSPACES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService KINESIS_FIREHOSE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService KINESIS_STREAMS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService KMS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService LAMBDA;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService RDS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService RDS_DATA;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService REKOGNITION;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService REKOGNITION_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SAGEMAKER_API;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SAGEMAKER_NOTEBOOK;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SAGEMAKER_RUNTIME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SAGEMAKER_RUNTIME_FIPS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SECRETS_MANAGER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SERVICE_CATALOG;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SNS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SQS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SSM;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService SSM_MESSAGES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService STEP_FUNCTIONS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService STORAGE_GATEWAY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService STS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService TRANSCRIBE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService TRANSFER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService XRAY;

    /**
     * The name of the service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port of the service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Whether Private DNS is supported by default.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getPrivateDnsDefault() {
        return software.amazon.jsii.Kernel.get(this, "privateDnsDefault", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }
}
