package software.amazon.awscdk.services.ec2;

/**
 * Properties to create a SubnetNetworkAclAssociation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * NetworkAcl networkAcl;
 * Subnet subnet;
 * SubnetNetworkAclAssociationProps subnetNetworkAclAssociationProps = SubnetNetworkAclAssociationProps.builder()
 *         .networkAcl(networkAcl)
 *         .subnet(subnet)
 *         // the properties below are optional
 *         .subnetNetworkAclAssociationName("subnetNetworkAclAssociationName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-22T19:35:43.163Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.SubnetNetworkAclAssociationProps")
@software.amazon.jsii.Jsii.Proxy(SubnetNetworkAclAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubnetNetworkAclAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Network ACL this association is defined for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.INetworkAcl getNetworkAcl();

    /**
     * ID of the Subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISubnet getSubnet();

    /**
     * The name of the SubnetNetworkAclAssociation.
     * <p>
     * It is not recommended to use an explicit name.
     * <p>
     * Default: If you don't specify a SubnetNetworkAclAssociationName, AWS CloudFormation generates a
     * unique physical ID and uses that ID for the group name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubnetNetworkAclAssociationName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SubnetNetworkAclAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubnetNetworkAclAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SubnetNetworkAclAssociationProps> {
        software.amazon.awscdk.services.ec2.INetworkAcl networkAcl;
        software.amazon.awscdk.services.ec2.ISubnet subnet;
        java.lang.String subnetNetworkAclAssociationName;

        /**
         * Sets the value of {@link SubnetNetworkAclAssociationProps#getNetworkAcl}
         * @param networkAcl The Network ACL this association is defined for. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkAcl(software.amazon.awscdk.services.ec2.INetworkAcl networkAcl) {
            this.networkAcl = networkAcl;
            return this;
        }

        /**
         * Sets the value of {@link SubnetNetworkAclAssociationProps#getSubnet}
         * @param subnet ID of the Subnet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnet(software.amazon.awscdk.services.ec2.ISubnet subnet) {
            this.subnet = subnet;
            return this;
        }

        /**
         * Sets the value of {@link SubnetNetworkAclAssociationProps#getSubnetNetworkAclAssociationName}
         * @param subnetNetworkAclAssociationName The name of the SubnetNetworkAclAssociation.
         *                                        It is not recommended to use an explicit name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetNetworkAclAssociationName(java.lang.String subnetNetworkAclAssociationName) {
            this.subnetNetworkAclAssociationName = subnetNetworkAclAssociationName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubnetNetworkAclAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SubnetNetworkAclAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SubnetNetworkAclAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubnetNetworkAclAssociationProps {
        private final software.amazon.awscdk.services.ec2.INetworkAcl networkAcl;
        private final software.amazon.awscdk.services.ec2.ISubnet subnet;
        private final java.lang.String subnetNetworkAclAssociationName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.networkAcl = software.amazon.jsii.Kernel.get(this, "networkAcl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.INetworkAcl.class));
            this.subnet = software.amazon.jsii.Kernel.get(this, "subnet", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class));
            this.subnetNetworkAclAssociationName = software.amazon.jsii.Kernel.get(this, "subnetNetworkAclAssociationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.networkAcl = java.util.Objects.requireNonNull(builder.networkAcl, "networkAcl is required");
            this.subnet = java.util.Objects.requireNonNull(builder.subnet, "subnet is required");
            this.subnetNetworkAclAssociationName = builder.subnetNetworkAclAssociationName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.INetworkAcl getNetworkAcl() {
            return this.networkAcl;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISubnet getSubnet() {
            return this.subnet;
        }

        @Override
        public final java.lang.String getSubnetNetworkAclAssociationName() {
            return this.subnetNetworkAclAssociationName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("networkAcl", om.valueToTree(this.getNetworkAcl()));
            data.set("subnet", om.valueToTree(this.getSubnet()));
            if (this.getSubnetNetworkAclAssociationName() != null) {
                data.set("subnetNetworkAclAssociationName", om.valueToTree(this.getSubnetNetworkAclAssociationName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.SubnetNetworkAclAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubnetNetworkAclAssociationProps.Jsii$Proxy that = (SubnetNetworkAclAssociationProps.Jsii$Proxy) o;

            if (!networkAcl.equals(that.networkAcl)) return false;
            if (!subnet.equals(that.subnet)) return false;
            return this.subnetNetworkAclAssociationName != null ? this.subnetNetworkAclAssociationName.equals(that.subnetNetworkAclAssociationName) : that.subnetNetworkAclAssociationName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.networkAcl.hashCode();
            result = 31 * result + (this.subnet.hashCode());
            result = 31 * result + (this.subnetNetworkAclAssociationName != null ? this.subnetNetworkAclAssociationName.hashCode() : 0);
            return result;
        }
    }
}
