package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnIPAMPool`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnIPAMPoolProps cfnIPAMPoolProps = CfnIPAMPoolProps.builder()
 *         .addressFamily("addressFamily")
 *         .ipamScopeId("ipamScopeId")
 *         // the properties below are optional
 *         .allocationDefaultNetmaskLength(123)
 *         .allocationMaxNetmaskLength(123)
 *         .allocationMinNetmaskLength(123)
 *         .allocationResourceTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .autoImport(false)
 *         .awsService("awsService")
 *         .description("description")
 *         .locale("locale")
 *         .provisionedCidrs(List.of(ProvisionedCidrProperty.builder()
 *                 .cidr("cidr")
 *                 .build()))
 *         .publicIpSource("publicIpSource")
 *         .publiclyAdvertisable(false)
 *         .sourceIpamPoolId("sourceIpamPoolId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-04-20T17:18:05.813Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnIPAMPoolProps")
@software.amazon.jsii.Jsii.Proxy(CfnIPAMPoolProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIPAMPoolProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The address family of the pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAddressFamily();

    /**
     * The ID of the scope in which you would like to create the IPAM pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIpamScopeId();

    /**
     * The default netmask length for allocations added to this pool.
     * <p>
     * If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAllocationDefaultNetmaskLength() {
        return null;
    }

    /**
     * The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant.
     * <p>
     * The maximum netmask length must be greater than the minimum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAllocationMaxNetmaskLength() {
        return null;
    }

    /**
     * The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant.
     * <p>
     * The minimum netmask length must be less than the maximum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAllocationMinNetmaskLength() {
        return null;
    }

    /**
     * Tags that are required for resources that use CIDRs from this IPAM pool.
     * <p>
     * Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAllocationResourceTags() {
        return null;
    }

    /**
     * If selected, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM.
     * <p>
     * The CIDRs that will be allocated for these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its compliance with the pool's allocation rules, so a resource might be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only.
     * <p>
     * A locale must be set on the pool for this feature to work.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoImport() {
        return null;
    }

    /**
     * Limits which service in AWS that the pool can be used in.
     * <p>
     * "ec2", for example, allows users to use space for Elastic IP addresses and VPCs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAwsService() {
        return null;
    }

    /**
     * The description of the IPAM pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The locale of the IPAM pool.
     * <p>
     * In IPAM, the locale is the AWS Region where you want to make an IPAM pool available for allocations. Only resources in the same Region as the locale of the pool can get IP address allocations from the pool. You can only allocate a CIDR for a VPC, for example, from an IPAM pool that shares a locale with the VPC’s Region. Note that once you choose a Locale for a pool, you cannot modify it. If you choose an AWS Region for locale that has not been configured as an operating Region for the IPAM, you'll get an error.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLocale() {
        return null;
    }

    /**
     * Information about the CIDRs provisioned to an IPAM pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedCidrs() {
        return null;
    }

    /**
     * The IP address source for pools in the public scope.
     * <p>
     * Only used for provisioning IP address CIDRs to pools in the public scope. Default is <code>BYOIP</code> . For more information, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/intro-create-ipv6-pools.html">Create IPv6 pools</a> in the <em>Amazon VPC IPAM User Guide</em> . By default, you can add only one Amazon-provided IPv6 CIDR block to a top-level IPv6 pool. For information on increasing the default limit, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/quotas-ipam.html">Quotas for your IPAM</a> in the <em>Amazon VPC IPAM User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPublicIpSource() {
        return null;
    }

    /**
     * Determines if a pool is publicly advertisable.
     * <p>
     * This option is not available for pools with AddressFamily set to <code>ipv4</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAdvertisable() {
        return null;
    }

    /**
     * The ID of the source IPAM pool.
     * <p>
     * You can use this option to create an IPAM pool within an existing source pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceIpamPoolId() {
        return null;
    }

    /**
     * The key/value combination of a tag assigned to the resource.
     * <p>
     * Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code> , specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIPAMPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIPAMPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIPAMPoolProps> {
        java.lang.String addressFamily;
        java.lang.String ipamScopeId;
        java.lang.Number allocationDefaultNetmaskLength;
        java.lang.Number allocationMaxNetmaskLength;
        java.lang.Number allocationMinNetmaskLength;
        java.lang.Object allocationResourceTags;
        java.lang.Object autoImport;
        java.lang.String awsService;
        java.lang.String description;
        java.lang.String locale;
        java.lang.Object provisionedCidrs;
        java.lang.String publicIpSource;
        java.lang.Object publiclyAdvertisable;
        java.lang.String sourceIpamPoolId;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getAddressFamily}
         * @param addressFamily The address family of the pool. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addressFamily(java.lang.String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getIpamScopeId}
         * @param ipamScopeId The ID of the scope in which you would like to create the IPAM pool. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipamScopeId(java.lang.String ipamScopeId) {
            this.ipamScopeId = ipamScopeId;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getAllocationDefaultNetmaskLength}
         * @param allocationDefaultNetmaskLength The default netmask length for allocations added to this pool.
         *                                       If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationDefaultNetmaskLength(java.lang.Number allocationDefaultNetmaskLength) {
            this.allocationDefaultNetmaskLength = allocationDefaultNetmaskLength;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getAllocationMaxNetmaskLength}
         * @param allocationMaxNetmaskLength The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant.
         *                                   The maximum netmask length must be greater than the minimum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationMaxNetmaskLength(java.lang.Number allocationMaxNetmaskLength) {
            this.allocationMaxNetmaskLength = allocationMaxNetmaskLength;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getAllocationMinNetmaskLength}
         * @param allocationMinNetmaskLength The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant.
         *                                   The minimum netmask length must be less than the maximum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationMinNetmaskLength(java.lang.Number allocationMinNetmaskLength) {
            this.allocationMinNetmaskLength = allocationMinNetmaskLength;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getAllocationResourceTags}
         * @param allocationResourceTags Tags that are required for resources that use CIDRs from this IPAM pool.
         *                               Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationResourceTags(software.amazon.awscdk.core.IResolvable allocationResourceTags) {
            this.allocationResourceTags = allocationResourceTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getAllocationResourceTags}
         * @param allocationResourceTags Tags that are required for resources that use CIDRs from this IPAM pool.
         *                               Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationResourceTags(java.util.List<? extends java.lang.Object> allocationResourceTags) {
            this.allocationResourceTags = allocationResourceTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getAutoImport}
         * @param autoImport If selected, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM.
         *                   The CIDRs that will be allocated for these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its compliance with the pool's allocation rules, so a resource might be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only.
         *                   <p>
         *                   A locale must be set on the pool for this feature to work.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoImport(java.lang.Boolean autoImport) {
            this.autoImport = autoImport;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getAutoImport}
         * @param autoImport If selected, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM.
         *                   The CIDRs that will be allocated for these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its compliance with the pool's allocation rules, so a resource might be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only.
         *                   <p>
         *                   A locale must be set on the pool for this feature to work.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoImport(software.amazon.awscdk.core.IResolvable autoImport) {
            this.autoImport = autoImport;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getAwsService}
         * @param awsService Limits which service in AWS that the pool can be used in.
         *                   "ec2", for example, allows users to use space for Elastic IP addresses and VPCs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsService(java.lang.String awsService) {
            this.awsService = awsService;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getDescription}
         * @param description The description of the IPAM pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getLocale}
         * @param locale The locale of the IPAM pool.
         *               In IPAM, the locale is the AWS Region where you want to make an IPAM pool available for allocations. Only resources in the same Region as the locale of the pool can get IP address allocations from the pool. You can only allocate a CIDR for a VPC, for example, from an IPAM pool that shares a locale with the VPC’s Region. Note that once you choose a Locale for a pool, you cannot modify it. If you choose an AWS Region for locale that has not been configured as an operating Region for the IPAM, you'll get an error.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locale(java.lang.String locale) {
            this.locale = locale;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getProvisionedCidrs}
         * @param provisionedCidrs Information about the CIDRs provisioned to an IPAM pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedCidrs(software.amazon.awscdk.core.IResolvable provisionedCidrs) {
            this.provisionedCidrs = provisionedCidrs;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getProvisionedCidrs}
         * @param provisionedCidrs Information about the CIDRs provisioned to an IPAM pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedCidrs(java.util.List<? extends java.lang.Object> provisionedCidrs) {
            this.provisionedCidrs = provisionedCidrs;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getPublicIpSource}
         * @param publicIpSource The IP address source for pools in the public scope.
         *                       Only used for provisioning IP address CIDRs to pools in the public scope. Default is <code>BYOIP</code> . For more information, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/intro-create-ipv6-pools.html">Create IPv6 pools</a> in the <em>Amazon VPC IPAM User Guide</em> . By default, you can add only one Amazon-provided IPv6 CIDR block to a top-level IPv6 pool. For information on increasing the default limit, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/quotas-ipam.html">Quotas for your IPAM</a> in the <em>Amazon VPC IPAM User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicIpSource(java.lang.String publicIpSource) {
            this.publicIpSource = publicIpSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getPubliclyAdvertisable}
         * @param publiclyAdvertisable Determines if a pool is publicly advertisable.
         *                             This option is not available for pools with AddressFamily set to <code>ipv4</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAdvertisable(java.lang.Boolean publiclyAdvertisable) {
            this.publiclyAdvertisable = publiclyAdvertisable;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getPubliclyAdvertisable}
         * @param publiclyAdvertisable Determines if a pool is publicly advertisable.
         *                             This option is not available for pools with AddressFamily set to <code>ipv4</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAdvertisable(software.amazon.awscdk.core.IResolvable publiclyAdvertisable) {
            this.publiclyAdvertisable = publiclyAdvertisable;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getSourceIpamPoolId}
         * @param sourceIpamPoolId The ID of the source IPAM pool.
         *                         You can use this option to create an IPAM pool within an existing source pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceIpamPoolId(java.lang.String sourceIpamPoolId) {
            this.sourceIpamPoolId = sourceIpamPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getTags}
         * @param tags The key/value combination of a tag assigned to the resource.
         *             Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code> , specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIPAMPoolProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIPAMPoolProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIPAMPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIPAMPoolProps {
        private final java.lang.String addressFamily;
        private final java.lang.String ipamScopeId;
        private final java.lang.Number allocationDefaultNetmaskLength;
        private final java.lang.Number allocationMaxNetmaskLength;
        private final java.lang.Number allocationMinNetmaskLength;
        private final java.lang.Object allocationResourceTags;
        private final java.lang.Object autoImport;
        private final java.lang.String awsService;
        private final java.lang.String description;
        private final java.lang.String locale;
        private final java.lang.Object provisionedCidrs;
        private final java.lang.String publicIpSource;
        private final java.lang.Object publiclyAdvertisable;
        private final java.lang.String sourceIpamPoolId;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.addressFamily = software.amazon.jsii.Kernel.get(this, "addressFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipamScopeId = software.amazon.jsii.Kernel.get(this, "ipamScopeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allocationDefaultNetmaskLength = software.amazon.jsii.Kernel.get(this, "allocationDefaultNetmaskLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.allocationMaxNetmaskLength = software.amazon.jsii.Kernel.get(this, "allocationMaxNetmaskLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.allocationMinNetmaskLength = software.amazon.jsii.Kernel.get(this, "allocationMinNetmaskLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.allocationResourceTags = software.amazon.jsii.Kernel.get(this, "allocationResourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.autoImport = software.amazon.jsii.Kernel.get(this, "autoImport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.awsService = software.amazon.jsii.Kernel.get(this, "awsService", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.locale = software.amazon.jsii.Kernel.get(this, "locale", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.provisionedCidrs = software.amazon.jsii.Kernel.get(this, "provisionedCidrs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.publicIpSource = software.amazon.jsii.Kernel.get(this, "publicIpSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publiclyAdvertisable = software.amazon.jsii.Kernel.get(this, "publiclyAdvertisable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceIpamPoolId = software.amazon.jsii.Kernel.get(this, "sourceIpamPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.addressFamily = java.util.Objects.requireNonNull(builder.addressFamily, "addressFamily is required");
            this.ipamScopeId = java.util.Objects.requireNonNull(builder.ipamScopeId, "ipamScopeId is required");
            this.allocationDefaultNetmaskLength = builder.allocationDefaultNetmaskLength;
            this.allocationMaxNetmaskLength = builder.allocationMaxNetmaskLength;
            this.allocationMinNetmaskLength = builder.allocationMinNetmaskLength;
            this.allocationResourceTags = builder.allocationResourceTags;
            this.autoImport = builder.autoImport;
            this.awsService = builder.awsService;
            this.description = builder.description;
            this.locale = builder.locale;
            this.provisionedCidrs = builder.provisionedCidrs;
            this.publicIpSource = builder.publicIpSource;
            this.publiclyAdvertisable = builder.publiclyAdvertisable;
            this.sourceIpamPoolId = builder.sourceIpamPoolId;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAddressFamily() {
            return this.addressFamily;
        }

        @Override
        public final java.lang.String getIpamScopeId() {
            return this.ipamScopeId;
        }

        @Override
        public final java.lang.Number getAllocationDefaultNetmaskLength() {
            return this.allocationDefaultNetmaskLength;
        }

        @Override
        public final java.lang.Number getAllocationMaxNetmaskLength() {
            return this.allocationMaxNetmaskLength;
        }

        @Override
        public final java.lang.Number getAllocationMinNetmaskLength() {
            return this.allocationMinNetmaskLength;
        }

        @Override
        public final java.lang.Object getAllocationResourceTags() {
            return this.allocationResourceTags;
        }

        @Override
        public final java.lang.Object getAutoImport() {
            return this.autoImport;
        }

        @Override
        public final java.lang.String getAwsService() {
            return this.awsService;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getLocale() {
            return this.locale;
        }

        @Override
        public final java.lang.Object getProvisionedCidrs() {
            return this.provisionedCidrs;
        }

        @Override
        public final java.lang.String getPublicIpSource() {
            return this.publicIpSource;
        }

        @Override
        public final java.lang.Object getPubliclyAdvertisable() {
            return this.publiclyAdvertisable;
        }

        @Override
        public final java.lang.String getSourceIpamPoolId() {
            return this.sourceIpamPoolId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("addressFamily", om.valueToTree(this.getAddressFamily()));
            data.set("ipamScopeId", om.valueToTree(this.getIpamScopeId()));
            if (this.getAllocationDefaultNetmaskLength() != null) {
                data.set("allocationDefaultNetmaskLength", om.valueToTree(this.getAllocationDefaultNetmaskLength()));
            }
            if (this.getAllocationMaxNetmaskLength() != null) {
                data.set("allocationMaxNetmaskLength", om.valueToTree(this.getAllocationMaxNetmaskLength()));
            }
            if (this.getAllocationMinNetmaskLength() != null) {
                data.set("allocationMinNetmaskLength", om.valueToTree(this.getAllocationMinNetmaskLength()));
            }
            if (this.getAllocationResourceTags() != null) {
                data.set("allocationResourceTags", om.valueToTree(this.getAllocationResourceTags()));
            }
            if (this.getAutoImport() != null) {
                data.set("autoImport", om.valueToTree(this.getAutoImport()));
            }
            if (this.getAwsService() != null) {
                data.set("awsService", om.valueToTree(this.getAwsService()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getLocale() != null) {
                data.set("locale", om.valueToTree(this.getLocale()));
            }
            if (this.getProvisionedCidrs() != null) {
                data.set("provisionedCidrs", om.valueToTree(this.getProvisionedCidrs()));
            }
            if (this.getPublicIpSource() != null) {
                data.set("publicIpSource", om.valueToTree(this.getPublicIpSource()));
            }
            if (this.getPubliclyAdvertisable() != null) {
                data.set("publiclyAdvertisable", om.valueToTree(this.getPubliclyAdvertisable()));
            }
            if (this.getSourceIpamPoolId() != null) {
                data.set("sourceIpamPoolId", om.valueToTree(this.getSourceIpamPoolId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnIPAMPoolProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIPAMPoolProps.Jsii$Proxy that = (CfnIPAMPoolProps.Jsii$Proxy) o;

            if (!addressFamily.equals(that.addressFamily)) return false;
            if (!ipamScopeId.equals(that.ipamScopeId)) return false;
            if (this.allocationDefaultNetmaskLength != null ? !this.allocationDefaultNetmaskLength.equals(that.allocationDefaultNetmaskLength) : that.allocationDefaultNetmaskLength != null) return false;
            if (this.allocationMaxNetmaskLength != null ? !this.allocationMaxNetmaskLength.equals(that.allocationMaxNetmaskLength) : that.allocationMaxNetmaskLength != null) return false;
            if (this.allocationMinNetmaskLength != null ? !this.allocationMinNetmaskLength.equals(that.allocationMinNetmaskLength) : that.allocationMinNetmaskLength != null) return false;
            if (this.allocationResourceTags != null ? !this.allocationResourceTags.equals(that.allocationResourceTags) : that.allocationResourceTags != null) return false;
            if (this.autoImport != null ? !this.autoImport.equals(that.autoImport) : that.autoImport != null) return false;
            if (this.awsService != null ? !this.awsService.equals(that.awsService) : that.awsService != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) return false;
            if (this.provisionedCidrs != null ? !this.provisionedCidrs.equals(that.provisionedCidrs) : that.provisionedCidrs != null) return false;
            if (this.publicIpSource != null ? !this.publicIpSource.equals(that.publicIpSource) : that.publicIpSource != null) return false;
            if (this.publiclyAdvertisable != null ? !this.publiclyAdvertisable.equals(that.publiclyAdvertisable) : that.publiclyAdvertisable != null) return false;
            if (this.sourceIpamPoolId != null ? !this.sourceIpamPoolId.equals(that.sourceIpamPoolId) : that.sourceIpamPoolId != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.addressFamily.hashCode();
            result = 31 * result + (this.ipamScopeId.hashCode());
            result = 31 * result + (this.allocationDefaultNetmaskLength != null ? this.allocationDefaultNetmaskLength.hashCode() : 0);
            result = 31 * result + (this.allocationMaxNetmaskLength != null ? this.allocationMaxNetmaskLength.hashCode() : 0);
            result = 31 * result + (this.allocationMinNetmaskLength != null ? this.allocationMinNetmaskLength.hashCode() : 0);
            result = 31 * result + (this.allocationResourceTags != null ? this.allocationResourceTags.hashCode() : 0);
            result = 31 * result + (this.autoImport != null ? this.autoImport.hashCode() : 0);
            result = 31 * result + (this.awsService != null ? this.awsService.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
            result = 31 * result + (this.provisionedCidrs != null ? this.provisionedCidrs.hashCode() : 0);
            result = 31 * result + (this.publicIpSource != null ? this.publicIpSource.hashCode() : 0);
            result = 31 * result + (this.publiclyAdvertisable != null ? this.publiclyAdvertisable.hashCode() : 0);
            result = 31 * result + (this.sourceIpamPoolId != null ? this.sourceIpamPoolId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
