package software.amazon.awscdk.services.ec2;

/**
 * An AWS service for a gateway VPC endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Add gateway endpoints when creating the VPC
 * Vpc vpc = Vpc.Builder.create(this, "MyVpc")
 *         .gatewayEndpoints(Map.of(
 *                 "S3", GatewayVpcEndpointOptions.builder()
 *                         .service(GatewayVpcEndpointAwsService.S3)
 *                         .build()))
 *         .build();
 * // Alternatively gateway endpoints can be added on the VPC
 * GatewayVpcEndpoint dynamoDbEndpoint = vpc.addGatewayEndpoint("DynamoDbEndpoint", GatewayVpcEndpointOptions.builder()
 *         .service(GatewayVpcEndpointAwsService.DYNAMODB)
 *         .build());
 * // This allows to customize the endpoint policy
 * dynamoDbEndpoint.addToPolicy(
 * PolicyStatement.Builder.create() // Restrict to listing and describing tables
 *         .principals(List.of(new AnyPrincipal()))
 *         .actions(List.of("dynamodb:DescribeTable", "dynamodb:ListTables"))
 *         .resources(List.of("*")).build());
 * // Add an interface endpoint
 * vpc.addInterfaceEndpoint("EcrDockerEndpoint", InterfaceVpcEndpointOptions.builder()
 *         .service(InterfaceVpcEndpointAwsService.ECR_DOCKER)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-04-20T17:18:06.400Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.GatewayVpcEndpointAwsService")
public class GatewayVpcEndpointAwsService extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService {

    protected GatewayVpcEndpointAwsService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GatewayVpcEndpointAwsService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DYNAMODB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.GatewayVpcEndpointAwsService.class, "DYNAMODB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.GatewayVpcEndpointAwsService.class));
        S3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.GatewayVpcEndpointAwsService.class, "S3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.GatewayVpcEndpointAwsService.class));
    }

    /**
     * @param name This parameter is required.
     * @param prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public GatewayVpcEndpointAwsService(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable java.lang.String prefix) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), prefix });
    }

    /**
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public GatewayVpcEndpointAwsService(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.GatewayVpcEndpointAwsService DYNAMODB;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.GatewayVpcEndpointAwsService S3;

    /**
     * The name of the service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
