package software.amazon.awscdk.services.ec2;

/**
 * Manage the allowed network connections for constructs with Security Groups.
 * <p>
 * Security Groups can be thought of as a firewall for network-connected
 * devices. This class makes it easy to allow network connections to and
 * from security groups, and between security groups individually. When
 * establishing connectivity between security groups, it will automatically
 * add rules in both security groups
 * <p>
 * This object can manage one or more security groups.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.1 (build 9ff44cb)", date = "2020-01-07T23:10:49.939Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.Connections")
public class Connections extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IConnectable {

    protected Connections(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Connections(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Connections(final software.amazon.awscdk.services.ec2.ConnectionsProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Connections() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Add a security group to the list of security groups managed by this object.
     * <p>
     * @param securityGroups This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSecurityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup... securityGroups) {
        this.jsiiCall("addSecurityGroup", Void.class, java.util.Arrays.<Object>stream(securityGroups).toArray(Object[]::new));
    }

    /**
     * Allow connections from the peer on our default port.
     * <p>
     * Even if the peer has a default port, we will always use our default port.
     * <p>
     * @param other This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDefaultPortFrom(final software.amazon.awscdk.services.ec2.IConnectable other, final java.lang.String description) {
        this.jsiiCall("allowDefaultPortFrom", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), description });
    }

    /**
     * Allow connections from the peer on our default port.
     * <p>
     * Even if the peer has a default port, we will always use our default port.
     * <p>
     * @param other This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDefaultPortFrom(final software.amazon.awscdk.services.ec2.IConnectable other) {
        this.jsiiCall("allowDefaultPortFrom", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required") });
    }

    /**
     * Allow default connections from all IPv4 ranges.
     * <p>
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDefaultPortFromAnyIpv4(final java.lang.String description) {
        this.jsiiCall("allowDefaultPortFromAnyIpv4", Void.class, new Object[] { description });
    }

    /**
     * Allow default connections from all IPv4 ranges.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDefaultPortFromAnyIpv4() {
        this.jsiiCall("allowDefaultPortFromAnyIpv4", Void.class);
    }

    /**
     * Allow hosts inside the security group to connect to each other.
     * <p>
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDefaultPortInternally(final java.lang.String description) {
        this.jsiiCall("allowDefaultPortInternally", Void.class, new Object[] { description });
    }

    /**
     * Allow hosts inside the security group to connect to each other.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDefaultPortInternally() {
        this.jsiiCall("allowDefaultPortInternally", Void.class);
    }

    /**
     * Allow connections from the peer on our default port.
     * <p>
     * Even if the peer has a default port, we will always use our default port.
     * <p>
     * @param other This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDefaultPortTo(final software.amazon.awscdk.services.ec2.IConnectable other, final java.lang.String description) {
        this.jsiiCall("allowDefaultPortTo", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), description });
    }

    /**
     * Allow connections from the peer on our default port.
     * <p>
     * Even if the peer has a default port, we will always use our default port.
     * <p>
     * @param other This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDefaultPortTo(final software.amazon.awscdk.services.ec2.IConnectable other) {
        this.jsiiCall("allowDefaultPortTo", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required") });
    }

    /**
     * Allow connections from the peer on the given port.
     * <p>
     * @param other This parameter is required.
     * @param portRange This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowFrom(final software.amazon.awscdk.services.ec2.IConnectable other, final software.amazon.awscdk.services.ec2.Port portRange, final java.lang.String description) {
        this.jsiiCall("allowFrom", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), java.util.Objects.requireNonNull(portRange, "portRange is required"), description });
    }

    /**
     * Allow connections from the peer on the given port.
     * <p>
     * @param other This parameter is required.
     * @param portRange This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowFrom(final software.amazon.awscdk.services.ec2.IConnectable other, final software.amazon.awscdk.services.ec2.Port portRange) {
        this.jsiiCall("allowFrom", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), java.util.Objects.requireNonNull(portRange, "portRange is required") });
    }

    /**
     * Allow from any IPv4 ranges.
     * <p>
     * @param portRange This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowFromAnyIpv4(final software.amazon.awscdk.services.ec2.Port portRange, final java.lang.String description) {
        this.jsiiCall("allowFromAnyIpv4", Void.class, new Object[] { java.util.Objects.requireNonNull(portRange, "portRange is required"), description });
    }

    /**
     * Allow from any IPv4 ranges.
     * <p>
     * @param portRange This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowFromAnyIpv4(final software.amazon.awscdk.services.ec2.Port portRange) {
        this.jsiiCall("allowFromAnyIpv4", Void.class, new Object[] { java.util.Objects.requireNonNull(portRange, "portRange is required") });
    }

    /**
     * Allow hosts inside the security group to connect to each other on the given port.
     * <p>
     * @param portRange This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowInternally(final software.amazon.awscdk.services.ec2.Port portRange, final java.lang.String description) {
        this.jsiiCall("allowInternally", Void.class, new Object[] { java.util.Objects.requireNonNull(portRange, "portRange is required"), description });
    }

    /**
     * Allow hosts inside the security group to connect to each other on the given port.
     * <p>
     * @param portRange This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowInternally(final software.amazon.awscdk.services.ec2.Port portRange) {
        this.jsiiCall("allowInternally", Void.class, new Object[] { java.util.Objects.requireNonNull(portRange, "portRange is required") });
    }

    /**
     * Allow connections to the peer on the given port.
     * <p>
     * @param other This parameter is required.
     * @param portRange This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowTo(final software.amazon.awscdk.services.ec2.IConnectable other, final software.amazon.awscdk.services.ec2.Port portRange, final java.lang.String description) {
        this.jsiiCall("allowTo", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), java.util.Objects.requireNonNull(portRange, "portRange is required"), description });
    }

    /**
     * Allow connections to the peer on the given port.
     * <p>
     * @param other This parameter is required.
     * @param portRange This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowTo(final software.amazon.awscdk.services.ec2.IConnectable other, final software.amazon.awscdk.services.ec2.Port portRange) {
        this.jsiiCall("allowTo", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), java.util.Objects.requireNonNull(portRange, "portRange is required") });
    }

    /**
     * Allow to all IPv4 ranges.
     * <p>
     * @param portRange This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowToAnyIpv4(final software.amazon.awscdk.services.ec2.Port portRange, final java.lang.String description) {
        this.jsiiCall("allowToAnyIpv4", Void.class, new Object[] { java.util.Objects.requireNonNull(portRange, "portRange is required"), description });
    }

    /**
     * Allow to all IPv4 ranges.
     * <p>
     * @param portRange This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowToAnyIpv4(final software.amazon.awscdk.services.ec2.Port portRange) {
        this.jsiiCall("allowToAnyIpv4", Void.class, new Object[] { java.util.Objects.requireNonNull(portRange, "portRange is required") });
    }

    /**
     * Allow connections to the security group on their default port.
     * <p>
     * @param other This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowToDefaultPort(final software.amazon.awscdk.services.ec2.IConnectable other, final java.lang.String description) {
        this.jsiiCall("allowToDefaultPort", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), description });
    }

    /**
     * Allow connections to the security group on their default port.
     * <p>
     * @param other This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowToDefaultPort(final software.amazon.awscdk.services.ec2.IConnectable other) {
        this.jsiiCall("allowToDefaultPort", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required") });
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("securityGroups", java.util.List.class));
    }

    /**
     * The default port configured for this connection peer, if available.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.Port getDefaultPort() {
        return this.jsiiGet("defaultPort", software.amazon.awscdk.services.ec2.Port.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.Connections}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.ec2.ConnectionsProps.Builder props;

        private Builder() {
        }

        /**
         * Default port range for initiating connections to and from this object.
         * <p>
         * Default: - No default port
         * <p>
         * @return {@code this}
         * @param defaultPort Default port range for initiating connections to and from this object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultPort(final software.amazon.awscdk.services.ec2.Port defaultPort) {
            this.props().defaultPort(defaultPort);
            return this;
        }

        /**
         * Class that represents the rule by which others can connect to this connectable.
         * <p>
         * This object is required, but will be derived from securityGroup if that is passed.
         * <p>
         * Default: Derived from securityGroup if set.
         * <p>
         * @return {@code this}
         * @param peer Class that represents the rule by which others can connect to this connectable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peer(final software.amazon.awscdk.services.ec2.IPeer peer) {
            this.props().peer(peer);
            return this;
        }

        /**
         * What securityGroup(s) this object is managing connections for.
         * <p>
         * Default: No security groups
         * <p>
         * @return {@code this}
         * @param securityGroups What securityGroup(s) this object is managing connections for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props().securityGroups(securityGroups);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.Connections}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.ec2.Connections build() {
            return new software.amazon.awscdk.services.ec2.Connections(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.ConnectionsProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.ConnectionsProps.Builder();
            }
            return this.props;
        }
    }
}
