package software.amazon.awscdk.services.ec2;

/**
 * Mime multipart user data.
 * <p>
 * This class represents MIME multipart user data, as described in.
 * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/bootstrap_container_instance.html#multi-part_user_data">Specifying Multiple User Data Blocks Using a MIME Multi Part Archive</a>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserData bootHookConf = UserData.forLinux();
 * bootHookConf.addCommands("cloud-init-per once docker_options echo 'OPTIONS=\"${OPTIONS} --storage-opt dm.basesize=40G\"' &gt;&gt; /etc/sysconfig/docker");
 * UserData setupCommands = UserData.forLinux();
 * setupCommands.addCommands("sudo yum install awscli &amp;&amp; echo Packages installed らと &gt; /var/tmp/setup");
 * MultipartUserData multipartUserData = new MultipartUserData();
 * // The docker has to be configured at early stage, so content type is overridden to boothook
 * multipartUserData.addPart(MultipartBody.fromUserData(bootHookConf, "text/cloud-boothook; charset=\"us-ascii\""));
 * // Execute the rest of setup
 * multipartUserData.addPart(MultipartBody.fromUserData(setupCommands));
 * LaunchTemplate.Builder.create(this, "")
 *         .userData(multipartUserData)
 *         .blockDevices(List.of())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-04-27T09:48:16.988Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.MultipartUserData")
public class MultipartUserData extends software.amazon.awscdk.services.ec2.UserData {

    protected MultipartUserData(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MultipartUserData(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public MultipartUserData(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.MultipartUserDataOptions opts) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { opts });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public MultipartUserData() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Add one or more commands to the user data.
     * <p>
     * @param commands This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addCommands(final @org.jetbrains.annotations.NotNull java.lang.String... commands) {
        software.amazon.jsii.Kernel.call(this, "addCommands", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(commands).toArray(Object[]::new));
    }

    /**
     * Adds commands to execute a file.
     * <p>
     * @param params This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addExecuteFileCommand(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ExecuteFileOptions params) {
        software.amazon.jsii.Kernel.call(this, "addExecuteFileCommand", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(params, "params is required") });
    }

    /**
     * Add one or more commands to the user data that will run when the script exits.
     * <p>
     * @param commands This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addOnExitCommands(final @org.jetbrains.annotations.NotNull java.lang.String... commands) {
        software.amazon.jsii.Kernel.call(this, "addOnExitCommands", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(commands).toArray(Object[]::new));
    }

    /**
     * Adds a part to the list of parts.
     * <p>
     * @param part This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPart(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.MultipartBody part) {
        software.amazon.jsii.Kernel.call(this, "addPart", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(part, "part is required") });
    }

    /**
     * Adds commands to download a file from S3.
     * <p>
     * @param params This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String addS3DownloadCommand(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.S3DownloadOptions params) {
        return software.amazon.jsii.Kernel.call(this, "addS3DownloadCommand", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(params, "params is required") });
    }

    /**
     * Adds a command which will send a cfn-signal when the user data script ends.
     * <p>
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addSignalOnExitCommand(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Resource resource) {
        software.amazon.jsii.Kernel.call(this, "addSignalOnExitCommand", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Adds a multipart part based on a UserData object.
     * <p>
     * If <code>makeDefault</code> is true, then the UserData added by this method
     * will also be the target of calls to the <code>add*Command</code> methods on
     * this MultipartUserData object.
     * <p>
     * If <code>makeDefault</code> is false, then this is the same as calling:
     * <p>
     * <blockquote><pre>
     * MultipartUserData multiPart;
     * UserData userData;
     * String contentType;
     * multiPart.addPart(MultipartBody.fromUserData(userData, contentType));
     * </pre></blockquote>
     * <p>
     * An undefined <code>makeDefault</code> defaults to either:
     * <p>
     * <ul>
     * <li><code>true</code> if no default UserData has been set yet; or</li>
     * <li><code>false</code> if there is no default UserData set.</li>
     * </ul>
     * <p>
     * @param userData This parameter is required.
     * @param contentType
     * @param makeDefault
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addUserDataPart(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.UserData userData, final @org.jetbrains.annotations.Nullable java.lang.String contentType, final @org.jetbrains.annotations.Nullable java.lang.Boolean makeDefault) {
        software.amazon.jsii.Kernel.call(this, "addUserDataPart", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(userData, "userData is required"), contentType, makeDefault });
    }

    /**
     * Adds a multipart part based on a UserData object.
     * <p>
     * If <code>makeDefault</code> is true, then the UserData added by this method
     * will also be the target of calls to the <code>add*Command</code> methods on
     * this MultipartUserData object.
     * <p>
     * If <code>makeDefault</code> is false, then this is the same as calling:
     * <p>
     * <blockquote><pre>
     * MultipartUserData multiPart;
     * UserData userData;
     * String contentType;
     * multiPart.addPart(MultipartBody.fromUserData(userData, contentType));
     * </pre></blockquote>
     * <p>
     * An undefined <code>makeDefault</code> defaults to either:
     * <p>
     * <ul>
     * <li><code>true</code> if no default UserData has been set yet; or</li>
     * <li><code>false</code> if there is no default UserData set.</li>
     * </ul>
     * <p>
     * @param userData This parameter is required.
     * @param contentType
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addUserDataPart(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.UserData userData, final @org.jetbrains.annotations.Nullable java.lang.String contentType) {
        software.amazon.jsii.Kernel.call(this, "addUserDataPart", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(userData, "userData is required"), contentType });
    }

    /**
     * Adds a multipart part based on a UserData object.
     * <p>
     * If <code>makeDefault</code> is true, then the UserData added by this method
     * will also be the target of calls to the <code>add*Command</code> methods on
     * this MultipartUserData object.
     * <p>
     * If <code>makeDefault</code> is false, then this is the same as calling:
     * <p>
     * <blockquote><pre>
     * MultipartUserData multiPart;
     * UserData userData;
     * String contentType;
     * multiPart.addPart(MultipartBody.fromUserData(userData, contentType));
     * </pre></blockquote>
     * <p>
     * An undefined <code>makeDefault</code> defaults to either:
     * <p>
     * <ul>
     * <li><code>true</code> if no default UserData has been set yet; or</li>
     * <li><code>false</code> if there is no default UserData set.</li>
     * </ul>
     * <p>
     * @param userData This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addUserDataPart(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.UserData userData) {
        software.amazon.jsii.Kernel.call(this, "addUserDataPart", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(userData, "userData is required") });
    }

    /**
     * Render the UserData for use in a construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String render() {
        return software.amazon.jsii.Kernel.call(this, "render", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.MultipartUserData}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.MultipartUserData> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.ec2.MultipartUserDataOptions.Builder opts;

        private Builder() {
        }

        /**
         * The string used to separate parts in multipart user data archive (it's like MIME boundary).
         * <p>
         * This string should contain [a-zA-Z0-9()+,-./:=?] characters only, and should not be present in any part, or in text content of archive.
         * <p>
         * Default: `+AWS+CDK+User+Data+Separator==`
         * <p>
         * @return {@code this}
         * @param partsSeparator The string used to separate parts in multipart user data archive (it's like MIME boundary). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partsSeparator(final java.lang.String partsSeparator) {
            this.opts().partsSeparator(partsSeparator);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.MultipartUserData}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.MultipartUserData build() {
            return new software.amazon.awscdk.services.ec2.MultipartUserData(
                this.opts != null ? this.opts.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.MultipartUserDataOptions.Builder opts() {
            if (this.opts == null) {
                this.opts = new software.amazon.awscdk.services.ec2.MultipartUserDataOptions.Builder();
            }
            return this.opts;
        }
    }
}
