package software.amazon.awscdk.services.ec2;

/**
 * Amazon Linux Kernel.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * // AWS Linux
 * // AWS Linux
 * Instance.Builder.create(this, "Instance1")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(new AmazonLinuxImage())
 *         .build();
 * // AWS Linux 2
 * // AWS Linux 2
 * Instance.Builder.create(this, "Instance2")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(AmazonLinuxImage.Builder.create()
 *                 .generation(AmazonLinuxGeneration.AMAZON_LINUX_2)
 *                 .build())
 *         .build();
 * // AWS Linux 2 with kernel 5.x
 * // AWS Linux 2 with kernel 5.x
 * Instance.Builder.create(this, "Instance3")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(AmazonLinuxImage.Builder.create()
 *                 .generation(AmazonLinuxGeneration.AMAZON_LINUX_2)
 *                 .kernel(AmazonLinuxKernel.KERNEL5_X)
 *                 .build())
 *         .build();
 * // AWS Linux 2022
 * // AWS Linux 2022
 * Instance.Builder.create(this, "Instance4")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(AmazonLinuxImage.Builder.create()
 *                 .generation(AmazonLinuxGeneration.AMAZON_LINUX_2022)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-10T17:05:54.512Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.AmazonLinuxKernel")
public enum AmazonLinuxKernel {
    /**
     * Standard edition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KERNEL5_X,
}
