package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnVolume`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVolumeProps cfnVolumeProps = CfnVolumeProps.builder()
 *         .availabilityZone("availabilityZone")
 *         // the properties below are optional
 *         .autoEnableIo(false)
 *         .encrypted(false)
 *         .iops(123)
 *         .kmsKeyId("kmsKeyId")
 *         .multiAttachEnabled(false)
 *         .outpostArn("outpostArn")
 *         .size(123)
 *         .snapshotId("snapshotId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .throughput(123)
 *         .volumeType("volumeType")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-31T18:44:10.902Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVolumeProps")
@software.amazon.jsii.Jsii.Proxy(CfnVolumeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVolumeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the Availability Zone in which to create the volume.
     * <p>
     * For example, <code>us-east-1a</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAvailabilityZone();

    /**
     * Indicates whether the volume is auto-enabled for I/O operations.
     * <p>
     * By default, Amazon EBS disables I/O to the volume from attached EC2 instances when it determines that a volume's data is potentially inconsistent. If the consistency of the volume is not a concern, and you prefer that the volume be made available immediately if it's impaired, you can configure the volume to automatically enable I/O.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoEnableIo() {
        return null;
    }

    /**
     * Indicates whether the volume should be encrypted.
     * <p>
     * The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default">Encryption by default</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
     * <p>
     * Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported instance types</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncrypted() {
        return null;
    }

    /**
     * The number of I/O operations per second (IOPS).
     * <p>
     * For <code>gp3</code> , <code>io1</code> , and <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
     * <p>
     * The following are the supported values for each volume type:
     * <p>
     * <ul>
     * <li><code>gp3</code> : 3,000-16,000 IOPS</li>
     * <li><code>io1</code> : 100-64,000 IOPS</li>
     * <li><code>io2</code> : 100-64,000 IOPS</li>
     * </ul>
     * <p>
     * <code>io1</code> and <code>io2</code> volumes support up to 64,000 IOPS only on <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> . Other instance families support performance up to 32,000 IOPS.
     * <p>
     * This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for <code>gp3</code> volumes is 3,000 IOPS. This parameter is not supported for <code>gp2</code> , <code>st1</code> , <code>sc1</code> , or <code>standard</code> volumes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
        return null;
    }

    /**
     * The identifier of the AWS KMS key to use for Amazon EBS encryption.
     * <p>
     * If <code>KmsKeyId</code> is specified, the encrypted state must be <code>true</code> .
     * <p>
     * If you omit this property and your account is enabled for encryption by default, or <em>Encrypted</em> is set to <code>true</code> , then the volume is encrypted using the default key specified for your account. If your account does not have a default key, then the volume is encrypted using the AWS managed key .
     * <p>
     * Alternatively, if you want to specify a different key, you can specify one of the following:
     * <p>
     * <ul>
     * <li>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</li>
     * <li>Key alias. Specify the alias for the key, prefixed with <code>alias/</code> . For example, for a key with the alias <code>my_cmk</code> , use <code>alias/my_cmk</code> . Or to specify the AWS managed key , use <code>alias/aws/ebs</code> .</li>
     * <li>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</li>
     * <li>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * Indicates whether Amazon EBS Multi-Attach is enabled.
     * <p>
     * AWS CloudFormation does not currently support updating a single-attach volume to be multi-attach enabled, updating a multi-attach enabled volume to be single-attach, or updating the size or number of I/O operations per second (IOPS) of a multi-attach enabled volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMultiAttachEnabled() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutpostArn() {
        return null;
    }

    /**
     * The size of the volume, in GiBs.
     * <p>
     * You must specify either a snapshot ID or a volume size. If you specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the snapshot size.
     * <p>
     * The following are the supported volumes sizes for each volume type:
     * <p>
     * <ul>
     * <li><code>gp2</code> and <code>gp3</code> : 1-16,384</li>
     * <li><code>io1</code> and <code>io2</code> : 4-16,384</li>
     * <li><code>st1</code> and <code>sc1</code> : 125-16,384</li>
     * <li><code>standard</code> : 1-1,024</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSize() {
        return null;
    }

    /**
     * The snapshot from which to create the volume.
     * <p>
     * You must specify either a snapshot ID or a volume size.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotId() {
        return null;
    }

    /**
     * The tags to apply to the volume during creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * The throughput to provision for a volume, with a maximum of 1,000 MiB/s.
     * <p>
     * This parameter is valid only for <code>gp3</code> volumes. The default value is 125.
     * <p>
     * Valid Range: Minimum value of 125. Maximum value of 1000.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getThroughput() {
        return null;
    }

    /**
     * The volume type. This parameter can be one of the following values:.
     * <p>
     * <ul>
     * <li>General Purpose SSD: <code>gp2</code> | <code>gp3</code></li>
     * <li>Provisioned IOPS SSD: <code>io1</code> | <code>io2</code></li>
     * <li>Throughput Optimized HDD: <code>st1</code></li>
     * <li>Cold HDD: <code>sc1</code></li>
     * <li>Magnetic: <code>standard</code></li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
     * <p>
     * Default: <code>gp2</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVolumeType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVolumeProps> {
        java.lang.String availabilityZone;
        java.lang.Object autoEnableIo;
        java.lang.Object encrypted;
        java.lang.Number iops;
        java.lang.String kmsKeyId;
        java.lang.Object multiAttachEnabled;
        java.lang.String outpostArn;
        java.lang.Number size;
        java.lang.String snapshotId;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.Number throughput;
        java.lang.String volumeType;

        /**
         * Sets the value of {@link CfnVolumeProps#getAvailabilityZone}
         * @param availabilityZone The ID of the Availability Zone in which to create the volume. This parameter is required.
         *                         For example, <code>us-east-1a</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getAutoEnableIo}
         * @param autoEnableIo Indicates whether the volume is auto-enabled for I/O operations.
         *                     By default, Amazon EBS disables I/O to the volume from attached EC2 instances when it determines that a volume's data is potentially inconsistent. If the consistency of the volume is not a concern, and you prefer that the volume be made available immediately if it's impaired, you can configure the volume to automatically enable I/O.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoEnableIo(java.lang.Boolean autoEnableIo) {
            this.autoEnableIo = autoEnableIo;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getAutoEnableIo}
         * @param autoEnableIo Indicates whether the volume is auto-enabled for I/O operations.
         *                     By default, Amazon EBS disables I/O to the volume from attached EC2 instances when it determines that a volume's data is potentially inconsistent. If the consistency of the volume is not a concern, and you prefer that the volume be made available immediately if it's impaired, you can configure the volume to automatically enable I/O.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoEnableIo(software.amazon.awscdk.core.IResolvable autoEnableIo) {
            this.autoEnableIo = autoEnableIo;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getEncrypted}
         * @param encrypted Indicates whether the volume should be encrypted.
         *                  The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default">Encryption by default</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         *                  <p>
         *                  Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported instance types</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(java.lang.Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getEncrypted}
         * @param encrypted Indicates whether the volume should be encrypted.
         *                  The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default">Encryption by default</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         *                  <p>
         *                  Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported instance types</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(software.amazon.awscdk.core.IResolvable encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getIops}
         * @param iops The number of I/O operations per second (IOPS).
         *             For <code>gp3</code> , <code>io1</code> , and <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
         *             <p>
         *             The following are the supported values for each volume type:
         *             <p>
         *             <ul>
         *             <li><code>gp3</code> : 3,000-16,000 IOPS</li>
         *             <li><code>io1</code> : 100-64,000 IOPS</li>
         *             <li><code>io2</code> : 100-64,000 IOPS</li>
         *             </ul>
         *             <p>
         *             <code>io1</code> and <code>io2</code> volumes support up to 64,000 IOPS only on <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> . Other instance families support performance up to 32,000 IOPS.
         *             <p>
         *             This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for <code>gp3</code> volumes is 3,000 IOPS. This parameter is not supported for <code>gp2</code> , <code>st1</code> , <code>sc1</code> , or <code>standard</code> volumes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iops(java.lang.Number iops) {
            this.iops = iops;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getKmsKeyId}
         * @param kmsKeyId The identifier of the AWS KMS key to use for Amazon EBS encryption.
         *                 If <code>KmsKeyId</code> is specified, the encrypted state must be <code>true</code> .
         *                 <p>
         *                 If you omit this property and your account is enabled for encryption by default, or <em>Encrypted</em> is set to <code>true</code> , then the volume is encrypted using the default key specified for your account. If your account does not have a default key, then the volume is encrypted using the AWS managed key .
         *                 <p>
         *                 Alternatively, if you want to specify a different key, you can specify one of the following:
         *                 <p>
         *                 <ul>
         *                 <li>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</li>
         *                 <li>Key alias. Specify the alias for the key, prefixed with <code>alias/</code> . For example, for a key with the alias <code>my_cmk</code> , use <code>alias/my_cmk</code> . Or to specify the AWS managed key , use <code>alias/aws/ebs</code> .</li>
         *                 <li>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</li>
         *                 <li>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</li>
         *                 </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getMultiAttachEnabled}
         * @param multiAttachEnabled Indicates whether Amazon EBS Multi-Attach is enabled.
         *                           AWS CloudFormation does not currently support updating a single-attach volume to be multi-attach enabled, updating a multi-attach enabled volume to be single-attach, or updating the size or number of I/O operations per second (IOPS) of a multi-attach enabled volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiAttachEnabled(java.lang.Boolean multiAttachEnabled) {
            this.multiAttachEnabled = multiAttachEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getMultiAttachEnabled}
         * @param multiAttachEnabled Indicates whether Amazon EBS Multi-Attach is enabled.
         *                           AWS CloudFormation does not currently support updating a single-attach volume to be multi-attach enabled, updating a multi-attach enabled volume to be single-attach, or updating the size or number of I/O operations per second (IOPS) of a multi-attach enabled volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiAttachEnabled(software.amazon.awscdk.core.IResolvable multiAttachEnabled) {
            this.multiAttachEnabled = multiAttachEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getOutpostArn}
         * @param outpostArn The Amazon Resource Name (ARN) of the Outpost.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outpostArn(java.lang.String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getSize}
         * @param size The size of the volume, in GiBs.
         *             You must specify either a snapshot ID or a volume size. If you specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the snapshot size.
         *             <p>
         *             The following are the supported volumes sizes for each volume type:
         *             <p>
         *             <ul>
         *             <li><code>gp2</code> and <code>gp3</code> : 1-16,384</li>
         *             <li><code>io1</code> and <code>io2</code> : 4-16,384</li>
         *             <li><code>st1</code> and <code>sc1</code> : 125-16,384</li>
         *             <li><code>standard</code> : 1-1,024</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder size(java.lang.Number size) {
            this.size = size;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getSnapshotId}
         * @param snapshotId The snapshot from which to create the volume.
         *                   You must specify either a snapshot ID or a volume size.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotId(java.lang.String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getTags}
         * @param tags The tags to apply to the volume during creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getThroughput}
         * @param throughput The throughput to provision for a volume, with a maximum of 1,000 MiB/s.
         *                   This parameter is valid only for <code>gp3</code> volumes. The default value is 125.
         *                   <p>
         *                   Valid Range: Minimum value of 125. Maximum value of 1000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throughput(java.lang.Number throughput) {
            this.throughput = throughput;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getVolumeType}
         * @param volumeType The volume type. This parameter can be one of the following values:.
         *                   <ul>
         *                   <li>General Purpose SSD: <code>gp2</code> | <code>gp3</code></li>
         *                   <li>Provisioned IOPS SSD: <code>io1</code> | <code>io2</code></li>
         *                   <li>Throughput Optimized HDD: <code>st1</code></li>
         *                   <li>Cold HDD: <code>sc1</code></li>
         *                   <li>Magnetic: <code>standard</code></li>
         *                   </ul>
         *                   <p>
         *                   For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         *                   <p>
         *                   Default: <code>gp2</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeType(java.lang.String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVolumeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVolumeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVolumeProps {
        private final java.lang.String availabilityZone;
        private final java.lang.Object autoEnableIo;
        private final java.lang.Object encrypted;
        private final java.lang.Number iops;
        private final java.lang.String kmsKeyId;
        private final java.lang.Object multiAttachEnabled;
        private final java.lang.String outpostArn;
        private final java.lang.Number size;
        private final java.lang.String snapshotId;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.Number throughput;
        private final java.lang.String volumeType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoEnableIo = software.amazon.jsii.Kernel.get(this, "autoEnableIo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.multiAttachEnabled = software.amazon.jsii.Kernel.get(this, "multiAttachEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.outpostArn = software.amazon.jsii.Kernel.get(this, "outpostArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.snapshotId = software.amazon.jsii.Kernel.get(this, "snapshotId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.throughput = software.amazon.jsii.Kernel.get(this, "throughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZone = java.util.Objects.requireNonNull(builder.availabilityZone, "availabilityZone is required");
            this.autoEnableIo = builder.autoEnableIo;
            this.encrypted = builder.encrypted;
            this.iops = builder.iops;
            this.kmsKeyId = builder.kmsKeyId;
            this.multiAttachEnabled = builder.multiAttachEnabled;
            this.outpostArn = builder.outpostArn;
            this.size = builder.size;
            this.snapshotId = builder.snapshotId;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.throughput = builder.throughput;
            this.volumeType = builder.volumeType;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.Object getAutoEnableIo() {
            return this.autoEnableIo;
        }

        @Override
        public final java.lang.Object getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final java.lang.Number getIops() {
            return this.iops;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.Object getMultiAttachEnabled() {
            return this.multiAttachEnabled;
        }

        @Override
        public final java.lang.String getOutpostArn() {
            return this.outpostArn;
        }

        @Override
        public final java.lang.Number getSize() {
            return this.size;
        }

        @Override
        public final java.lang.String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Number getThroughput() {
            return this.throughput;
        }

        @Override
        public final java.lang.String getVolumeType() {
            return this.volumeType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            if (this.getAutoEnableIo() != null) {
                data.set("autoEnableIo", om.valueToTree(this.getAutoEnableIo()));
            }
            if (this.getEncrypted() != null) {
                data.set("encrypted", om.valueToTree(this.getEncrypted()));
            }
            if (this.getIops() != null) {
                data.set("iops", om.valueToTree(this.getIops()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getMultiAttachEnabled() != null) {
                data.set("multiAttachEnabled", om.valueToTree(this.getMultiAttachEnabled()));
            }
            if (this.getOutpostArn() != null) {
                data.set("outpostArn", om.valueToTree(this.getOutpostArn()));
            }
            if (this.getSize() != null) {
                data.set("size", om.valueToTree(this.getSize()));
            }
            if (this.getSnapshotId() != null) {
                data.set("snapshotId", om.valueToTree(this.getSnapshotId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getThroughput() != null) {
                data.set("throughput", om.valueToTree(this.getThroughput()));
            }
            if (this.getVolumeType() != null) {
                data.set("volumeType", om.valueToTree(this.getVolumeType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnVolumeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVolumeProps.Jsii$Proxy that = (CfnVolumeProps.Jsii$Proxy) o;

            if (!availabilityZone.equals(that.availabilityZone)) return false;
            if (this.autoEnableIo != null ? !this.autoEnableIo.equals(that.autoEnableIo) : that.autoEnableIo != null) return false;
            if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
            if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.multiAttachEnabled != null ? !this.multiAttachEnabled.equals(that.multiAttachEnabled) : that.multiAttachEnabled != null) return false;
            if (this.outpostArn != null ? !this.outpostArn.equals(that.outpostArn) : that.outpostArn != null) return false;
            if (this.size != null ? !this.size.equals(that.size) : that.size != null) return false;
            if (this.snapshotId != null ? !this.snapshotId.equals(that.snapshotId) : that.snapshotId != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.throughput != null ? !this.throughput.equals(that.throughput) : that.throughput != null) return false;
            return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.availabilityZone.hashCode();
            result = 31 * result + (this.autoEnableIo != null ? this.autoEnableIo.hashCode() : 0);
            result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
            result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.multiAttachEnabled != null ? this.multiAttachEnabled.hashCode() : 0);
            result = 31 * result + (this.outpostArn != null ? this.outpostArn.hashCode() : 0);
            result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
            result = 31 * result + (this.snapshotId != null ? this.snapshotId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.throughput != null ? this.throughput.hashCode() : 0);
            result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
            return result;
        }
    }
}
