package software.amazon.awscdk.services.ec2;

/**
 * Properties for a ClientVpnAuthorizationRule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * ClientVpnEndpoint clientVpnEndpoint;
 * ClientVpnAuthorizationRuleProps clientVpnAuthorizationRuleProps = ClientVpnAuthorizationRuleProps.builder()
 *         .cidr("cidr")
 *         // the properties below are optional
 *         .clientVpnEndoint(clientVpnEndpoint)
 *         .clientVpnEndpoint(clientVpnEndpoint)
 *         .description("description")
 *         .groupId("groupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-31T18:44:10.908Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.ClientVpnAuthorizationRuleProps")
@software.amazon.jsii.Jsii.Proxy(ClientVpnAuthorizationRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ClientVpnAuthorizationRuleProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.ClientVpnAuthorizationRuleOptions {

    /**
     * (deprecated) The client VPN endpoint to which to add the rule.
     * <p>
     * Default: clientVpnEndpoint is required
     * <p>
     * @deprecated Use `clientVpnEndpoint` instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IClientVpnEndpoint getClientVpnEndoint() {
        return null;
    }

    /**
     * The client VPN endpoint to which to add the rule.
     * <p>
     * Default: clientVpnEndpoint is required
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IClientVpnEndpoint getClientVpnEndpoint() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ClientVpnAuthorizationRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClientVpnAuthorizationRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ClientVpnAuthorizationRuleProps> {
        software.amazon.awscdk.services.ec2.IClientVpnEndpoint clientVpnEndoint;
        software.amazon.awscdk.services.ec2.IClientVpnEndpoint clientVpnEndpoint;
        java.lang.String cidr;
        java.lang.String description;
        java.lang.String groupId;

        /**
         * Sets the value of {@link ClientVpnAuthorizationRuleProps#getClientVpnEndoint}
         * @param clientVpnEndoint The client VPN endpoint to which to add the rule.
         * @return {@code this}
         * @deprecated Use `clientVpnEndpoint` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder clientVpnEndoint(software.amazon.awscdk.services.ec2.IClientVpnEndpoint clientVpnEndoint) {
            this.clientVpnEndoint = clientVpnEndoint;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnAuthorizationRuleProps#getClientVpnEndpoint}
         * @param clientVpnEndpoint The client VPN endpoint to which to add the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientVpnEndpoint(software.amazon.awscdk.services.ec2.IClientVpnEndpoint clientVpnEndpoint) {
            this.clientVpnEndpoint = clientVpnEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnAuthorizationRuleProps#getCidr}
         * @param cidr The IPv4 address range, in CIDR notation, of the network for which access is being authorized. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidr(java.lang.String cidr) {
            this.cidr = cidr;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnAuthorizationRuleProps#getDescription}
         * @param description A brief description of the authorization rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnAuthorizationRuleProps#getGroupId}
         * @param groupId The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupId(java.lang.String groupId) {
            this.groupId = groupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClientVpnAuthorizationRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ClientVpnAuthorizationRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ClientVpnAuthorizationRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientVpnAuthorizationRuleProps {
        private final software.amazon.awscdk.services.ec2.IClientVpnEndpoint clientVpnEndoint;
        private final software.amazon.awscdk.services.ec2.IClientVpnEndpoint clientVpnEndpoint;
        private final java.lang.String cidr;
        private final java.lang.String description;
        private final java.lang.String groupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clientVpnEndoint = software.amazon.jsii.Kernel.get(this, "clientVpnEndoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IClientVpnEndpoint.class));
            this.clientVpnEndpoint = software.amazon.jsii.Kernel.get(this, "clientVpnEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IClientVpnEndpoint.class));
            this.cidr = software.amazon.jsii.Kernel.get(this, "cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.groupId = software.amazon.jsii.Kernel.get(this, "groupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientVpnEndoint = builder.clientVpnEndoint;
            this.clientVpnEndpoint = builder.clientVpnEndpoint;
            this.cidr = java.util.Objects.requireNonNull(builder.cidr, "cidr is required");
            this.description = builder.description;
            this.groupId = builder.groupId;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IClientVpnEndpoint getClientVpnEndoint() {
            return this.clientVpnEndoint;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IClientVpnEndpoint getClientVpnEndpoint() {
            return this.clientVpnEndpoint;
        }

        @Override
        public final java.lang.String getCidr() {
            return this.cidr;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getGroupId() {
            return this.groupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getClientVpnEndoint() != null) {
                data.set("clientVpnEndoint", om.valueToTree(this.getClientVpnEndoint()));
            }
            if (this.getClientVpnEndpoint() != null) {
                data.set("clientVpnEndpoint", om.valueToTree(this.getClientVpnEndpoint()));
            }
            data.set("cidr", om.valueToTree(this.getCidr()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getGroupId() != null) {
                data.set("groupId", om.valueToTree(this.getGroupId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.ClientVpnAuthorizationRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClientVpnAuthorizationRuleProps.Jsii$Proxy that = (ClientVpnAuthorizationRuleProps.Jsii$Proxy) o;

            if (this.clientVpnEndoint != null ? !this.clientVpnEndoint.equals(that.clientVpnEndoint) : that.clientVpnEndoint != null) return false;
            if (this.clientVpnEndpoint != null ? !this.clientVpnEndpoint.equals(that.clientVpnEndpoint) : that.clientVpnEndpoint != null) return false;
            if (!cidr.equals(that.cidr)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.groupId != null ? this.groupId.equals(that.groupId) : that.groupId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clientVpnEndoint != null ? this.clientVpnEndoint.hashCode() : 0;
            result = 31 * result + (this.clientVpnEndpoint != null ? this.clientVpnEndpoint.hashCode() : 0);
            result = 31 * result + (this.cidr.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.groupId != null ? this.groupId.hashCode() : 0);
            return result;
        }
    }
}
