package software.amazon.awscdk.services.ec2;

/**
 * Contains logic which chooses a set of subnets from a larger list, in conjunction with SubnetSelection, to determine where to place AWS resources such as VPC endpoints, EC2 instances, etc.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * SubnetFilter subnetFilter = SubnetFilter.availabilityZones(List.of("availabilityZones"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-31T18:44:11.190Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.SubnetFilter")
public abstract class SubnetFilter extends software.amazon.jsii.JsiiObject {

    protected SubnetFilter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SubnetFilter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected SubnetFilter() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Chooses subnets which are in one of the given availability zones.
     * <p>
     * @param availabilityZones This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SubnetFilter availabilityZones(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> availabilityZones) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.SubnetFilter.class, "availabilityZones", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetFilter.class), new Object[] { java.util.Objects.requireNonNull(availabilityZones, "availabilityZones is required") });
    }

    /**
     * Chooses subnets which have the provided CIDR netmask.
     * <p>
     * @param mask This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SubnetFilter byCidrMask(final @org.jetbrains.annotations.NotNull java.lang.Number mask) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.SubnetFilter.class, "byCidrMask", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetFilter.class), new Object[] { java.util.Objects.requireNonNull(mask, "mask is required") });
    }

    /**
     * Chooses subnets by id.
     * <p>
     * @param subnetIds This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SubnetFilter byIds(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> subnetIds) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.SubnetFilter.class, "byIds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetFilter.class), new Object[] { java.util.Objects.requireNonNull(subnetIds, "subnetIds is required") });
    }

    /**
     * Chooses subnets which contain any of the specified IP addresses.
     * <p>
     * @param ipv4addrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SubnetFilter containsIpAddresses(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> ipv4addrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.SubnetFilter.class, "containsIpAddresses", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetFilter.class), new Object[] { java.util.Objects.requireNonNull(ipv4addrs, "ipv4addrs is required") });
    }

    /**
     * Chooses subnets such that there is at most one per availability zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SubnetFilter onePerAz() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.SubnetFilter.class, "onePerAz", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetFilter.class));
    }

    /**
     * Executes the subnet filtering logic, returning a filtered set of subnets.
     * <p>
     * @param _subnets This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISubnet> selectSubnets(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISubnet> _subnets) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "selectSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class)), new Object[] { java.util.Objects.requireNonNull(_subnets, "_subnets is required") }));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ec2.SubnetFilter {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
