package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnCapacityReservationFleet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnCapacityReservationFleetProps cfnCapacityReservationFleetProps = CfnCapacityReservationFleetProps.builder()
 *         .allocationStrategy("allocationStrategy")
 *         .endDate("endDate")
 *         .instanceMatchCriteria("instanceMatchCriteria")
 *         .instanceTypeSpecifications(List.of(InstanceTypeSpecificationProperty.builder()
 *                 .availabilityZone("availabilityZone")
 *                 .availabilityZoneId("availabilityZoneId")
 *                 .ebsOptimized(false)
 *                 .instancePlatform("instancePlatform")
 *                 .instanceType("instanceType")
 *                 .priority(123)
 *                 .weight(123)
 *                 .build()))
 *         .noRemoveEndDate(false)
 *         .removeEndDate(false)
 *         .tagSpecifications(List.of(TagSpecificationProperty.builder()
 *                 .resourceType("resourceType")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .tenancy("tenancy")
 *         .totalTargetCapacity(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.84.0 (build 5404dcf)", date = "2023-06-19T16:30:38.425Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnCapacityReservationFleetProps")
@software.amazon.jsii.Jsii.Proxy(CfnCapacityReservationFleetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCapacityReservationFleetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The strategy used by the Capacity Reservation Fleet to determine which of the specified instance types to use.
     * <p>
     * Currently, only the <code>prioritized</code> allocation strategy is supported. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy">Allocation strategy</a> in the Amazon EC2 User Guide.
     * <p>
     * Valid values: <code>prioritized</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAllocationStrategy() {
        return null;
    }

    /**
     * The date and time at which the Capacity Reservation Fleet expires.
     * <p>
     * When the Capacity Reservation Fleet expires, its state changes to <code>expired</code> and all of the Capacity Reservations in the Fleet expire.
     * <p>
     * The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you specify <code>5/31/2019</code> , <code>13:30:55</code> , the Capacity Reservation Fleet is guaranteed to expire between <code>13:30:55</code> and <code>14:30:55</code> on <code>5/31/2019</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndDate() {
        return null;
    }

    /**
     * Indicates the type of instance launches that the Capacity Reservation Fleet accepts.
     * <p>
     * All Capacity Reservations in the Fleet inherit this instance matching criteria.
     * <p>
     * Currently, Capacity Reservation Fleets support <code>open</code> instance matching criteria only. This means that instances that have matching attributes (instance type, platform, and Availability Zone) run in the Capacity Reservations automatically. Instances do not need to explicitly target a Capacity Reservation Fleet to use its reserved capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceMatchCriteria() {
        return null;
    }

    /**
     * Information about the instance types for which to reserve the capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceTypeSpecifications() {
        return null;
    }

    /**
     * Used to add an end date to a Capacity Reservation Fleet that has no end date and time.
     * <p>
     * To add an end date to a Capacity Reservation Fleet, specify <code>true</code> for this paramater and specify the end date and time (in UTC time format) for the <em>EndDate</em> parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNoRemoveEndDate() {
        return null;
    }

    /**
     * Used to remove an end date from a Capacity Reservation Fleet that is configured to end automatically at a specific date and time.
     * <p>
     * To remove the end date from a Capacity Reservation Fleet, specify <code>true</code> for this paramater and omit the <em>EndDate</em> parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveEndDate() {
        return null;
    }

    /**
     * The tags to assign to the Capacity Reservation Fleet.
     * <p>
     * The tags are automatically assigned to the Capacity Reservations in the Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
        return null;
    }

    /**
     * Indicates the tenancy of the Capacity Reservation Fleet.
     * <p>
     * All Capacity Reservations in the Fleet inherit this tenancy. The Capacity Reservation Fleet can have one of the following tenancy settings:
     * <p>
     * <ul>
     * <li><code>default</code> - The Capacity Reservation Fleet is created on hardware that is shared with other AWS accounts .</li>
     * <li><code>dedicated</code> - The Capacity Reservations are created on single-tenant hardware that is dedicated to a single AWS account .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTenancy() {
        return null;
    }

    /**
     * The total number of capacity units to be reserved by the Capacity Reservation Fleet.
     * <p>
     * This value, together with the instance type weights that you assign to each instance type used by the Fleet determine the number of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your workload. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target capacity</a> in the Amazon EC2 User Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTotalTargetCapacity() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCapacityReservationFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCapacityReservationFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCapacityReservationFleetProps> {
        java.lang.String allocationStrategy;
        java.lang.String endDate;
        java.lang.String instanceMatchCriteria;
        java.lang.Object instanceTypeSpecifications;
        java.lang.Object noRemoveEndDate;
        java.lang.Object removeEndDate;
        java.lang.Object tagSpecifications;
        java.lang.String tenancy;
        java.lang.Number totalTargetCapacity;

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getAllocationStrategy}
         * @param allocationStrategy The strategy used by the Capacity Reservation Fleet to determine which of the specified instance types to use.
         *                           Currently, only the <code>prioritized</code> allocation strategy is supported. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy">Allocation strategy</a> in the Amazon EC2 User Guide.
         *                           <p>
         *                           Valid values: <code>prioritized</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationStrategy(java.lang.String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getEndDate}
         * @param endDate The date and time at which the Capacity Reservation Fleet expires.
         *                When the Capacity Reservation Fleet expires, its state changes to <code>expired</code> and all of the Capacity Reservations in the Fleet expire.
         *                <p>
         *                The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you specify <code>5/31/2019</code> , <code>13:30:55</code> , the Capacity Reservation Fleet is guaranteed to expire between <code>13:30:55</code> and <code>14:30:55</code> on <code>5/31/2019</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endDate(java.lang.String endDate) {
            this.endDate = endDate;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getInstanceMatchCriteria}
         * @param instanceMatchCriteria Indicates the type of instance launches that the Capacity Reservation Fleet accepts.
         *                              All Capacity Reservations in the Fleet inherit this instance matching criteria.
         *                              <p>
         *                              Currently, Capacity Reservation Fleets support <code>open</code> instance matching criteria only. This means that instances that have matching attributes (instance type, platform, and Availability Zone) run in the Capacity Reservations automatically. Instances do not need to explicitly target a Capacity Reservation Fleet to use its reserved capacity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMatchCriteria(java.lang.String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getInstanceTypeSpecifications}
         * @param instanceTypeSpecifications Information about the instance types for which to reserve the capacity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypeSpecifications(software.amazon.awscdk.core.IResolvable instanceTypeSpecifications) {
            this.instanceTypeSpecifications = instanceTypeSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getInstanceTypeSpecifications}
         * @param instanceTypeSpecifications Information about the instance types for which to reserve the capacity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypeSpecifications(java.util.List<? extends java.lang.Object> instanceTypeSpecifications) {
            this.instanceTypeSpecifications = instanceTypeSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getNoRemoveEndDate}
         * @param noRemoveEndDate Used to add an end date to a Capacity Reservation Fleet that has no end date and time.
         *                        To add an end date to a Capacity Reservation Fleet, specify <code>true</code> for this paramater and specify the end date and time (in UTC time format) for the <em>EndDate</em> parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noRemoveEndDate(java.lang.Boolean noRemoveEndDate) {
            this.noRemoveEndDate = noRemoveEndDate;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getNoRemoveEndDate}
         * @param noRemoveEndDate Used to add an end date to a Capacity Reservation Fleet that has no end date and time.
         *                        To add an end date to a Capacity Reservation Fleet, specify <code>true</code> for this paramater and specify the end date and time (in UTC time format) for the <em>EndDate</em> parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noRemoveEndDate(software.amazon.awscdk.core.IResolvable noRemoveEndDate) {
            this.noRemoveEndDate = noRemoveEndDate;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getRemoveEndDate}
         * @param removeEndDate Used to remove an end date from a Capacity Reservation Fleet that is configured to end automatically at a specific date and time.
         *                      To remove the end date from a Capacity Reservation Fleet, specify <code>true</code> for this paramater and omit the <em>EndDate</em> parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeEndDate(java.lang.Boolean removeEndDate) {
            this.removeEndDate = removeEndDate;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getRemoveEndDate}
         * @param removeEndDate Used to remove an end date from a Capacity Reservation Fleet that is configured to end automatically at a specific date and time.
         *                      To remove the end date from a Capacity Reservation Fleet, specify <code>true</code> for this paramater and omit the <em>EndDate</em> parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeEndDate(software.amazon.awscdk.core.IResolvable removeEndDate) {
            this.removeEndDate = removeEndDate;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getTagSpecifications}
         * @param tagSpecifications The tags to assign to the Capacity Reservation Fleet.
         *                          The tags are automatically assigned to the Capacity Reservations in the Fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(software.amazon.awscdk.core.IResolvable tagSpecifications) {
            this.tagSpecifications = tagSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getTagSpecifications}
         * @param tagSpecifications The tags to assign to the Capacity Reservation Fleet.
         *                          The tags are automatically assigned to the Capacity Reservations in the Fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(java.util.List<? extends java.lang.Object> tagSpecifications) {
            this.tagSpecifications = tagSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getTenancy}
         * @param tenancy Indicates the tenancy of the Capacity Reservation Fleet.
         *                All Capacity Reservations in the Fleet inherit this tenancy. The Capacity Reservation Fleet can have one of the following tenancy settings:
         *                <p>
         *                <ul>
         *                <li><code>default</code> - The Capacity Reservation Fleet is created on hardware that is shared with other AWS accounts .</li>
         *                <li><code>dedicated</code> - The Capacity Reservations are created on single-tenant hardware that is dedicated to a single AWS account .</li>
         *                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tenancy(java.lang.String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getTotalTargetCapacity}
         * @param totalTargetCapacity The total number of capacity units to be reserved by the Capacity Reservation Fleet.
         *                            This value, together with the instance type weights that you assign to each instance type used by the Fleet determine the number of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your workload. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target capacity</a> in the Amazon EC2 User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalTargetCapacity(java.lang.Number totalTargetCapacity) {
            this.totalTargetCapacity = totalTargetCapacity;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCapacityReservationFleetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCapacityReservationFleetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCapacityReservationFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCapacityReservationFleetProps {
        private final java.lang.String allocationStrategy;
        private final java.lang.String endDate;
        private final java.lang.String instanceMatchCriteria;
        private final java.lang.Object instanceTypeSpecifications;
        private final java.lang.Object noRemoveEndDate;
        private final java.lang.Object removeEndDate;
        private final java.lang.Object tagSpecifications;
        private final java.lang.String tenancy;
        private final java.lang.Number totalTargetCapacity;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endDate = software.amazon.jsii.Kernel.get(this, "endDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceMatchCriteria = software.amazon.jsii.Kernel.get(this, "instanceMatchCriteria", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceTypeSpecifications = software.amazon.jsii.Kernel.get(this, "instanceTypeSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.noRemoveEndDate = software.amazon.jsii.Kernel.get(this, "noRemoveEndDate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.removeEndDate = software.amazon.jsii.Kernel.get(this, "removeEndDate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tagSpecifications = software.amazon.jsii.Kernel.get(this, "tagSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tenancy = software.amazon.jsii.Kernel.get(this, "tenancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.totalTargetCapacity = software.amazon.jsii.Kernel.get(this, "totalTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allocationStrategy = builder.allocationStrategy;
            this.endDate = builder.endDate;
            this.instanceMatchCriteria = builder.instanceMatchCriteria;
            this.instanceTypeSpecifications = builder.instanceTypeSpecifications;
            this.noRemoveEndDate = builder.noRemoveEndDate;
            this.removeEndDate = builder.removeEndDate;
            this.tagSpecifications = builder.tagSpecifications;
            this.tenancy = builder.tenancy;
            this.totalTargetCapacity = builder.totalTargetCapacity;
        }

        @Override
        public final java.lang.String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        @Override
        public final java.lang.String getEndDate() {
            return this.endDate;
        }

        @Override
        public final java.lang.String getInstanceMatchCriteria() {
            return this.instanceMatchCriteria;
        }

        @Override
        public final java.lang.Object getInstanceTypeSpecifications() {
            return this.instanceTypeSpecifications;
        }

        @Override
        public final java.lang.Object getNoRemoveEndDate() {
            return this.noRemoveEndDate;
        }

        @Override
        public final java.lang.Object getRemoveEndDate() {
            return this.removeEndDate;
        }

        @Override
        public final java.lang.Object getTagSpecifications() {
            return this.tagSpecifications;
        }

        @Override
        public final java.lang.String getTenancy() {
            return this.tenancy;
        }

        @Override
        public final java.lang.Number getTotalTargetCapacity() {
            return this.totalTargetCapacity;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllocationStrategy() != null) {
                data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
            }
            if (this.getEndDate() != null) {
                data.set("endDate", om.valueToTree(this.getEndDate()));
            }
            if (this.getInstanceMatchCriteria() != null) {
                data.set("instanceMatchCriteria", om.valueToTree(this.getInstanceMatchCriteria()));
            }
            if (this.getInstanceTypeSpecifications() != null) {
                data.set("instanceTypeSpecifications", om.valueToTree(this.getInstanceTypeSpecifications()));
            }
            if (this.getNoRemoveEndDate() != null) {
                data.set("noRemoveEndDate", om.valueToTree(this.getNoRemoveEndDate()));
            }
            if (this.getRemoveEndDate() != null) {
                data.set("removeEndDate", om.valueToTree(this.getRemoveEndDate()));
            }
            if (this.getTagSpecifications() != null) {
                data.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
            }
            if (this.getTenancy() != null) {
                data.set("tenancy", om.valueToTree(this.getTenancy()));
            }
            if (this.getTotalTargetCapacity() != null) {
                data.set("totalTargetCapacity", om.valueToTree(this.getTotalTargetCapacity()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnCapacityReservationFleetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCapacityReservationFleetProps.Jsii$Proxy that = (CfnCapacityReservationFleetProps.Jsii$Proxy) o;

            if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
            if (this.endDate != null ? !this.endDate.equals(that.endDate) : that.endDate != null) return false;
            if (this.instanceMatchCriteria != null ? !this.instanceMatchCriteria.equals(that.instanceMatchCriteria) : that.instanceMatchCriteria != null) return false;
            if (this.instanceTypeSpecifications != null ? !this.instanceTypeSpecifications.equals(that.instanceTypeSpecifications) : that.instanceTypeSpecifications != null) return false;
            if (this.noRemoveEndDate != null ? !this.noRemoveEndDate.equals(that.noRemoveEndDate) : that.noRemoveEndDate != null) return false;
            if (this.removeEndDate != null ? !this.removeEndDate.equals(that.removeEndDate) : that.removeEndDate != null) return false;
            if (this.tagSpecifications != null ? !this.tagSpecifications.equals(that.tagSpecifications) : that.tagSpecifications != null) return false;
            if (this.tenancy != null ? !this.tenancy.equals(that.tenancy) : that.tenancy != null) return false;
            return this.totalTargetCapacity != null ? this.totalTargetCapacity.equals(that.totalTargetCapacity) : that.totalTargetCapacity == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0;
            result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
            result = 31 * result + (this.instanceMatchCriteria != null ? this.instanceMatchCriteria.hashCode() : 0);
            result = 31 * result + (this.instanceTypeSpecifications != null ? this.instanceTypeSpecifications.hashCode() : 0);
            result = 31 * result + (this.noRemoveEndDate != null ? this.noRemoveEndDate.hashCode() : 0);
            result = 31 * result + (this.removeEndDate != null ? this.removeEndDate.hashCode() : 0);
            result = 31 * result + (this.tagSpecifications != null ? this.tagSpecifications.hashCode() : 0);
            result = 31 * result + (this.tenancy != null ? this.tenancy.hashCode() : 0);
            result = 31 * result + (this.totalTargetCapacity != null ? this.totalTargetCapacity.hashCode() : 0);
            return result;
        }
    }
}
