package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnFlowLog</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * Object destinationOptions;
 * CfnFlowLogProps cfnFlowLogProps = CfnFlowLogProps.builder()
 *         .resourceId("resourceId")
 *         .resourceType("resourceType")
 *         // the properties below are optional
 *         .deliverLogsPermissionArn("deliverLogsPermissionArn")
 *         .destinationOptions(destinationOptions)
 *         .logDestination("logDestination")
 *         .logDestinationType("logDestinationType")
 *         .logFormat("logFormat")
 *         .logGroupName("logGroupName")
 *         .maxAggregationInterval(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .trafficType("trafficType")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.84.0 (build 5404dcf)", date = "2023-06-19T16:30:38.564Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnFlowLogProps")
@software.amazon.jsii.Jsii.Proxy(CfnFlowLogProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFlowLogProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the resource to monitor.
     * <p>
     * For example, if the resource type is <code>VPC</code> , specify the ID of the VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceId();

    /**
     * The type of resource to monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceType();

    /**
     * The ARN of the IAM role that allows Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.
     * <p>
     * This parameter is required if the destination type is <code>cloud-watch-logs</code> and unsupported otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeliverLogsPermissionArn() {
        return null;
    }

    /**
     * The destination options. The following options are supported:.
     * <p>
     * <ul>
     * <li><code>FileFormat</code> - The format for the flow log ( <code>plain-text</code> | <code>parquet</code> ). The default is <code>plain-text</code> .</li>
     * <li><code>HiveCompatiblePartitions</code> - Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3 ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
     * <li><code>PerHourPartition</code> - Indicates whether to partition the flow log per hour ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationOptions() {
        return null;
    }

    /**
     * The destination for the flow log data. The meaning of this parameter depends on the destination type.
     * <p>
     * <ul>
     * <li>If the destination type is <code>cloud-watch-logs</code> , specify the ARN of a CloudWatch Logs log group. For example:</li>
     * </ul>
     * <p>
     * arn:aws:logs: <em>region</em> : <em>account_id</em> :log-group: <em>my_group</em>
     * <p>
     * Alternatively, use the <code>LogGroupName</code> parameter.
     * <p>
     * <ul>
     * <li>If the destination type is <code>s3</code> , specify the ARN of an S3 bucket. For example:</li>
     * </ul>
     * <p>
     * arn:aws:s3::: <em>my_bucket</em> / <em>my_subfolder</em> /
     * <p>
     * The subfolder is optional. Note that you can't use <code>AWSLogs</code> as a subfolder name.
     * <p>
     * <ul>
     * <li>If the destination type is <code>kinesis-data-firehose</code> , specify the ARN of a Kinesis Data Firehose delivery stream. For example:</li>
     * </ul>
     * <p>
     * arn:aws:firehose: <em>region</em> : <em>account_id</em> :deliverystream: <em>my_stream</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogDestination() {
        return null;
    }

    /**
     * The type of destination for the flow log data.
     * <p>
     * Default: <code>cloud-watch-logs</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogDestinationType() {
        return null;
    }

    /**
     * The fields to include in the flow log record, in the order in which they should appear.
     * <p>
     * If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must include at least one field. For more information about the available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records</a> in the <em>Amazon VPC User Guide</em> or <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-flow-logs.html#flow-log-records">Transit Gateway Flow Log records</a> in the <em>AWS Transit Gateway Guide</em> .
     * <p>
     * Specify the fields using the <code>${field-id}</code> format, separated by spaces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogFormat() {
        return null;
    }

    /**
     * The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.
     * <p>
     * This parameter is valid only if the destination type is <code>cloud-watch-logs</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogGroupName() {
        return null;
    }

    /**
     * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
     * <p>
     * The possible values are 60 seconds (1 minute) or 600 seconds (10 minutes). This parameter must be 60 seconds for transit gateway resource types.
     * <p>
     * When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instance</a> , the aggregation interval is always 60 seconds or less, regardless of the value that you specify.
     * <p>
     * Default: 600
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAggregationInterval() {
        return null;
    }

    /**
     * The tags to apply to the flow logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * The type of traffic to monitor (accepted traffic, rejected traffic, or all traffic).
     * <p>
     * This parameter is not supported for transit gateway resource types. It is required for the other resource types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTrafficType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFlowLogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFlowLogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFlowLogProps> {
        java.lang.String resourceId;
        java.lang.String resourceType;
        java.lang.String deliverLogsPermissionArn;
        java.lang.Object destinationOptions;
        java.lang.String logDestination;
        java.lang.String logDestinationType;
        java.lang.String logFormat;
        java.lang.String logGroupName;
        java.lang.Number maxAggregationInterval;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.String trafficType;

        /**
         * Sets the value of {@link CfnFlowLogProps#getResourceId}
         * @param resourceId The ID of the resource to monitor. This parameter is required.
         *                   For example, if the resource type is <code>VPC</code> , specify the ID of the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(java.lang.String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getResourceType}
         * @param resourceType The type of resource to monitor. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getDeliverLogsPermissionArn}
         * @param deliverLogsPermissionArn The ARN of the IAM role that allows Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.
         *                                 This parameter is required if the destination type is <code>cloud-watch-logs</code> and unsupported otherwise.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliverLogsPermissionArn(java.lang.String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getDestinationOptions}
         * @param destinationOptions The destination options. The following options are supported:.
         *                           <ul>
         *                           <li><code>FileFormat</code> - The format for the flow log ( <code>plain-text</code> | <code>parquet</code> ). The default is <code>plain-text</code> .</li>
         *                           <li><code>HiveCompatiblePartitions</code> - Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3 ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
         *                           <li><code>PerHourPartition</code> - Indicates whether to partition the flow log per hour ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
         *                           </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationOptions(java.lang.Object destinationOptions) {
            this.destinationOptions = destinationOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getLogDestination}
         * @param logDestination The destination for the flow log data. The meaning of this parameter depends on the destination type.
         *                       <ul>
         *                       <li>If the destination type is <code>cloud-watch-logs</code> , specify the ARN of a CloudWatch Logs log group. For example:</li>
         *                       </ul>
         *                       <p>
         *                       arn:aws:logs: <em>region</em> : <em>account_id</em> :log-group: <em>my_group</em>
         *                       <p>
         *                       Alternatively, use the <code>LogGroupName</code> parameter.
         *                       <p>
         *                       <ul>
         *                       <li>If the destination type is <code>s3</code> , specify the ARN of an S3 bucket. For example:</li>
         *                       </ul>
         *                       <p>
         *                       arn:aws:s3::: <em>my_bucket</em> / <em>my_subfolder</em> /
         *                       <p>
         *                       The subfolder is optional. Note that you can't use <code>AWSLogs</code> as a subfolder name.
         *                       <p>
         *                       <ul>
         *                       <li>If the destination type is <code>kinesis-data-firehose</code> , specify the ARN of a Kinesis Data Firehose delivery stream. For example:</li>
         *                       </ul>
         *                       <p>
         *                       arn:aws:firehose: <em>region</em> : <em>account_id</em> :deliverystream: <em>my_stream</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDestination(java.lang.String logDestination) {
            this.logDestination = logDestination;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getLogDestinationType}
         * @param logDestinationType The type of destination for the flow log data.
         *                           Default: <code>cloud-watch-logs</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDestinationType(java.lang.String logDestinationType) {
            this.logDestinationType = logDestinationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getLogFormat}
         * @param logFormat The fields to include in the flow log record, in the order in which they should appear.
         *                  If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must include at least one field. For more information about the available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records</a> in the <em>Amazon VPC User Guide</em> or <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-flow-logs.html#flow-log-records">Transit Gateway Flow Log records</a> in the <em>AWS Transit Gateway Guide</em> .
         *                  <p>
         *                  Specify the fields using the <code>${field-id}</code> format, separated by spaces.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logFormat(java.lang.String logFormat) {
            this.logFormat = logFormat;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getLogGroupName}
         * @param logGroupName The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.
         *                     This parameter is valid only if the destination type is <code>cloud-watch-logs</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(java.lang.String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getMaxAggregationInterval}
         * @param maxAggregationInterval The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
         *                               The possible values are 60 seconds (1 minute) or 600 seconds (10 minutes). This parameter must be 60 seconds for transit gateway resource types.
         *                               <p>
         *                               When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instance</a> , the aggregation interval is always 60 seconds or less, regardless of the value that you specify.
         *                               <p>
         *                               Default: 600
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAggregationInterval(java.lang.Number maxAggregationInterval) {
            this.maxAggregationInterval = maxAggregationInterval;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getTags}
         * @param tags The tags to apply to the flow logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getTrafficType}
         * @param trafficType The type of traffic to monitor (accepted traffic, rejected traffic, or all traffic).
         *                    This parameter is not supported for transit gateway resource types. It is required for the other resource types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficType(java.lang.String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFlowLogProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFlowLogProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFlowLogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFlowLogProps {
        private final java.lang.String resourceId;
        private final java.lang.String resourceType;
        private final java.lang.String deliverLogsPermissionArn;
        private final java.lang.Object destinationOptions;
        private final java.lang.String logDestination;
        private final java.lang.String logDestinationType;
        private final java.lang.String logFormat;
        private final java.lang.String logGroupName;
        private final java.lang.Number maxAggregationInterval;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.String trafficType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deliverLogsPermissionArn = software.amazon.jsii.Kernel.get(this, "deliverLogsPermissionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationOptions = software.amazon.jsii.Kernel.get(this, "destinationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logDestination = software.amazon.jsii.Kernel.get(this, "logDestination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logDestinationType = software.amazon.jsii.Kernel.get(this, "logDestinationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logFormat = software.amazon.jsii.Kernel.get(this, "logFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxAggregationInterval = software.amazon.jsii.Kernel.get(this, "maxAggregationInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.trafficType = software.amazon.jsii.Kernel.get(this, "trafficType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceId = java.util.Objects.requireNonNull(builder.resourceId, "resourceId is required");
            this.resourceType = java.util.Objects.requireNonNull(builder.resourceType, "resourceType is required");
            this.deliverLogsPermissionArn = builder.deliverLogsPermissionArn;
            this.destinationOptions = builder.destinationOptions;
            this.logDestination = builder.logDestination;
            this.logDestinationType = builder.logDestinationType;
            this.logFormat = builder.logFormat;
            this.logGroupName = builder.logGroupName;
            this.maxAggregationInterval = builder.maxAggregationInterval;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.trafficType = builder.trafficType;
        }

        @Override
        public final java.lang.String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final java.lang.String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final java.lang.String getDeliverLogsPermissionArn() {
            return this.deliverLogsPermissionArn;
        }

        @Override
        public final java.lang.Object getDestinationOptions() {
            return this.destinationOptions;
        }

        @Override
        public final java.lang.String getLogDestination() {
            return this.logDestination;
        }

        @Override
        public final java.lang.String getLogDestinationType() {
            return this.logDestinationType;
        }

        @Override
        public final java.lang.String getLogFormat() {
            return this.logFormat;
        }

        @Override
        public final java.lang.String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final java.lang.Number getMaxAggregationInterval() {
            return this.maxAggregationInterval;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTrafficType() {
            return this.trafficType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceId", om.valueToTree(this.getResourceId()));
            data.set("resourceType", om.valueToTree(this.getResourceType()));
            if (this.getDeliverLogsPermissionArn() != null) {
                data.set("deliverLogsPermissionArn", om.valueToTree(this.getDeliverLogsPermissionArn()));
            }
            if (this.getDestinationOptions() != null) {
                data.set("destinationOptions", om.valueToTree(this.getDestinationOptions()));
            }
            if (this.getLogDestination() != null) {
                data.set("logDestination", om.valueToTree(this.getLogDestination()));
            }
            if (this.getLogDestinationType() != null) {
                data.set("logDestinationType", om.valueToTree(this.getLogDestinationType()));
            }
            if (this.getLogFormat() != null) {
                data.set("logFormat", om.valueToTree(this.getLogFormat()));
            }
            if (this.getLogGroupName() != null) {
                data.set("logGroupName", om.valueToTree(this.getLogGroupName()));
            }
            if (this.getMaxAggregationInterval() != null) {
                data.set("maxAggregationInterval", om.valueToTree(this.getMaxAggregationInterval()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTrafficType() != null) {
                data.set("trafficType", om.valueToTree(this.getTrafficType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnFlowLogProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFlowLogProps.Jsii$Proxy that = (CfnFlowLogProps.Jsii$Proxy) o;

            if (!resourceId.equals(that.resourceId)) return false;
            if (!resourceType.equals(that.resourceType)) return false;
            if (this.deliverLogsPermissionArn != null ? !this.deliverLogsPermissionArn.equals(that.deliverLogsPermissionArn) : that.deliverLogsPermissionArn != null) return false;
            if (this.destinationOptions != null ? !this.destinationOptions.equals(that.destinationOptions) : that.destinationOptions != null) return false;
            if (this.logDestination != null ? !this.logDestination.equals(that.logDestination) : that.logDestination != null) return false;
            if (this.logDestinationType != null ? !this.logDestinationType.equals(that.logDestinationType) : that.logDestinationType != null) return false;
            if (this.logFormat != null ? !this.logFormat.equals(that.logFormat) : that.logFormat != null) return false;
            if (this.logGroupName != null ? !this.logGroupName.equals(that.logGroupName) : that.logGroupName != null) return false;
            if (this.maxAggregationInterval != null ? !this.maxAggregationInterval.equals(that.maxAggregationInterval) : that.maxAggregationInterval != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.trafficType != null ? this.trafficType.equals(that.trafficType) : that.trafficType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.resourceId.hashCode();
            result = 31 * result + (this.resourceType.hashCode());
            result = 31 * result + (this.deliverLogsPermissionArn != null ? this.deliverLogsPermissionArn.hashCode() : 0);
            result = 31 * result + (this.destinationOptions != null ? this.destinationOptions.hashCode() : 0);
            result = 31 * result + (this.logDestination != null ? this.logDestination.hashCode() : 0);
            result = 31 * result + (this.logDestinationType != null ? this.logDestinationType.hashCode() : 0);
            result = 31 * result + (this.logFormat != null ? this.logFormat.hashCode() : 0);
            result = 31 * result + (this.logGroupName != null ? this.logGroupName.hashCode() : 0);
            result = 31 * result + (this.maxAggregationInterval != null ? this.maxAggregationInterval.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.trafficType != null ? this.trafficType.hashCode() : 0);
            return result;
        }
    }
}
